/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.ycsb.core.generator;

import gfxdperf.ycsb.core.Utils;
import gfxdperf.ycsb.core.generator.ExponentialGeneratorPrms;
import gfxdperf.ycsb.core.generator.IntegerGenerator;

public class ExponentialGenerator
extends IntegerGenerator {
    double _gamma;

    public ExponentialGenerator(double mean) {
        this._gamma = 1.0 / mean;
    }

    public ExponentialGenerator(int recordcount) {
        double percentile = ExponentialGeneratorPrms.getExponentialFraction();
        double fraction = ExponentialGeneratorPrms.getExponentialPercentile();
        double range = (double)recordcount * fraction;
        this._gamma = -Math.log(1.0 - percentile / 100.0) / range;
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    public long nextLong() {
        return (long)(-Math.log(Utils.random().nextDouble()) / this._gamma);
    }

    @Override
    public double mean() {
        return 1.0 / this._gamma;
    }
}

