/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.ycsb.core.generator;

import gfxdperf.ycsb.core.generator.Generator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class FileGenerator
extends Generator {
    String filename;
    String current;
    BufferedReader reader;

    public FileGenerator(String _filename) {
        try {
            this.filename = _filename;
            File file = new File(this.filename);
            FileInputStream in = new FileInputStream(file);
            this.reader = new BufferedReader(new InputStreamReader(in));
        }
        catch (IOException e) {
            System.err.println("Exception: " + e);
        }
    }

    @Override
    public synchronized String nextString() {
        try {
            this.current = this.reader.readLine();
            return this.current;
        }
        catch (NullPointerException e) {
            System.err.println("NullPointerException: " + this.filename + ':' + this.current);
            throw e;
        }
        catch (IOException e) {
            System.err.println("Exception: " + e);
            return null;
        }
    }

    @Override
    public String lastString() {
        return this.current;
    }

    public synchronized void reloadFile() {
        try {
            System.err.println("Reload " + this.filename);
            this.reader.close();
            File file = new File(this.filename);
            FileInputStream in = new FileInputStream(file);
            this.reader = new BufferedReader(new InputStreamReader(in));
        }
        catch (IOException e) {
            System.err.println("Exception: " + e);
        }
    }
}

