/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.ycsb.core.workloads;

import gfxdperf.ycsb.core.ByteIterator;
import gfxdperf.ycsb.core.DB;
import gfxdperf.ycsb.core.RandomByteIterator;
import gfxdperf.ycsb.core.Utils;
import gfxdperf.ycsb.core.Workload;
import gfxdperf.ycsb.core.WorkloadException;
import gfxdperf.ycsb.core.generator.ConstantIntegerGenerator;
import gfxdperf.ycsb.core.generator.CounterGenerator;
import gfxdperf.ycsb.core.generator.DiscreteGenerator;
import gfxdperf.ycsb.core.generator.ExponentialGenerator;
import gfxdperf.ycsb.core.generator.Generator;
import gfxdperf.ycsb.core.generator.HistogramGenerator;
import gfxdperf.ycsb.core.generator.HotspotIntegerGenerator;
import gfxdperf.ycsb.core.generator.IntegerGenerator;
import gfxdperf.ycsb.core.generator.ScrambledZipfianGenerator;
import gfxdperf.ycsb.core.generator.SkewedLatestGenerator;
import gfxdperf.ycsb.core.generator.UniformIntegerGenerator;
import gfxdperf.ycsb.core.generator.ZipfianGenerator;
import gfxdperf.ycsb.core.workloads.CoreWorkloadPrms;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;

public class CoreWorkload
extends Workload {
    public static String table;
    int fieldcount;
    int fieldstart;
    boolean readallfields;
    boolean writeallfields;
    IntegerGenerator keysequence;
    DiscreteGenerator operationchooser;
    IntegerGenerator keychooser;
    Generator fieldchooser;
    IntegerGenerator fieldlengthgenerator;
    CounterGenerator transactioninsertkeysequence;
    IntegerGenerator scanlength;
    boolean orderedinserts;
    int recordcount;
    int myThreadId;
    int numThreads;

    protected static IntegerGenerator getFieldLengthGenerator() throws WorkloadException {
        IntegerGenerator fieldlengthgenerator;
        CoreWorkloadPrms.FieldLengthDistribution fieldlengthdistribution = CoreWorkloadPrms.getFieldLengthDistribution();
        int fieldlength = CoreWorkloadPrms.getFieldLength();
        String fieldlengthhistogram = CoreWorkloadPrms.getFieldLengthHistogramFile();
        if (fieldlengthdistribution == CoreWorkloadPrms.FieldLengthDistribution.constant) {
            fieldlengthgenerator = new ConstantIntegerGenerator(fieldlength);
        } else if (fieldlengthdistribution == CoreWorkloadPrms.FieldLengthDistribution.uniform) {
            fieldlengthgenerator = new UniformIntegerGenerator(1, fieldlength);
        } else if (fieldlengthdistribution == CoreWorkloadPrms.FieldLengthDistribution.zipfian) {
            fieldlengthgenerator = new ZipfianGenerator(1L, fieldlength);
        } else if (fieldlengthdistribution == CoreWorkloadPrms.FieldLengthDistribution.histogram) {
            try {
                fieldlengthgenerator = new HistogramGenerator(fieldlengthhistogram);
            }
            catch (IOException e) {
                throw new WorkloadException("Couldn't read field length histogram file: " + fieldlengthhistogram, e);
            }
        } else {
            throw new WorkloadException("Should not happen");
        }
        return fieldlengthgenerator;
    }

    @Override
    public void init(Properties p, int threadId, int threads) throws WorkloadException {
        table = CoreWorkloadPrms.getTableName();
        this.fieldcount = CoreWorkloadPrms.getFieldCount();
        this.fieldstart = CoreWorkloadPrms.getFieldStart();
        this.fieldlengthgenerator = CoreWorkload.getFieldLengthGenerator();
        double insertproportion = CoreWorkloadPrms.getInsertProportion();
        double readmodifywriteproportion = CoreWorkloadPrms.getReadModifyWriteProportion();
        double readproportion = CoreWorkloadPrms.getReadProportion();
        double scanproportion = CoreWorkloadPrms.getScanProportion();
        double updateproportion = CoreWorkloadPrms.getUpdateProportion();
        this.recordcount = CoreWorkloadPrms.getRecordCount();
        CoreWorkloadPrms.RequestDistribution requestdistrib = CoreWorkloadPrms.getRequestDistribution();
        int maxscanlength = CoreWorkloadPrms.getMaxScanLength();
        CoreWorkloadPrms.ScanLengthDistribution scanlengthdistrib = CoreWorkloadPrms.getScanLengthDistribution();
        this.readallfields = CoreWorkloadPrms.getReadAllFields();
        this.writeallfields = CoreWorkloadPrms.getWriteAllFields();
        this.myThreadId = threadId;
        this.numThreads = threads;
        int recordsPerThread = this.recordcount / this.numThreads;
        int remainder = this.recordcount - this.numThreads * recordsPerThread;
        if (remainder > 0) {
            String s = "Number of threads: " + this.numThreads + " does not evenly divide recordcount: " + this.recordcount;
            throw new WorkloadException(s);
        }
        int insertstart = 0;
        for (int i = 0; i < this.myThreadId; ++i) {
            insertstart += recordsPerThread;
        }
        if (CoreWorkloadPrms.getInsertOrder() == CoreWorkloadPrms.InsertOrder.hashed) {
            this.orderedinserts = false;
        } else if (requestdistrib == CoreWorkloadPrms.RequestDistribution.exponential) {
            this.keychooser = new ExponentialGenerator(this.recordcount);
        } else {
            this.orderedinserts = true;
        }
        this.keysequence = new CounterGenerator(insertstart);
        this.operationchooser = new DiscreteGenerator();
        if (readproportion + updateproportion + insertproportion + scanproportion + readmodifywriteproportion != 1.0) {
            String s = "Proportions do not add up to 1.00";
            throw new WorkloadException(s);
        }
        if (readproportion > 0.0) {
            this.operationchooser.addValue(readproportion, "READ");
        }
        if (updateproportion > 0.0) {
            this.operationchooser.addValue(updateproportion, "UPDATE");
        }
        if (insertproportion > 0.0) {
            this.operationchooser.addValue(insertproportion, "INSERT");
        }
        if (scanproportion > 0.0) {
            this.operationchooser.addValue(scanproportion, "SCAN");
        }
        if (readmodifywriteproportion > 0.0) {
            this.operationchooser.addValue(readmodifywriteproportion, "READMODIFYWRITE");
        }
        this.transactioninsertkeysequence = new CounterGenerator(this.recordcount);
        if (requestdistrib == CoreWorkloadPrms.RequestDistribution.uniform) {
            this.keychooser = new UniformIntegerGenerator(0, this.recordcount - 1);
        } else if (requestdistrib == CoreWorkloadPrms.RequestDistribution.zipfian) {
            if (insertproportion > 0.0) {
                throw new WorkloadException("Workloads with inserts are not recommended with zipfian distribution");
            }
            this.keychooser = new ScrambledZipfianGenerator(this.recordcount);
        } else if (requestdistrib == CoreWorkloadPrms.RequestDistribution.latest) {
            this.keychooser = new SkewedLatestGenerator(this.transactioninsertkeysequence);
        } else if (requestdistrib == CoreWorkloadPrms.RequestDistribution.hotspot) {
            this.keychooser = new HotspotIntegerGenerator(0, this.recordcount - 1);
        } else {
            throw new WorkloadException("Unknown request distribution \"" + (Object)((Object)requestdistrib) + "\"");
        }
        this.fieldchooser = new UniformIntegerGenerator(this.fieldstart, this.fieldcount - 1);
        if (scanlengthdistrib == CoreWorkloadPrms.ScanLengthDistribution.uniform) {
            this.scanlength = new UniformIntegerGenerator(1, maxscanlength);
        } else if (scanlengthdistrib == CoreWorkloadPrms.ScanLengthDistribution.zipfian) {
            this.scanlength = new ZipfianGenerator(1L, maxscanlength);
        } else {
            throw new WorkloadException("Distribution \"" + (Object)((Object)scanlengthdistrib) + "\" not allowed for scan length");
        }
    }

    @Override
    public Object initThread(Properties p) throws WorkloadException {
        return null;
    }

    public String buildKeyName(long keynum) {
        if (!this.orderedinserts) {
            keynum = Utils.hash(keynum);
        }
        return "user" + keynum;
    }

    HashMap<String, ByteIterator> buildValues(String fk) {
        HashMap<String, ByteIterator> values = new HashMap<String, ByteIterator>();
        for (int i = 0; i < this.fieldcount; ++i) {
            String fieldkey = "field" + i;
            RandomByteIterator data = new RandomByteIterator(this.fieldlengthgenerator.nextInt());
            values.put(fieldkey, data);
        }
        return values;
    }

    HashMap<String, ByteIterator> buildUpdate() {
        HashMap<String, ByteIterator> values = new HashMap<String, ByteIterator>();
        String fieldname = "field" + this.fieldchooser.nextString();
        RandomByteIterator data = new RandomByteIterator(this.fieldlengthgenerator.nextInt());
        values.put(fieldname, data);
        return values;
    }

    @Override
    public void doInsert(DB db, Object threadstate) {
        int keynum = this.keysequence.nextInt();
        String dbkey = this.buildKeyName(keynum);
        HashMap<String, ByteIterator> values = this.buildValues(null);
        int result = db.insert(table, dbkey, values);
    }

    @Override
    public void doTransaction(DB db, Object threadstate) {
        String op = this.operationchooser.nextString();
        if (op.compareTo("READ") == 0) {
            this.doTransactionRead(db);
        } else if (op.compareTo("UPDATE") == 0) {
            this.doTransactionUpdate(db);
        } else if (op.compareTo("INSERT") == 0) {
            this.doTransactionInsert(db);
        } else if (op.compareTo("SCAN") == 0) {
            this.doTransactionScan(db);
        } else if (op.compareTo("READMODIFYWRITE") == 0) {
            this.doTransactionReadModifyWrite(db);
        }
    }

    int nextKeynum() {
        int keynum;
        if (this.keychooser instanceof ExponentialGenerator) {
            while ((keynum = this.transactioninsertkeysequence.lastInt() - this.keychooser.nextInt()) < 0) {
            }
        } else {
            while ((keynum = this.keychooser.nextInt()) > this.transactioninsertkeysequence.lastInt()) {
            }
        }
        return keynum;
    }

    public void doTransactionRead(DB db) {
        int keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = "field" + this.fieldchooser.nextString();
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        db.read(table, keyname, fields, new HashMap<String, ByteIterator>());
    }

    public void doTransactionReadModifyWrite(DB db) {
        int keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = "field" + this.fieldchooser.nextString();
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        HashMap<String, ByteIterator> values = this.writeallfields ? this.buildValues(null) : this.buildUpdate();
        db.read(table, keyname, fields, new HashMap<String, ByteIterator>());
        db.update(table, keyname, values);
    }

    public void doTransactionScan(DB db) {
        int keynum = this.nextKeynum();
        String startkeyname = this.buildKeyName(keynum);
        int len = this.scanlength.nextInt();
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = "field" + this.fieldchooser.nextString();
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        db.scan(table, startkeyname, len, fields, new Vector<HashMap<String, ByteIterator>>());
    }

    public void doTransactionUpdate(DB db) {
        int keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashMap<String, ByteIterator> values = this.writeallfields ? this.buildValues(null) : this.buildUpdate();
        db.update(table, keyname, values);
    }

    public void doTransactionInsert(DB db) {
        int keynum = this.transactioninsertkeysequence.nextInt();
        String dbkey = this.buildKeyName(keynum);
        HashMap<String, ByteIterator> values = this.buildValues(null);
        db.insert(table, dbkey, values);
    }
}

