/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.ycsb.core.workloads;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class CoreWorkloadStats
extends PerformanceStatistics {
    protected static final String READS = "reads";
    protected static final String READ_TIME = "readTime";
    protected static final String UPDATES = "updates";
    protected static final String UPDATE_TIME = "updateTime";
    protected static final String INSERTS = "inserts";
    protected static final String INSERT_TIME = "insertTime";
    protected static final String DELETES = "deletes";
    protected static final String DELETE_TIME = "deleteTime";

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{CoreWorkloadStats.factory().createIntCounter(READS, "Number of reads done.", "operations", largerIsBetter), CoreWorkloadStats.factory().createLongCounter(READ_TIME, "Total time spent doing reads.", "nanoseconds", !largerIsBetter), CoreWorkloadStats.factory().createIntCounter(UPDATES, "Number of updatges done.", "operations", largerIsBetter), CoreWorkloadStats.factory().createLongCounter(UPDATE_TIME, "Total time spent doing updatges.", "nanoseconds", !largerIsBetter), CoreWorkloadStats.factory().createIntCounter(INSERTS, "Number of inserts done.", "operations", largerIsBetter), CoreWorkloadStats.factory().createLongCounter(INSERT_TIME, "Total time spent doing inserts.", "nanoseconds", !largerIsBetter), CoreWorkloadStats.factory().createIntCounter(DELETES, "Number of deletes done.", "operations", largerIsBetter), CoreWorkloadStats.factory().createLongCounter(DELETE_TIME, "Total time spent doing deletes.", "nanoseconds", !largerIsBetter)};
    }

    public static CoreWorkloadStats getInstance() {
        return (CoreWorkloadStats)CoreWorkloadStats.getInstance(CoreWorkloadStats.class, (int)0);
    }

    public CoreWorkloadStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public long startRead() {
        return NanoTimer.getTime();
    }

    public long endRead(long start, int amount) {
        long elapsed = NanoTimer.getTime() - start;
        this.statistics().incInt(READS, amount);
        this.statistics().incLong(READ_TIME, elapsed);
        return elapsed;
    }

    public long startUpdate() {
        return NanoTimer.getTime();
    }

    public long endUpdate(long start, int amount) {
        long elapsed = NanoTimer.getTime() - start;
        this.statistics().incInt(UPDATES, amount);
        this.statistics().incLong(UPDATE_TIME, elapsed);
        return elapsed;
    }

    public long startInsert() {
        return NanoTimer.getTime();
    }

    public long endInsert(long start, int amount) {
        long elapsed = NanoTimer.getTime() - start;
        this.statistics().incInt(INSERTS, amount);
        this.statistics().incLong(INSERT_TIME, elapsed);
        return elapsed;
    }

    public long startDelete() {
        return NanoTimer.getTime();
    }

    public long endDelete(long start, int amount) {
        long elapsed = NanoTimer.getTime() - start;
        this.statistics().incInt(DELETES, amount);
        this.statistics().incLong(DELETE_TIME, elapsed);
        return elapsed;
    }
}

