/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.ycsb.gf;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import gfxdperf.PerfTestException;
import gfxdperf.ycsb.YCSBClient;
import gfxdperf.ycsb.core.DBException;
import gfxdperf.ycsb.core.WorkloadException;
import gfxdperf.ycsb.core.workloads.CoreWorkload;
import gfxdperf.ycsb.core.workloads.CoreWorkloadPrms;
import gfxdperf.ycsb.gf.GFDB;
import gfxdperf.ycsb.gf.GFPrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.RegionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GFClient
extends YCSBClient {
    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void startServerTask() {
        DistributedSystemHelper.getDistributedSystem();
        CacheHelper.createCache((String)ConfigPrms.getCacheConfig());
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer((String)bridgeConfig);
        }
        RegionHelper.createRegion((String)CoreWorkloadPrms.getTableName(), (String)ConfigPrms.getRegionConfig());
    }

    public static void stopServerTask() {
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.stopBridgeServer();
        }
    }

    public static void createBucketsTask() throws InterruptedException {
        GFClient client = new GFClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.createBuckets();
        }
    }

    private void createBuckets() throws InterruptedException {
        Cache c = CacheHelper.getCache();
        if (c != null) {
            for (Region r : c.rootRegions()) {
                if (!r.getAttributes().getDataPolicy().withPartitioning()) continue;
                Log.getLogWriter().info("Creating buckets for region " + r.getName());
                PartitionRegionHelper.assignBucketsToPartitions((Region)r);
                RebalanceFactory rf = CacheHelper.getCache().getResourceManager().createRebalanceFactory();
                RebalanceOperation ro = rf.start();
                RebalanceResults results = ro.getResults();
                Log.getLogWriter().info("Created buckets for region " + r.getName());
            }
        }
    }

    public static void checkBucketLoadBalanceTask() {
        GFClient client = new GFClient();
        client.initialize();
        if (client.jid == 0) {
            client.checkBucketLoadBalance();
        }
    }

    protected void checkBucketLoadBalance() {
        for (PartitionedRegion pr : this.getPartitionedRegions()) {
            this.checkBucketLoadBalance(pr.getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkBucketLoadBalance(String regionName) {
        Statistics prstats = this.getPartitionedRegionStats(regionName);
        int buckets = 0;
        int primaries = 0;
        if (prstats == null) return;
        ArrayList<String> errs = new ArrayList<String>();
        int datahosts = this.getNumServersHosting(regionName);
        if (datahosts > 1) {
            Log.getLogWriter().info("Checking bucket load balance for " + regionName + " with " + datahosts + " datahosts");
            primaries = prstats.getInt("primaryBucketCount");
            buckets = prstats.getInt("bucketCount");
            int copies = prstats.getInt("configuredRedundantCopies") + 1;
            int totalPrimaries = prstats.getInt("totalNumBuckets");
            int totalBuckets = totalPrimaries * copies;
            int primariesPerDatahost = totalPrimaries / datahosts;
            int bucketsPerDatahost = totalBuckets / datahosts;
            if (buckets != bucketsPerDatahost && (totalBuckets % datahosts == 0 || buckets != bucketsPerDatahost + 1)) {
                errs.add(regionName + " has " + buckets + " buckets");
            }
            if (primaries != primariesPerDatahost && (totalPrimaries % datahosts == 0 || primaries != primariesPerDatahost + 1)) {
                errs.add(regionName + " has " + primaries + " primary buckets");
            }
        }
        if (errs.size() > 0) {
            this.printBucketIdsAndSizes(regionName);
            String s = "Bucket load balance failures: " + errs;
            if (!GFPrms.getFailOnLoadImbalance()) throw new PerfTestException(s);
            Log.getLogWriter().warning(s);
            return;
        } else {
            Log.getLogWriter().info("Region " + regionName + " is bucket-balanced" + " with " + buckets + " buckets and " + primaries + " primaries");
        }
    }

    public static void checkDataLoadBalanceTask() {
        GFClient client = new GFClient();
        client.initialize();
        if (client.jid == 0) {
            client.checkDataLoadBalance();
        }
    }

    protected void checkDataLoadBalance() {
        for (PartitionedRegion pr : this.getPartitionedRegions()) {
            this.checkDataLoadBalance(pr.getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkDataLoadBalance(String regionName) {
        ArrayList<String> errs = new ArrayList<String>();
        for (PartitionRegionInfo pri : this.getPartitionRegionInfo()) {
            int datahosts;
            String regionPath = pri.getRegionPath();
            if (!regionPath.contains(regionName) || (datahosts = this.getNumServersHosting(regionName)) <= 1) continue;
            Log.getLogWriter().info("Checking entry load for " + regionName + " with " + datahosts + " datahosts");
            ArrayList<Long> sizes = new ArrayList<Long>();
            Set pmis = pri.getPartitionMemberInfo();
            long maxSize = 0L;
            for (PartitionMemberInfo pmi : pmis) {
                long size = pmi.getSize();
                if (size < 0L) {
                    errs.add("Negative size for " + regionName + ": " + size);
                }
                if (size > maxSize) {
                    maxSize = size;
                }
                sizes.add(size);
            }
            if (maxSize > 0L) {
                for (Long size : sizes) {
                    double d = size < maxSize ? (double)size.longValue() / (double)maxSize : (double)maxSize / (double)size.longValue();
                    double ratio = d;
                    if (!(ratio < 0.9)) continue;
                    errs.add(regionName + " is imbalanced: " + sizes);
                    break;
                }
            }
            Log.getLogWriter().info("Checked entry load for " + regionName + ", found entry sizes " + sizes + " bytes");
        }
        if (errs.size() > 0) {
            this.printBucketIdsAndSizes(regionName);
            String s = "Data load balance failures: " + errs;
            if (!GFPrms.getFailOnLoadImbalance()) throw new PerfTestException(s);
            Log.getLogWriter().warning(s);
            return;
        } else {
            Log.getLogWriter().info("Region " + regionName + " is load-balanced");
        }
    }

    public static void printBucketIdsAndSizesTask() {
        GFClient client = new GFClient();
        client.initialize();
        if (client.jid == 0) {
            client.printBucketIdsAndSizes();
        }
    }

    protected void printBucketIdsAndSizes() {
        for (PartitionedRegion pr : this.getPartitionedRegions()) {
            this.printBucketIdsAndSizes(pr.getName());
        }
    }

    protected void printBucketIdsAndSizes(String regionName) {
        for (PartitionRegionInfo pri : this.getPartitionRegionInfo()) {
            String regionPath = pri.getRegionPath();
            if (!regionPath.contains(regionName)) continue;
            StringBuilder sb = new StringBuilder();
            PartitionedRegion pr = (PartitionedRegion)CacheHelper.getCache().getRegion(regionPath);
            List bids = pr.getLocalBucketsListTestOnly();
            sb.append("Buckets for " + regionName + " at " + regionPath + "/" + pr.getName() + ": " + bids + "\n");
            for (Integer bid : bids) {
                sb.append("size of bucket[" + bid + "]=").append(pr.getDataStore().getBucketSize(bid.intValue()) + "\n");
            }
            List pbids = pr.getLocalPrimaryBucketsListTestOnly();
            sb.append("Primary buckets for " + regionName + " at " + regionPath + "/" + pr.getName() + ": " + pbids + "\n");
            for (Integer pbid : pbids) {
                sb.append("size of primary bucket[" + pbid + "]=").append(pr.getDataStore().getBucketSize(pbid.intValue()) + "\n");
            }
            Log.getLogWriter().info(sb.toString());
            return;
        }
    }

    protected Set<PartitionedRegion> getPartitionedRegions() {
        GemFireCacheImpl c = (GemFireCacheImpl)CacheHelper.getCache();
        return c.getPartitionedRegions();
    }

    protected Statistics getPartitionedRegionStats(String regionName) {
        Statistics[] stats = DistributedSystemHelper.getDistributedSystem().findStatisticsByTextId(regionName);
        Statistics prStats = null;
        for (int i = 0; i < stats.length; ++i) {
            if (!stats[i].getType().getName().equals("PartitionedRegionStats")) continue;
            prStats = stats[i];
        }
        return prStats;
    }

    protected Set<PartitionRegionInfo> getPartitionRegionInfo() {
        return PartitionRegionHelper.getPartitionRegionInfo((Cache)CacheHelper.getCache());
    }

    protected int getNumServersHosting(String regionName) {
        for (PartitionRegionInfo pri : this.getPartitionRegionInfo()) {
            if (!pri.getRegionPath().contains(regionName)) continue;
            Set pmis = pri.getPartitionMemberInfo();
            return pmis.size();
        }
        return 0;
    }

    public static void initDBTask() throws DBException, WorkloadException {
        GFClient client = new GFClient();
        client.initialize();
        client.initDB();
        client.updateHydraThreadLocals();
    }

    protected void initDB() throws DBException {
        this.db = new GFDB();
        this.db.init();
    }

    public static void cleanupDBTask() throws DBException, InterruptedException {
        GFClient client = new GFClient();
        client.initialize();
        client.cleanupDB();
        client.updateHydraThreadLocals();
    }

    protected void cleanupDB() throws DBException, InterruptedException {
        this.db.cleanup();
    }

    public static void initWorkloadTask() throws WorkloadException {
        GFClient client = new GFClient();
        client.initialize();
        client.initWorkload();
        client.updateHydraThreadLocals();
    }

    protected void initWorkload() throws WorkloadException {
        this.workload = new CoreWorkload();
        this.workload.init(null, this.ttgid, this.numThreads);
        this.workloadstate = this.workload.initThread(null);
    }

    public static void loadDataTask() {
        GFClient client = new GFClient();
        client.initialize();
        client.loadData();
    }

    public static void doWorkloadTask() throws InterruptedException {
        GFClient client = new GFClient();
        client.initialize();
        client.doWorkload();
    }

    @Override
    protected long completeTask(String trimIntervalName) {
        return System.currentTimeMillis();
    }
}

