/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.ycsb.gfxd;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.tools.utils.ExecutionPlanUtils;
import gfxdperf.PerfTestException;
import gfxdperf.ycsb.YCSBClient;
import gfxdperf.ycsb.core.DBException;
import gfxdperf.ycsb.core.WorkloadException;
import gfxdperf.ycsb.core.workloads.CoreWorkload;
import gfxdperf.ycsb.core.workloads.CoreWorkloadPrms;
import gfxdperf.ycsb.gfxd.GFXDDB;
import gfxdperf.ycsb.gfxd.GFXDPrms;
import gfxdperf.ycsb.gfxd.GFXDStats;
import gfxdperf.ycsb.gfxd.GFXDUtil;
import hydra.CacheHelper;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HadoopHelper;
import hydra.HostDescription;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.gemfirexd.DiskStoreHelper;
import hydra.gemfirexd.FabricServerDescription;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.HDFSStoreHelper;
import hydra.gemfirexd.NetworkServerHelper;
import hydra.gemfirexd.ThinClientDescription;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GFXDClient
extends YCSBClient {
    public static final String DRIVER = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    public static final String PROTOCOL = "jdbc:gemfirexd:";
    public static final String TABLE_DATAPOLICY_QUERY = "SELECT tablename, datapolicy FROM sys.systables WHERE tableschemaname='APP'";
    public static final String QUERY_PLAN_QUERY = "select STMT_ID, STMT_TEXT from SYS.STATEMENTPLANS";
    public static final String HDFS_AEQ = "AsyncEventQueue_GEMFIRE_HDFS_BUCKETSORTED_QUEUE";
    public static final String HDFS_FLUSH_QUEUE_CALL = "call sys.HDFS_FLUSH_QUEUE(?,?)";
    public static final String HDFS_FORCE_COMPACTION_CALL = "call sys.HDFS_FORCE_COMPACTION(?,?)";
    public static String COLUMN_PREFIX = "field";
    public static final String DDL_FILE = "ddl.sql";
    public static final String EVICT_INCOMING = "EVICTION BY CRITERIA (1=1 OR YCSB_KEY='') EVICT INCOMING";
    public static final String HDFS_CLIENT_CONFIG_FILE = "gfxd-client-config.xml";
    public static final String PRIMARY_KEY = "YCSB_KEY";
    public static final String TABLE_QUERY = "SELECT tablename, datapolicy FROM sys.systables WHERE tableschemaname='APP'";
    public static final String TABLE_NAME = CoreWorkloadPrms.getTableName();
    protected static HydraThreadLocal localgfxdstats = new HydraThreadLocal();
    protected GFXDStats gfxdstats;

    @Override
    public void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.gfxdstats = (GFXDStats)((Object)localgfxdstats.get());
    }

    @Override
    public void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        localgfxdstats.set((Object)this.gfxdstats);
    }

    public static void generateHDFSClientConfigTask() throws IOException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.generateHDFSClientConfig();
        }
    }

    private void generateHDFSClientConfig() throws IOException {
        String ifn = GFXDPrms.getHDFSClientConfigFile();
        HostDescription hd = GFXDClient.getHostDescription();
        String xml = FileUtil.getText((String)EnvHelper.expandEnvVars((String)ifn, (HostDescription)hd));
        String hadoopConfig = ConfigPrms.getHadoopConfig();
        xml = xml.replace("${dfs.replication}", String.valueOf(HadoopHelper.getHadoopDescription((String)hadoopConfig).getReplication()));
        xml = xml.replace("${user}", System.getProperty("user.name"));
        String ofn = System.getProperty("user.dir") + hd.getFileSep() + HDFS_CLIENT_CONFIG_FILE;
        FileUtil.writeToFile((String)ofn, (String)xml);
    }

    public static void generateDDLTask() throws IOException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.generateDDL();
        }
    }

    private void generateDDL() throws IOException {
        String hdfsStoreConfig;
        String ddl = "";
        String diskStoreConfig = GfxdConfigPrms.getDiskStoreConfig();
        if (diskStoreConfig != null) {
            ddl = ddl + DiskStoreHelper.getDiskStoreDDL(diskStoreConfig) + ";\n";
        }
        if ((hdfsStoreConfig = GfxdConfigPrms.getHDFSStoreConfig()) != null) {
            ddl = ddl + HDFSStoreHelper.getHDFSStoreDDL(hdfsStoreConfig) + ";\n";
        }
        ddl = ddl + this.generateTableDDL(diskStoreConfig) + ";\n";
        FileUtil.writeToFile((String)DDL_FILE, (String)ddl);
    }

    private String generateTableDDL(String diskStoreConfig) {
        String hdfsStoreConfig;
        int fieldcount = CoreWorkloadPrms.getFieldCount();
        int buckets = GFXDPrms.getBucketCount();
        int redundancy = GFXDPrms.getPartitionRedundancy();
        StringBuilder sql = new StringBuilder("CREATE TABLE ");
        sql.append(TABLE_NAME).append(" (").append(PRIMARY_KEY).append(" VARCHAR(100) PRIMARY KEY");
        for (int i = 0; i < fieldcount; ++i) {
            sql.append(", FIELD").append(i).append(" VARCHAR(100)");
        }
        String primaryKey = GFXDPrms.useGlobalIndex() ? "FIELD0" : PRIMARY_KEY;
        sql.append(")").append(" partition by (").append(primaryKey).append(") ").append(" buckets ").append(buckets).append(" redundancy ").append(redundancy);
        Map<String, FabricServerDescription> fsds = GfxdTestConfig.getInstance().getFabricServerDescriptions();
        for (FabricServerDescription fsd : fsds.values()) {
            if (fsd.getOffHeapMemorySize() == null) continue;
            sql.append(" offheap");
            break;
        }
        for (FabricServerDescription fsd : fsds.values()) {
            if (!fsd.getPersistTables().booleanValue()) continue;
            sql.append(" persistent '").append(diskStoreConfig);
            if (GFXDPrms.persistSynchronous()) {
                sql.append("' synchronous");
                break;
            }
            sql.append("' asynchronous");
            break;
        }
        if ((hdfsStoreConfig = GfxdConfigPrms.getHDFSStoreConfig()) != null) {
            boolean evictIncoming = GFXDPrms.evictIncoming();
            if (evictIncoming) {
                sql.append(" ").append(EVICT_INCOMING);
            }
            String hdfsStoreName = HDFSStoreHelper.getHDFSStoreDescription(hdfsStoreConfig).getName();
            sql.append(" HDFSSTORE (").append(hdfsStoreName).append(")");
        }
        return sql.toString();
    }

    public static void executeDDLTask() throws IOException, SQLException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.executeDDL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDDL() throws IOException, SQLException {
        Connection conn = this.openTmpConnection();
        try {
            Statement stmt = conn.createStatement();
            String fn = System.getProperty("user.dir") + "/" + DDL_FILE;
            List ddls = FileUtil.getTextAsList((String)fn);
            for (String ddl : ddls) {
                if (ddl.length() <= 0) continue;
                Log.getLogWriter().info("Executing DDL: " + ddl);
                boolean result = stmt.execute(ddl);
                Log.getLogWriter().info("Executed DDL: " + ddl + " with result " + result);
            }
            stmt.close();
        }
        finally {
            this.closeTmpConnection(conn);
        }
    }

    public static void configureHadoopTask() throws SQLException {
        String hadoopConfig = ConfigPrms.getHadoopConfig();
        if (hadoopConfig != null) {
            HadoopHelper.configureHadoop((String)hadoopConfig);
        }
    }

    public static void startHDFSClusterTask() throws SQLException {
        String hadoopConfig = ConfigPrms.getHadoopConfig();
        if (hadoopConfig != null) {
            HadoopHelper.startHDFSCluster((String)hadoopConfig);
        }
    }

    public static void stopHDFSClusterTask() throws SQLException {
        String hadoopConfig = ConfigPrms.getHadoopConfig();
        if (hadoopConfig != null) {
            HadoopHelper.stopHDFSCluster((String)hadoopConfig);
        }
    }

    public static void createLocatorTask() throws SQLException {
        FabricServerHelper.createLocator();
    }

    public static void startLocatorTask() throws SQLException {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        if (networkServerConfig == null) {
            Log.getLogWriter().info("Starting peer locator only");
            FabricServerHelper.startLocator();
        } else {
            Log.getLogWriter().info("Starting network locator");
            FabricServerHelper.startLocator(networkServerConfig);
        }
    }

    public static void startFabricServerTask() throws SQLException {
        FabricServerHelper.startFabricServer();
        if (GFXDPrms.getConnectionType() == GFXDPrms.ConnectionType.thin) {
            String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
            NetworkServerHelper.startNetworkServers(networkServerConfig);
        }
    }

    public static void stopFabricServerTask() throws SQLException {
        if (GFXDPrms.getConnectionType() == GFXDPrms.ConnectionType.thin) {
            NetworkServerHelper.stopNetworkServers();
        }
        FabricServerHelper.stopFabricServer();
    }

    public static void shutDownAllTask() {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.ttgid == 0) {
            FabricServerHelper.shutDownAllFabricServers(300);
        }
    }

    public static synchronized void waitForServerShutdownTask() {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.jid == 0) {
            while (!FabricServerHelper.isFabricServerStopped()) {
                MasterController.sleepForMs((int)500);
            }
            return;
        }
    }

    public static void bounceSelfTask() throws ClientVmNotFoundException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.jid == 0) {
            Log.getLogWriter().info("Bouncing self, catch you later...");
            ClientVmMgr.stopAsync((String)"Killing myself nicely with immediate restart", (int)-20, (int)-30);
        }
    }

    public static void createBucketsTask() throws IOException, SQLException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.createBuckets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBuckets() throws SQLException {
        Connection conn = this.openTmpConnection();
        try {
            CallableStatement cs = conn.prepareCall("call SYS.CREATE_ALL_BUCKETS(?)");
            List<String> tableNames = this.getPartitionedTables();
            for (String tableName : tableNames) {
                Log.getLogWriter().info("Creating buckets for table " + tableName);
                cs.setString(1, tableName);
                cs.execute();
                Log.getLogWriter().info("Created buckets for table " + tableName);
            }
            cs.close();
        }
        finally {
            this.closeTmpConnection(conn);
        }
    }

    public static void checkBucketLoadBalanceTask() throws SQLException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.jid == 0) {
            client.checkBucketLoadBalance();
        }
    }

    protected void checkBucketLoadBalance() throws SQLException {
        for (String tableName : this.getPartitionedTables()) {
            this.checkBucketLoadBalance(tableName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkBucketLoadBalance(String tableName) {
        Statistics prstats = this.getPartitionedRegionStats(tableName);
        int buckets = 0;
        int primaries = 0;
        if (prstats == null) return;
        ArrayList<String> errs = new ArrayList<String>();
        int datahosts = this.getNumServersHosting(tableName);
        if (datahosts > 1) {
            Log.getLogWriter().info("Checking bucket load balance for " + tableName + " with " + datahosts + " datahosts");
            primaries = prstats.getInt("primaryBucketCount");
            buckets = prstats.getInt("bucketCount");
            int copies = prstats.getInt("configuredRedundantCopies") + 1;
            int totalPrimaries = prstats.getInt("totalNumBuckets");
            int totalBuckets = totalPrimaries * copies;
            int primariesPerDatahost = totalPrimaries / datahosts;
            int bucketsPerDatahost = totalBuckets / datahosts;
            if (buckets != bucketsPerDatahost && (totalBuckets % datahosts == 0 || buckets != bucketsPerDatahost + 1)) {
                errs.add(tableName + " has " + buckets + " buckets");
            }
            if (primaries != primariesPerDatahost && (totalPrimaries % datahosts == 0 || primaries != primariesPerDatahost + 1)) {
                errs.add(tableName + " has " + primaries + " primary buckets");
            }
        }
        if (errs.size() > 0) {
            this.printBucketIdsAndSizes(tableName);
            String s = "Bucket load balance failures: " + errs;
            if (!GFXDPrms.getFailOnLoadImbalance()) throw new PerfTestException(s);
            Log.getLogWriter().warning(s);
            return;
        } else {
            Log.getLogWriter().info("Table " + tableName + " is bucket-balanced" + " with " + buckets + " buckets and " + primaries + " primaries");
        }
    }

    public static void checkDataLoadBalanceTask() throws SQLException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.jid == 0) {
            client.checkDataLoadBalance();
        }
    }

    protected void checkDataLoadBalance() throws SQLException {
        for (String tableName : this.getPartitionedTables()) {
            this.checkDataLoadBalance(tableName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkDataLoadBalance(String tableName) {
        ArrayList<String> errs = new ArrayList<String>();
        for (PartitionRegionInfo pri : this.getPartitionRegionInfo()) {
            int datahosts;
            String regionPath = pri.getRegionPath();
            if (!regionPath.contains(tableName) || regionPath.contains(HDFS_AEQ) || (datahosts = this.getNumServersHosting(tableName)) <= 1) continue;
            Log.getLogWriter().info("Checking entry load for " + tableName + " with " + datahosts + " datahosts");
            ArrayList<Long> sizes = new ArrayList<Long>();
            Set pmis = pri.getPartitionMemberInfo();
            long maxSize = 0L;
            for (PartitionMemberInfo pmi : pmis) {
                long size = pmi.getSize();
                if (size < 0L) {
                    errs.add("Negative size for " + tableName + ": " + size);
                }
                if (size > maxSize) {
                    maxSize = size;
                }
                sizes.add(size);
            }
            if (maxSize > 0L) {
                for (Long size : sizes) {
                    double d = size < maxSize ? (double)size.longValue() / (double)maxSize : (double)maxSize / (double)size.longValue();
                    double ratio = d;
                    if (!(ratio < 0.9)) continue;
                    errs.add(tableName + " is imbalanced: " + sizes);
                    break;
                }
            }
            Log.getLogWriter().info("Checked entry load for " + tableName + ", found entry sizes " + sizes + " bytes");
        }
        if (errs.size() > 0) {
            this.printBucketIdsAndSizes(tableName);
            String s = "Data load balance failures: " + errs;
            if (!GFXDPrms.getFailOnLoadImbalance()) throw new PerfTestException(s);
            Log.getLogWriter().warning(s);
            return;
        } else {
            Log.getLogWriter().info("Table " + tableName + " is load-balanced");
        }
    }

    public static void printBucketIdsAndSizesTask() throws SQLException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.jid == 0) {
            client.printBucketIdsAndSizes();
        }
    }

    protected void printBucketIdsAndSizes() throws SQLException {
        for (String tableName : this.getPartitionedTables()) {
            this.printBucketIdsAndSizes(tableName);
        }
    }

    protected void printBucketIdsAndSizes(String tableName) {
        for (PartitionRegionInfo pri : this.getPartitionRegionInfo()) {
            String regionPath = pri.getRegionPath();
            if (!regionPath.contains(tableName)) continue;
            StringBuilder sb = new StringBuilder();
            PartitionedRegion pr = (PartitionedRegion)CacheHelper.getCache().getRegion(regionPath);
            List bids = pr.getLocalBucketsListTestOnly();
            sb.append("Buckets for " + tableName + " at " + regionPath + "/" + pr.getName() + ": " + bids + "\n");
            for (Integer bid : bids) {
                sb.append("size of bucket[" + bid + "]=").append(pr.getDataStore().getBucketSize(bid.intValue()) + "\n");
            }
            List pbids = pr.getLocalPrimaryBucketsListTestOnly();
            sb.append("Primary buckets for " + tableName + " at " + regionPath + "/" + pr.getName() + ": " + pbids + "\n");
            for (Integer pbid : pbids) {
                sb.append("size of primary bucket[" + pbid + "]=").append(pr.getDataStore().getBucketSize(pbid.intValue()) + "\n");
            }
            Log.getLogWriter().info(sb.toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getPartitionedTables() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        Connection conn = this.openTmpConnection();
        try {
            PreparedStatement ps = conn.prepareStatement("SELECT tablename, datapolicy FROM sys.systables WHERE tableschemaname='APP'");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String tablename = rs.getString("tablename");
                String datapolicy = rs.getString("datapolicy");
                if (!datapolicy.contains("PARTITION")) continue;
                tableNames.add(tablename);
            }
            rs.close();
            rs = null;
            ps.close();
        }
        finally {
            this.closeTmpConnection(conn);
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getHDFSPartitionedTables() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        Connection conn = this.openTmpConnection();
        try {
            PreparedStatement ps = conn.prepareStatement("SELECT tablename, datapolicy FROM sys.systables WHERE tableschemaname='APP'");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String tablename = rs.getString("tablename");
                String datapolicy = rs.getString("datapolicy");
                if (!datapolicy.contains("HDFS") || !datapolicy.contains("PARTITION")) continue;
                tableNames.add(tablename);
            }
            rs.close();
            rs = null;
            ps.close();
        }
        finally {
            this.closeTmpConnection(conn);
        }
        return tableNames;
    }

    protected Statistics getPartitionedRegionStats(String tableName) {
        Statistics[] stats = DistributedSystemHelper.getDistributedSystem().findStatisticsByTextId("/APP/" + tableName);
        Statistics prStats = null;
        for (int i = 0; i < stats.length; ++i) {
            if (!stats[i].getType().getName().equals("PartitionedRegionStats")) continue;
            prStats = stats[i];
        }
        return prStats;
    }

    protected Set<PartitionRegionInfo> getPartitionRegionInfo() {
        return PartitionRegionHelper.getPartitionRegionInfo((Cache)CacheHelper.getCache());
    }

    protected int getNumServersHosting(String tableName) {
        for (PartitionRegionInfo pri : this.getPartitionRegionInfo()) {
            if (!pri.getRegionPath().contains(tableName)) continue;
            Set pmis = pri.getPartitionMemberInfo();
            return pmis.size();
        }
        return 0;
    }

    public static void monitorWorkloadTask() throws InterruptedException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        client.monitorWorkload();
    }

    protected void monitorWorkload() throws InterruptedException {
        String host = TestConfig.getInstance().getClientDescription(RemoteTestModule.getMyClientName()).getVmDescription().getHostDescription().getHostName();
        int pid = RemoteTestModule.getMyPid();
        String diskStoreName = GfxdConfigPrms.getDiskStoreConfig();
        if (diskStoreName == null) {
            Log.getLogWriter().info("There is no diskstore to monitor.");
            throw new StopSchedulingTaskOnClientOrder();
        }
        Statistics diskStoreStats = this.getDiskStoreStats(diskStoreName);
        if (diskStoreStats == null) {
            String s = "Found diskstore " + diskStoreName + " but no statistics";
            throw new PerfTestException(s);
        }
        int threadCount = GFXDPrms.getThreadCount();
        int blockedCount = 0;
        Log.getLogWriter().info("Monitoring DiskStoreStats.writesInProgress for " + threadCount + " threads using disk store " + diskStoreName);
        this.terminator.startBatch();
        while (!this.terminator.batchComplete()) {
            if (this.terminator.warmupComplete()) {
                this.terminator.startWork();
            }
            if (this.terminator.workComplete()) {
                this.terminator.terminateTask();
            }
            Thread.sleep(1000L);
            int writesInProgress = diskStoreStats.getInt("writesInProgress");
            if (writesInProgress < threadCount) continue;
            if (++blockedCount > 2) {
                ProcessMgr.printProcessStacks((String)host, (int)pid);
                ProcessMgr.printProcessStacks((String)host, (int)pid);
                Log.getLogWriter().info("DiskStoreStats.writesInProgress=" + writesInProgress + " blockedCount=" + blockedCount + " printed process stacks");
                while (blockedCount != 0) {
                    Thread.sleep(1000L);
                    writesInProgress = diskStoreStats.getInt("writesInProgress");
                    if (writesInProgress >= threadCount) {
                        ProcessMgr.printProcessStacks((String)host, (int)pid);
                        Log.getLogWriter().info("DiskStoreStats.writesInProgress=" + writesInProgress + " blockedCount=" + ++blockedCount + " printed process stacks");
                        continue;
                    }
                    blockedCount = 0;
                }
                continue;
            }
            Log.getLogWriter().info("DiskStoreStats.writesInProgress=" + writesInProgress + " blockedCount=" + blockedCount);
        }
        this.updateHydraThreadLocals();
        this.terminator.terminateBatch();
    }

    protected Statistics getDiskStoreStats(String diskStoreName) {
        Statistics[] stats = DistributedSystemHelper.getDistributedSystem().findStatisticsByTextId(diskStoreName.toUpperCase());
        for (int i = 0; i < stats.length; ++i) {
            if (!stats[i].getType().getName().equals("DiskStoreStatistics")) continue;
            return stats[i];
        }
        return null;
    }

    public static void dumpQueryPlansTask() throws SQLException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.dumpQueryPlans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpQueryPlans() throws SQLException {
        Connection conn = this.openTmpConnection();
        try {
            Log.getLogWriter().info("Extracting query plans...");
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(QUERY_PLAN_QUERY);
            int numQueryPlans = 0;
            while (rs.next()) {
                ++numQueryPlans;
                String stmt_id = rs.getString("STMT_ID");
                String stmtInfo = "stmt_id = " + stmt_id + " statement = " + rs.getString("STMT_TEXT");
                ExecutionPlanUtils plan = new ExecutionPlanUtils(conn, stmt_id, null, true);
                String planAsText = String.valueOf(plan.getPlanAsText(null)).trim();
                Log.getLogWriter().info("Query plan...\n" + stmtInfo + "\n" + planAsText);
            }
            Log.getLogWriter().info("Extracted " + numQueryPlans + " query plans");
            rs.close();
            Object var3_3 = null;
        }
        finally {
            this.closeTmpConnection(conn);
        }
    }

    protected Connection openTmpConnection() throws SQLException {
        Connection conn = this.getDBConnection();
        if (conn == null) {
            if (this.isThinClient()) {
                String s = "Cannot create an embedded tmp connection in a thin client.";
                s = s + " Either open a connection or assign the task to a peer.";
                throw new PerfTestException(s);
            }
            return GFXDUtil.openBasicEmbeddedConnection();
        }
        return conn;
    }

    protected void closeTmpConnection(Connection conn) throws SQLException {
        Connection existingConn = this.getDBConnection();
        if (existingConn == null) {
            conn.close();
        }
    }

    protected Connection getDBConnection() {
        if (this.db == null) {
            return null;
        }
        return ((GFXDDB)this.db).getConnection();
    }

    protected boolean isThinClient() {
        String clientName = RemoteTestModule.getMyClientName();
        Collection<ThinClientDescription> tcds = GfxdTestConfig.getInstance().getThinClientDescriptions().values();
        for (ThinClientDescription tcd : tcds) {
            if (!tcd.getClientNames().contains(clientName)) continue;
            return true;
        }
        return false;
    }

    public static void initDBTask() throws DBException, WorkloadException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        client.initDB();
        client.updateHydraThreadLocals();
    }

    protected void initDB() throws DBException {
        this.db = new GFXDDB();
        this.db.init();
        this.gfxdstats = GFXDStats.getInstance();
    }

    public static void cleanupDBTask() throws DBException, InterruptedException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        client.cleanupDB();
        client.updateHydraThreadLocals();
    }

    protected void cleanupDB() throws DBException, InterruptedException {
        if (this.gfxdstats != null) {
            Thread.sleep(2000L);
            this.gfxdstats.close();
            this.gfxdstats = null;
        }
        this.db.cleanup();
    }

    public static void initWorkloadTask() throws WorkloadException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        client.initWorkload();
        client.updateHydraThreadLocals();
    }

    protected void initWorkload() throws WorkloadException {
        this.workload = new CoreWorkload();
        this.workload.init(null, this.ttgid, this.numThreads);
        this.workloadstate = this.workload.initThread(null);
    }

    public static void loadDataTask() {
        GFXDClient client = new GFXDClient();
        client.initialize();
        client.loadData();
    }

    public static void doWorkloadTask() throws InterruptedException {
        GFXDClient client = new GFXDClient();
        client.initialize();
        client.doWorkload();
    }

    @Override
    protected long completeTask(String trimIntervalName) {
        String hdfsStoreConfig;
        long timestamp = 0L;
        if (this.ttgid == 0 && (hdfsStoreConfig = GfxdConfigPrms.getHDFSStoreConfig()) != null) {
            try {
                if (GFXDPrms.hdfsFlushQueues()) {
                    this.hdfsFlushQueues();
                    timestamp = System.currentTimeMillis();
                }
                if (GFXDPrms.hdfsForceCompaction()) {
                    this.hdfsForceCompaction();
                    timestamp = System.currentTimeMillis();
                }
            }
            catch (SQLException e) {
                String s = "Problem completing workload";
                throw new PerfTestException(s, e);
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hdfsFlushQueues() throws SQLException {
        long start = this.gfxdstats.startHDFSFlushQueues();
        Connection conn = this.openTmpConnection();
        List<String> tableNames = this.getHDFSPartitionedTables();
        try {
            PreparedStatement ps = conn.prepareStatement(HDFS_FLUSH_QUEUE_CALL);
            for (String tableName : tableNames) {
                ps.setString(1, tableName);
                ps.setInt(2, 0);
                ps.execute();
            }
            ps.close();
        }
        finally {
            this.closeTmpConnection(conn);
        }
        this.gfxdstats.endHDFSFlushQueues(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hdfsForceCompaction() throws SQLException {
        long start = this.gfxdstats.startHDFSForceCompaction();
        Connection conn = this.openTmpConnection();
        List<String> tableNames = this.getHDFSPartitionedTables();
        try {
            PreparedStatement ps = conn.prepareStatement(HDFS_FORCE_COMPACTION_CALL);
            for (String tableName : tableNames) {
                ps.setString(1, tableName);
                ps.setInt(2, 0);
                ps.execute();
            }
            ps.close();
        }
        finally {
            this.closeTmpConnection(conn);
        }
        this.gfxdstats.endHDFSForceCompaction(start);
    }
}

