/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.ycsb.gfxd;

import gfxdperf.PerfTestException;
import gfxdperf.ycsb.gfxd.GFXDPrms;
import hydra.Log;
import hydra.gemfirexd.NetworkServerHelper;
import hydra.gemfirexd.ThinClientHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

public class GFXDUtil {
    public static final String PEER_DRIVER = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    public static final String THIN_DRIVER = "com.pivotal.gemfirexd.jdbc.ClientDriver";
    public static final String PROTOCOL = "jdbc:gemfirexd:";

    public static Connection openConnection(GFXDPrms.ConnectionType type) throws SQLException {
        switch (type) {
            case peer: {
                return GFXDUtil.openPeerClientConnection();
            }
            case thin: {
                return GFXDUtil.openThinClientConnection();
            }
        }
        String s = "Should not happen";
        throw new PerfTestException(s);
    }

    public static Connection openPeerClientConnection() throws SQLException {
        Properties p = new Properties();
        p.setProperty("enable-stats", String.valueOf(GFXDPrms.enableStats()));
        p.setProperty("enable-timestats", String.valueOf(GFXDPrms.enableTimeStats()));
        return GFXDUtil.openConnection(PEER_DRIVER, PROTOCOL, GFXDPrms.getTxIsolation(), GFXDPrms.getAutoCommit(), p);
    }

    public static Connection openThinClientConnection() throws SQLException {
        List endpoints = NetworkServerHelper.getNetworkLocatorEndpoints();
        if (endpoints.size() == 0) {
            String s = "No network locator endpoints found";
            throw new PerfTestException(s);
        }
        String url = "jdbc:gemfirexd://" + endpoints.get(0);
        Properties p = ThinClientHelper.getConnectionProperties();
        List secondaries = endpoints.subList(1, endpoints.size());
        if (secondaries.size() > 0) {
            String val = "";
            for (int i = 0; i < secondaries.size(); ++i) {
                if (i > 0) {
                    val = val + ",";
                }
                val = val + ((NetworkServerHelper.Endpoint)secondaries.get(i)).toString();
            }
            p.setProperty("secondary-locators", val);
        }
        return GFXDUtil.openConnection(THIN_DRIVER, url, GFXDPrms.getTxIsolation(), GFXDPrms.getAutoCommit(), p);
    }

    public static Connection openConnection(String driver, String url, int txIsolation, boolean autocommit) throws SQLException {
        return GFXDUtil.openConnection(driver, url, txIsolation, autocommit, null);
    }

    public static Connection openConnection(String driver, String url, int txIsolation, boolean autocommit, Properties p) throws SQLException {
        Log.getLogWriter().info("Creating connection using " + driver + " with " + url + " and properties: " + p);
        GFXDUtil.loadDriver(driver);
        Connection conn = p == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, p);
        conn.setAutoCommit(autocommit);
        conn.setTransactionIsolation(txIsolation);
        Log.getLogWriter().info("Created connection using transaction isolation: " + GFXDPrms.getTxIsolation(conn.getTransactionIsolation()) + " autocommit: " + autocommit);
        return conn;
    }

    public static Connection openBasicEmbeddedConnection() throws SQLException {
        return GFXDUtil.openConnection(PEER_DRIVER, PROTOCOL, 0, false);
    }

    private static void loadDriver(String driver) {
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            String s = "Problem loading JDBC driver: " + driver;
            throw new PerfTestException(s, e);
        }
    }
}

