/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.cache.DiskStoreFactory;
import hydra.AbstractDescription;
import hydra.ConfigHashtable;
import hydra.HydraVector;
import hydra.TestConfig;
import hydra.gemfirexd.DiskStorePrms;
import hydra.gemfirexd.GfxdTestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class DiskStoreDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String TIC = "'";
    private String name;
    private Boolean allowForceCompaction;
    private Boolean autoCompact;
    private Integer compactionThreshold;
    private List<String> dirNames;
    private Integer maxDirSize;
    private Long maxLogSize;
    private Integer queueSize;
    private Long timeInterval;
    private Integer writeBufferSize;
    private transient String DDL;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private Boolean getAllowForceCompaction() {
        return this.allowForceCompaction;
    }

    private void setAllowForceCompaction(Boolean bool) {
        this.allowForceCompaction = bool;
    }

    private Boolean getAutoCompact() {
        return this.autoCompact;
    }

    private void setAutoCompact(Boolean bool) {
        this.autoCompact = bool;
    }

    private Integer getCompactionThreshold() {
        return this.compactionThreshold;
    }

    private void setCompactionThreshold(Integer i) {
        this.compactionThreshold = i;
    }

    private void setDirNames(List<String> l) {
        this.dirNames = l;
    }

    private List<String> getDirNames() {
        return this.dirNames;
    }

    private void setMaxDirSize(Integer i) {
        this.maxDirSize = i;
    }

    private Integer getMaxDirSize() {
        return this.maxDirSize;
    }

    private Long getMaxLogSize() {
        return this.maxLogSize;
    }

    private void setMaxLogSize(Long l) {
        this.maxLogSize = l;
    }

    private Integer getQueueSize() {
        return this.queueSize;
    }

    private void setQueueSize(Integer i) {
        this.queueSize = i;
    }

    private Long getTimeInterval() {
        return this.timeInterval;
    }

    private void setTimeInterval(Long l) {
        this.timeInterval = l;
    }

    private Integer getWriteBufferSize() {
        return this.writeBufferSize;
    }

    private void setWriteBufferSize(Integer i) {
        this.writeBufferSize = i;
    }

    protected synchronized String getDDL() {
        if (this.DDL == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("CREATE DISKSTORE ").append(this.getName()).append(SPACE).append("ALLOWFORCECOMPACTION").append(SPACE).append(this.getAllowForceCompaction()).append(SPACE).append("AUTOCOMPACT").append(SPACE).append(this.getAutoCompact()).append(SPACE).append("COMPACTIONTHRESHOLD").append(SPACE).append(this.getCompactionThreshold()).append(SPACE).append("MAXLOGSIZE").append(SPACE).append(this.getMaxLogSize()).append(SPACE).append("QUEUESIZE").append(SPACE).append(this.getQueueSize()).append(SPACE).append("TIMEINTERVAL").append(SPACE).append(this.getTimeInterval()).append(SPACE).append("WRITEBUFFERSIZE").append(SPACE).append(this.getWriteBufferSize());
            List<String> dirs = this.getDirNames();
            Integer size = this.getMaxDirSize();
            buf.append(SPACE).append("(");
            for (int i = 0; i < dirs.size(); ++i) {
                if (i > 0) {
                    buf.append(COMMA).append(SPACE);
                }
                buf.append(TIC).append(dirs.get(i)).append(TIC);
                if (size == null) continue;
                buf.append(SPACE).append(size);
            }
            buf.append(")");
            this.DDL = buf.toString();
        }
        return this.DDL;
    }

    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "allowForceCompaction", this.getAllowForceCompaction());
        map.put(header + "autoCompact", this.getAutoCompact());
        map.put(header + "compactionThreshold", this.getCompactionThreshold());
        map.put(header + "dirNames", this.getDirNames());
        if (this.getMaxDirSize() == null) {
            map.put(header + "maxDirSize", "unlimited");
        } else {
            map.put(header + "maxDirSize", this.getMaxDirSize());
        }
        map.put(header + "maxLogSize", this.getMaxLogSize());
        map.put(header + "queueSize", this.getQueueSize());
        map.put(header + "timeInterval", this.getTimeInterval());
        map.put(header + "writeBufferSize", this.getWriteBufferSize());
        return map;
    }

    protected static Map configure(TestConfig config, GfxdTestConfig sconfig) {
        ConfigHashtable tab = config.getParameters();
        TreeMap<String, DiskStoreDescription> dsds = new TreeMap<String, DiskStoreDescription>();
        HydraVector names = tab.vecAt(DiskStorePrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            DiskStoreDescription dsd = DiskStoreDescription.createDiskStoreDescription(name, config, sconfig, i);
            dsds.put(name, dsd);
        }
        return dsds;
    }

    private static DiskStoreDescription createDiskStoreDescription(String name, TestConfig config, GfxdTestConfig sconfig, int index) {
        ConfigHashtable tab = config.getParameters();
        DiskStoreDescription dsd = new DiskStoreDescription();
        dsd.setName(name);
        Long key = DiskStorePrms.allowForceCompaction;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        dsd.setAllowForceCompaction(bool);
        key = DiskStorePrms.autoCompact;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        dsd.setAutoCompact(bool);
        key = DiskStorePrms.compactionThreshold;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 50;
        }
        dsd.setCompactionThreshold(i);
        key = DiskStorePrms.dirNames;
        Object l = DiskStoreDescription.getDirNames(key, (Vector)tab.vecAtWild(key, index, null), tab);
        dsd.setDirNames((List<String>)l);
        key = DiskStorePrms.maxDirSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i != null) {
            dsd.setMaxDirSize(i);
        }
        if ((l = tab.getLong(key = DiskStorePrms.maxLogSize, tab.getWild(key, index, null))) == null) {
            l = DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE;
        }
        dsd.setMaxLogSize((Long)l);
        key = DiskStorePrms.queueSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        dsd.setQueueSize(i);
        key = DiskStorePrms.timeInterval;
        l = tab.getLong(key, tab.getWild(key, index, null));
        if (l == null) {
            l = 1000L;
        }
        dsd.setTimeInterval((Long)l);
        key = DiskStorePrms.writeBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 32768;
        }
        dsd.setWriteBufferSize(i);
        return dsd;
    }

    private static List<String> getDirNames(Long key, Vector val, ConfigHashtable tab) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (val != null) {
            for (int i = 0; i < val.size(); ++i) {
                String dir = tab.getString(key, ConfigHashtable.getWild((Vector)val, (int)i, null));
                if (dir == null) continue;
                dirs.add(dir);
            }
        }
        if (dirs.size() == 0) {
            dirs.add("data");
        }
        return dirs;
    }
}

