/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.LogWriter;
import hydra.BasePrms;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.gemfirexd.DiskStoreDescription;
import hydra.gemfirexd.DiskStorePrms;
import hydra.gemfirexd.GfxdTestConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DiskStoreHelper {
    private static LogWriter log = Log.getLogWriter();

    public static synchronized List<String> getDiskStoreDDL() {
        log.info("Generating DiskStore DDL");
        ArrayList<String> ddls = new ArrayList<String>();
        Collection dsds = GfxdTestConfig.getInstance().getDiskStoreDescriptions().values();
        for (DiskStoreDescription dsd : dsds) {
            String ddl = dsd.getDDL();
            ddls.add(ddl);
        }
        log.info("Generated DiskStore DDL: " + ddls);
        return ddls;
    }

    public static synchronized String getDiskStoreDDL(String diskStoreConfig) {
        DiskStoreDescription dsd = GfxdTestConfig.getInstance().getDiskStoreDescription(diskStoreConfig);
        log.info("Generating DiskStore DDL for " + diskStoreConfig + " using " + dsd);
        String ddl = dsd.getDDL();
        log.info("Generated DiskStore DDL for " + diskStoreConfig + ": " + ddl);
        return ddl;
    }

    public static DiskStoreDescription getDiskStoreDescription(String diskStoreConfig) {
        if (diskStoreConfig == null) {
            throw new IllegalArgumentException("diskStoreConfig cannot be null");
        }
        log.info("Looking up disk store config: " + diskStoreConfig);
        DiskStoreDescription dsd = GfxdTestConfig.getInstance().getDiskStoreDescription(diskStoreConfig);
        if (dsd == null) {
            String s = diskStoreConfig + " not found in " + BasePrms.nameForKey((Long)DiskStorePrms.names);
            throw new HydraRuntimeException(s);
        }
        log.info("Looked up disk store config:\n" + dsd);
        return dsd;
    }
}

