/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.pivotal.gemfirexd.auth.callback.UserAuthenticator;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.TestConfig;
import hydra.gemfirexd.FabricSecurityPrms;
import hydra.gemfirexd.GfxdTestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class FabricSecurityDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String authProvider;
    private String authzDefaultConnectionMode;
    private List authzFullAccessUsers;
    private String authzFullAccessUsersStr;
    private List authzReadOnlyAccessUsers;
    private String authzReadOnlyAccessUsersStr;
    private String password;
    private String serverAuthProvider;
    private Boolean sqlAuthorization;
    private String user;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public String getAuthProvider() {
        return this.authProvider;
    }

    private void setAuthProvider(String str) {
        this.authProvider = str;
    }

    public String getAuthzDefaultConnectionMode() {
        return this.authzDefaultConnectionMode;
    }

    private void setAuthzDefaultConnectionMode(String str) {
        this.authzDefaultConnectionMode = str;
    }

    public List<String> getAuthzFullAccessUsers() {
        return this.authzFullAccessUsers;
    }

    private void setAuthzFullAccessUsers(List<String> list) {
        this.authzFullAccessUsers = list;
    }

    public String getAuthzFullAccessUsersStr() {
        return this.authzFullAccessUsersStr;
    }

    private void setAuthzFullAccessUsersStr(String str) {
        this.authzFullAccessUsersStr = str;
    }

    public List<String> getAuthzReadOnlyAccessUsers() {
        return this.authzReadOnlyAccessUsers;
    }

    private void setAuthzReadOnlyAccessUsers(List<String> list) {
        this.authzReadOnlyAccessUsers = list;
    }

    public String getAuthzReadOnlyAccessUsersStr() {
        return this.authzReadOnlyAccessUsersStr;
    }

    private void setAuthzReadOnlyAccessUsersStr(String str) {
        this.authzReadOnlyAccessUsersStr = str;
    }

    public String getPassword() {
        return this.password;
    }

    private void setPassword(String str) {
        this.password = str;
    }

    public String getServerAuthProvider() {
        return this.serverAuthProvider;
    }

    private void setServerAuthProvider(String str) {
        this.serverAuthProvider = str;
    }

    public Boolean getSqlAuthorization() {
        return this.sqlAuthorization;
    }

    private void setSqlAuthorization(Boolean bool) {
        this.sqlAuthorization = bool;
    }

    public String getUser() {
        return this.user;
    }

    private void setUser(String str) {
        this.user = str;
    }

    protected Properties getBootProperties() {
        Properties p = new Properties();
        if (this.getAuthProvider() != null) {
            p.setProperty("auth-provider", this.getAuthProvider());
        }
        if (this.getAuthzDefaultConnectionMode() != null) {
            p.setProperty("gemfirexd.authz-default-connection-mode", this.getAuthzDefaultConnectionMode());
        }
        if (this.getAuthzFullAccessUsers() != null) {
            p.setProperty("gemfirexd.authz-full-access-users", this.getAuthzFullAccessUsersStr());
        }
        if (this.getAuthzReadOnlyAccessUsers() != null) {
            p.setProperty("gemfirexd.authz-read-only-access-users", this.getAuthzReadOnlyAccessUsersStr());
        }
        if (this.getServerAuthProvider() != null) {
            p.setProperty("server-auth-provider", this.getServerAuthProvider());
        }
        p.setProperty("gemfirexd.sql-authorization", this.getSqlAuthorization().toString());
        if (this.getUser() != null) {
            p.setProperty("gemfirexd.user." + this.getUser(), this.getPassword());
            p.setProperty(TestConfig.tab().getRandGen().nextBoolean() ? "user" : "UserName", this.getUser());
            p.setProperty("password", this.getPassword());
        }
        return p;
    }

    protected Properties getShutdownProperties() {
        Properties p = new Properties();
        if (this.getUser() != null) {
            p.setProperty("gemfirexd.user." + this.getUser(), this.getPassword());
            p.setProperty("user", this.getUser());
            p.setProperty("password", this.getPassword());
        }
        return p;
    }

    public SortedMap<String, Object> toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "authProvider", this.getAuthProvider());
        map.put(header + "authzDefaultConnectionMode", this.getAuthzDefaultConnectionMode());
        map.put(header + "authzFullAccessUsers", this.getAuthzFullAccessUsersStr());
        map.put(header + "authzReadOnlyAccessUsers", this.getAuthzReadOnlyAccessUsersStr());
        map.put(header + "password", this.getPassword());
        map.put(header + "serverAuthProvider", this.getServerAuthProvider());
        map.put(header + "sqlAuthorization", this.getSqlAuthorization());
        map.put(header + "user", this.getUser());
        return map;
    }

    protected static Map configure(TestConfig config, GfxdTestConfig sconfig) {
        ConfigHashtable tab = config.getParameters();
        TreeMap<String, FabricSecurityDescription> fsds = new TreeMap<String, FabricSecurityDescription>();
        HydraVector names = tab.vecAt(FabricSecurityPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            if (fsds.containsKey(name)) {
                String s = BasePrms.nameForKey((Long)FabricSecurityPrms.names) + " contains duplicate entries: " + names;
                throw new HydraConfigException(s);
            }
            FabricSecurityDescription fsd = FabricSecurityDescription.createFabricSecurityDescription(name, config, sconfig, i);
            fsds.put(name, fsd);
        }
        return fsds;
    }

    private static FabricSecurityDescription createFabricSecurityDescription(String name, TestConfig config, GfxdTestConfig sconfig, int index) {
        Boolean bool;
        List<String> list;
        HydraVector strs;
        ConfigHashtable tab = config.getParameters();
        FabricSecurityDescription fsd = new FabricSecurityDescription();
        fsd.setName(name);
        Long key = FabricSecurityPrms.authProvider;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null) {
            fsd.setAuthProvider(FabricSecurityDescription.getAuthProvider(str, key));
        }
        if ((str = tab.getString(key = FabricSecurityPrms.authzDefaultConnectionMode, tab.getWild(key, index, null))) != null) {
            fsd.setAuthzDefaultConnectionMode(FabricSecurityDescription.getAuthzDefaultConnectionMode(str, key));
        }
        if ((strs = tab.vecAtWild(key = FabricSecurityPrms.authzFullAccessUsers, index, null)) != null) {
            list = FabricSecurityDescription.getAccessUsers((Vector)strs, key);
            fsd.setAuthzFullAccessUsers(list);
            fsd.setAuthzFullAccessUsersStr(FabricSecurityDescription.getAccessUsersString(list));
        }
        if ((strs = tab.vecAtWild(key = FabricSecurityPrms.authzReadOnlyAccessUsers, index, null)) != null) {
            list = FabricSecurityDescription.getAccessUsers((Vector)strs, key);
            fsd.setAuthzReadOnlyAccessUsers(list);
            fsd.setAuthzReadOnlyAccessUsersStr(FabricSecurityDescription.getAccessUsersString(list));
        }
        if ((str = tab.getString(key = FabricSecurityPrms.password, tab.getWild(key, index, null))) != null) {
            fsd.setPassword(str);
        }
        if ((str = tab.getString(key = FabricSecurityPrms.serverAuthProvider, tab.getWild(key, index, null))) != null) {
            fsd.setServerAuthProvider(FabricSecurityDescription.getAuthProvider(str, key));
        }
        if ((bool = tab.getBoolean(key = FabricSecurityPrms.sqlAuthorization, tab.getWild(key, index, null))) == null) {
            bool = Boolean.FALSE;
        }
        fsd.setSqlAuthorization(bool);
        key = FabricSecurityPrms.user;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null) {
            fsd.setUser(str);
        }
        return fsd;
    }

    private static String getAuthProvider(String str, Long key) {
        if (str.equalsIgnoreCase("BUILTIN")) {
            return "BUILTIN";
        }
        if (str.equalsIgnoreCase("LDAP")) {
            return "LDAP";
        }
        try {
            UserAuthenticator userAuthenticator = (UserAuthenticator)FabricSecurityDescription.getInstance((Long)key, (String)str);
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey((Long)key) + " does not implement " + UserAuthenticator.class.getName() + ": " + str;
            throw new HydraConfigException(s);
        }
        return str;
    }

    private static String getAuthzDefaultConnectionMode(String str, Long key) {
        if (str.equalsIgnoreCase("NOACCESS")) {
            return "NOACCESS";
        }
        if (str.equalsIgnoreCase("READONLYACCESS")) {
            return "READONLYACCESS";
        }
        if (str.equalsIgnoreCase("FULLACCESS")) {
            return "FULLACCESS";
        }
        String s = BasePrms.nameForKey((Long)key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    private static List<String> getAccessUsers(Vector strs, Long key) {
        if (strs.size() == 0) {
            return null;
        }
        if (strs.size() == 1 && strs.get(0).equals("none")) {
            return null;
        }
        return new ArrayList<String>(strs);
    }

    private static String getAccessUsersString(List<String> users) {
        if (users == null) {
            return null;
        }
        String str = "";
        for (String user : users) {
            str = str + (str.length() == 0 ? user : ", " + user);
        }
        return str;
    }
}

