/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.LogWriterImpl;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.VmDescription;
import hydra.blackboard.SharedMap;
import hydra.gemfirexd.FabricSecurityDescription;
import hydra.gemfirexd.FabricSecurityPrms;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.FabricServerPrms;
import hydra.gemfirexd.FabricServerVersionHelper;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.SysDiskDirBlackboard;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class FabricServerDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LONER = "loner";
    private String name;
    private Integer ackSevereAlertThreshold;
    private Integer ackWaitThreshold;
    private Integer archiveDiskSpaceLimit;
    private Integer archiveFileSizeLimit;
    private Integer asyncDistributionTimeout;
    private Integer asyncMaxQueueSize;
    private Integer asyncQueueTimeout;
    private transient String bindAddress;
    private List<String> clientNames;
    private Boolean conserveSockets;
    private Boolean disableAutoReconnect;
    private Boolean disableTcp;
    private String distributedSystem;
    private Integer distributedSystemId;
    private Boolean enableNetworkPartitionDetection;
    private Boolean enableStatsGlobally;
    private Boolean enableTimeStatistics;
    private Boolean enableTimeStatsGlobally;
    private Boolean enforceUniqueHost;
    private String fabricSecurityName;
    private FabricSecurityDescription fabricSecurityDescription;
    private Boolean hostData;
    private Boolean lockMemory;
    private transient String locators;
    private Integer logDiskSpaceLimit;
    private transient String logFile;
    private Integer logFileSizeLimit;
    private String logLevel;
    private Integer maxNumReconnectTries;
    private Integer maxWaitTimeForReconnect;
    private String mcastAddress;
    private Boolean mcastDistributionEnabled;
    private String mcastFlowControl;
    private Integer mcastPort;
    private Integer mcastRecvBufferSize;
    private Integer mcastSendBufferSize;
    private Integer mcastTtl;
    private String membershipPortRange;
    private Integer memberTimeout;
    private transient String nameOfMember;
    private String offHeapMemorySize;
    private Boolean persistDD;
    private Boolean persistIndexes;
    private Boolean persistQueues;
    private Boolean persistTables;
    private Boolean rebalance;
    private String redundancyZone;
    private List<String> remoteDistributedSystems;
    private transient String remoteLocators;
    private transient String resourceDir;
    private Boolean saveSysDiskDir;
    private transient String serverBindAddress;
    private List<String> serverGroups;
    private int socketBufferSize;
    private int socketLeaseTime;
    private transient String statisticArchiveFile;
    private Integer statisticSampleRate;
    private Boolean statisticSamplingEnabled;
    private transient String sysDir;
    private transient String sysDiskDir;
    private Map<String, List<String>> sysDiskDirBases;
    private Boolean tableDefaultPartitioned;
    private Integer tcpPort;
    private Integer udpFragmentSize;
    private Integer udpRecvBufferSize;
    private Integer udpSendBufferSize;
    private Boolean useExistingSysDiskDir;
    private Boolean useGenericSysDiskDir;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public Integer getAckSevereAlertThreshold() {
        return this.ackSevereAlertThreshold;
    }

    private void setAckSevereAlertThreshold(Integer i) {
        this.ackSevereAlertThreshold = i;
    }

    public Integer getAckWaitThreshold() {
        return this.ackWaitThreshold;
    }

    private void setAckWaitThreshold(Integer i) {
        this.ackWaitThreshold = i;
    }

    public Integer getArchiveDiskSpaceLimit() {
        return this.archiveDiskSpaceLimit;
    }

    private void setArchiveDiskSpaceLimit(Integer i) {
        this.archiveDiskSpaceLimit = i;
    }

    public Integer getArchiveFileSizeLimit() {
        return this.archiveFileSizeLimit;
    }

    private void setArchiveFileSizeLimit(Integer i) {
        this.archiveFileSizeLimit = i;
    }

    public Integer getAsyncDistributionTimeout() {
        return this.asyncDistributionTimeout;
    }

    private void setAsyncDistributionTimeout(Integer i) {
        this.asyncDistributionTimeout = i;
    }

    public Integer getAsyncMaxQueueSize() {
        return this.asyncMaxQueueSize;
    }

    private void setAsyncMaxQueueSize(Integer i) {
        this.asyncMaxQueueSize = i;
    }

    public Integer getAsyncQueueTimeout() {
        return this.asyncQueueTimeout;
    }

    private void setAsyncQueueTimeout(Integer i) {
        this.asyncQueueTimeout = i;
    }

    private synchronized String getBindAddress() {
        if (this.bindAddress == null) {
            String addr = "";
            if (TestConfig.tab().booleanAt(Prms.useIPv6) && (addr = HostHelper.getHostAddress()) == null) {
                String s = "IPv6 address is not available for this host";
                throw new HydraRuntimeException(s);
            }
            this.bindAddress = addr;
        }
        return this.bindAddress;
    }

    public List<String> getClientNames() {
        return this.clientNames;
    }

    private void setClientNames(List<String> list) {
        this.clientNames = list;
    }

    public Boolean getConserveSockets() {
        return this.conserveSockets;
    }

    private void setConserveSockets(Boolean bool) {
        this.conserveSockets = bool;
    }

    public Boolean getDisableAutoReconnect() {
        return this.disableAutoReconnect;
    }

    private void setDisableAutoReconnect(Boolean bool) {
        this.disableAutoReconnect = bool;
    }

    public Boolean getDisableTcp() {
        return this.disableTcp;
    }

    private void setDisableTcp(Boolean bool) {
        this.disableTcp = bool;
    }

    public String getDistributedSystem() {
        return this.distributedSystem;
    }

    private void setDistributedSystem(String str) {
        this.distributedSystem = str;
    }

    public Integer getDistributedSystemId() {
        return this.distributedSystemId;
    }

    private void setDistributedSystemId(Integer i) {
        this.distributedSystemId = i;
    }

    public Boolean getEnableNetworkPartitionDetection() {
        return this.enableNetworkPartitionDetection;
    }

    private void setEnableNetworkPartitionDetection(Boolean bool) {
        this.enableNetworkPartitionDetection = bool;
    }

    public Boolean getEnableStatsGlobally() {
        return this.enableStatsGlobally;
    }

    private void setEnableStatsGlobally(Boolean bool) {
        this.enableStatsGlobally = bool;
    }

    public Boolean getEnableTimeStatistics() {
        return this.enableTimeStatistics;
    }

    private void setEnableTimeStatistics(Boolean bool) {
        this.enableTimeStatistics = bool;
    }

    public Boolean getEnableTimeStatsGlobally() {
        return this.enableTimeStatsGlobally;
    }

    private void setEnableTimeStatsGlobally(Boolean bool) {
        this.enableTimeStatsGlobally = bool;
    }

    public Boolean getEnforceUniqueHost() {
        return this.enforceUniqueHost;
    }

    private void setEnforceUniqueHost(Boolean bool) {
        this.enforceUniqueHost = bool;
    }

    public String getFabricSecurityName() {
        return this.fabricSecurityName;
    }

    private void setFabricSecurityName(String str) {
        this.fabricSecurityName = str;
    }

    public FabricSecurityDescription getFabricSecurityDescription() {
        return this.fabricSecurityDescription;
    }

    private void setFabricSecurityDescription(FabricSecurityDescription fsd) {
        this.fabricSecurityDescription = fsd;
    }

    public Boolean getHostData() {
        return this.hostData;
    }

    private void setHostData(Boolean bool) {
        this.hostData = bool;
    }

    public Boolean getLockMemory() {
        return this.lockMemory;
    }

    private void setLockMemory(Boolean bool) {
        this.lockMemory = bool;
    }

    private synchronized String getLocators() {
        if (this.locators == null) {
            String locs = "";
            String dsname = this.getDistributedSystem();
            List<FabricServerHelper.Endpoint> endpoints = FabricServerHelper.getEndpoints(dsname);
            if (endpoints != null) {
                for (FabricServerHelper.Endpoint endpoint : endpoints) {
                    if (locs.length() > 0) {
                        locs = locs + ",";
                    }
                    locs = locs + endpoint.getId();
                }
            }
            this.locators = locs;
        }
        return this.locators;
    }

    public Integer getLogDiskSpaceLimit() {
        return this.logDiskSpaceLimit;
    }

    private void setLogDiskSpaceLimit(Integer i) {
        this.logDiskSpaceLimit = i;
    }

    private synchronized String getLogFile() {
        if (this.logFile == null) {
            this.logFile = this.getSysDir() + "/system.log";
        }
        return this.logFile;
    }

    public Integer getLogFileSizeLimit() {
        return this.logFileSizeLimit;
    }

    private void setLogFileSizeLimit(Integer i) {
        this.logFileSizeLimit = i;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    private void setLogLevel(String str) {
        this.logLevel = str;
    }

    public Integer getMaxNumReconnectTries() {
        return this.maxNumReconnectTries;
    }

    private void setMaxNumReconnectTries(Integer i) {
        this.maxNumReconnectTries = i;
    }

    private Integer getMaxWaitTimeForReconnect() {
        return this.maxWaitTimeForReconnect;
    }

    private void setMaxWaitTimeForReconnect(Integer i) {
        this.maxWaitTimeForReconnect = i;
    }

    public String getMcastAddress() {
        return this.mcastAddress;
    }

    private void setMcastAddress(String str) {
        this.mcastAddress = str;
    }

    public Boolean getMcastDistributionEnabled() {
        return this.mcastDistributionEnabled;
    }

    private void setMcastDistributionEnabled(Boolean bool) {
        this.mcastDistributionEnabled = bool;
    }

    public String getMcastFlowControl() {
        return this.mcastFlowControl;
    }

    private void setMcastFlowControl(String str) {
        this.mcastFlowControl = str;
    }

    public Integer getMcastPort() {
        return this.mcastPort;
    }

    private void setMcastPort(Integer i) {
        this.mcastPort = i;
    }

    public Integer getMcastRecvBufferSize() {
        return this.mcastRecvBufferSize;
    }

    private void setMcastRecvBufferSize(Integer i) {
        this.mcastRecvBufferSize = i;
    }

    public Integer getMcastSendBufferSize() {
        return this.mcastSendBufferSize;
    }

    private void setMcastSendBufferSize(Integer i) {
        this.mcastSendBufferSize = i;
    }

    public Integer getMcastTtl() {
        return this.mcastTtl;
    }

    private void setMcastTtl(Integer i) {
        this.mcastTtl = i;
    }

    public String getMembershipPortRange() {
        return this.membershipPortRange;
    }

    private void setMembershipPortRange(String str) {
        this.membershipPortRange = str;
    }

    public Integer getMemberTimeout() {
        return this.memberTimeout;
    }

    private void setMemberTimeout(Integer i) {
        this.memberTimeout = i;
    }

    private synchronized String getNameOfMember() {
        if (this.nameOfMember == null) {
            this.nameOfMember = RemoteTestModule.getCurrentThread() == null ? this.name : this.name + "_" + RemoteTestModule.getMyHost() + "_" + RemoteTestModule.getMyPid();
        }
        return this.nameOfMember;
    }

    public String getOffHeapMemorySize() {
        return this.offHeapMemorySize;
    }

    private void setOffHeapMemorySize(String str) {
        this.offHeapMemorySize = str;
    }

    public Boolean getPersistDD() {
        return this.persistDD;
    }

    private void setPersistDD(Boolean bool) {
        this.persistDD = bool;
    }

    public Boolean getPersistIndexes() {
        return this.persistIndexes;
    }

    private void setPersistIndexes(Boolean bool) {
        this.persistIndexes = bool;
    }

    public Boolean getPersistQueues() {
        return this.persistQueues;
    }

    private void setPersistQueues(Boolean bool) {
        this.persistQueues = bool;
    }

    public Boolean getPersistTables() {
        return this.persistTables;
    }

    private void setPersistTables(Boolean bool) {
        this.persistTables = bool;
    }

    public Boolean getRebalance() {
        return this.rebalance;
    }

    private void setRebalance(Boolean bool) {
        this.rebalance = bool;
    }

    public String getRedundancyZone() {
        return this.redundancyZone;
    }

    private void setRedundancyZone(String str) {
        this.redundancyZone = str;
    }

    public List<String> getRemoteDistributedSystems() {
        return this.remoteDistributedSystems;
    }

    private void setRemoteDistributedSystems(List<String> systems) {
        this.remoteDistributedSystems = systems;
    }

    protected synchronized String getRemoteLocators() {
        if (this.remoteLocators == null) {
            String locs = "";
            List<String> dsnames = this.getRemoteDistributedSystems();
            if (dsnames != null) {
                List<FabricServerHelper.Endpoint> endpoints = FabricServerHelper.getEndpoints(dsnames);
                for (FabricServerHelper.Endpoint endpoint : endpoints) {
                    if (locs.length() > 0) {
                        locs = locs + ",";
                    }
                    locs = locs + endpoint.getId();
                }
            }
            this.remoteLocators = locs;
        }
        return this.remoteLocators;
    }

    private synchronized String getResourceDir() {
        if (this.resourceDir == null) {
            HostDescription hd = this.getHostDescription();
            String dir = hd.getResourceDir();
            if (dir == null) {
                dir = hd.getUserDir();
            }
            this.resourceDir = dir;
        }
        return this.resourceDir;
    }

    public Boolean saveSysDiskDir() {
        return this.saveSysDiskDir;
    }

    private void setSaveSysDiskDir(Boolean bool) {
        this.saveSysDiskDir = bool;
    }

    private synchronized String getServerBindAddress() {
        if (this.serverBindAddress == null) {
            this.serverBindAddress = this.getBindAddress();
        }
        return this.serverBindAddress;
    }

    public List<String> getServerGroups() {
        return this.serverGroups;
    }

    public String getServerGroupsProperty() {
        String str = "";
        for (String group : this.serverGroups) {
            str = str + (str.length() == 0 ? group : "," + group);
        }
        return str.length() == 0 ? null : str;
    }

    private void setServerGroups(List<String> list) {
        this.serverGroups = list;
    }

    public Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    private void setSocketBufferSize(Integer i) {
        this.socketBufferSize = i;
    }

    public Integer getSocketLeaseTime() {
        return this.socketLeaseTime;
    }

    private void setSocketLeaseTime(Integer i) {
        this.socketLeaseTime = i;
    }

    private synchronized String getStatisticArchiveFile() {
        if (this.statisticArchiveFile == null) {
            this.statisticArchiveFile = this.getSysDir() + "/statArchive.gfs";
        }
        return this.statisticArchiveFile;
    }

    public Integer getStatisticSampleRate() {
        return this.statisticSampleRate;
    }

    private void setStatisticSampleRate(Integer i) {
        this.statisticSampleRate = i;
    }

    public Boolean getStatisticSamplingEnabled() {
        return this.statisticSamplingEnabled;
    }

    private void setStatisticSamplingEnabled(Boolean bool) {
        this.statisticSamplingEnabled = bool;
    }

    public synchronized String getSysDir() {
        if (this.sysDir == null) {
            HostDescription hd = this.getHostDescription();
            String dir = this.getResourceDir() + "/" + "vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "_" + hd.getHostName() + "_" + RemoteTestModule.getMyPid();
            FileUtil.mkdir((File)new File(dir));
            try {
                RemoteTestModule.Master.recordDir(hd, this.getName(), dir);
            }
            catch (RemoteException e) {
                String s = "Unable to access master to record directory: " + dir;
                throw new HydraRuntimeException(s, (Exception)e);
            }
            this.sysDir = dir;
        }
        return this.sysDir;
    }

    public synchronized String getSysDiskDir() {
        if (this.sysDiskDir == null && (this.getPersistDD().booleanValue() || this.getPersistQueues().booleanValue() || this.getPersistTables().booleanValue())) {
            HostDescription hd;
            String hostName;
            List<String> paths;
            Map<String, List<String>> bases = this.getSysDiskDirBases();
            if (bases != null && (paths = bases.get(hostName = (hd = this.getHostDescription()).getHostName())) != null) {
                Integer nextPathNum;
                SharedMap map = SysDiskDirBlackboard.getInstance().getSharedMap();
                Integer newPathNum = null;
                while (!map.replace((Object)hostName, (Object)(nextPathNum = (Integer)map.get((Object)hostName)), (Object)(newPathNum = Integer.valueOf((nextPathNum + 1) % paths.size())))) {
                }
                String path = paths.get(nextPathNum);
                String testDir = new File(this.getSysDir()).getParentFile().getName();
                String dir = path;
                if (!this.useGenericSysDiskDir.booleanValue()) {
                    dir = dir + File.separator + testDir;
                }
                dir = dir + File.separator + "vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "_" + hd.getHostName() + "_disk";
                dir = EnvHelper.expandEnvVars((String)dir, (HostDescription)hd);
                if (this.useExistingSysDiskDir.booleanValue()) {
                    if (!FileUtil.exists((String)dir)) {
                        String s = BasePrms.nameForKey((Long)FabricServerPrms.useExistingSysDiskDir) + "=true but system disk directory was not found: " + dir;
                        throw new HydraRuntimeException(s);
                    }
                } else {
                    if (this.useGenericSysDiskDir.booleanValue() && FileUtil.exists((String)dir)) {
                        String s = BasePrms.nameForKey((Long)FabricServerPrms.useExistingSysDiskDir) + "=false but system disk directory already exists: " + dir;
                        throw new HydraRuntimeException(s);
                    }
                    FileUtil.mkdir((File)new File(dir));
                }
                if (!this.saveSysDiskDir().booleanValue()) {
                    try {
                        RemoteTestModule.Master.recordDir(hd, this.getName(), dir);
                    }
                    catch (RemoteException e) {
                        String s = "Unable to access master to record directory: " + dir;
                        throw new HydraRuntimeException(s, (Exception)e);
                    }
                }
                this.sysDiskDir = dir;
            }
            if (this.sysDiskDir == null) {
                hd = this.getHostDescription();
                String dir = this.getResourceDir() + "/" + "vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "_" + hd.getHostName() + "_disk";
                FileUtil.mkdir((File)new File(dir));
                try {
                    RemoteTestModule.Master.recordDir(hd, this.getName(), dir);
                }
                catch (RemoteException e) {
                    String s = "Unable to access master to record directory: " + dir;
                    throw new HydraRuntimeException(s, (Exception)e);
                }
                this.sysDiskDir = dir;
            }
        }
        return this.sysDiskDir;
    }

    private Map<String, List<String>> getSysDiskDirBases() {
        return this.sysDiskDirBases;
    }

    private void setSysDiskDirBases(Map<String, List<String>> bases) {
        this.sysDiskDirBases = bases;
    }

    public Boolean useExistingSysDiskDir() {
        return this.useExistingSysDiskDir;
    }

    private void setUseExistingSysDiskDir(Boolean bool) {
        this.useExistingSysDiskDir = bool;
    }

    public Boolean useGenericSysDiskDir() {
        return this.useGenericSysDiskDir;
    }

    private void setUseGenericSysDiskDir(Boolean bool) {
        this.useGenericSysDiskDir = bool;
    }

    public Boolean getTableDefaultPartitioned() {
        return this.tableDefaultPartitioned;
    }

    private void setTableDefaultPartitioned(Boolean bool) {
        this.tableDefaultPartitioned = bool;
    }

    public Integer getTcpPort() {
        return this.tcpPort;
    }

    private void setTcpPort(Integer i) {
        this.tcpPort = i;
    }

    public Integer getUdpFragmentSize() {
        return this.udpFragmentSize;
    }

    private void setUdpFragmentSize(Integer i) {
        this.udpFragmentSize = i;
    }

    public Integer getUdpRecvBufferSize() {
        return this.udpRecvBufferSize;
    }

    private void setUdpRecvBufferSize(Integer i) {
        this.udpRecvBufferSize = i;
    }

    public Integer getUdpSendBufferSize() {
        return this.udpSendBufferSize;
    }

    private void setUdpSendBufferSize(Integer i) {
        this.udpSendBufferSize = i;
    }

    private HostDescription getHostDescription() {
        String clientName = RemoteTestModule.getMyClientName();
        if (clientName == null) {
            String s = "This method can only be invoked from hydra client VMs";
            throw new HydraInternalException(s);
        }
        if (this.clientNames != null && !this.clientNames.contains(clientName)) {
            String s = "Logical client " + clientName + " is not in the list of clients supported by " + BasePrms.nameForKey((Long)FabricServerPrms.names) + "=" + this.getName();
            throw new HydraRuntimeException(s);
        }
        return TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
    }

    protected Properties getBootProperties() {
        Properties p = new Properties();
        p.setProperty("name", this.getNameOfMember());
        p.setProperty("ack-severe-alert-threshold", this.getAckSevereAlertThreshold().toString());
        p.setProperty("ack-wait-threshold", this.getAckWaitThreshold().toString());
        p.setProperty("archive-disk-space-limit", this.getArchiveDiskSpaceLimit().toString());
        p.setProperty("archive-file-size-limit", this.getArchiveFileSizeLimit().toString());
        p.setProperty("async-distribution-timeout", this.getAsyncDistributionTimeout().toString());
        p.setProperty("async-max-queue-size", this.getAsyncMaxQueueSize().toString());
        p.setProperty("async-queue-timeout", this.getAsyncQueueTimeout().toString());
        p.setProperty("bind-address", this.getBindAddress());
        p.setProperty("conserve-sockets", this.getConserveSockets().toString());
        p.setProperty("disable-auto-reconnect", this.getDisableAutoReconnect().toString());
        p.setProperty("disable-tcp", this.getDisableTcp().toString());
        p.setProperty("enable-network-partition-detection", this.getEnableNetworkPartitionDetection().toString());
        p.setProperty("enable-time-statistics", this.getEnableTimeStatistics().toString());
        p.setProperty("enforce-unique-host", this.getEnforceUniqueHost().toString());
        if (this.getFabricSecurityDescription() != null) {
            this.addProperties(this.getFabricSecurityDescription().getBootProperties(), p);
        }
        p.setProperty("host-data", this.getHostData().toString());
        p.setProperty("lock-memory", this.getLockMemory().toString());
        p.setProperty("locators", this.getLocators());
        p.setProperty("log-disk-space-limit", this.getLogDiskSpaceLimit().toString());
        p.setProperty("log-file", this.getLogFile());
        p.setProperty("log-file-size-limit", this.getLogFileSizeLimit().toString());
        p.setProperty("log-level", this.getLogLevel());
        p.setProperty("max-num-reconnect-tries", this.getMaxNumReconnectTries().toString());
        p.setProperty("max-wait-time-reconnect", this.getMaxWaitTimeForReconnect().toString());
        p.setProperty("mcast-address", this.getMcastAddress());
        p.setProperty("mcast-flow-control", this.getMcastFlowControl());
        p.setProperty("mcast-port", this.getMcastPort().toString());
        p.setProperty("mcast-recv-buffer-size", this.getMcastRecvBufferSize().toString());
        p.setProperty("mcast-send-buffer-size", this.getMcastSendBufferSize().toString());
        p.setProperty("mcast-ttl", this.getMcastTtl().toString());
        p.setProperty("membership-port-range", this.getMembershipPortRange());
        p.setProperty("member-timeout", this.getMemberTimeout().toString());
        if (this.getOffHeapMemorySize() != null) {
            p.setProperty("off-heap-memory-size", this.getOffHeapMemorySize().toString());
        }
        if (this.getRedundancyZone() != null) {
            p.setProperty("redundancy-zone", this.getRedundancyZone());
        }
        p.setProperty("persist-dd", this.getPersistDD().toString());
        p.setProperty("persist-indexes", this.getPersistIndexes().toString());
        FabricServerVersionHelper.setRebalance(p, this.getRebalance());
        p.setProperty("server-bind-address", this.getServerBindAddress());
        p.setProperty("socket-buffer-size", this.getSocketBufferSize().toString());
        p.setProperty("socket-lease-time", this.getSocketLeaseTime().toString());
        p.setProperty("statistic-archive-file", this.getStatisticArchiveFile());
        p.setProperty("statistic-sample-rate", this.getStatisticSampleRate().toString());
        p.setProperty("statistic-sampling-enabled", this.getStatisticSamplingEnabled().toString());
        if (this.getServerGroups() != null) {
            p.setProperty("server-groups", this.getServerGroupsProperty());
        }
        if (this.getSysDiskDir() != null) {
            p.setProperty("sys-disk-dir", this.getSysDiskDir());
        }
        p.setProperty("table-default-partitioned", this.getTableDefaultPartitioned().toString());
        p.setProperty("tcp-port", this.getTcpPort().toString());
        p.setProperty("udp-fragment-size", this.getUdpFragmentSize().toString());
        p.setProperty("udp-recv-buffer-size", this.getUdpRecvBufferSize().toString());
        p.setProperty("udp-send-buffer-size", this.getUdpSendBufferSize().toString());
        return p;
    }

    protected Properties getShutdownProperties() {
        Properties p = new Properties();
        if (this.getFabricSecurityDescription() != null) {
            this.addProperties(this.getFabricSecurityDescription().getShutdownProperties(), p);
        }
        return p;
    }

    public SortedMap<String, Object> toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "ackSevereAlertThreshold", this.getAckSevereAlertThreshold());
        map.put(header + "ackWaitThreshold", this.getAckWaitThreshold());
        map.put(header + "archiveDiskSpaceLimit", this.getArchiveDiskSpaceLimit());
        map.put(header + "archiveFileSizeLimit", this.getArchiveFileSizeLimit());
        map.put(header + "asyncDistributionTimeout", this.getAsyncDistributionTimeout());
        map.put(header + "asyncMaxQueueSize", this.getAsyncMaxQueueSize());
        map.put(header + "asyncQueueTimeout", this.getAsyncQueueTimeout());
        map.put(header + "bindAddress", "autogenerated using hydra client localhost");
        map.put(header + "clientNames", this.getClientNames());
        map.put(header + "conserveSockets", this.getConserveSockets());
        map.put(header + "disableAutoReconnect", this.getDisableAutoReconnect());
        map.put(header + "disableTcp", this.getDisableTcp());
        map.put(header + "distributedSystem", this.getDistributedSystem());
        map.put(header + "distributedSystemId", this.getDistributedSystemId());
        map.put(header + "enableNetworkPartitionDetection", this.getEnableNetworkPartitionDetection());
        map.put(header + "enableStatsGlobally", this.getEnableStatsGlobally());
        map.put(header + "enableTimeStatistics", this.getEnableTimeStatistics());
        map.put(header + "enableTimeStatsGlobally", this.getEnableTimeStatsGlobally());
        map.put(header + "enforceUniqueHost", this.getEnforceUniqueHost());
        map.put(header + "fabricSecurityName", this.getFabricSecurityName());
        map.put(header + "hostData", this.getHostData());
        map.put(header + "lockMemory", this.getLockMemory());
        map.put(header + "locators", "deferred to hydra client");
        map.put(header + "logDiskSpaceLimit", this.getLogDiskSpaceLimit());
        map.put(header + "logFile", "autogenerated: system.log in gemfire system directory");
        map.put(header + "logFileSizeLimit", this.getLogFileSizeLimit());
        map.put(header + "logLevel", this.getLogLevel());
        map.put(header + "maxNumReconnectTries", this.getMaxNumReconnectTries());
        map.put(header + "maxWaitTimeForReconnect", this.getMaxWaitTimeForReconnect());
        map.put(header + "mcastAddress", this.getMcastAddress());
        map.put(header + "mcastDistributionEnabled", this.getMcastDistributionEnabled());
        map.put(header + "mcastFlowControl", this.getMcastFlowControl());
        map.put(header + "mcastPort", this.getMcastPort());
        map.put(header + "mcastRecvBufferSize", this.getMcastRecvBufferSize());
        map.put(header + "mcastSendBufferSize", this.getMcastSendBufferSize());
        map.put(header + "mcastTtl", this.getMcastTtl());
        map.put(header + "membershipPortRange", this.getMembershipPortRange());
        map.put(header + "memberTimeout", this.getMemberTimeout());
        map.put(header + "offHeapMemorySize", this.getOffHeapMemorySize());
        map.put(header + "persistDD", this.getPersistDD());
        map.put(header + "persistIndexes", this.getPersistIndexes());
        map.put(header + "persistQueues", this.getPersistQueues());
        map.put(header + "persistTables", this.getPersistTables());
        map.put(header + "rebalance", this.getRebalance());
        map.put(header + "redundancyZone", this.getRedundancyZone());
        map.put(header + "remoteDistributedSystems", this.getRemoteDistributedSystems());
        map.put(header + "saveSysDiskDir", this.saveSysDiskDir());
        map.put(header + "serverBindAddress", "autogenerated using hydra client localhost");
        map.put(header + "serverGroups", this.getServerGroups());
        map.put(header + "socketBufferSize", this.getSocketBufferSize());
        map.put(header + "socketLeaseTime", this.getSocketLeaseTime());
        map.put(header + "statisticArchiveFile", "autogenerated: statArchive.gfs in gemfire system directory");
        map.put(header + "statisticSampleRate", this.getStatisticSampleRate());
        map.put(header + "statisticSamplingEnabled", this.getStatisticSamplingEnabled());
        map.put(header + "sysDiskDir", "autogenerated");
        map.put(header + "sysDiskDirBases", this.getSysDiskDirBases());
        map.put(header + "tableDefaultPartitioned", this.getTableDefaultPartitioned());
        map.put(header + "tcpPort", this.getTcpPort());
        map.put(header + "udpFragmentSize", this.getUdpFragmentSize());
        map.put(header + "udpRecvBufferSize", this.getUdpRecvBufferSize());
        map.put(header + "udpSendBufferSize", this.getUdpSendBufferSize());
        map.put(header + "useExistingSysDiskDir", this.useExistingSysDiskDir());
        map.put(header + "useGenericSysDiskDir", this.useGenericSysDiskDir());
        return map;
    }

    protected static Map configure(TestConfig config, GfxdTestConfig sconfig) {
        ConfigHashtable tab = config.getParameters();
        if (tab.booleanAt(Prms.manageLocatorAgents)) {
            String string = "Master-managed fabric server locators are unsupported.  Set " + BasePrms.nameForKey((Long)Prms.manageLocatorAgents) + " = false";
        }
        TreeMap<String, FabricServerDescription> fsds = new TreeMap<String, FabricServerDescription>();
        HashMap<String, Integer> dsids = new HashMap<String, Integer>();
        int nextDSID = 0;
        ArrayList<String> usedClients = new ArrayList<String>();
        HashMap<String, Integer> usedMcastPorts = new HashMap<String, Integer>();
        HydraVector names = tab.vecAt(FabricServerPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            if (fsds.containsKey(name)) {
                String s = BasePrms.nameForKey((Long)FabricServerPrms.names) + " contains duplicate entries: " + names;
                throw new HydraConfigException(s);
            }
            FabricServerDescription fsd = FabricServerDescription.createFabricServerDescription(name, config, sconfig, i, dsids, nextDSID, usedClients, usedMcastPorts);
            fsds.put(name, fsd);
        }
        return fsds;
    }

    private static FabricServerDescription createFabricServerDescription(String name, TestConfig config, GfxdTestConfig sconfig, int index, Map<String, Integer> dsids, int nextDSID, List<String> usedClients, Map<String, Integer> usedMcastPorts) {
        String str;
        Double rt;
        Integer rb;
        String arg;
        ConfigHashtable tab = config.getParameters();
        FabricServerDescription fsd = new FabricServerDescription();
        fsd.setName(name);
        Long key = FabricServerPrms.ackSevereAlertThreshold;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        fsd.setAckSevereAlertThreshold(i);
        key = FabricServerPrms.ackWaitThreshold;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 15;
        }
        fsd.setAckWaitThreshold(i);
        key = FabricServerPrms.archiveDiskSpaceLimit;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        fsd.setArchiveDiskSpaceLimit(i);
        key = FabricServerPrms.archiveFileSizeLimit;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        fsd.setArchiveFileSizeLimit(i);
        key = FabricServerPrms.asyncDistributionTimeout;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        fsd.setAsyncDistributionTimeout(i);
        key = FabricServerPrms.asyncMaxQueueSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 8;
        }
        fsd.setAsyncMaxQueueSize(i);
        key = FabricServerPrms.asyncQueueTimeout;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 60000;
        }
        fsd.setAsyncQueueTimeout(i);
        key = FabricServerPrms.clientNames;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs == null) {
            String s = BasePrms.nameForKey((Long)key) + " is a required field and has no default value";
            throw new HydraConfigException(s);
        }
        List<String> cnames = FabricServerDescription.getClientNames((Vector)strs, key, usedClients, tab);
        fsd.setClientNames(cnames);
        for (String cname : cnames) {
            VmDescription vmd = config.getClientDescription(cname).getVmDescription();
            HostDescription hd = vmd.getHostDescription();
            ArrayList<String> classPaths = new ArrayList<String>();
            String classPath = hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + "product-gfxd" + hd.getFileSep() + "lib" + hd.getFileSep() + "gemfirexd.jar";
            classPaths.add(classPath);
            vmd.setGemFireXDClassPaths(classPaths);
        }
        key = FabricServerPrms.conserveSockets;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        fsd.setConserveSockets(bool);
        key = FabricServerPrms.disableAutoReconnect;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        fsd.setDisableAutoReconnect(bool);
        key = FabricServerPrms.disableTcp;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        fsd.setDisableTcp(bool);
        key = FabricServerPrms.distributedSystem;
        String str2 = tab.getString(key, tab.getWild(key, index, (Object)"ds"));
        if (str2.equalsIgnoreCase(LONER)) {
            String s = BasePrms.nameForKey((Long)FabricServerPrms.distributedSystem) + " cannot be set to \"" + LONER + "\". Use hydra.gemfirexd.LonerPrms instead.";
            throw new HydraConfigException(s);
        }
        Integer dsid = dsids.get(str2);
        if (dsid == null) {
            dsid = FabricServerDescription.toDSID(str2);
            if (dsid == null || dsids.values().contains(dsid)) {
                do {
                    dsid = ++nextDSID;
                } while (dsids.values().contains(dsid));
            }
            dsids.put(str2, dsid);
        }
        fsd.setDistributedSystem(str2);
        fsd.setDistributedSystemId(dsid);
        key = FabricServerPrms.enableNetworkPartitionDetection;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        fsd.setEnableNetworkPartitionDetection(bool);
        key = FabricServerPrms.enableStatsGlobally;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        fsd.setEnableStatsGlobally(bool);
        if (fsd.getEnableStatsGlobally().booleanValue()) {
            arg = "-Dgemfirexd.enable-stats=true";
            for (String cname : fsd.getClientNames()) {
                config.getClientDescription(cname).getVmDescription().addExtraVMArg(arg);
            }
        }
        if ((bool = tab.getBoolean(key = FabricServerPrms.enableTimeStatistics, tab.getWild(key, index, null))) == null) {
            bool = Boolean.TRUE;
        }
        fsd.setEnableTimeStatistics(bool);
        key = FabricServerPrms.enableTimeStatsGlobally;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        fsd.setEnableTimeStatsGlobally(bool);
        if (fsd.getEnableStatsGlobally().booleanValue() && fsd.getEnableTimeStatsGlobally().booleanValue()) {
            arg = "-Dgemfirexd.enable-timestats=true";
            for (String cname : fsd.getClientNames()) {
                config.getClientDescription(cname).getVmDescription().addExtraVMArg(arg);
            }
        }
        if ((bool = tab.getBoolean(key = FabricServerPrms.enforceUniqueHost, tab.getWild(key, index, null))) == null) {
            bool = DistributionConfig.DEFAULT_ENFORCE_UNIQUE_HOST;
        }
        fsd.setEnforceUniqueHost(bool);
        key = FabricServerPrms.fabricSecurityName;
        str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 != null && !str2.equalsIgnoreCase("none")) {
            fsd.setFabricSecurityName("FabricSecurityDescription." + str2);
            fsd.setFabricSecurityDescription(FabricServerDescription.getFabricSecurityDescription(str2, key, sconfig));
        }
        if ((bool = tab.getBoolean(key = FabricServerPrms.hostData, tab.getWild(key, index, null))) == null) {
            bool = Boolean.TRUE;
        }
        fsd.setHostData(bool);
        key = FabricServerPrms.lockMemory;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        fsd.setLockMemory(bool);
        key = FabricServerPrms.logDiskSpaceLimit;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        fsd.setLogDiskSpaceLimit(i);
        key = FabricServerPrms.logFileSizeLimit;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        fsd.setLogFileSizeLimit(i);
        key = FabricServerPrms.logLevel;
        str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 == null) {
            str2 = LogWriterImpl.levelToString((int)700);
        }
        fsd.setLogLevel(str2);
        key = FabricServerPrms.maxNumReconnectTries;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 3;
        }
        fsd.setMaxNumReconnectTries(i);
        key = FabricServerPrms.maxWaitTimeForReconnect;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 60000;
        }
        fsd.setMaxWaitTimeForReconnect(i);
        key = FabricServerPrms.mcastAddress;
        str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 == null) {
            if (tab.booleanAt(Prms.useIPv6)) {
                int addr = tab.getRandGen().nextInt(1111, 8888);
                str2 = "FF38::" + addr;
            } else {
                int addr1 = tab.getRandGen().nextInt(81, 254);
                int addr2 = tab.getRandGen().nextInt(1, 254);
                str2 = "239.192." + addr1 + "." + addr2;
            }
        }
        fsd.setMcastAddress(str2);
        key = FabricServerPrms.mcastDistributionEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        if (usedMcastPorts.get(fsd.getDistributedSystem()) != null && !bool.booleanValue()) {
            String s = BasePrms.nameForKey((Long)FabricServerPrms.distributedSystem) + "=" + fsd.getDistributedSystem() + " has inconsistent values for " + BasePrms.nameForKey((Long)FabricServerPrms.mcastDistributionEnabled);
            throw new HydraConfigException(s);
        }
        fsd.setMcastDistributionEnabled(bool);
        key = FabricServerPrms.mcastFlowControlByteAllowance;
        Integer ba = tab.getInteger(key, tab.getWild(key, index, null));
        if (ba == null) {
            ba = DistributionConfig.DEFAULT_MCAST_FLOW_CONTROL.getByteAllowance();
        }
        if ((rb = tab.getInteger(key = FabricServerPrms.mcastFlowControlRechargeBlockMs, tab.getWild(key, index, null))) == null) {
            rb = DistributionConfig.DEFAULT_MCAST_FLOW_CONTROL.getRechargeBlockMs();
        }
        if ((rt = tab.getDouble(key = FabricServerPrms.mcastFlowControlRechargeThreshold, tab.getWild(key, index, null))) == null) {
            rt = DistributionConfig.DEFAULT_MCAST_FLOW_CONTROL.getRechargeThreshold();
        }
        fsd.setMcastFlowControl(ba + "," + rt + "," + rb);
        Integer priorPort = usedMcastPorts.get(fsd.getDistributedSystem());
        i = null;
        if (!fsd.getMcastDistributionEnabled().booleanValue()) {
            i = 0;
        } else {
            String s;
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(fsd.getMcastAddress());
            }
            catch (UnknownHostException e) {
                s = "Unable to get address for: " + fsd.getMcastAddress();
                throw new HydraRuntimeException(s, (Exception)e);
            }
            Long key2 = FabricServerPrms.mcastPort;
            i = tab.getInteger(key2, tab.getWild(key2, index, (Object)priorPort));
            if (i == null) {
                i = AvailablePort.getRandomAvailablePort((int)1, (InetAddress)addr);
                usedMcastPorts.put(fsd.getDistributedSystem(), i);
            } else if (i != priorPort) {
                s = BasePrms.nameForKey((Long)FabricServerPrms.distributedSystem) + "=" + fsd.getDistributedSystem() + " has inconsistent values for " + BasePrms.nameForKey((Long)FabricServerPrms.mcastPort);
                throw new HydraConfigException(s);
            }
            if (!AvailablePort.isPortAvailable((int)i, (int)1, (InetAddress)addr)) {
                s = "Port is already in use: " + i;
                throw new HydraConfigException(s);
            }
        }
        fsd.setMcastPort(i);
        key = FabricServerPrms.mcastRecvBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0x100000;
        }
        fsd.setMcastRecvBufferSize(i);
        key = FabricServerPrms.mcastSendBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 65535;
        }
        fsd.setMcastSendBufferSize(i);
        key = FabricServerPrms.mcastTtl;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        fsd.setMcastTtl(i);
        key = FabricServerPrms.membershipPortRange;
        str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 == null) {
            str2 = DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[0] + "-" + DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[1];
        }
        fsd.setMembershipPortRange(str2);
        key = FabricServerPrms.memberTimeout;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 5000;
        }
        fsd.setMemberTimeout(i);
        key = FabricServerPrms.offHeapMemorySize;
        str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 != null) {
            fsd.setOffHeapMemorySize(str2);
        }
        if ((bool = tab.getBoolean(key = FabricServerPrms.persistDD, tab.getWild(key, index, null))) == null) {
            bool = Boolean.TRUE;
        }
        fsd.setPersistDD(bool);
        key = FabricServerPrms.persistIndexes;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.TRUE;
        }
        fsd.setPersistIndexes(bool);
        key = FabricServerPrms.persistQueues;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        fsd.setPersistQueues(bool);
        key = FabricServerPrms.persistTables;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        fsd.setPersistTables(bool);
        key = FabricServerPrms.rebalance;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        fsd.setRebalance(bool);
        key = FabricServerPrms.redundancyZone;
        str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 != null && !str2.equalsIgnoreCase("none")) {
            fsd.setRedundancyZone(str2);
        }
        if ((strs = tab.vecAtWild(key = FabricServerPrms.remoteDistributedSystems, index, null)) != null) {
            Iterator it = strs.iterator();
            while (it.hasNext()) {
                str = tab.getString(key, it.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                it.remove();
            }
            if (strs.size() > 0) {
                if (TestConfig.tab().booleanAt(Prms.manageLocatorAgents)) {
                    String s = BasePrms.nameForKey((Long)key) + " cannot be used when " + BasePrms.nameForKey((Long)Prms.manageLocatorAgents) + "=true.  Use hydra client-managed locators.";
                    throw new HydraConfigException(s);
                }
                fsd.setRemoteDistributedSystems((List<String>)strs);
            }
        }
        if ((bool = tab.getBoolean(key = FabricServerPrms.saveSysDiskDir, tab.getWild(key, index, null))) == null) {
            bool = Boolean.FALSE;
        }
        fsd.setSaveSysDiskDir(bool);
        key = FabricServerPrms.serverGroups;
        strs = tab.vecAtWild(key, index, null);
        if (strs != null) {
            Iterator i2 = strs.iterator();
            while (i2.hasNext()) {
                str = tab.getString(key, i2.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                i2.remove();
            }
            if (strs.size() != 0) {
                fsd.setServerGroups(new ArrayList<String>((Collection<String>)strs));
            }
        }
        if ((i = tab.getInteger(key = FabricServerPrms.socketBufferSize, tab.getWild(key, index, null))) == null) {
            i = 32768;
        }
        fsd.setSocketBufferSize(i);
        key = FabricServerPrms.socketLeaseTime;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 60000;
        }
        fsd.setSocketLeaseTime(i);
        key = FabricServerPrms.statisticSampleRate;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 1000;
        }
        fsd.setStatisticSampleRate(i);
        key = FabricServerPrms.statisticSamplingEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.TRUE;
        }
        fsd.setStatisticSamplingEnabled(bool);
        key = FabricServerPrms.sysDiskDirBaseMapFileName;
        str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 != null && !str2.equalsIgnoreCase("none")) {
            Map<String, List<String>> bases = FabricServerDescription.getSysDiskDirBases(key, str2);
            fsd.setSysDiskDirBases(bases);
            FabricServerDescription.initSysDiskDirBlackboard(bases);
        }
        if ((bool = tab.getBoolean(key = FabricServerPrms.tableDefaultPartitioned, tab.getWild(key, index, null))) == null) {
            bool = Boolean.TRUE;
        }
        fsd.setTableDefaultPartitioned(bool);
        key = FabricServerPrms.tcpPort;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        fsd.setTcpPort(i);
        key = FabricServerPrms.udpFragmentSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 60000;
        }
        fsd.setUdpFragmentSize(i);
        key = FabricServerPrms.udpRecvBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0x100000;
        }
        fsd.setUdpRecvBufferSize(i);
        key = FabricServerPrms.udpSendBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 65535;
        }
        fsd.setUdpSendBufferSize(i);
        key = FabricServerPrms.useExistingSysDiskDir;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        fsd.setUseExistingSysDiskDir(bool);
        key = FabricServerPrms.useGenericSysDiskDir;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        fsd.setUseGenericSysDiskDir(bool);
        return fsd;
    }

    private static List<String> getClientNames(Vector strs, Long key, List<String> usedClients, ConfigHashtable tab) {
        Iterator i = strs.iterator();
        while (i.hasNext()) {
            String str = tab.getString(key, i.next());
            if (usedClients.contains(str)) {
                String s = BasePrms.nameForKey((Long)key) + " contains duplicate: " + str;
                throw new HydraConfigException(s);
            }
            usedClients.add(str);
        }
        return new ArrayList<String>(strs);
    }

    private static Map<String, List<String>> getSysDiskDirBases(Long key, String str) {
        String fn = EnvHelper.expandEnvVars((String)str);
        try {
            List tokens = FileUtil.getTextAsTokens((String)fn);
            if (tokens == null || tokens.size() == 0) {
                return null;
            }
            return FabricServerDescription.getSysDiskDirBases(key, new ArrayList<String>(tokens));
        }
        catch (IOException e) {
            String s = "Problem reading " + BasePrms.nameForKey((Long)key) + ": " + fn;
            throw new HydraConfigException(s, (Exception)e);
        }
    }

    private static Map<String, List<String>> getSysDiskDirBases(Long key, List<String> vals) {
        if (vals == null || vals.size() == 0) {
            return null;
        }
        TreeMap<String, List<String>> bases = new TreeMap<String, List<String>>();
        String currentHost = null;
        ArrayList<String> currentBases = null;
        for (String val : vals) {
            if (val.indexOf("/") == -1 && val.indexOf("\\") == -1) {
                currentHost = val;
                currentBases = new ArrayList<String>();
                bases.put(currentHost, currentBases);
                continue;
            }
            currentBases = (ArrayList<String>)bases.get(currentHost);
            if (currentBases == null) {
                String s = BasePrms.nameForKey((Long)key) + " missing host for: " + val;
                throw new HydraConfigException(s);
            }
            currentBases.add(val);
        }
        for (String host : bases.keySet()) {
            if (((List)bases.get(host)).size() != 0) continue;
            String s = BasePrms.nameForKey((Long)key) + " missing bases for: " + host;
            throw new HydraConfigException(s);
        }
        return bases;
    }

    private static void initSysDiskDirBlackboard(Map<String, List<String>> bases) {
        SharedMap map = SysDiskDirBlackboard.getInstance().getSharedMap();
        for (String host : bases.keySet()) {
            map.put((Object)host, (Object)0);
        }
    }

    private static Integer toDSID(String dsName) {
        String dsid = dsName.substring(dsName.indexOf("_") + 1, dsName.length());
        try {
            return Integer.parseInt(dsid);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static FabricSecurityDescription getFabricSecurityDescription(String str, Long key, GfxdTestConfig sconfig) {
        FabricSecurityDescription fsd = sconfig.getFabricSecurityDescription(str);
        if (fsd == null) {
            String s = BasePrms.nameForKey((Long)key) + " not found in " + BasePrms.nameForKey((Long)FabricSecurityPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return fsd;
    }
}

