/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import hydra.BasePrms;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.PortHelper;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import hydra.gemfirexd.FabricServerDescription;
import hydra.gemfirexd.FabricServerPrms;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.LocatorBlackboard;
import hydra.gemfirexd.NetworkServerHelper;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class FabricServerHelper {
    protected static FabricServerDescription TheFabricServerDescription;
    private static Properties TheFabricServerProperties;
    private static Endpoint TheLocatorEndpoint;
    private static LogWriter log;

    public static synchronized FabricServer startFabricServer() {
        log.info("Starting the fabric server");
        Properties p = FabricServerHelper.getBootProperties();
        return FabricServerHelper.startFabricServer(p);
    }

    public static synchronized FabricServer startFabricServer(Properties bootProperties) {
        log.info("Starting the fabric server: " + FabricServerHelper.prettyprint(bootProperties));
        FabricServer fs = FabricServiceManager.getFabricServerInstance();
        FabricService.State status = fs.status();
        switch (status) {
            case UNINITIALIZED: 
            case STOPPED: {
                try {
                    fs.start(bootProperties);
                }
                catch (SQLException e) {
                    String s = "Unable to start fabric server";
                    throw new HydraRuntimeException(s, (Exception)e);
                }
                fs = FabricServiceManager.getFabricServerInstance();
                FabricService.State statusNow = fs.status();
                if (statusNow != FabricService.State.RUNNING) {
                    String s = "Expected fabric server to be RUNNING, but it is: " + statusNow;
                    throw new HydraRuntimeException(s);
                }
                log.info("Started the fabric server");
                TheFabricServerProperties = bootProperties;
                break;
            }
            case RUNNING: {
                if (TheFabricServerProperties == null) {
                    String s = "Fabric server was already started without FabricServerHelper using an unknown, and possibly different, configuration";
                    throw new HydraRuntimeException(s);
                }
                if (!TheFabricServerProperties.equals(bootProperties)) {
                    String s = "Fabric server already exists using boot properties " + TheFabricServerProperties + ", cannot also use " + bootProperties;
                    throw new HydraRuntimeException(s);
                }
                log.info("Already started the fabric server");
                break;
            }
            default: {
                throw new HydraRuntimeException("Unexpected state: " + status);
            }
        }
        return fs;
    }

    public static synchronized FabricServer getFabricServer() {
        return FabricServiceManager.getFabricServerInstance();
    }

    public static synchronized void stopFabricServer() {
        log.info("Stopping the fabric server");
        Properties p = FabricServerHelper.getShutdownProperties();
        FabricServerHelper.stopFabricServer(p);
    }

    public static synchronized void stopFabricServer(Properties shutdownProperties) {
        log.info("Stopping the fabric server: " + FabricServerHelper.prettyprint(shutdownProperties));
        FabricService fs = FabricServiceManager.currentFabricServiceInstance();
        if (fs == null) {
            log.info("Fabric server already stopped.");
            return;
        }
        FabricService.State status = fs.status();
        switch (status) {
            case UNINITIALIZED: 
            case STOPPED: {
                log.info("Fabric server already stopped.");
                break;
            }
            case RUNNING: {
                try {
                    fs.stop(shutdownProperties);
                }
                catch (SQLException e) {
                    String s = "Unable to stop fabric server";
                    throw new HydraRuntimeException(s, (Exception)e);
                }
                FabricService.State statusNow = fs.status();
                if (statusNow != FabricService.State.STOPPED) {
                    String s = "Expected fabric server to be STOPPED, but it is: " + statusNow;
                    throw new HydraRuntimeException(s);
                }
                log.info("Stopped the fabric server");
                TheFabricServerDescription = null;
                TheFabricServerProperties = null;
                break;
            }
            default: {
                throw new HydraRuntimeException("Unexpected state: " + status);
            }
        }
    }

    public static synchronized void shutDownAllFabricServers(int shutDownAllCmdWaitSec) {
        log.info("Issuing shut-down-all command");
        List<Endpoint> locators = FabricServerHelper.getSystemEndpoints();
        if (locators.size() == 0) {
            throw new HydraRuntimeException("No locators found");
        }
        String locId = locators.get(0).getId();
        String cmd = FabricServerHelper.getGFXDCommand() + "shut-down-all -locators=" + locId;
        String output = ProcessMgr.fgexec((String)cmd, (int)shutDownAllCmdWaitSec);
        log.info("Issued shut-down-all command:\n" + output);
    }

    public static synchronized void shutDownAllFabricServers(String dsName, int shutDownAllCmdWaitSec) {
        log.info("Issuing shut-down-all command to " + dsName);
        List<Endpoint> locators = FabricServerHelper.getEndpoints(dsName);
        if (locators.size() == 0) {
            throw new HydraRuntimeException("No locators found");
        }
        String locId = locators.get(0).getId();
        String cmd = FabricServerHelper.getGFXDCommand() + "shut-down-all -locators=" + locId;
        String output = ProcessMgr.fgexec((String)cmd, (int)shutDownAllCmdWaitSec);
        log.info("Issued shut-down-all command:\n" + output);
    }

    public static synchronized void executeSQLCommands(String dsName, String fn, int waitSec) {
        log.info("Issuing run command to " + dsName + " using " + fn);
        List<Endpoint> locators = FabricServerHelper.getEndpoints(dsName);
        if (locators.size() == 0) {
            throw new HydraRuntimeException("No locators found");
        }
        Endpoint endpoint = locators.get(0);
        String cmd = FabricServerHelper.getGFXDCommand() + "run -file=" + fn + " -locators=" + endpoint.getId();
        String output = ProcessMgr.fgexec((String)cmd, (int)waitSec);
        log.info("Issued run command to " + dsName + " using " + fn);
    }

    public static boolean isFabricServerRunning() {
        FabricService fs = FabricServiceManager.currentFabricServiceInstance();
        return fs != null && fs.status().equals((Object)FabricService.State.RUNNING);
    }

    public static boolean isFabricServerStopped() {
        FabricService fs = FabricServiceManager.currentFabricServiceInstance();
        return fs == null || fs.status().equals((Object)FabricService.State.STOPPED);
    }

    public static String getGFXDCommand() {
        HostDescription hd = TestConfig.getInstance().getClientDescription(RemoteTestModule.getMyClientName()).getVmDescription().getHostDescription();
        char sep = hd.getFileSep();
        String productBin = hd.getGemFireHome() + sep + ".." + sep + "snappy" + sep + "bin";
        String productHiddenBin = hd.getGemFireHome() + sep + ".." + sep + "snappy" + sep + "bin";
        String gfxdScript = null;
        switch (hd.getOSType()) {
            case unix: {
                gfxdScript = "snappy-shell";
                break;
            }
            case windows: {
                gfxdScript = "snappy-shell.bat";
            }
        }
        String gfxd = productBin + sep + gfxdScript;
        if (!FileUtil.exists((String)gfxd) && !FileUtil.exists((String)(gfxd = productHiddenBin + sep + gfxdScript))) {
            String s = gfxdScript + " not found in " + productBin + " or " + productHiddenBin;
            throw new HydraRuntimeException(s);
        }
        String cmd = null;
        switch (hd.getOSType()) {
            case unix: {
                cmd = "env GFXD_JAVA=" + hd.getJavaHome() + sep + "bin" + sep + "java " + gfxd;
                break;
            }
            case windows: {
                cmd = "cmd /c set GFXD_JAVA=" + hd.getJavaHome() + sep + "bin" + sep + "java.exe " + "&& cmd /c " + gfxd;
            }
        }
        return cmd + " ";
    }

    public static Integer getDistributedSystemId() {
        return FabricServerHelper.getFabricServerDescription().getDistributedSystemId();
    }

    public static int getDistributedSystemId(String distributedSystemName) {
        for (FabricServerDescription fsd : GfxdTestConfig.getInstance().getFabricServerDescriptions().values()) {
            if (!fsd.getDistributedSystem().equals(distributedSystemName)) continue;
            return fsd.getDistributedSystemId();
        }
        String s = "Distributed system not found: " + distributedSystemName;
        throw new HydraRuntimeException(s);
    }

    public static String getDistributedSystemName() {
        return FabricServerHelper.getFabricServerDescription().getDistributedSystem();
    }

    public static String getDistributedSystemName(int distributedSystemId) {
        for (FabricServerDescription fsd : GfxdTestConfig.getInstance().getFabricServerDescriptions().values()) {
            if (fsd.getDistributedSystemId() != distributedSystemId) continue;
            return fsd.getDistributedSystem();
        }
        String s = "Distributed system not found: " + distributedSystemId;
        throw new HydraRuntimeException(s);
    }

    public static Properties getBootProperties() {
        FabricServerDescription fsd = FabricServerHelper.getFabricServerDescription();
        return FabricServerHelper.getBootProperties(fsd);
    }

    public static synchronized Properties getBootProperties(FabricServerDescription fsd) {
        log.info("Looking up boot properties");
        Properties p = fsd.getBootProperties();
        log.info("Looked up boot properties: " + FabricServerHelper.prettyprint(p));
        return p;
    }

    public static Properties getShutdownProperties() {
        FabricServerDescription fsd = FabricServerHelper.getFabricServerDescription();
        return FabricServerHelper.getShutdownProperties(fsd);
    }

    private static synchronized Properties getShutdownProperties(FabricServerDescription fsd) {
        log.info("Looking up shutdown properties");
        Properties p = fsd.getShutdownProperties();
        log.info("Looked up shutdown properties: " + FabricServerHelper.prettyprint(p));
        return p;
    }

    private static String prettyprint(Properties p) {
        ArrayList<?> l = Collections.list(p.propertyNames());
        TreeSet set = new TreeSet(l);
        StringBuffer buf = new StringBuffer();
        for (String key : set) {
            String val = p.getProperty(key);
            buf.append("\n  " + key + "=" + val);
        }
        return buf.toString();
    }

    public static FabricServerDescription getFabricServerDescription() {
        String clientName = RemoteTestModule.getMyClientName();
        if (TheFabricServerDescription == null) {
            log.info("Looking up fabric server config for " + clientName);
            Map<String, FabricServerDescription> fsds = GfxdTestConfig.getInstance().getFabricServerDescriptions();
            for (FabricServerDescription fsd : fsds.values()) {
                if (!fsd.getClientNames().contains(clientName)) continue;
                log.info("Looked up fabric server config for " + clientName + ":\n" + fsd);
                TheFabricServerDescription = fsd;
                break;
            }
            if (TheFabricServerDescription == null) {
                String s = clientName + " is not wired to any fabric server description" + " using " + BasePrms.nameForKey((Long)FabricServerPrms.clientNames) + ". Either add it or use an alternate method that takes a " + BasePrms.nameForKey((Long)FabricServerPrms.names) + " argument.";
                throw new HydraRuntimeException(s);
            }
        }
        return TheFabricServerDescription;
    }

    public static synchronized void createLocator() {
        Endpoint endpoint = FabricServerHelper.findEndpoint();
        Locator locator = DistributedSystemHelper.getLocator();
        if (locator == null) {
            if (endpoint == null) {
                FabricServerHelper.generateEndpoint(FabricServerHelper.getFabricServerDescription());
            }
        } else if (endpoint == null) {
            String s = "Locator was already started without FabricServerHelper using an unknown port";
            throw new HydraRuntimeException(s);
        }
    }

    public static void startLocator() {
        FabricServerHelper._startLocator(null, null);
    }

    public static void startLocator(String networkServerConfig) {
        FabricServerHelper._startLocator(networkServerConfig, null);
    }

    public static void startLocator(String networkServerConfig, Map<String, String> systemUserPasswords) {
        FabricServerHelper._startLocator(networkServerConfig, systemUserPasswords);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized void _startLocator(String networkServerConfig, Map<String, String> systemUserPasswords) {
        String s;
        String s2;
        Endpoint endpoint = FabricServerHelper.findEndpoint();
        if (endpoint == null) {
            String s3 = "Locator has not been created yet";
            throw new HydraRuntimeException(s3);
        }
        FabricServerDescription fsd = FabricServerHelper.getFabricServerDescription();
        Properties bootProps = fsd.getBootProperties();
        Locator locator = DistributedSystemHelper.getLocator();
        if (systemUserPasswords != null) {
            for (Map.Entry<String, String> entry : systemUserPasswords.entrySet()) {
                String systemUser = entry.getKey();
                String password = entry.getValue();
                bootProps.put("gemfirexd.user." + systemUser, password);
            }
        }
        bootProps.put("distributed-system-id", fsd.getDistributedSystemId().toString());
        bootProps.put("remote-locators", fsd.getRemoteLocators());
        if (locator == null) {
            DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
            if (ds == null) {
                SharedCounters counters = LocatorBlackboard.getInstance(fsd.getDistributedSystem()).getSharedCounters();
                while (counters.incrementAndRead(LocatorBlackboard.locatorLock) != 1L) {
                    MasterController.sleepForMs((int)500);
                }
                log.info("Starting gemfirexd locator");
                try {
                    log.info("Starting gemfirexd locator \"" + endpoint + "\" using boot properties: " + FabricServerHelper.prettyprint(bootProps));
                    FabricServiceManager.getFabricLocatorInstance().start(endpoint.getAddress(), endpoint.getPort(), bootProps);
                    if (networkServerConfig != null) {
                        NetworkServerHelper.startNetworkLocators(networkServerConfig);
                    }
                }
                catch (SQLException e) {
                    String s4 = "Problem starting gemfirexd locator";
                    throw new HydraRuntimeException(s4, (Exception)e);
                }
                log.info("Started locator: " + locator);
                TheFabricServerProperties = bootProps;
                counters.zero(LocatorBlackboard.locatorLock);
                return;
            }
            s2 = "This VM is already connected to a distributed system. Too late to start a locator";
            throw new HydraRuntimeException(s2);
        }
        if (TheFabricServerProperties == null) {
            s = "Locator was already started without FabricServerHelper using an unknown, and possibly different, configuration";
            throw new HydraRuntimeException(s);
        }
        if (!TheFabricServerProperties.equals(bootProps)) {
            s = "Already booted using properties " + TheFabricServerProperties + ", cannot also use " + bootProps;
            throw new HydraRuntimeException(s);
        }
        FabricLocator loc = FabricServiceManager.getFabricLocatorInstance();
        if (loc.status() == FabricService.State.RUNNING) return;
        s2 = "This VM already contains a non-GemFireXD locator";
        throw new HydraRuntimeException(s2);
    }

    public static synchronized void stopLocator() {
        FabricServerHelper.stopFabricServer();
    }

    public static synchronized List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        Collection c = LocatorBlackboard.getInstance().getSharedMap().getMap().values();
        endpoints.addAll(c);
        return endpoints;
    }

    public static synchronized List<Endpoint> getSystemEndpoints() {
        FabricServerDescription fsd = FabricServerHelper.getFabricServerDescription();
        String distributedSystemName = fsd.getDistributedSystem();
        return FabricServerHelper.getEndpoints(distributedSystemName);
    }

    public static synchronized List<Endpoint> getEndpoints(String distributedSystemName) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : FabricServerHelper.getEndpoints()) {
            if (!endpoint.getDistributedSystemName().equals(distributedSystemName)) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    public static synchronized List<Endpoint> getEndpoints(List<String> distributedSystemNames) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (String distributedSystemName : distributedSystemNames) {
            endpoints.addAll(FabricServerHelper.getEndpoints(distributedSystemName));
        }
        return endpoints;
    }

    private static synchronized Endpoint findEndpoint() {
        if (TheLocatorEndpoint == null) {
            Integer vmid = RemoteTestModule.getMyVmid();
            TheLocatorEndpoint = (Endpoint)LocatorBlackboard.getInstance().getSharedMap().get((Object)vmid);
        }
        return TheLocatorEndpoint;
    }

    private static synchronized Endpoint generateEndpoint(FabricServerDescription fsd) {
        Endpoint endpoint = FabricServerHelper.findEndpoint();
        if (endpoint == null) {
            log.info("Generating peer locator endpoint");
            Integer vmid = RemoteTestModule.getMyVmid();
            String name = RemoteTestModule.getMyClientName();
            String host = HostHelper.getCanonicalHostName();
            String addr = HostHelper.getHostAddress();
            int port = PortHelper.getRandomPort();
            String id = addr + "[" + port + "]";
            String ds = fsd.getDistributedSystem();
            endpoint = new Endpoint(id, name, vmid, host, addr, port, ds);
            log.info("Generated peer locator endpoint: " + endpoint);
            LocatorBlackboard.getInstance().getSharedMap().put((Object)vmid, (Object)endpoint);
        }
        TheLocatorEndpoint = endpoint;
        return endpoint;
    }

    static {
        log = Log.getLogWriter();
    }

    public static class Endpoint
    implements Serializable {
        String id;
        String name;
        String host;
        String addr;
        String ds;
        int vmid;
        int port;

        public Endpoint(String id, String name, int vmid, String host, String addr, int port, String ds) {
            if (id == null) {
                throw new IllegalArgumentException("id cannot be null");
            }
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (host == null) {
                throw new IllegalArgumentException("host cannot be null");
            }
            if (addr == null) {
                throw new IllegalArgumentException("addr cannot be null");
            }
            if (ds == null) {
                throw new IllegalArgumentException("ds cannot be null");
            }
            this.id = id;
            this.name = name;
            this.vmid = vmid;
            this.host = host;
            this.addr = addr;
            this.port = port;
            this.ds = ds;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getVmid() {
            return this.vmid;
        }

        public String getHost() {
            return this.host;
        }

        public String getAddress() {
            return this.addr;
        }

        public int getPort() {
            return this.port;
        }

        public String getDistributedSystemName() {
            return this.ds;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)obj;
                return endpoint.getId().equals(this.getId()) && endpoint.getName().equals(this.getName()) && endpoint.getVmid() == this.getVmid() && endpoint.getHost().equals(this.getHost()) && endpoint.getAddress().equals(this.getAddress()) && endpoint.getPort() == this.getPort() && endpoint.getDistributedSystemName().equals(this.getDistributedSystemName());
            }
            return false;
        }

        public int hashCode() {
            return this.port;
        }

        public String toString() {
            return this.id + "(" + this.ds + ":vm_" + this.vmid + "_" + this.name + "_" + this.host + ")";
        }
    }
}

