/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.TestConfig;
import hydra.gemfirexd.FabricServerDescription;
import hydra.gemfirexd.FabricServerPrms;
import hydra.gemfirexd.GatewayReceiverPrms;
import hydra.gemfirexd.GfxdTestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class GatewayReceiverDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String distributedSystem;
    private Integer distributedSystemId;
    private Integer endPort;
    private String id;
    private Integer maximumTimeBetweenPings;
    private List<String> serverGroups;
    private Integer socketBufferSize;
    private Integer startPort;
    private transient String DDL;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public String getDistributedSystem() {
        return this.distributedSystem;
    }

    private void setDistributedSystem(String str) {
        this.distributedSystem = str;
    }

    public Integer getDistributedSystemId() {
        return this.distributedSystemId;
    }

    private void setDistributedSystemId(Integer i) {
        this.distributedSystemId = i;
    }

    private Integer getEndPort() {
        return this.endPort;
    }

    private void setEndPort(Integer i) {
        this.endPort = i;
    }

    public String getId() {
        return this.id;
    }

    private void setId(String s) {
        this.id = s;
    }

    private Integer getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    private void setMaximumTimeBetweenPings(Integer i) {
        this.maximumTimeBetweenPings = i;
    }

    public List<String> getServerGroups() {
        return this.serverGroups;
    }

    public String getServerGroupsProperty() {
        String str = "";
        for (String group : this.serverGroups) {
            str = str + (str.length() == 0 ? group : "," + group);
        }
        return str.length() == 0 ? null : str;
    }

    private void setServerGroups(List<String> list) {
        this.serverGroups = list;
    }

    private Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    private void setSocketBufferSize(Integer i) {
        this.socketBufferSize = i;
    }

    private Integer getStartPort() {
        return this.startPort;
    }

    private void setStartPort(Integer i) {
        this.startPort = i;
    }

    protected synchronized String getDDL() {
        if (this.DDL == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("CREATE GATEWAYRECEIVER ").append(this.getId()).append(" (").append(" STARTPORT ").append(this.getStartPort()).append(" ENDPORT ").append(this.getEndPort()).append(" MAXTIMEBETWEENPINGS ").append(this.getMaximumTimeBetweenPings()).append(" SOCKETBUFFERSIZE ").append(this.getSocketBufferSize()).append(" )");
            if (this.getServerGroups() != null) {
                buf.append(" SERVER GROUPS (").append(this.getServerGroupsProperty()).append(" )");
            }
            this.DDL = buf.toString();
        }
        return this.DDL;
    }

    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "distributedSystem", this.getDistributedSystem());
        map.put(header + "distributedSystemId", this.getDistributedSystemId());
        map.put(header + "endPort", this.getEndPort());
        map.put(header + "id", this.getId());
        map.put(header + "maximumTimeBetweenPings", this.getMaximumTimeBetweenPings());
        map.put(header + "serverGroups", this.getServerGroups());
        map.put(header + "socketBufferSize", this.getSocketBufferSize());
        map.put(header + "startPort", this.getStartPort());
        return map;
    }

    protected static Map configure(TestConfig config, GfxdTestConfig sconfig) {
        ConfigHashtable tab = config.getParameters();
        TreeMap<String, GatewayReceiverDescription> grds = new TreeMap<String, GatewayReceiverDescription>();
        HydraVector names = tab.vecAt(GatewayReceiverPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            GatewayReceiverDescription grd = GatewayReceiverDescription.createGatewayReceiverDescription(name, config, sconfig, i);
            grds.put(name, grd);
        }
        return grds;
    }

    private static GatewayReceiverDescription createGatewayReceiverDescription(String name, TestConfig config, GfxdTestConfig sconfig, int index) {
        Integer i;
        ConfigHashtable tab = config.getParameters();
        GatewayReceiverDescription grd = new GatewayReceiverDescription();
        grd.setName(name);
        Long key = GatewayReceiverPrms.distributedSystem;
        String str = tab.stringAtWild(key, index, null);
        if (str != null && !str.equalsIgnoreCase("none")) {
            Integer dsid = GatewayReceiverDescription.getDistributedSystemId(str, key, sconfig);
            grd.setDistributedSystemId(dsid);
            grd.setDistributedSystem(str);
        }
        if ((i = tab.getInteger(key = GatewayReceiverPrms.endPort, tab.getWild(key, index, null))) == null) {
            i = 5500;
        }
        grd.setEndPort(i);
        key = GatewayReceiverPrms.id;
        str = tab.stringAtWild(key, index, null);
        if (str == null) {
            grd.setId("receiver");
        } else {
            grd.setId(str);
        }
        key = GatewayReceiverPrms.maximumTimeBetweenPings;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 60000;
        }
        grd.setMaximumTimeBetweenPings(i);
        key = GatewayReceiverPrms.serverGroups;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs != null) {
            Iterator it = strs.iterator();
            while (it.hasNext()) {
                String str2 = tab.getString(key, it.next());
                if (str2 != null && !str2.equalsIgnoreCase("none")) continue;
                it.remove();
            }
            if (strs.size() != 0) {
                List<String> groups = GatewayReceiverDescription.getServerGroups((Vector)strs, key, sconfig);
                grd.setServerGroups(groups);
            }
        }
        if ((i = tab.getInteger(key = GatewayReceiverPrms.socketBufferSize, tab.getWild(key, index, null))) == null) {
            i = 524288;
        }
        grd.setSocketBufferSize(i);
        key = GatewayReceiverPrms.startPort;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 5000;
        }
        grd.setStartPort(i);
        return grd;
    }

    private static Integer getDistributedSystemId(String str, Long key, GfxdTestConfig config) {
        for (FabricServerDescription fsd : config.getFabricServerDescriptions().values()) {
            if (!fsd.getDistributedSystem().equals(str)) continue;
            return fsd.getDistributedSystemId();
        }
        String s = BasePrms.nameForKey((Long)key) + " not found in " + BasePrms.nameForKey((Long)FabricServerPrms.distributedSystem) + ": " + str;
        throw new HydraConfigException(s);
    }

    private static List<String> getServerGroups(Vector strs, Long key, GfxdTestConfig config) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String str : strs) {
            String group = null;
            for (FabricServerDescription fsd : config.getFabricServerDescriptions().values()) {
                if (fsd.getServerGroups() == null || !fsd.getServerGroups().contains(str) || groups.contains(group = str)) continue;
                groups.add(group);
            }
            if (group != null) continue;
            String s = BasePrms.nameForKey((Long)key) + " not found in " + BasePrms.nameForKey((Long)FabricServerPrms.serverGroups) + ": " + str;
            throw new HydraConfigException(s);
        }
        return groups;
    }
}

