/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.LogWriter;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.gemfirexd.GatewayReceiverDescription;
import hydra.gemfirexd.GfxdTestConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GatewayReceiverHelper {
    private static LogWriter log = Log.getLogWriter();

    public static synchronized List<String> getGatewayReceiverDDL(int dsid) {
        log.info("Generating gateway receiver DDL for DSID=" + dsid);
        ArrayList<String> ddls = new ArrayList<String>();
        Collection<GatewayReceiverDescription> grds = GfxdTestConfig.getInstance().getGatewayReceiverDescriptions().values();
        for (GatewayReceiverDescription grd : grds) {
            if (grd.getDistributedSystemId() != dsid) continue;
            if (log.fineEnabled()) {
                log.fine("Generating gateway receiver DDL for " + grd);
            }
            String ddl = grd.getDDL();
            log.info("Generated DDL: " + ddl);
            ddls.add(ddl);
        }
        log.info("Generated gateway receiver DDL for DSID=" + dsid + ": " + ddls);
        return ddls;
    }

    public static synchronized String getGatewayReceiverDDL(String id, int dsid) {
        log.info("Generating gateway receiver DDL for ID=" + id + " DSID=" + dsid);
        Collection<GatewayReceiverDescription> grds = GfxdTestConfig.getInstance().getGatewayReceiverDescriptions().values();
        for (GatewayReceiverDescription grd : grds) {
            if (!grd.getId().equals(id) || grd.getDistributedSystemId() != dsid) continue;
            if (log.fineEnabled()) {
                log.fine("Generating gateway receiver DDL for " + grd);
            }
            String ddl = grd.getDDL();
            log.info("Generated gateway receiver DDL for ID=" + id + " DSID=" + dsid + ": " + ddl);
        }
        String s = "No GatewayReceiverDescription found with id=" + id + " dsid=" + dsid;
        throw new HydraRuntimeException(s);
    }
}

