/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.cache.wan.GatewaySender;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.TestConfig;
import hydra.gemfirexd.FabricServerDescription;
import hydra.gemfirexd.FabricServerPrms;
import hydra.gemfirexd.GatewaySenderPrms;
import hydra.gemfirexd.GfxdTestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class GatewaySenderDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SPACE = " ";
    private String name;
    private Integer alertThreshold;
    private Boolean batchConflationEnabled;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private String diskStoreName;
    private String distributedSystem;
    private Integer distributedSystemId;
    private String id;
    private Boolean isParallel;
    private Boolean manualStart;
    private Integer maximumQueueMemory;
    private Boolean persistenceEnabled;
    private List<String> remoteDistributedSystems;
    private List<Integer> remoteDistributedSystemIds;
    private List<String> serverGroups;
    private Integer socketBufferSize;
    private Integer socketReadTimeout;
    private Type type;
    private transient List<String> DDL;
    private transient List<String> IDS;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private Integer getAlertThreshold() {
        return this.alertThreshold;
    }

    private void setAlertThreshold(Integer i) {
        this.alertThreshold = i;
    }

    private Boolean getBatchConflationEnabled() {
        return this.batchConflationEnabled;
    }

    private void setBatchConflationEnabled(Boolean bool) {
        this.batchConflationEnabled = bool;
    }

    private Integer getBatchSize() {
        return this.batchSize;
    }

    private void setBatchSize(Integer i) {
        this.batchSize = i;
    }

    private Integer getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    private void setBatchTimeInterval(Integer i) {
        this.batchTimeInterval = i;
    }

    private String getDiskStoreName() {
        return this.diskStoreName;
    }

    private void setDiskStoreName(String str) {
        this.diskStoreName = str;
    }

    public String getDistributedSystem() {
        return this.distributedSystem;
    }

    private void setDistributedSystem(String str) {
        this.distributedSystem = str;
    }

    public Integer getDistributedSystemId() {
        return this.distributedSystemId;
    }

    private void setDistributedSystemId(Integer i) {
        this.distributedSystemId = i;
    }

    public String getId() {
        return this.id;
    }

    private void setId(String str) {
        this.id = str;
    }

    public Boolean getIsParallel() {
        return this.isParallel;
    }

    private void setIsParallel(Boolean bool) {
        this.isParallel = bool;
    }

    public Boolean getManualStart() {
        return this.manualStart;
    }

    private void setManualStart(Boolean bool) {
        this.manualStart = bool;
    }

    private Integer getMaximumQueueMemory() {
        return this.maximumQueueMemory;
    }

    private void setMaximumQueueMemory(Integer i) {
        this.maximumQueueMemory = i;
    }

    private Boolean getPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    private void setPersistenceEnabled(Boolean bool) {
        this.persistenceEnabled = bool;
    }

    public List<String> getRemoteDistributedSystems() {
        return this.remoteDistributedSystems;
    }

    private void setRemoteDistributedSystems(List<String> systems) {
        this.remoteDistributedSystems = systems;
    }

    public List<Integer> getRemoteDistributedSystemIds() {
        return this.remoteDistributedSystemIds;
    }

    private void setRemoteDistributedSystemIds(List<Integer> systems) {
        this.remoteDistributedSystemIds = systems;
    }

    public List<String> getServerGroups() {
        return this.serverGroups;
    }

    public String getServerGroupsProperty() {
        String str = "";
        for (String group : this.serverGroups) {
            str = str + (str.length() == 0 ? group : "," + group);
        }
        return str.length() == 0 ? null : str;
    }

    private void setServerGroups(List<String> list) {
        this.serverGroups = list;
    }

    private Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    private void setSocketBufferSize(Integer i) {
        this.socketBufferSize = i;
    }

    private Integer getSocketReadTimeout() {
        return this.socketReadTimeout;
    }

    private void setSocketReadTimeout(Integer i) {
        this.socketReadTimeout = i;
    }

    protected Type getType() {
        return this.type;
    }

    private void setType(Type t) {
        this.type = t;
    }

    protected synchronized List<String> getDDL() {
        if (this.getDistributedSystemId() == null || this.getRemoteDistributedSystemIds() == null) {
            String s = "Please ask for a supporting method";
            throw new UnsupportedOperationException(s);
        }
        if (this.DDL == null) {
            this.DDL = new ArrayList<String>();
            this.IDS = new ArrayList<String>();
            int localDSID = this.getDistributedSystemId();
            for (Integer remoteDSID : this.getRemoteDistributedSystemIds()) {
                String senderID = this.getId() + "_" + localDSID + "_to_" + remoteDSID;
                this.IDS.add(senderID);
                StringBuilder buf = new StringBuilder();
                buf.append("CREATE GATEWAYSENDER ").append(senderID).append(" ( ").append("remotedsid").append(SPACE).append(remoteDSID).append(SPACE).append("socketbuffersize").append(SPACE).append(this.getSocketBufferSize()).append(SPACE).append("socketreadtimeout").append(SPACE).append(this.getSocketReadTimeout()).append(SPACE).append("manualstart").append(SPACE).append(this.getManualStart()).append(SPACE).append("isparallel").append(SPACE).append(this.getIsParallel()).append(SPACE).append("enablebatchconflation").append(SPACE).append(this.getBatchConflationEnabled()).append(SPACE).append("batchsize").append(SPACE).append(this.getBatchSize()).append(SPACE).append("batchtimeinterval").append(SPACE).append(this.getBatchTimeInterval()).append(SPACE).append("enablepersistence").append(SPACE).append(this.getPersistenceEnabled()).append(SPACE);
                if (this.getDiskStoreName() != null) {
                    buf.append("diskstorename").append(SPACE).append(this.getDiskStoreName()).append(SPACE);
                }
                buf.append("maxqueuememory").append(SPACE).append(this.getMaximumQueueMemory()).append(SPACE).append("alertthreshold").append(SPACE).append(this.getAlertThreshold()).append(SPACE).append(")");
                if (this.getServerGroups() != null) {
                    buf.append(" SERVER GROUPS ( ").append(this.getServerGroupsProperty()).append(" )");
                }
                this.DDL.add(buf.toString());
            }
        }
        return this.DDL;
    }

    protected synchronized List<String> getIDs() {
        if (this.IDS == null) {
            this.getDDL();
        }
        return this.IDS;
    }

    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "alertThreshold", this.getAlertThreshold());
        map.put(header + "batchConflationEnabled", this.getBatchConflationEnabled());
        map.put(header + "batchSize", this.getBatchSize());
        map.put(header + "batchTimeInterval", this.getBatchTimeInterval());
        map.put(header + "diskStoreName", this.getDiskStoreName());
        map.put(header + "distributedSystem", this.getDistributedSystem());
        map.put(header + "distributedSystemId", this.getDistributedSystemId());
        map.put(header + "id", this.getId());
        map.put(header + "isParallel", this.getIsParallel());
        map.put(header + "manualStart", this.getManualStart());
        map.put(header + "maximumQueueMemory", this.getMaximumQueueMemory());
        map.put(header + "persistenceEnabled", this.getPersistenceEnabled());
        map.put(header + "remoteDistributedSystems", this.getRemoteDistributedSystems());
        map.put(header + "serverGroups", this.getServerGroups());
        map.put(header + "socketBufferSize", this.getSocketBufferSize());
        map.put(header + "socketReadTimeout", this.getSocketReadTimeout());
        return map;
    }

    protected static Map configure(TestConfig config, GfxdTestConfig sconfig) {
        ConfigHashtable tab = config.getParameters();
        TreeMap<String, GatewaySenderDescription> gsds = new TreeMap<String, GatewaySenderDescription>();
        HydraVector names = tab.vecAt(GatewaySenderPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            GatewaySenderDescription gsd = GatewaySenderDescription.createGatewaySenderDescription(name, config, sconfig, i);
            gsds.put(name, gsd);
        }
        return gsds;
    }

    private static GatewaySenderDescription createGatewaySenderDescription(String name, TestConfig config, GfxdTestConfig sconfig, int index) {
        String str;
        Iterator it;
        ConfigHashtable tab = config.getParameters();
        GatewaySenderDescription gsd = new GatewaySenderDescription();
        gsd.setName(name);
        Long key = GatewaySenderPrms.alertThreshold;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        gsd.setAlertThreshold(i);
        key = GatewaySenderPrms.batchConflationEnabled;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        gsd.setBatchConflationEnabled(bool);
        key = GatewaySenderPrms.batchSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 100;
        }
        gsd.setBatchSize(i);
        key = GatewaySenderPrms.batchTimeInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 1000;
        }
        gsd.setBatchTimeInterval(i);
        key = GatewaySenderPrms.diskStoreName;
        String str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 != null && !str2.equalsIgnoreCase("none")) {
            gsd.setDiskStoreName(str2);
        }
        if ((str2 = tab.stringAtWild(key = GatewaySenderPrms.distributedSystem, index, null)) != null && !str2.equalsIgnoreCase("none")) {
            Integer dsid = GatewaySenderDescription.getDistributedSystemId(str2, key, sconfig);
            gsd.setDistributedSystemId(dsid);
            gsd.setDistributedSystem(str2);
        }
        if ((str2 = tab.getString(key = GatewaySenderPrms.id, tab.getWild(key, index, null))) != null && !str2.equalsIgnoreCase("none")) {
            gsd.setId(str2);
        } else {
            gsd.setId("sender");
        }
        key = GatewaySenderPrms.isParallel;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        gsd.setIsParallel(bool);
        key = GatewaySenderPrms.manualStart;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        gsd.setManualStart(bool);
        key = GatewaySenderPrms.maximumQueueMemory;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 100;
        }
        gsd.setMaximumQueueMemory(i);
        key = GatewaySenderPrms.persistenceEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        gsd.setPersistenceEnabled(bool);
        key = GatewaySenderPrms.remoteDistributedSystems;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs != null) {
            it = strs.iterator();
            while (it.hasNext()) {
                str = tab.getString(key, it.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                it.remove();
            }
            if (strs.size() > 0) {
                List<Integer> dsids = GatewaySenderDescription.getRemoteDistributedSystemIds((Vector)strs, key, sconfig);
                gsd.setRemoteDistributedSystemIds(dsids);
                gsd.setRemoteDistributedSystems((List<String>)strs);
            }
        }
        if ((strs = tab.vecAtWild(key = GatewaySenderPrms.serverGroups, index, null)) != null) {
            it = strs.iterator();
            while (it.hasNext()) {
                str = tab.getString(key, it.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                it.remove();
            }
            if (strs.size() != 0) {
                List<String> groups = GatewaySenderDescription.getServerGroups((Vector)strs, key, sconfig);
                gsd.setServerGroups(groups);
            }
        }
        if ((i = tab.getInteger(key = GatewaySenderPrms.socketBufferSize, tab.getWild(key, index, null))) == null) {
            i = 524288;
        }
        gsd.setSocketBufferSize(i);
        key = GatewaySenderPrms.socketReadTimeout;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = GatewaySender.DEFAULT_SOCKET_READ_TIMEOUT;
        }
        gsd.setSocketReadTimeout(i);
        key = GatewaySenderPrms.type;
        str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 == null) {
            gsd.setType(Type.serial);
        } else {
            gsd.setType(GatewaySenderDescription.getType(str2, key));
        }
        return gsd;
    }

    private static Integer getDistributedSystemId(String str, Long key, GfxdTestConfig config) {
        for (FabricServerDescription fsd : config.getFabricServerDescriptions().values()) {
            if (!fsd.getDistributedSystem().equals(str)) continue;
            return fsd.getDistributedSystemId();
        }
        String s = BasePrms.nameForKey((Long)key) + " not found in " + BasePrms.nameForKey((Long)FabricServerPrms.distributedSystem) + ": " + str;
        throw new HydraConfigException(s);
    }

    private static List<Integer> getRemoteDistributedSystemIds(Vector strs, Long key, GfxdTestConfig config) {
        ArrayList<Integer> dsids = new ArrayList<Integer>();
        for (String str : strs) {
            Integer dsid = null;
            for (FabricServerDescription fsd : config.getFabricServerDescriptions().values()) {
                if (!fsd.getDistributedSystem().equals(str) || dsids.contains(dsid = fsd.getDistributedSystemId())) continue;
                dsids.add(dsid);
            }
            if (dsid != null) continue;
            String s = BasePrms.nameForKey((Long)key) + " not found in " + BasePrms.nameForKey((Long)FabricServerPrms.distributedSystem) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsids;
    }

    private static List<String> getServerGroups(Vector strs, Long key, GfxdTestConfig config) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String str : strs) {
            String group = null;
            for (FabricServerDescription fsd : config.getFabricServerDescriptions().values()) {
                if (fsd.getServerGroups() == null || !fsd.getServerGroups().contains(str) || groups.contains(group = str)) continue;
                groups.add(group);
            }
            if (group != null) continue;
            String s = BasePrms.nameForKey((Long)key) + " not found in " + BasePrms.nameForKey((Long)FabricServerPrms.serverGroups) + ": " + str;
            throw new HydraConfigException(s);
        }
        return groups;
    }

    private static Type getType(String str, Long key) {
        if (str.equalsIgnoreCase(Type.serial.toString())) {
            return Type.serial;
        }
        String s = BasePrms.nameForKey((Long)key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    public static enum Type {
        serial;

    }
}

