/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.LogWriter;
import hydra.Log;
import hydra.gemfirexd.GatewaySenderDescription;
import hydra.gemfirexd.GfxdTestConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class GatewaySenderHelper {
    private static LogWriter log = Log.getLogWriter();

    public static synchronized List<String> getGatewaySenderDDL(int dsid) {
        log.info("Generating gateway sender DDL for DSID=" + dsid);
        ArrayList<String> ddls = new ArrayList<String>();
        Collection<GatewaySenderDescription> gsds = GfxdTestConfig.getInstance().getGatewaySenderDescriptions().values();
        for (GatewaySenderDescription gsd : gsds) {
            if (gsd.getDistributedSystemId() != dsid) continue;
            log.info("Generating gateway sender DDL for " + gsd);
            List<String> ddl = gsd.getDDL();
            log.info("Generated DDL: " + ddl);
            ddls.addAll(ddl);
        }
        log.info("Generated gateway sender DDL for DSID=" + dsid + ": " + ddls);
        return ddls;
    }

    public static synchronized String getGatewaySenderClause(String senderID, int dsid) {
        log.info("Generating gateway sender clause for ID=" + senderID + " DSID=" + dsid);
        String clause = "";
        TreeSet<String> ids = new TreeSet<String>();
        Collection<GatewaySenderDescription> gsds = GfxdTestConfig.getInstance().getGatewaySenderDescriptions().values();
        for (GatewaySenderDescription gsd : gsds) {
            if (!gsd.getId().equals(senderID) || gsd.getDistributedSystemId() != dsid) continue;
            ids.addAll(gsd.getIDs());
        }
        for (String id : ids) {
            if (clause.length() > 0) {
                clause = clause + ", ";
            }
            clause = clause + id;
        }
        if (clause.length() > 0) {
            clause = " gatewaysender ( " + clause + " )";
        }
        log.info("Generated gateway sender clause for ID=" + senderID + " DSID=" + dsid + ": " + clause);
        return clause;
    }

    public static synchronized List<String> getGatewaySenderIds(int dsid) {
        log.info("Generating gateway sender IDs for DSID=" + dsid);
        ArrayList<String> ids = new ArrayList<String>();
        Collection<GatewaySenderDescription> gsds = GfxdTestConfig.getInstance().getGatewaySenderDescriptions().values();
        for (GatewaySenderDescription gsd : gsds) {
            if (gsd.getDistributedSystemId() != dsid) continue;
            if (log.fineEnabled()) {
                log.fine("Generating gateway sender IDs for " + gsd);
            }
            List<String> id = gsd.getIDs();
            log.info("Generated IDs: " + id);
            ids.addAll(id);
        }
        log.info("Generated gateway sender IDs for DSID=" + dsid + ": " + ids);
        return ids;
    }
}

