/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.gemfirexd.GfxdTestConfig;

public class GfxdConfigPrms
extends BasePrms {
    public static Long networkServerConfig;
    public static Long diskStoreConfig;
    public static Long hdfsStoreConfig;

    public static String getNetworkServerConfig() {
        return GfxdConfigPrms.getString(networkServerConfig);
    }

    public static String getDiskStoreConfig() {
        return GfxdConfigPrms.getString(diskStoreConfig);
    }

    public static String getHDFSStoreConfig() {
        return GfxdConfigPrms.getString(hdfsStoreConfig);
    }

    public static String getString(Long key) {
        AbstractDescription description;
        String val = GfxdConfigPrms.tasktab().stringAt(key, GfxdConfigPrms.tab().stringAt(key, null));
        if (val == null) {
            return null;
        }
        if (key == networkServerConfig) {
            description = GfxdTestConfig.getInstance().getNetworkServerDescription(val);
        } else if (key == diskStoreConfig) {
            description = GfxdTestConfig.getInstance().getDiskStoreDescription(val);
        } else if (key == hdfsStoreConfig) {
            description = GfxdTestConfig.getInstance().getHDFSStoreDescription(val);
        } else {
            throw new HydraInternalException("Unknown key: " + GfxdConfigPrms.nameForKey((Long)key));
        }
        if (description == null) {
            String s = "Description for configuration name \"" + GfxdConfigPrms.nameForKey((Long)key) + "\" not found: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    static {
        GfxdConfigPrms.setValues(GfxdConfigPrms.class);
    }
}

