/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.SystemFailure;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.HostDescription;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.gemfirexd.GfxdHelperPrms;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Properties;

public class GfxdHelper {
    private static String diskDirName;

    public static Properties getConnectionProperties() {
        GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
        Properties p = gfd.getDistributedSystemProperties();
        boolean persistDD = GfxdHelperPrms.persistDD();
        boolean persistQueues = GfxdHelperPrms.persistQueues();
        boolean persistTables = GfxdHelperPrms.persistTables();
        boolean createDiskStore = GfxdHelperPrms.createDiskStore();
        p.setProperty("persist-dd", String.valueOf(persistDD));
        if (persistDD || persistQueues || persistTables || createDiskStore) {
            p.setProperty("sys-disk-dir", GfxdHelper.getDiskDirName());
        }
        Log.getLogWriter().info("Configured connection properties: " + p);
        return p;
    }

    private static synchronized String getDiskDirName() {
        if (diskDirName == null) {
            GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
            String path = new File(gfd.getSysDirName()).getParent();
            String dir = path + File.separator + "vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "_disk";
            try {
                FileUtil.mkdir((String)dir);
                HostDescription hd = gfd.getHostDescription();
                try {
                    RemoteTestModule.Master.recordDir(hd, gfd.getName(), dir);
                }
                catch (RemoteException e) {
                    String s = "Unable to access master to record directory: " + dir;
                    throw new HydraRuntimeException(s, (Exception)e);
                }
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Error e) {
                String s = "Unable to create directory: " + dir;
                throw new HydraRuntimeException(s);
            }
            diskDirName = dir;
        }
        return diskDirName;
    }
}

