/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import hydra.FileUtil;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;
import hydra.gemfirexd.DiskStoreDescription;
import hydra.gemfirexd.FabricSecurityDescription;
import hydra.gemfirexd.FabricServerDescription;
import hydra.gemfirexd.GatewayReceiverDescription;
import hydra.gemfirexd.GatewaySenderDescription;
import hydra.gemfirexd.HDFSStoreDescription;
import hydra.gemfirexd.LonerDescription;
import hydra.gemfirexd.NetworkServerDescription;
import hydra.gemfirexd.ThinClientDescription;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class GfxdTestConfig
implements Serializable {
    private static transient GfxdTestConfig singleton;
    private static final String GFXDConfigFileName = "gfxdConfig.obj";
    private Map<String, FabricServerDescription> FabricServerDescriptions;
    private Map<String, FabricSecurityDescription> FabricSecurityDescriptions;
    private Map<String, GatewayReceiverDescription> GatewayReceiverDescriptions;
    private Map<String, GatewaySenderDescription> GatewaySenderDescriptions;
    private Map<String, LonerDescription> LonerDescriptions;
    private Map<String, NetworkServerDescription> NetworkServerDescriptions;
    private Map<String, ThinClientDescription> ThinClientDescriptions;
    private Map<String, DiskStoreDescription> DiskStoreDescriptions;
    private Map<String, HDFSStoreDescription> HDFSStoreDescriptions;

    public static synchronized GfxdTestConfig getInstance() {
        if (singleton == null) {
            Log.getLogWriter().info("Deserializing gemfirexd test configuration...");
            String fn = System.getProperty("user.dir") + "/" + GFXDConfigFileName;
            if (FileUtil.exists((String)fn)) {
                singleton = (GfxdTestConfig)FileUtil.deserialize((String)fn);
            } else {
                String s = "gfxdConfig.obj not found";
                throw new HydraRuntimeException(s);
            }
        }
        return singleton;
    }

    public static Properties getGemFireXDProductVersion() {
        String fn = "com/pivotal/gemfirexd/internal/GemFireXDVersion.properties";
        try {
            return FileUtil.getPropertiesFromResource((String)fn);
        }
        catch (IOException e) {
            String s = "Unable to find GemFireXD product version";
            throw new HydraRuntimeException(s, (Exception)e);
        }
    }

    public void logBuildSanity() {
        boolean sanity = true;
        Log.getLogWriter().info("GemFireXD Build Sanity: " + sanity);
    }

    public void configure(TestConfig tc) {
        this.logBuildSanity();
        this.LonerDescriptions = LonerDescription.configure(tc, this);
        this.NetworkServerDescriptions = NetworkServerDescription.configure(tc, this);
        this.FabricSecurityDescriptions = FabricSecurityDescription.configure(tc, this);
        this.FabricServerDescriptions = FabricServerDescription.configure(tc, this);
        this.GatewayReceiverDescriptions = GatewayReceiverDescription.configure(tc, this);
        this.GatewaySenderDescriptions = GatewaySenderDescription.configure(tc, this);
        this.ThinClientDescriptions = ThinClientDescription.configure(tc, this);
        this.DiskStoreDescriptions = DiskStoreDescription.configure(tc, this);
        this.HDFSStoreDescriptions = HDFSStoreDescription.configure(tc, this);
        tc.share();
        this.share(tc);
    }

    private void share(TestConfig tc) {
        String userDir = tc.getMasterDescription().getVmDescription().getHostDescription().getUserDir();
        String fn = userDir + "/" + GFXDConfigFileName;
        FileUtil.serialize((Object)this, (String)fn);
        String latest = userDir + "/latest.prop";
        String content = this.toString();
        content = content.replace('\\', '/');
        FileUtil.appendToFile((String)latest, (String)content);
        Log.getLogWriter().info(this.toString());
    }

    private SortedMap<String, Object> toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        if (this.FabricServerDescriptions.size() != 0) {
            for (FabricServerDescription fabricServerDescription : this.FabricServerDescriptions.values()) {
                map.putAll(fabricServerDescription.toSortedMap());
            }
        }
        if (this.FabricSecurityDescriptions.size() != 0) {
            for (FabricSecurityDescription fabricSecurityDescription : this.FabricSecurityDescriptions.values()) {
                map.putAll(fabricSecurityDescription.toSortedMap());
            }
        }
        if (this.GatewayReceiverDescriptions.size() != 0) {
            for (GatewayReceiverDescription gatewayReceiverDescription : this.GatewayReceiverDescriptions.values()) {
                map.putAll(gatewayReceiverDescription.toSortedMap());
            }
        }
        if (this.GatewaySenderDescriptions.size() != 0) {
            for (GatewaySenderDescription gatewaySenderDescription : this.GatewaySenderDescriptions.values()) {
                map.putAll(gatewaySenderDescription.toSortedMap());
            }
        }
        if (this.DiskStoreDescriptions.size() != 0) {
            for (DiskStoreDescription diskStoreDescription : this.DiskStoreDescriptions.values()) {
                map.putAll(diskStoreDescription.toSortedMap());
            }
        }
        if (this.HDFSStoreDescriptions.size() != 0) {
            for (HDFSStoreDescription hDFSStoreDescription : this.HDFSStoreDescriptions.values()) {
                map.putAll(hDFSStoreDescription.toSortedMap());
            }
        }
        if (this.LonerDescriptions.size() != 0) {
            for (LonerDescription lonerDescription : this.LonerDescriptions.values()) {
                map.putAll(lonerDescription.toSortedMap());
            }
        }
        if (this.NetworkServerDescriptions.size() != 0) {
            for (NetworkServerDescription networkServerDescription : this.NetworkServerDescriptions.values()) {
                map.putAll(networkServerDescription.toSortedMap());
            }
        }
        if (this.ThinClientDescriptions.size() != 0) {
            for (ThinClientDescription thinClientDescription : this.ThinClientDescriptions.values()) {
                map.putAll(thinClientDescription.toSortedMap());
            }
        }
        return map;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SortedMap<String, Object> map = this.toSortedMap();
        for (String key : map.keySet()) {
            Object val = map.get(key);
            buf.append(key + "=" + val + "\n");
        }
        return buf.toString();
    }

    public Map<String, FabricServerDescription> getFabricServerDescriptions() {
        return this.FabricServerDescriptions;
    }

    public FabricServerDescription getFabricServerDescription(String name) {
        return this.FabricServerDescriptions.get(name);
    }

    public Map<String, FabricSecurityDescription> getFabricSecurityDescriptions() {
        return this.FabricSecurityDescriptions;
    }

    public FabricSecurityDescription getFabricSecurityDescription(String name) {
        return this.FabricSecurityDescriptions.get(name);
    }

    public Map<String, GatewayReceiverDescription> getGatewayReceiverDescriptions() {
        return this.GatewayReceiverDescriptions;
    }

    public GatewayReceiverDescription getGatewayReceiverDescription(String name) {
        return this.GatewayReceiverDescriptions.get(name);
    }

    public Map<String, GatewaySenderDescription> getGatewaySenderDescriptions() {
        return this.GatewaySenderDescriptions;
    }

    public GatewaySenderDescription getGatewaySenderDescription(String name) {
        return this.GatewaySenderDescriptions.get(name);
    }

    public Map getDiskStoreDescriptions() {
        return this.DiskStoreDescriptions;
    }

    public DiskStoreDescription getDiskStoreDescription(String name) {
        return this.DiskStoreDescriptions.get(name);
    }

    public Map getHDFSStoreDescriptions() {
        return this.HDFSStoreDescriptions;
    }

    public HDFSStoreDescription getHDFSStoreDescription(String name) {
        return this.HDFSStoreDescriptions.get(name);
    }

    public Map<String, LonerDescription> getLonerDescriptions() {
        return this.LonerDescriptions;
    }

    public LonerDescription getLonerDescription(String name) {
        return this.LonerDescriptions.get(name);
    }

    public Map<String, NetworkServerDescription> getNetworkServerDescriptions() {
        return this.NetworkServerDescriptions;
    }

    public NetworkServerDescription getNetworkServerDescription(String name) {
        return this.NetworkServerDescriptions.get(name);
    }

    public Map<String, ThinClientDescription> getThinClientDescriptions() {
        return this.ThinClientDescriptions;
    }

    public ThinClientDescription getThinClientDescription(String name) {
        return this.ThinClientDescriptions.get(name);
    }
}

