/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HadoopDescription;
import hydra.HadoopPrms;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HostPrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.Nuker;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.DiskStoreDescription;
import hydra.gemfirexd.DiskStorePrms;
import hydra.gemfirexd.FabricServerDescription;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.HDFSStorePrms;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class HDFSStoreDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SPACE = " ";
    private static final String TIC = "'";
    private String name;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private Integer blockCacheSize;
    private String clientConfigFile;
    private DiskStoreDescription diskStoreDescription;
    private String diskStoreName;
    private Boolean diskSynchronous;
    private Integer dispatcherThreads;
    private HadoopDescription hadoopDescription;
    private String hadoopName;
    private String homeDir;
    private Boolean majorCompact;
    private Integer majorCompactionInterval;
    private Integer majorCompactionThreads;
    private Integer maxInputFileCount;
    private Integer maxInputFileSize;
    private Integer maxQueueMemory;
    private Integer maxWriteOnlyFileSize;
    private Integer minInputFileCount;
    private Boolean minorCompact;
    private Integer minorCompactionThreads;
    private Integer purgeInterval;
    private Boolean queuePersistent;
    private Integer writeOnlyFileRolloverInterval;
    private transient String DDL;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    private void setBatchSize(Integer i) {
        this.batchSize = i;
    }

    public Integer getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    private void setBatchTimeInterval(Integer i) {
        this.batchTimeInterval = i;
    }

    public Integer getBlockCacheSize() {
        return this.blockCacheSize;
    }

    private void setBlockCacheSize(Integer i) {
        this.blockCacheSize = i;
    }

    public String getClientConfigFile() {
        return this.clientConfigFile;
    }

    private void setClientConfigFile(String str) {
        this.clientConfigFile = str;
    }

    public DiskStoreDescription getDiskStoreDescription() {
        return this.diskStoreDescription;
    }

    private void setDiskStoreDescription(DiskStoreDescription dsd) {
        this.diskStoreDescription = dsd;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    private void setDiskStoreName(String str) {
        this.diskStoreName = str;
    }

    public Boolean getDiskSynchronous() {
        return this.diskSynchronous;
    }

    private void setDiskSynchronous(Boolean bool) {
        this.diskSynchronous = bool;
    }

    public Integer getDispatcherThreads() {
        return this.dispatcherThreads;
    }

    private void setDispatcherThreads(Integer i) {
        this.dispatcherThreads = i;
    }

    public HadoopDescription getHadoopDescription() {
        return this.hadoopDescription;
    }

    private void setHadoopDescription(HadoopDescription hd) {
        this.hadoopDescription = hd;
    }

    public String getHadoopName() {
        return this.hadoopName;
    }

    private void setHadoopName(String str) {
        this.hadoopName = str;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    private void setHomeDir(String str) {
        this.homeDir = str;
    }

    public Boolean getMajorCompact() {
        return this.majorCompact;
    }

    private void setMajorCompact(Boolean bool) {
        this.majorCompact = bool;
    }

    public Integer getMajorCompactionInterval() {
        return this.majorCompactionInterval;
    }

    public Integer getMajorCompactionThreads() {
        return this.majorCompactionThreads;
    }

    private void setMajorCompactionThreads(Integer i) {
        this.majorCompactionThreads = i;
    }

    private void setMajorCompactionInterval(Integer i) {
        this.majorCompactionInterval = i;
    }

    public Integer getMaxInputFileCount() {
        return this.maxInputFileCount;
    }

    private void setMaxInputFileCount(Integer i) {
        this.maxInputFileCount = i;
    }

    public Integer getMaxInputFileSize() {
        return this.maxInputFileSize;
    }

    private void setMaxInputFileSize(Integer i) {
        this.maxInputFileSize = i;
    }

    public Integer getMaxQueueMemory() {
        return this.maxQueueMemory;
    }

    private void setMaxQueueMemory(Integer i) {
        this.maxQueueMemory = i;
    }

    public Integer getMaxWriteOnlyFileSize() {
        return this.maxWriteOnlyFileSize;
    }

    private void setMaxWriteOnlyFileSize(Integer i) {
        this.maxWriteOnlyFileSize = i;
    }

    public Integer getMinInputFileCount() {
        return this.minInputFileCount;
    }

    private void setMinInputFileCount(Integer i) {
        this.minInputFileCount = i;
    }

    public Boolean getMinorCompact() {
        return this.minorCompact;
    }

    private void setMinorCompact(Boolean bool) {
        this.minorCompact = bool;
    }

    public Integer getMinorCompactionThreads() {
        return this.minorCompactionThreads;
    }

    private void setMinorCompactionThreads(Integer i) {
        this.minorCompactionThreads = i;
    }

    public Integer getPurgeInterval() {
        return this.purgeInterval;
    }

    private void setPurgeInterval(Integer i) {
        this.purgeInterval = i;
    }

    public Boolean getQueuePersistent() {
        return this.queuePersistent;
    }

    private void setQueuePersistent(Boolean bool) {
        this.queuePersistent = bool;
    }

    public Integer getWriteOnlyFileRolloverInterval() {
        return this.writeOnlyFileRolloverInterval;
    }

    private void setWriteOnlyFileRolloverInterval(Integer i) {
        this.writeOnlyFileRolloverInterval = i;
    }

    protected synchronized String getDDL() {
        if (this.DDL == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("CREATE HDFSSTORE ").append(this.getName()).append(" NAMENODE '").append(this.getHadoopDescription().getNameNodeURL()).append(TIC).append(SPACE).append("homedir").append(SPACE).append(TIC).append(this.getHomeDir()).append(TIC).append(SPACE).append("batchsize").append(SPACE).append(this.getBatchSize()).append(SPACE).append("batchtimeinterval").append(SPACE).append(this.getBatchTimeInterval()).append(" milliseconds").append(SPACE).append("blockcachesize").append(SPACE).append(this.getBlockCacheSize()).append(SPACE).append("diskstorename").append(SPACE).append(this.getDiskStoreDescription().getName()).append(SPACE).append("disksynchronous").append(SPACE).append(this.getDiskSynchronous()).append(SPACE).append("dispatcherthreads").append(SPACE).append(this.getDispatcherThreads()).append(SPACE).append("majorcompact").append(SPACE).append(this.getMajorCompact()).append(SPACE).append("majorcompactioninterval").append(SPACE).append(this.getMajorCompactionInterval()).append(" minutes").append(SPACE).append("majorcompactionthreads").append(SPACE).append(this.getMajorCompactionThreads()).append(SPACE).append("maxinputfilecount").append(SPACE).append(this.getMaxInputFileCount()).append(SPACE).append("maxinputfilesize").append(SPACE).append(this.getMaxInputFileSize()).append(SPACE).append("maxqueuememory").append(SPACE).append(this.getMaxQueueMemory()).append(SPACE).append("maxwriteonlyfilesize").append(SPACE).append(this.getMaxWriteOnlyFileSize()).append(SPACE).append("minorcompact").append(SPACE).append(this.getMinorCompact()).append(SPACE).append("minorcompactionthreads").append(SPACE).append(this.getMinorCompactionThreads()).append(SPACE).append("mininputfilecount").append(SPACE).append(this.getMinInputFileCount()).append(SPACE).append("purgeinterval").append(SPACE).append(this.getPurgeInterval()).append(" minutes").append(SPACE).append("queuepersistent").append(SPACE).append(this.getQueuePersistent()).append(SPACE).append("writeonlyfilerolloverinterval").append(SPACE).append(this.getWriteOnlyFileRolloverInterval()).append(" seconds");
            String ccf = this.getClientConfigFile();
            if (ccf != null && ccf.length() > 0) {
                buf.append(SPACE).append("clientconfigfile").append(SPACE).append(TIC).append(this.expandClientConfigFile(ccf)).append(TIC);
            }
            this.DDL = buf.toString();
        }
        return this.DDL;
    }

    private String expandClientConfigFile(String fn) {
        HostDescription rhd = null;
        Map<String, FabricServerDescription> fsds = GfxdTestConfig.getInstance().getFabricServerDescriptions();
        for (FabricServerDescription fsd : fsds.values()) {
            if (!fsd.getHostData().booleanValue()) continue;
            for (String clientName : fsd.getClientNames()) {
                HostDescription hd = TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
                if (rhd == null) {
                    rhd = hd;
                }
                if (fn.contains("$PWD") && !hd.getUserDir().equals(rhd.getUserDir())) {
                    String s = "Unsure how to expand " + HDFSStorePrms.nameForKey((Long)HDFSStorePrms.clientConfigFile) + "=" + fn + " with servers setting " + HostPrms.nameForKey((Long)HostPrms.userDirs) + " to both " + hd.getUserDir() + " and " + rhd.getUserDir();
                    throw new HydraConfigException(s);
                }
                if (!fn.contains("$JTESTS") || hd.getTestDir() == rhd.getTestDir()) continue;
                String s = "Unsure how to expand " + HDFSStorePrms.nameForKey((Long)HDFSStorePrms.clientConfigFile) + "=" + fn + " with servers setting " + HostPrms.nameForKey((Long)HostPrms.testDirs) + " to both " + hd.getTestDir() + " and " + rhd.getTestDir();
                throw new HydraConfigException(s);
            }
        }
        if (rhd == null) {
            rhd = TestConfig.getInstance().getClientDescription(RemoteTestModule.getMyClientName()).getVmDescription().getHostDescription();
        }
        String tmpfn = EnvHelper.expandEnvVars((String)fn, rhd);
        if (rhd.getOSType() == HostHelper.OSType.windows) {
            tmpfn = tmpfn.replace("\\", "/");
        }
        return tmpfn;
    }

    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "batchSize", this.getBatchSize());
        map.put(header + "batchTimeInterval", this.getBatchTimeInterval());
        map.put(header + "blockCacheSize", this.getBlockCacheSize());
        map.put(header + "clientConfigFile", this.getClientConfigFile());
        map.put(header + "diskStoreName", this.getDiskStoreName());
        map.put(header + "diskSynchronous", this.getDiskSynchronous());
        map.put(header + "dispatcherThreads", this.getDispatcherThreads());
        map.put(header + "hadoopName", this.getHadoopName());
        map.put(header + "homeDir", this.getHomeDir());
        map.put(header + "majorCompact", this.getMajorCompact());
        map.put(header + "majorCompactionInterval", this.getMajorCompactionInterval());
        map.put(header + "majorCompactionThreads", this.getMajorCompactionThreads());
        map.put(header + "maxInputFileCount", this.getMaxInputFileCount());
        map.put(header + "maxInputFileSize", this.getMaxInputFileSize());
        map.put(header + "maxQueueMemory", this.getMaxQueueMemory());
        map.put(header + "maxWriteOnlyFileSize", this.getMaxWriteOnlyFileSize());
        map.put(header + "minInputFileCount", this.getMinInputFileCount());
        map.put(header + "minorCompact", this.getMinorCompact());
        map.put(header + "minorCompactionThreads", this.getMinorCompactionThreads());
        map.put(header + "purgeInterval", this.getPurgeInterval());
        map.put(header + "queuePersistent", this.getQueuePersistent());
        map.put(header + "writeOnlyFileRolloverInterval", this.getWriteOnlyFileRolloverInterval());
        return map;
    }

    protected static Map configure(TestConfig config, GfxdTestConfig sconfig) {
        ConfigHashtable tab = config.getParameters();
        TreeMap<String, HDFSStoreDescription> hsds = new TreeMap<String, HDFSStoreDescription>();
        HydraVector names = tab.vecAt(HDFSStorePrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            HDFSStoreDescription hsd = HDFSStoreDescription.createHDFSStoreDescription(name, config, sconfig, i);
            hsds.put(name, hsd);
        }
        return hsds;
    }

    private static HDFSStoreDescription createHDFSStoreDescription(String name, TestConfig config, GfxdTestConfig sconfig, int index) {
        Boolean bool;
        ConfigHashtable tab = config.getParameters();
        HDFSStoreDescription hsd = new HDFSStoreDescription();
        hsd.setName(name);
        Long key = HDFSStorePrms.batchSize;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 32;
        }
        hsd.setBatchSize(i);
        key = HDFSStorePrms.batchTimeInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 60000;
        }
        hsd.setBatchTimeInterval(i);
        key = HDFSStorePrms.blockCacheSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = Float.valueOf(10.0f).intValue();
        }
        hsd.setBlockCacheSize(i);
        key = HDFSStorePrms.clientConfigFile;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null) {
            hsd.setClientConfigFile(str);
        }
        if ((str = tab.getString(key = HDFSStorePrms.diskStoreName, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            hsd.setDiskStoreDescription(HDFSStoreDescription.getDiskStoreDescription(str, key, sconfig));
            hsd.setDiskStoreName("DiskStoreDescription." + str);
        }
        if ((bool = tab.getBoolean(key = HDFSStorePrms.diskSynchronous, tab.getWild(key, index, null))) == null) {
            bool = true;
        }
        hsd.setDiskSynchronous(bool);
        key = HDFSStorePrms.dispatcherThreads;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 5;
        }
        hsd.setDispatcherThreads(i);
        key = HDFSStorePrms.hadoopName;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            String s = BasePrms.nameForKey((Long)key) + " is a required parameter";
            throw new HydraConfigException(s);
        }
        hsd.setHadoopDescription(HDFSStoreDescription.getHadoopDescription(str, key, config));
        hsd.setHadoopName("HadoopDescription." + str);
        key = HDFSStorePrms.homeDir;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            String userDir = config.getMasterDescription().getVmDescription().getHostDescription().getUserDir();
            str = FileUtil.filenameFor((String)userDir);
        }
        hsd.setHomeDir(str);
        key = HDFSStorePrms.majorCompact;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        hsd.setMajorCompact(bool);
        key = HDFSStorePrms.majorCompactionInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 720;
        }
        hsd.setMajorCompactionInterval(i);
        key = HDFSStorePrms.majorCompactionThreads;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 2;
        }
        hsd.setMajorCompactionThreads(i);
        key = HDFSStorePrms.maxInputFileCount;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 10;
        }
        hsd.setMaxInputFileCount(i);
        key = HDFSStorePrms.maxInputFileSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 512;
        }
        hsd.setMaxInputFileSize(i);
        key = HDFSStorePrms.maxQueueMemory;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 100;
        }
        hsd.setMaxQueueMemory(i);
        key = HDFSStorePrms.maxWriteOnlyFileSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 256;
        }
        hsd.setMaxWriteOnlyFileSize(i);
        key = HDFSStorePrms.minInputFileCount;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 4;
        }
        hsd.setMinInputFileCount(i);
        key = HDFSStorePrms.minorCompact;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        hsd.setMinorCompact(bool);
        key = HDFSStorePrms.minorCompactionThreads;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 10;
        }
        hsd.setMinorCompactionThreads(i);
        key = HDFSStorePrms.purgeInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 30;
        }
        hsd.setPurgeInterval(i);
        key = HDFSStorePrms.queuePersistent;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        hsd.setQueuePersistent(bool);
        key = HDFSStorePrms.writeOnlyFileRolloverInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 3600;
        }
        hsd.setWriteOnlyFileRolloverInterval(i);
        HadoopDescription hdd = hsd.getHadoopDescription();
        if (hdd.useExistingCluster()) {
            boolean moveHadoopData = Boolean.getBoolean("moveHadoopData");
            Nuker.getInstance().recordHDFSDir(hdd.getHadoopDist(), hdd.getNameNodeURL(), moveHadoopData);
        }
        return hsd;
    }

    private static DiskStoreDescription getDiskStoreDescription(String str, Long key, GfxdTestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey((Long)key) + " not found in " + BasePrms.nameForKey((Long)DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private static HadoopDescription getHadoopDescription(String str, Long key, TestConfig config) {
        HadoopDescription hd = config.getHadoopDescription(str);
        if (hd == null) {
            String s = BasePrms.nameForKey((Long)key) + " not found in " + BasePrms.nameForKey((Long)HadoopPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return hd;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.batchSize = (Integer)in.readObject();
        this.batchTimeInterval = (Integer)in.readObject();
        this.blockCacheSize = (Integer)in.readObject();
        this.clientConfigFile = (String)in.readObject();
        this.diskStoreDescription = (DiskStoreDescription)in.readObject();
        this.diskStoreName = (String)in.readObject();
        this.diskSynchronous = (Boolean)in.readObject();
        this.dispatcherThreads = (Integer)in.readObject();
        this.hadoopDescription = (HadoopDescription)in.readObject();
        this.hadoopName = (String)in.readObject();
        this.homeDir = (String)in.readObject();
        this.majorCompact = (Boolean)in.readObject();
        this.majorCompactionInterval = (Integer)in.readObject();
        this.majorCompactionThreads = (Integer)in.readObject();
        this.maxInputFileCount = (Integer)in.readObject();
        this.maxInputFileSize = (Integer)in.readObject();
        this.maxQueueMemory = (Integer)in.readObject();
        this.maxWriteOnlyFileSize = (Integer)in.readObject();
        this.minInputFileCount = (Integer)in.readObject();
        this.minorCompact = (Boolean)in.readObject();
        this.minorCompactionThreads = (Integer)in.readObject();
        this.name = (String)in.readObject();
        this.purgeInterval = (Integer)in.readObject();
        this.queuePersistent = (Boolean)in.readObject();
        this.writeOnlyFileRolloverInterval = (Integer)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.batchSize);
        out.writeObject(this.batchTimeInterval);
        out.writeObject(this.blockCacheSize);
        out.writeObject(this.clientConfigFile);
        out.writeObject(this.diskStoreDescription);
        out.writeObject(this.diskStoreName);
        out.writeObject(this.diskSynchronous);
        out.writeObject(this.dispatcherThreads);
        out.writeObject(this.hadoopDescription);
        out.writeObject(this.hadoopName);
        out.writeObject(this.homeDir);
        out.writeObject(this.majorCompact);
        out.writeObject(this.majorCompactionInterval);
        out.writeObject(this.majorCompactionThreads);
        out.writeObject(this.maxInputFileCount);
        out.writeObject(this.maxInputFileSize);
        out.writeObject(this.maxQueueMemory);
        out.writeObject(this.maxWriteOnlyFileSize);
        out.writeObject(this.minInputFileCount);
        out.writeObject(this.minorCompact);
        out.writeObject(this.minorCompactionThreads);
        out.writeObject(this.name);
        out.writeObject(this.purgeInterval);
        out.writeObject(this.queuePersistent);
        out.writeObject(this.writeOnlyFileRolloverInterval);
    }
}

