/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.LogWriter;
import hydra.BasePrms;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.HDFSStoreDescription;
import hydra.gemfirexd.HDFSStorePrms;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HDFSStoreHelper {
    private static LogWriter log = Log.getLogWriter();

    public static synchronized List<String> getHDFSStoreDDL() {
        log.info("Generating HDFSSTORE DDL");
        ArrayList<String> ddls = new ArrayList<String>();
        Collection hsds = GfxdTestConfig.getInstance().getHDFSStoreDescriptions().values();
        for (HDFSStoreDescription hsd : hsds) {
            String ddl = hsd.getDDL();
            ddls.add(ddl);
        }
        log.info("Generated HDFSSTORE DDL: " + ddls);
        return ddls;
    }

    public static synchronized String getHDFSStoreDDL(String hdfsStoreConfig) {
        HDFSStoreDescription hsd = GfxdTestConfig.getInstance().getHDFSStoreDescription(hdfsStoreConfig);
        log.info("Generating HDFSSTORE DDL for " + hdfsStoreConfig + " using " + hsd);
        String ddl = hsd.getDDL();
        log.info("Generated HDFSSTORE DDL for " + hdfsStoreConfig + ": " + ddl);
        return ddl;
    }

    public static HDFSStoreDescription getHDFSStoreDescription(String hdfsStoreConfig) {
        if (hdfsStoreConfig == null) {
            throw new IllegalArgumentException("hdfsStoreConfig cannot be null");
        }
        log.info("Looking up HDFS store config: " + hdfsStoreConfig);
        HDFSStoreDescription hsd = GfxdTestConfig.getInstance().getHDFSStoreDescription(hdfsStoreConfig);
        if (hsd == null) {
            String s = hdfsStoreConfig + " not found in " + BasePrms.nameForKey((Long)HDFSStorePrms.names);
            throw new HydraRuntimeException(s);
        }
        log.info("Looked up HDFS store config:\n" + hsd);
        return hsd;
    }
}

