/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.internal.LogWriterImpl;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.FileUtil;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.VmDescription;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.LonerPrms;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class LonerDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer archiveDiskSpaceLimit;
    private Integer archiveFileSizeLimit;
    private List<String> clientNames;
    private Boolean enableTimeStatistics;
    private Integer logDiskSpaceLimit;
    private transient String logFile;
    private Integer logFileSizeLimit;
    private String logLevel;
    private transient String nameOfMember;
    private transient String resourceDir;
    private transient String statisticArchiveFile;
    private Integer statisticSampleRate;
    private Boolean statisticSamplingEnabled;
    private transient String sysDir;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public Integer getArchiveDiskSpaceLimit() {
        return this.archiveDiskSpaceLimit;
    }

    private void setArchiveDiskSpaceLimit(Integer i) {
        this.archiveDiskSpaceLimit = i;
    }

    public Integer getArchiveFileSizeLimit() {
        return this.archiveFileSizeLimit;
    }

    private void setArchiveFileSizeLimit(Integer i) {
        this.archiveFileSizeLimit = i;
    }

    public List<String> getClientNames() {
        return this.clientNames;
    }

    private void setClientNames(List<String> list) {
        this.clientNames = list;
    }

    public Boolean getEnableTimeStatistics() {
        return this.enableTimeStatistics;
    }

    private void setEnableTimeStatistics(Boolean bool) {
        this.enableTimeStatistics = bool;
    }

    public Integer getLogDiskSpaceLimit() {
        return this.logDiskSpaceLimit;
    }

    private void setLogDiskSpaceLimit(Integer i) {
        this.logDiskSpaceLimit = i;
    }

    private synchronized String getLogFile() {
        if (this.logFile == null) {
            this.logFile = this.getSysDir() + "/system.log";
        }
        return this.logFile;
    }

    public Integer getLogFileSizeLimit() {
        return this.logFileSizeLimit;
    }

    private void setLogFileSizeLimit(Integer i) {
        this.logFileSizeLimit = i;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    private void setLogLevel(String str) {
        this.logLevel = str;
    }

    private synchronized String getNameOfMember() {
        if (this.nameOfMember == null) {
            this.nameOfMember = RemoteTestModule.getCurrentThread() == null ? this.name : this.name + "_" + RemoteTestModule.getMyHost() + "_" + RemoteTestModule.getMyPid();
        }
        return this.nameOfMember;
    }

    private synchronized String getResourceDir() {
        if (this.resourceDir == null) {
            HostDescription hd = this.getHostDescription();
            String dir = hd.getResourceDir();
            if (dir == null) {
                dir = hd.getUserDir();
            }
            this.resourceDir = dir;
        }
        return this.resourceDir;
    }

    private synchronized String getStatisticArchiveFile() {
        if (this.statisticArchiveFile == null) {
            this.statisticArchiveFile = this.getSysDir() + "/statArchive.gfs";
        }
        return this.statisticArchiveFile;
    }

    public Integer getStatisticSampleRate() {
        return this.statisticSampleRate;
    }

    private void setStatisticSampleRate(Integer i) {
        this.statisticSampleRate = i;
    }

    public Boolean getStatisticSamplingEnabled() {
        return this.statisticSamplingEnabled;
    }

    private void setStatisticSamplingEnabled(Boolean bool) {
        this.statisticSamplingEnabled = bool;
    }

    protected synchronized String getSysDir() {
        if (this.sysDir == null) {
            HostDescription hd = this.getHostDescription();
            String dir = this.getResourceDir() + "/" + "vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "_" + hd.getHostName() + "_" + RemoteTestModule.getMyPid();
            FileUtil.mkdir((File)new File(dir));
            try {
                RemoteTestModule.Master.recordDir(hd, this.getName(), dir);
            }
            catch (RemoteException e) {
                String s = "Unable to access master to record directory: " + dir;
                throw new HydraRuntimeException(s, (Exception)e);
            }
            this.sysDir = dir;
        }
        return this.sysDir;
    }

    private HostDescription getHostDescription() {
        String clientName = RemoteTestModule.getMyClientName();
        if (clientName == null) {
            String s = "This method can only be invoked from hydra client VMs";
            throw new HydraInternalException(s);
        }
        if (!this.clientNames.contains(clientName)) {
            String s = "Logical client " + clientName + " is not in the list of clients supported by " + BasePrms.nameForKey((Long)LonerPrms.names) + "=" + this.getName();
            throw new HydraRuntimeException(s);
        }
        return TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
    }

    protected Properties getLonerProperties() {
        Properties p = new Properties();
        p.setProperty("name", this.getNameOfMember());
        p.setProperty("archive-disk-space-limit", this.getArchiveDiskSpaceLimit().toString());
        p.setProperty("archive-file-size-limit", this.getArchiveFileSizeLimit().toString());
        p.setProperty("enable-time-statistics", this.getEnableTimeStatistics().toString());
        p.setProperty("locators", "");
        p.setProperty("log-disk-space-limit", this.getLogDiskSpaceLimit().toString());
        p.setProperty("log-file", this.getLogFile());
        p.setProperty("log-file-size-limit", this.getLogFileSizeLimit().toString());
        p.setProperty("log-level", this.getLogLevel());
        p.setProperty("mcast-port", String.valueOf(0));
        p.setProperty("statistic-archive-file", this.getStatisticArchiveFile());
        p.setProperty("statistic-sample-rate", this.getStatisticSampleRate().toString());
        p.setProperty("statistic-sampling-enabled", this.getStatisticSamplingEnabled().toString());
        return p;
    }

    public SortedMap<String, Object> toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "archiveDiskSpaceLimit", this.getArchiveDiskSpaceLimit());
        map.put(header + "archiveFileSizeLimit", this.getArchiveFileSizeLimit());
        map.put(header + "clientNames", this.getClientNames());
        map.put(header + "enableTimeStatistics", this.getEnableTimeStatistics());
        map.put(header + "logDiskSpaceLimit", this.getLogDiskSpaceLimit());
        map.put(header + "logFile", "autogenerated: system.log in gemfire system directory");
        map.put(header + "logFileSizeLimit", this.getLogFileSizeLimit());
        map.put(header + "logLevel", this.getLogLevel());
        map.put(header + "statisticArchiveFile", "autogenerated: statArchive.gfs in gemfire system directory");
        map.put(header + "statisticSampleRate", this.getStatisticSampleRate());
        map.put(header + "statisticSamplingEnabled", this.getStatisticSamplingEnabled());
        return map;
    }

    protected static Map configure(TestConfig config, GfxdTestConfig sconfig) {
        ConfigHashtable tab = config.getParameters();
        ArrayList<String> usedClients = new ArrayList<String>();
        TreeMap<String, LonerDescription> lds = new TreeMap<String, LonerDescription>();
        HydraVector names = tab.vecAt(LonerPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            if (lds.containsKey(name)) {
                String s = BasePrms.nameForKey((Long)LonerPrms.names) + " contains duplicate entries: " + names;
                throw new HydraConfigException(s);
            }
            LonerDescription ld = LonerDescription.createLonerDescription(name, config, i, usedClients);
            lds.put(name, ld);
        }
        return lds;
    }

    private static LonerDescription createLonerDescription(String name, TestConfig config, int index, List<String> usedClients) {
        ConfigHashtable tab = config.getParameters();
        LonerDescription ld = new LonerDescription();
        ld.setName(name);
        Long key = LonerPrms.archiveDiskSpaceLimit;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        ld.setArchiveDiskSpaceLimit(i);
        key = LonerPrms.archiveFileSizeLimit;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        ld.setArchiveFileSizeLimit(i);
        key = LonerPrms.clientNames;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs == null) {
            String s = BasePrms.nameForKey((Long)key) + " is a required field and has no default value";
            throw new HydraConfigException(s);
        }
        List<String> cnames = LonerDescription.getClientNames((Vector)strs, key, usedClients, tab);
        ld.setClientNames(cnames);
        for (String cname : cnames) {
            VmDescription vmd = config.getClientDescription(cname).getVmDescription();
            HostDescription hd = vmd.getHostDescription();
            ArrayList<String> classPaths = new ArrayList<String>();
            String classPath = hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + "product-gfxd" + hd.getFileSep() + "lib" + hd.getFileSep() + "gemfirexd.jar";
            classPaths.add(classPath);
            vmd.setGemFireXDClassPaths(classPaths);
        }
        key = LonerPrms.enableTimeStatistics;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.TRUE;
        }
        ld.setEnableTimeStatistics(bool);
        key = LonerPrms.logDiskSpaceLimit;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        ld.setLogDiskSpaceLimit(i);
        key = LonerPrms.logFileSizeLimit;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        ld.setLogFileSizeLimit(i);
        key = LonerPrms.logLevel;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            str = LogWriterImpl.levelToString((int)700);
        }
        ld.setLogLevel(str);
        key = LonerPrms.statisticSampleRate;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 1000;
        }
        ld.setStatisticSampleRate(i);
        key = LonerPrms.statisticSamplingEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.TRUE;
        }
        ld.setStatisticSamplingEnabled(bool);
        return ld;
    }

    private static List<String> getClientNames(Vector strs, Long key, List<String> usedClients, ConfigHashtable tab) {
        Iterator i = strs.iterator();
        while (i.hasNext()) {
            String str = tab.getString(key, i.next());
            if (usedClients.contains(str)) {
                String s = BasePrms.nameForKey((Long)key) + " contains duplicate: " + str;
                throw new HydraConfigException(s);
            }
            usedClients.add(str);
        }
        return new ArrayList<String>(strs);
    }
}

