/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import hydra.BasePrms;
import hydra.DistributedSystemHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.LonerDescription;
import hydra.gemfirexd.LonerPrms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class LonerHelper {
    protected static LonerDescription TheLonerDescription;
    private static Properties TheLonerProperties;
    private static LogWriter log;

    public static synchronized DistributedSystem connect() {
        log.info("Connecting the loner distributed system");
        Properties p = LonerHelper.getLonerProperties();
        return LonerHelper.connect(p);
    }

    private static synchronized DistributedSystem connect(Properties p) {
        DistributedSystem loner = DistributedSystemHelper.getDistributedSystem();
        if (loner == null) {
            log.info("Connecting to loner distributed system: " + LonerHelper.prettyprint(p));
            loner = DistributedSystem.connect((Properties)p);
            log.info("Connected to loner distributed system");
            TheLonerProperties = p;
        } else {
            if (TheLonerProperties == null) {
                String s = "Distributed system was already connected without LonerHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheLonerProperties.equals(p)) {
                String s = "Distributed system already exists using properties " + TheLonerProperties + ", cannot also use " + p;
                throw new HydraRuntimeException(s);
            }
            log.info("Already connected to loner distributed system");
        }
        return loner;
    }

    public static synchronized DistributedSystem getDistributedSystem() {
        return InternalDistributedSystem.getAnyInstance();
    }

    public static synchronized void disconnect() {
        DistributedSystem loner = LonerHelper.getDistributedSystem();
        if (loner != null) {
            log.info("Disconnecting from the loner distributed system: " + loner.getName());
            loner.disconnect();
            log.info("Disconnected from the loner distributed system");
            TheLonerProperties = null;
        }
    }

    public static Properties getLonerProperties() {
        LonerDescription ld = LonerHelper.getLonerDescription();
        return LonerHelper.getLonerProperties(ld);
    }

    private static synchronized Properties getLonerProperties(LonerDescription ld) {
        log.info("Looking up loner distributed system properties");
        Properties p = ld.getLonerProperties();
        log.info("Looked up loner distributed system properties: " + LonerHelper.prettyprint(p));
        return p;
    }

    private static String prettyprint(Properties p) {
        ArrayList<?> l = Collections.list(p.propertyNames());
        TreeSet set = new TreeSet(l);
        StringBuffer buf = new StringBuffer();
        for (String key : set) {
            String val = p.getProperty(key);
            buf.append("\n  " + key + "=" + val);
        }
        return buf.toString();
    }

    private static LonerDescription getLonerDescription() {
        String clientName = RemoteTestModule.getMyClientName();
        if (TheLonerDescription == null) {
            log.info("Looking up loner config for " + clientName);
            Map<String, LonerDescription> lds = GfxdTestConfig.getInstance().getLonerDescriptions();
            for (LonerDescription ld : lds.values()) {
                if (!ld.getClientNames().contains(clientName)) continue;
                log.info("Looked up loner config for " + clientName + ":\n" + ld);
                TheLonerDescription = ld;
                break;
            }
            if (TheLonerDescription == null) {
                String s = clientName + " is not wired to any loner description" + " using " + BasePrms.nameForKey((Long)LonerPrms.clientNames) + ". Either add it or use an alternate method that takes a " + BasePrms.nameForKey((Long)LonerPrms.names) + " argument.";
                throw new HydraRuntimeException(s);
            }
        }
        return TheLonerDescription;
    }

    static {
        log = Log.getLogWriter();
    }
}

