/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.pivotal.gemfirexd.NetworkInterface;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.TestConfig;
import hydra.gemfirexd.FabricServerDescription;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.NetworkServerPrms;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class NetworkServerDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String connectionListener;
    private Boolean logConnections;
    private Integer maxIdleTime;
    private Integer maxStartupWaitSec;
    private Integer maxThreads;
    private Integer numServers;
    private Boolean reusePorts;
    private Integer timeSlice;
    private Boolean trace;
    private transient String traceDirectory;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public String getConnectionListener() {
        return this.connectionListener;
    }

    private void setConnectionListener(String str) {
        this.connectionListener = str;
    }

    public Boolean getLogConnections() {
        return this.logConnections;
    }

    private void setLogConnections(Boolean bool) {
        this.logConnections = bool;
    }

    public Integer getMaxIdleTime() {
        return this.maxIdleTime;
    }

    private void setMaxIdleTime(Integer i) {
        this.maxIdleTime = i;
    }

    public Integer getMaxStartupWaitSec() {
        return this.maxStartupWaitSec;
    }

    private void setMaxStartupWaitSec(Integer i) {
        this.maxStartupWaitSec = i;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    private void setMaxThreads(Integer i) {
        this.maxThreads = i;
    }

    public Integer getNumServers() {
        return this.numServers;
    }

    private void setNumServers(Integer i) {
        this.numServers = i;
    }

    public Boolean getReusePorts() {
        return this.reusePorts;
    }

    private void setReusePorts(Boolean bool) {
        this.reusePorts = bool;
    }

    public Integer getTimeSlice() {
        return this.timeSlice;
    }

    private void setTimeSlice(Integer i) {
        this.timeSlice = i;
    }

    public Boolean getTrace() {
        return this.trace;
    }

    private void setTrace(Boolean bool) {
        this.trace = bool;
    }

    private synchronized String getTraceDirectory() {
        if (this.traceDirectory == null) {
            FabricServerDescription fsd = FabricServerHelper.TheFabricServerDescription;
            if (fsd == null) {
                String s = "Cannot start network server before fabric server";
                throw new HydraRuntimeException(s);
            }
            this.traceDirectory = fsd.getSysDir();
        }
        return this.traceDirectory;
    }

    protected Properties getNetworkProperties() {
        Properties p = new Properties();
        p.setProperty("gemfirexd.drda.logConnections", this.getLogConnections().toString());
        p.setProperty("gemfirexd.drda.maxIdleTime", this.getMaxIdleTime().toString());
        p.setProperty("gemfirexd.drda.maxThreads", this.getMaxThreads().toString());
        p.setProperty("gemfirexd.drda.timeSlice", this.getTimeSlice().toString());
        p.setProperty("gemfirexd.drda.trace", this.getTrace().toString());
        p.setProperty("gemfirexd.drda.traceDirectory", this.getTraceDirectory().toString());
        return p;
    }

    public SortedMap<String, Object> toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "connectionListener", this.getConnectionListener());
        map.put(header + "logConnections", this.getLogConnections());
        map.put(header + "maxIdleTime", this.getMaxIdleTime());
        map.put(header + "maxStartupWaitSec", this.getMaxStartupWaitSec());
        map.put(header + "maxThreads", this.getMaxThreads());
        map.put(header + "numServers", this.getNumServers());
        map.put(header + "reusePorts", this.getReusePorts());
        map.put(header + "timeSlice", this.getTimeSlice());
        map.put(header + "trace", this.getTrace());
        map.put(header + "traceDirectory", "autogenerated");
        return map;
    }

    protected void configure(NetworkInterface ns) {
        ns.setConnectionListener(this.getConnectionListenerInstance());
    }

    protected static synchronized String networkServerToString(NetworkInterface ni) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n  currentProperties: " + ni.getCurrentProperties());
        buf.append("\n  maxThreads: " + ni.getMaxThreads());
        buf.append("\n  timeSlice: " + ni.getTimeSlice());
        return buf.toString();
    }

    protected static Map configure(TestConfig config, GfxdTestConfig sconfig) {
        ConfigHashtable tab = config.getParameters();
        TreeMap<String, NetworkServerDescription> nsds = new TreeMap<String, NetworkServerDescription>();
        HydraVector names = tab.vecAt(NetworkServerPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            if (nsds.containsKey(name)) {
                String s = BasePrms.nameForKey((Long)NetworkServerPrms.names) + " contains duplicate entries: " + names;
                throw new HydraConfigException(s);
            }
            NetworkServerDescription nsd = NetworkServerDescription.createNetworkServerDescription(name, config, sconfig, i);
            nsds.put(name, nsd);
        }
        return nsds;
    }

    private static NetworkServerDescription createNetworkServerDescription(String name, TestConfig config, GfxdTestConfig sconfig, int index) {
        Boolean bool;
        ConfigHashtable tab = config.getParameters();
        NetworkServerDescription nsd = new NetworkServerDescription();
        nsd.setName(name);
        Long key = NetworkServerPrms.connectionListener;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            nsd.setConnectionListener(NetworkServerDescription.getConnectionListener(key, str, config));
        }
        if ((bool = tab.getBoolean(key = NetworkServerPrms.logConnections, tab.getWild(key, index, null))) == null) {
            bool = Boolean.TRUE;
        }
        nsd.setLogConnections(bool);
        key = NetworkServerPrms.maxIdleTime;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 30000;
        }
        nsd.setMaxIdleTime(i);
        key = NetworkServerPrms.maxStartupWaitSec;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 30;
        }
        nsd.setMaxStartupWaitSec(i);
        key = NetworkServerPrms.maxThreads;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        nsd.setMaxThreads(i);
        key = NetworkServerPrms.numServers;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 1;
        }
        nsd.setNumServers(i);
        key = NetworkServerPrms.reusePorts;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.TRUE;
        }
        nsd.setReusePorts(bool);
        key = NetworkServerPrms.timeSlice;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        nsd.setTimeSlice(i);
        key = NetworkServerPrms.trace;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        nsd.setTrace(bool);
        return nsd;
    }

    private static String getConnectionListener(Long key, String val, TestConfig config) {
        return NetworkServerDescription.getConnectionListenerInstance(val).getClass().getName();
    }

    private synchronized NetworkInterface.ConnectionListener getConnectionListenerInstance() {
        String s = this.getConnectionListener();
        return s == null ? null : NetworkServerDescription.getConnectionListenerInstance(s);
    }

    private static NetworkInterface.ConnectionListener getConnectionListenerInstance(String classname) {
        Long key = NetworkServerPrms.connectionListener;
        Object obj = NetworkServerDescription.getInstance((Long)key, (String)classname);
        try {
            return (NetworkInterface.ConnectionListener)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey((Long)key) + " does not implement ConnectionListener: " + classname;
            throw new HydraConfigException(s);
        }
    }
}

