/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.LogWriter;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.NetworkInterface;
import hydra.BasePrms;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterController;
import hydra.PortHelper;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.NetworkServerBlackboard;
import hydra.gemfirexd.NetworkServerDescription;
import hydra.gemfirexd.NetworkServerPrms;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkServerHelper {
    private static String TheNetworkServerConfig;
    private static LogWriter log;

    public static List<NetworkInterface> startNetworkServers(String networkServerConfig) {
        return NetworkServerHelper.startNetworkServers(networkServerConfig, Type.server);
    }

    protected static List<NetworkInterface> startNetworkLocators(String networkServerConfig) {
        return NetworkServerHelper.startNetworkServers(networkServerConfig, Type.locator);
    }

    private static synchronized List<NetworkInterface> startNetworkServers(String networkServerConfig, Type type) {
        List<NetworkInterface> servers = NetworkServerHelper.getNetworkServers();
        if (servers.size() == 0) {
            NetworkServerDescription nsd = NetworkServerHelper.getNetworkServerDescription(networkServerConfig);
            int numServers = nsd.getNumServers();
            log.info("Starting " + numServers + " network " + (Object)((Object)type) + "s " + "using configuration: " + networkServerConfig);
            for (int i = 0; i < numServers; ++i) {
                log.info("Starting network " + (Object)((Object)type) + " #" + i + " of " + numServers);
                NetworkInterface server = NetworkServerHelper.startNetworkServer(i, nsd, type);
                servers.add(server);
                log.info("Started network server #" + i + " of " + numServers);
            }
            TheNetworkServerConfig = networkServerConfig;
        } else {
            if (TheNetworkServerConfig == null) {
                String s = "Network servers were already created without NetworkServerHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheNetworkServerConfig.equals(networkServerConfig)) {
                String s = "Network servers already exist using logical configuration " + TheNetworkServerConfig + ", cannot also use " + networkServerConfig;
                throw new HydraRuntimeException(s);
            }
        }
        return servers;
    }

    private static synchronized NetworkInterface startNetworkServer(int index, NetworkServerDescription nsd, Type type) {
        NetworkInterface server;
        Endpoint endpoint = NetworkServerHelper.getEndpoint(index, type, nsd.getReusePorts());
        log.info("Starting network " + (Object)((Object)type) + " \"" + endpoint + "\"");
        FabricService service = FabricServiceManager.currentFabricServiceInstance();
        if (service == null) {
            throw new HydraRuntimeException("No FabricService started yet.");
        }
        try {
            server = service.startNetworkServer(endpoint.getAddress(), endpoint.getPort(), nsd.getNetworkProperties());
        }
        catch (SQLException e) {
            String s = "Problem starting network server at " + endpoint + " for " + nsd;
            throw new HydraRuntimeException(s, (Exception)e);
        }
        int timeoutSec = nsd.getMaxStartupWaitSec();
        log.info("Waiting " + timeoutSec + " seconds for network server to start");
        long timeout = System.currentTimeMillis() + (long)(timeoutSec * 1000);
        while (!server.status()) {
            MasterController.sleepForMs((int)250);
            if (System.currentTimeMillis() <= timeout) continue;
            String s = "Timed out after waiting " + timeoutSec + " seconds for network server to start";
            throw new HydraTimeoutException(s);
        }
        log.info("Configuring network server");
        nsd.configure(server);
        log.info("Started network server: " + NetworkServerHelper.networkServerToString(server));
        return server;
    }

    public static synchronized List<NetworkInterface> getNetworkServers() {
        FabricService service = FabricServiceManager.currentFabricServiceInstance();
        if (service != null) {
            return new ArrayList<NetworkInterface>(service.getAllNetworkServers());
        }
        return new ArrayList<NetworkInterface>();
    }

    public static synchronized void stopNetworkServers() {
        log.info("Stopping network servers");
        FabricService fs = FabricServiceManager.currentFabricServiceInstance();
        if (fs != null) {
            fs.stopAllNetworkServers();
        }
        TheNetworkServerConfig = null;
        log.info("Stopped network servers");
    }

    public static String networkServerToString(NetworkInterface server) {
        return NetworkServerDescription.networkServerToString(server);
    }

    public static synchronized void executeSQLCommands(String dsName, String fn, int waitSec) {
        log.info("Issuing run command to " + dsName + " using " + fn);
        List locators = NetworkServerHelper.getNetworkServerEndpoints(dsName);
        if (locators.size() == 0) {
            throw new HydraRuntimeException("No network locators found");
        }
        Endpoint endpoint = (Endpoint)locators.get(0);
        String cmd = FabricServerHelper.getGFXDCommand() + "run -file=" + fn + " -client-bind-address=" + endpoint.getAddress() + " -client-port=" + endpoint.getPort();
        String output = ProcessMgr.fgexec((String)cmd, (int)waitSec);
        log.info("Issued run command to " + dsName + " using " + fn);
    }

    public static NetworkServerDescription getNetworkServerDescription(String networkServerConfig) {
        if (networkServerConfig == null) {
            throw new IllegalArgumentException("networkServerConfig cannot be null");
        }
        log.info("Looking up network server config: " + networkServerConfig);
        NetworkServerDescription nsd = GfxdTestConfig.getInstance().getNetworkServerDescription(networkServerConfig);
        if (nsd == null) {
            String s = networkServerConfig + " not found in " + BasePrms.nameForKey((Long)NetworkServerPrms.names);
            throw new HydraRuntimeException(s);
        }
        log.info("Looked up network server config:\n" + nsd);
        return nsd;
    }

    public static List<Endpoint> getNetworkLocatorEndpointsInWanSite() {
        List endpoints = NetworkServerHelper.getNetworkLocatorEndpoints();
        return NetworkServerHelper.getEndpointsInWanSite(endpoints);
    }

    public static List<Endpoint> getNetworkServerEndpointsInWanSite() {
        List endpoints = NetworkServerHelper.getNetworkServerEndpoints();
        return NetworkServerHelper.getEndpointsInWanSite(endpoints);
    }

    private static List<Endpoint> getEndpointsInWanSite(List<Endpoint> endpoints) {
        int wanSite = NetworkServerHelper.toWanSite(RemoteTestModule.getMyClientName());
        ArrayList<Endpoint> matchingEndpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : endpoints) {
            if (NetworkServerHelper.toWanSite(endpoint.getName()) != wanSite) continue;
            matchingEndpoints.add(endpoint);
        }
        return matchingEndpoints;
    }

    public static int toWanSite(String clientName) {
        String[] arr = clientName.split("_");
        if (arr.length != 3) {
            String s = clientName + " is not in the form <name>_<wanSiteNumber>_<itemNumber>";
            throw new HydraRuntimeException(s);
        }
        try {
            return Integer.parseInt(arr[1]);
        }
        catch (NumberFormatException e) {
            String s = clientName + " is not in the form <name>_<wanSiteNumber>_<itemNumber>";
            throw new HydraRuntimeException(s, (Exception)e);
        }
    }

    public static List getNetworkLocatorEndpoints() {
        return NetworkServerHelper.getEndpoints(Type.locator);
    }

    public static List getNetworkServerEndpoints() {
        return NetworkServerHelper.getEndpoints(Type.server);
    }

    private static synchronized List<Endpoint> getEndpoints(Type type) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        Map map = NetworkServerBlackboard.getInstance().getSharedMap().getMap();
        log.info("Complete endpoint map contains: " + map);
        for (String key : map.keySet()) {
            if (!key.startsWith(type.toString())) continue;
            endpoints.addAll(((Map)map.get(key)).values());
        }
        log.info("Returning endpoint map: " + endpoints);
        return endpoints;
    }

    public static List getNetworkServerEndpoints(String distributedSystemName) {
        return NetworkServerHelper.getEndpoints(Type.server, distributedSystemName);
    }

    public static List getNetworkLocatorEndpoints(String distributedSystemName) {
        return NetworkServerHelper.getEndpoints(Type.locator, distributedSystemName);
    }

    private static synchronized List getEndpoints(Type type, String distributedSystemName) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : NetworkServerHelper.getEndpoints(type)) {
            if (!endpoint.getDistributedSystemName().equals(distributedSystemName)) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    private static synchronized Endpoint getEndpoint(int index, Type type, boolean reusePorts) {
        Endpoint endpoint;
        String key;
        SharedMap map = NetworkServerBlackboard.getInstance().getSharedMap();
        HashMap<Integer, Endpoint> endpoints = (HashMap<Integer, Endpoint>)map.get((Object)(key = NetworkServerHelper.getKey(type, RemoteTestModule.getMyVmid())));
        if (endpoints == null) {
            endpoints = new HashMap<Integer, Endpoint>();
        }
        if ((endpoint = (Endpoint)endpoints.get(index)) == null) {
            log.info("Generating network " + (Object)((Object)type) + " endpoint");
        } else if (reusePorts) {
            log.info("Reusing network " + (Object)((Object)type) + " endpoint: " + endpoint);
        } else {
            log.info("Regenerating network " + (Object)((Object)type) + " endpoint: " + endpoint);
            endpoints.remove(index);
            endpoint = null;
        }
        if (endpoint == null) {
            endpoint = NetworkServerHelper.generateEndpoint();
            endpoints.put(index, endpoint);
            map.put((Object)key, endpoints);
            log.info("Generated network " + (Object)((Object)type) + " endpoint: " + endpoint);
        }
        return endpoint;
    }

    private static Endpoint generateEndpoint() {
        Integer vmid = RemoteTestModule.getMyVmid();
        String name = RemoteTestModule.getMyClientName();
        String host = HostHelper.getLocalHost();
        String addr = HostHelper.getHostAddress();
        InetAddress iaddr = HostHelper.getIPAddress();
        log.info("Generating random port");
        int port = PortHelper.getRandomPort();
        log.info("Generated network port: " + port);
        String ds = FabricServerHelper.TheFabricServerDescription.getDistributedSystem();
        return new Endpoint(name, vmid, host, addr, iaddr, port, ds);
    }

    private static String getKey(Type type, int vmid) {
        return (Object)((Object)type) + "_" + vmid;
    }

    static {
        log = Log.getLogWriter();
    }

    public static class Endpoint
    implements Serializable {
        String id;
        String name;
        String host;
        String addr;
        String ds;
        InetAddress iaddr;
        int vmid;
        int port;

        public Endpoint(String name, int vmid, String host, String addr, InetAddress iaddr, int port, String ds) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (host == null) {
                throw new IllegalArgumentException("host cannot be null");
            }
            if (addr == null) {
                throw new IllegalArgumentException("addr cannot be null");
            }
            if (iaddr == null) {
                throw new IllegalArgumentException("iaddr cannot be null");
            }
            if (ds == null) {
                throw new IllegalArgumentException("ds cannot be null");
            }
            this.name = name;
            this.vmid = vmid;
            this.host = host;
            this.addr = addr;
            this.iaddr = iaddr;
            this.port = port;
            this.ds = ds;
            this.id = "vm_" + this.vmid + "_" + this.name + "_" + this.host;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getVmid() {
            return this.vmid;
        }

        public String getHost() {
            return this.host;
        }

        public String getAddress() {
            return this.addr;
        }

        public InetAddress getInetAddress() {
            return this.iaddr;
        }

        public int getPort() {
            return this.port;
        }

        public String getDistributedSystemName() {
            return this.ds;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)obj;
                return endpoint.getName().equals(this.getName()) && endpoint.getVmid() == this.getVmid() && endpoint.getHost().equals(this.getHost()) && endpoint.getAddress().equals(this.getAddress()) && endpoint.getInetAddress().equals(this.getInetAddress()) && endpoint.getPort() == this.getPort() && endpoint.getDistributedSystemName() == this.getDistributedSystemName();
            }
            return false;
        }

        public int hashCode() {
            return this.port;
        }

        public String toString() {
            return this.addr + ":" + this.port;
        }
    }

    private static enum Type {
        locator,
        server;

    }
}

