/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.FileUtil;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.VmDescription;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.ThinClientPrms;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class ThinClientDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LOG_FILE_NAME = "log-file";
    private String name;
    private List<String> clientNames;
    private Boolean queryHDFS;
    private Integer readTimeout;
    private Boolean singleHopEnabled;
    private Integer singleHopMaxConnections;
    private transient String logFile;
    private transient String resourceDir;
    private transient String clientDir;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public List<String> getClientNames() {
        return this.clientNames;
    }

    private void setClientNames(List<String> list) {
        this.clientNames = list;
    }

    public Boolean getQueryHDFS() {
        return this.queryHDFS;
    }

    private void setQueryHDFS(Boolean bool) {
        this.queryHDFS = bool;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    private void setReadTimeout(Integer i) {
        this.readTimeout = i;
    }

    public Boolean getSingleHopEnabled() {
        return this.singleHopEnabled;
    }

    private void setSingleHopEnabled(Boolean bool) {
        this.singleHopEnabled = bool;
    }

    public Integer getSingleHopMaxConnections() {
        return this.singleHopMaxConnections;
    }

    private void setSingleHopMaxConnections(Integer i) {
        this.singleHopMaxConnections = i;
    }

    private synchronized String getLogFile() {
        if (this.logFile == null) {
            this.logFile = this.getClientDir() + "/client.log";
        }
        return this.logFile;
    }

    private synchronized String getResourceDir() {
        if (this.resourceDir == null) {
            HostDescription hd = this.getHostDescription();
            String dir = hd.getResourceDir();
            if (dir == null) {
                dir = hd.getUserDir();
            }
            this.resourceDir = dir;
        }
        return this.resourceDir;
    }

    protected synchronized String getClientDir() {
        if (this.clientDir == null) {
            HostDescription hd = this.getHostDescription();
            String dir = this.getResourceDir() + "/" + "vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "_" + hd.getHostName() + "_" + RemoteTestModule.getMyPid();
            FileUtil.mkdir((File)new File(dir));
            try {
                RemoteTestModule.Master.recordDir(hd, this.getName(), dir);
            }
            catch (RemoteException e) {
                String s = "Unable to access master to record directory: " + dir;
                throw new HydraRuntimeException(s, (Exception)e);
            }
            this.clientDir = dir;
        }
        return this.clientDir;
    }

    private HostDescription getHostDescription() {
        String clientName = RemoteTestModule.getMyClientName();
        if (clientName == null) {
            String s = "This method can only be invoked from hydra client VMs";
            throw new HydraInternalException(s);
        }
        if (!this.clientNames.contains(clientName)) {
            String s = "Logical client " + clientName + " is not in the list of clients supported by " + BasePrms.nameForKey((Long)ThinClientPrms.names) + "=" + this.getName();
            throw new HydraRuntimeException(s);
        }
        return TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
    }

    protected Properties getConnectionProperties() {
        Properties p = new Properties();
        p.setProperty(LOG_FILE_NAME, this.getLogFile());
        p.setProperty("query-HDFS", this.getQueryHDFS().toString());
        p.setProperty("read-timeout", this.getReadTimeout().toString());
        p.setProperty("single-hop-enabled", this.getSingleHopEnabled().toString());
        return p;
    }

    public SortedMap<String, Object> toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "clientNames", this.getClientNames());
        map.put(header + "logFile", "autogenerated: client.log in client directory");
        map.put(header + "queryHDFS", this.getQueryHDFS());
        map.put(header + "readTimeout", this.getReadTimeout());
        map.put(header + "singleHopEnabled", this.getSingleHopEnabled());
        map.put(header + "singleHopMaxConnections", this.getSingleHopMaxConnections());
        return map;
    }

    protected static Map configure(TestConfig config, GfxdTestConfig sconfig) {
        ConfigHashtable tab = config.getParameters();
        ArrayList<String> usedClients = new ArrayList<String>();
        TreeMap<String, ThinClientDescription> tcds = new TreeMap<String, ThinClientDescription>();
        HydraVector names = tab.vecAt(ThinClientPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            if (tcds.containsKey(name)) {
                String s = BasePrms.nameForKey((Long)ThinClientPrms.names) + " contains duplicate entries: " + names;
                throw new HydraConfigException(s);
            }
            ThinClientDescription tcd = ThinClientDescription.createThinClientDescription(name, config, i, usedClients);
            tcds.put(name, tcd);
        }
        return tcds;
    }

    private static ThinClientDescription createThinClientDescription(String name, TestConfig config, int index, List<String> usedClients) {
        ConfigHashtable tab = config.getParameters();
        ThinClientDescription tcd = new ThinClientDescription();
        tcd.setName(name);
        Long key = ThinClientPrms.clientNames;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs == null) {
            String s = BasePrms.nameForKey((Long)key) + " is a required field and has no default value";
            throw new HydraConfigException(s);
        }
        List<String> cnames = ThinClientDescription.getClientNames((Vector)strs, key, usedClients, tab);
        tcd.setClientNames(cnames);
        for (String cname : cnames) {
            VmDescription vmd = config.getClientDescription(cname).getVmDescription();
            HostDescription hd = vmd.getHostDescription();
            ArrayList<String> classPaths = new ArrayList<String>();
            String classPath2 = hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + "product-gfxd" + hd.getFileSep() + "lib" + hd.getFileSep() + "gemfirexd.jar";
            classPaths.add(classPath2);
            String classPath = hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + "product-gfxd" + hd.getFileSep() + "lib" + hd.getFileSep() + "gemfirexd-client.jar";
            classPaths.add(classPath);
            vmd.setGemFireXDClassPaths(classPaths);
        }
        key = ThinClientPrms.queryHDFS;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        tcd.setQueryHDFS(bool);
        key = ThinClientPrms.readTimeout;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        tcd.setReadTimeout(i);
        key = ThinClientPrms.singleHopEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = Boolean.FALSE;
        }
        tcd.setSingleHopEnabled(bool);
        key = ThinClientPrms.singleHopMaxConnections;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        int defaultVal = 5;
        if (i == null) {
            i = defaultVal;
        }
        tcd.setSingleHopMaxConnections(i);
        if (tcd.getSingleHopEnabled().booleanValue() && tcd.getSingleHopMaxConnections() != defaultVal) {
            String arg = "-Dgemfirexd.client.single-hop-max-connections=" + tcd.getSingleHopMaxConnections();
            for (String cname : tcd.getClientNames()) {
                VmDescription vmd = config.getClientDescription(cname).getVmDescription();
                vmd.addExtraVMArg(arg);
            }
        }
        return tcd;
    }

    private static List<String> getClientNames(Vector strs, Long key, List<String> usedClients, ConfigHashtable tab) {
        Iterator i = strs.iterator();
        while (i.hasNext()) {
            String str = tab.getString(key, i.next());
            if (usedClients.contains(str)) {
                String s = BasePrms.nameForKey((Long)key) + " contains duplicate: " + str;
                throw new HydraConfigException(s);
            }
            usedClients.add(str);
        }
        return new ArrayList<String>(strs);
    }
}

