/*
 * Decompiled with CFR 0.152.
 */
package hydra.gemfirexd;

import com.gemstone.gemfire.LogWriter;
import hydra.BasePrms;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.ThinClientDescription;
import hydra.gemfirexd.ThinClientPrms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class ThinClientHelper {
    protected static ThinClientDescription TheThinClientDescription;
    private static LogWriter log;

    public static Properties getConnectionProperties() {
        ThinClientDescription tcd = ThinClientHelper.getThinClientDescription();
        return ThinClientHelper.getConnectionProperties(tcd);
    }

    private static synchronized Properties getConnectionProperties(ThinClientDescription tcd) {
        log.info("Looking up thin client connection properties");
        Properties p = tcd.getConnectionProperties();
        log.info("Looked up thin client connection properties: " + ThinClientHelper.prettyprint(p));
        return p;
    }

    private static String prettyprint(Properties p) {
        ArrayList<?> l = Collections.list(p.propertyNames());
        TreeSet set = new TreeSet(l);
        StringBuffer buf = new StringBuffer();
        for (String key : set) {
            String val = p.getProperty(key);
            buf.append("\n  " + key + "=" + val);
        }
        return buf.toString();
    }

    private static synchronized ThinClientDescription getThinClientDescription() {
        String clientName = RemoteTestModule.getMyClientName();
        if (TheThinClientDescription == null) {
            log.info("Looking up thin client config for " + clientName);
            Map<String, ThinClientDescription> tcds = GfxdTestConfig.getInstance().getThinClientDescriptions();
            for (ThinClientDescription tcd : tcds.values()) {
                if (!tcd.getClientNames().contains(clientName)) continue;
                log.info("Looked up thin client config for " + clientName + ":\n" + tcd);
                TheThinClientDescription = tcd;
                break;
            }
            if (TheThinClientDescription == null) {
                String s = clientName + " is not wired to any thin client description" + " using " + BasePrms.nameForKey((Long)ThinClientPrms.clientNames) + ".";
                throw new HydraRuntimeException(s);
            }
        }
        return TheThinClientDescription;
    }

    static {
        log = Log.getLogWriter();
    }
}

