/*
 * Decompiled with CFR 0.152.
 */
package objects.query;

import hydra.HydraConfigException;
import objects.query.QueryFactory;
import objects.query.broker.Broker;
import objects.query.largeobject.LargeObject;
import objects.query.sector.Sector;
import objects.query.tinyobject.TinyObject;

public class QueryHelper {
    public static QueryFactory getQueryFactory(int api, String objectType) {
        QueryFactory factory = null;
        if (objectType.equals("objects.query.broker.Broker")) {
            factory = Broker.getQueryFactory((int)api);
            if (factory == null) {
                String s = api + " factory not found for " + objectType;
                throw new HydraConfigException(s);
            }
        } else if (objectType.equals("objects.query.sector.Sector")) {
            factory = Sector.getQueryFactory(api);
            if (factory == null) {
                String s = api + " factory not found for " + objectType;
                throw new HydraConfigException(s);
            }
        } else if (objectType.equals("objects.query.largeobject.LargeObject")) {
            factory = LargeObject.getQueryFactory(api);
            if (factory == null) {
                String s = api + " factory not found for " + objectType;
                throw new HydraConfigException(s);
            }
        } else if (objectType.equals("objects.query.tinyobject.TinyObject")) {
            factory = TinyObject.getQueryFactory(api);
            if (factory == null) {
                String s = api + " factory not found for " + objectType;
                throw new HydraConfigException(s);
            }
        } else {
            String s = "Factory not found: " + objectType;
            s = s + " check QueryHelper to make sure object type has been added.";
            throw new HydraConfigException(s);
        }
        factory.init();
        return factory;
    }
}

