/*
 * Decompiled with CFR 0.152.
 */
package objects.query.largeobject;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.Log;
import java.util.ArrayList;
import java.util.List;
import objects.query.largeobject.LargeObject;
import objects.query.largeobject.LargeObjectPrms;
import objects.query.largeobject.MySQLLargeObjectQueryFactory;

public class MySQLCLargeObjectQueryFactory
extends MySQLLargeObjectQueryFactory {
    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "create table " + LargeObject.getTableName() + " (" + this.getIdCreateStatement() + "," + " stringField1 varchar(20), stringField2 varchar(20), stringField3 varchar(20), stringField4 varchar(20), stringField5 varchar(20), stringField6 varchar(20), stringField7 varchar(20), stringField8 varchar(20), stringField9 varchar(20), stringField10 varchar(20), stringField11 varchar(20), stringField12 varchar(20), stringField13 varchar(20), stringField14 varchar(20), stringField15 varchar(20), stringField16 varchar(20), stringField17 varchar(20), stringField18 varchar(20), stringField19 varchar(20), stringField20 varchar(20), intField1 int, intField2 int, intField3 int, intField4 int, intField5 int, intField6 int, intField7 int, intField8 int, intField9 int, intField10 int, intField11 int, intField12 int, intField13 int, intField14 int, intField15 int, intField16 int, intField17 int, intField18 int, intField19 int, intField20 int " + ") ENGINE=NDBCLUSTER";
        int dataPolicy = LargeObjectPrms.getLargeObjectDataPolicy();
        if (dataPolicy == 0) {
            String s = "Replicated data policy is not supported in MySQL Cluster";
            throw new UnsupportedOperationException(s);
        }
        if (dataPolicy == 1) {
            int buckets = LargeObjectPrms.getLargeObjectPartitionTotalNumBuckets();
            int partitionType = LargeObjectPrms.getLargeObjectPartitionType();
            switch (partitionType) {
                case 3: {
                    String s = "Default partition type is currently not supported for table LargeObject";
                    throw new UnsupportedOperationException(s);
                }
                case 1: {
                    String s = "Partition by column is currently not supported for table LargeObject";
                    throw new UnsupportedOperationException(s);
                }
                case 0: {
                    stmt = stmt + " PARTITION BY KEY(id)";
                    if (buckets == 0) break;
                    stmt = stmt + " PARTITIONS " + buckets;
                    break;
                }
                case 2: {
                    int numLargeObjects = LargeObjectPrms.getNumLargeObjects();
                    buckets = LargeObjectPrms.getLargeObjectPartitionTotalNumBuckets();
                    if (numLargeObjects % buckets != 0) {
                        String s = BasePrms.nameForKey((Long)LargeObjectPrms.largeObjectPartitionTotalNumBuckets) + ": " + buckets + " does not evenly divide " + BasePrms.nameForKey((Long)LargeObjectPrms.numLargeObjects) + ": " + numLargeObjects;
                        throw new HydraConfigException(s);
                    }
                    int largeObjectsPerBucket = numLargeObjects / buckets;
                    Log.getLogWriter().info("Configuring partition by range for " + numLargeObjects + " objects using " + buckets + " ranges and " + largeObjectsPerBucket + " objects per range");
                    stmt = stmt + " PARTITION BY RANGE (" + LargeObjectPrms.getLargeObjectPartitionColumn() + ")";
                    stmt = stmt + " (";
                    for (int i = 0; i < buckets; ++i) {
                        if (i != 0) {
                            stmt = stmt + ", ";
                        }
                        int y = (i + 1) * largeObjectsPerBucket;
                        stmt = stmt + "PARTITION p" + i + " VALUES LESS THAN (" + y + ")";
                    }
                    stmt = stmt + ")";
                    break;
                }
                default: {
                    String s = "Invalid partitioning scheme";
                    throw new HydraConfigException(s);
                }
            }
        }
        stmts.add(stmt);
        return stmts;
    }
}

