/*
 * Decompiled with CFR 0.152.
 */
package objects.query.largeobject;

import com.gemstone.gemfire.cache.Region;
import hydra.BasePrms;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.TestConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import objects.query.BaseSQLQueryFactory;
import objects.query.QueryObjectException;
import objects.query.SQLQueryFactory;
import objects.query.largeobject.LargeObject;
import objects.query.largeobject.LargeObjectPrms;
import util.TestException;

public class SQLLargeObjectQueryFactory
extends BaseSQLQueryFactory
implements SQLQueryFactory {
    protected static final GsRandom rng = TestConfig.tab().getRandGen();
    protected static final String FIELD_SPEC = " stringField1 varchar(20), stringField2 varchar(20), stringField3 varchar(20), stringField4 varchar(20), stringField5 varchar(20), stringField6 varchar(20), stringField7 varchar(20), stringField8 varchar(20), stringField9 varchar(20), stringField10 varchar(20), stringField11 varchar(20), stringField12 varchar(20), stringField13 varchar(20), stringField14 varchar(20), stringField15 varchar(20), stringField16 varchar(20), stringField17 varchar(20), stringField18 varchar(20), stringField19 varchar(20), stringField20 varchar(20), intField1 int, intField2 int, intField3 int, intField4 int, intField5 int, intField6 int, intField7 int, intField8 int, intField9 int, intField10 int, intField11 int, intField12 int, intField13 int, intField14 int, intField15 int, intField16 int, intField17 int, intField18 int, intField19 int, intField20 int ";
    private int totalPositions;

    public List getConstraintStatements() {
        return new ArrayList();
    }

    public int getQueryType() {
        return LargeObjectPrms.getQueryType(1);
    }

    public int getUpdateQueryType() {
        return LargeObjectPrms.getUpdateQueryType(1);
    }

    public int getDeleteQueryType() {
        return LargeObjectPrms.getDeleteQueryType(1);
    }

    public String getQuery(int queryType, int i) {
        String query = "";
        int type = queryType;
        switch (type) {
            case 0: {
                query = this.getRandomEqualityOnLargeObjectIdQuery();
                break;
            }
            case 1: {
                query = this.getPutNewLargeObjectByLargeObjectIdQuery(i);
                break;
            }
            case 2: {
                query = this.getGetAndPutLargeObjectByLargeObjectIdQuery(i);
                break;
            }
            case 5: {
                query = this.getDeleteLargeObjectByLargeObjectIdQuery(i);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    public String getPreparedQuery(int queryType) {
        String query = "";
        int type = queryType;
        switch (type) {
            case 0: {
                query = this.getPreparedStatementForRandomEqualityOnLargeObjectIdQuery();
                break;
            }
            case 1: {
                query = this.getPreparedStatementForPutNewLargeObjectByLargeObjectIdQuery();
                break;
            }
            case 2: {
                query = this.getPreparedStatementForGetAndPutLargeObjectByLargeObjectIdQuery();
                break;
            }
            case 5: {
                query = this.getPreparedStatementForDeleteLargeObjectByLargeObjectIdQuery();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    public String getPrimaryKeyIndexOnLargeObjectId() {
        return "alter table " + LargeObject.getTableName() + " add primary key(id)";
    }

    public List getIndexStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        Vector indexTypes = LargeObjectPrms.getIndexTypes();
        for (String indexTypeString : indexTypes) {
            int indexType = LargeObjectPrms.getIndexType(indexTypeString);
            String stmt = this.getIndexStatement(indexType);
            if (stmt == null) continue;
            stmts.add(stmt);
        }
        return stmts;
    }

    public String getIndexStatement(int type) {
        String query;
        switch (type) {
            case 0: {
                query = this.getPrimaryKeyIndexOnLargeObjectId();
                break;
            }
            case -1: {
                query = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    public List getInsertStatements(int bid) {
        ArrayList<String> stmts = new ArrayList<String>();
        int numLargeObjects = LargeObjectPrms.getNumLargeObjects();
        if (bid >= numLargeObjects) {
            String s = "Attempt to get insert statement with bid=" + bid + " when " + BasePrms.nameForKey((Long)LargeObjectPrms.numLargeObjects) + "=" + numLargeObjects;
            throw new QueryObjectException(s);
        }
        String stmt = "insert into " + LargeObject.getTableName() + " values (" + bid + "," + "'stringField1 " + bid + "'," + "'stringField2 " + bid + "'," + "'stringField3 " + bid + "'," + "'stringField4 " + bid + "'," + "'stringField5 " + bid + "'," + "'stringField6 " + bid + "'," + "'stringField7 " + bid + "'," + "'stringField8 " + bid + "'," + "'stringField9 " + bid + "'," + "'stringField10 " + bid + "'," + "'stringField11 " + bid + "'," + "'stringField12 " + bid + "'," + "'stringField13 " + bid + "'," + "'stringField14 " + bid + "'," + "'stringField15 " + bid + "'," + "'stringField16 " + bid + "'," + "'stringField17 " + bid + "'," + "'stringField18 " + bid + "'," + "'stringField19 " + bid + "'," + "'stringField20 " + bid + "'," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + "," + bid + ")";
        stmts.add(stmt);
        return stmts;
    }

    public List getPreparedInsertStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "insert into " + LargeObject.getTableName() + " values (?, " + "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?," + "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        stmts.add(stmt);
        return stmts;
    }

    public int fillAndExecutePreparedInsertStatements(List pstmts, List stmts, int i) throws SQLException {
        int numLargeObjects = LargeObjectPrms.getNumLargeObjects();
        PreparedStatement pstmt = (PreparedStatement)pstmts.get(0);
        boolean results = false;
        if (i >= numLargeObjects) {
            String s = "Attempt to get insert statement with bid=" + i + " when " + BasePrms.nameForKey((Long)LargeObjectPrms.numLargeObjects) + "=" + numLargeObjects;
            throw new QueryObjectException(s);
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executing " + stmts.get(0) + " on " + i);
        }
        pstmt.setInt(1, i);
        pstmt.setString(2, "stringField1");
        pstmt.setString(3, "stringField2");
        pstmt.setString(4, "stringField3");
        pstmt.setString(5, "stringField4");
        pstmt.setString(6, "stringField5");
        pstmt.setString(7, "stringField6");
        pstmt.setString(8, "stringField7");
        pstmt.setString(9, "stringField8");
        pstmt.setString(10, "stringField9");
        pstmt.setString(11, "stringField10");
        pstmt.setString(12, "stringField11");
        pstmt.setString(13, "stringField12");
        pstmt.setString(14, "stringField13");
        pstmt.setString(15, "stringField14");
        pstmt.setString(16, "stringField15");
        pstmt.setString(17, "stringField16");
        pstmt.setString(18, "stringField17");
        pstmt.setString(19, "stringField18");
        pstmt.setString(20, "stringField19");
        pstmt.setString(21, "stringField20");
        pstmt.setInt(22, i);
        pstmt.setInt(23, i);
        pstmt.setInt(24, i);
        pstmt.setInt(25, i);
        pstmt.setInt(26, i);
        pstmt.setInt(27, i);
        pstmt.setInt(28, i);
        pstmt.setInt(29, i);
        pstmt.setInt(30, i);
        pstmt.setInt(31, i);
        pstmt.setInt(32, i);
        pstmt.setInt(33, i);
        pstmt.setInt(34, i);
        pstmt.setInt(35, i);
        pstmt.setInt(36, i);
        pstmt.setInt(37, i);
        pstmt.setInt(38, i);
        pstmt.setInt(39, i);
        pstmt.setInt(40, i);
        pstmt.setInt(41, i);
        return this.executeUpdatePreparedStatement(pstmt);
    }

    public String getCreateSchemaStatement() {
        String stmt = "create schema perfTest";
        return stmt;
    }

    public String getDropSchemaStatement() {
        String stmt = "drop schema perfTest restrict";
        return stmt;
    }

    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "create table " + LargeObject.getTableName() + " (" + this.getIdCreateStatement() + "," + FIELD_SPEC + ")";
        stmts.add(stmt);
        return stmts;
    }

    public List getDropTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add("drop table if exists " + LargeObject.getTableName());
        return stmts;
    }

    protected String getIdCreateStatement() {
        String stmt = "id int not null";
        Vector indexes = LargeObjectPrms.getLargeObjectCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = LargeObjectPrms.getIndexType((String)iterator.next());
            if (indexType == 0) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 1) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    public String getRandomEqualityOnLargeObjectIdQuery() {
        String fields = LargeObjectPrms.getLargeObjectFields();
        int id = rng.nextInt(0, LargeObjectPrms.getNumLargeObjects() - 1);
        return "select " + fields + " from " + LargeObject.getTableAndShortName() + " where " + LargeObject.getTableShortName() + ".id=" + id;
    }

    public String getPutNewLargeObjectByLargeObjectIdQuery(int id) {
        StringBuffer sb = new StringBuffer("update " + LargeObject.getTableAndShortName() + " set " + LargeObject.getTableShortName() + ".stringField1" + "=" + "'stringField1 " + id + "', " + LargeObject.getTableShortName() + ".stringField2" + "=" + "'stringField2 " + id + "', " + LargeObject.getTableShortName() + ".stringField3" + "=" + "'stringField3 " + id + "', " + LargeObject.getTableShortName() + ".stringField4" + "=" + "'stringField4 " + id + "', " + LargeObject.getTableShortName() + ".stringField5" + "=" + "'stringField5 " + id + "', " + LargeObject.getTableShortName() + ".stringField6" + "=" + "'stringField6 " + id + "', " + LargeObject.getTableShortName() + ".stringField7" + "=" + "'stringField7 " + id + "', " + LargeObject.getTableShortName() + ".stringField8" + "=" + "'stringField8 " + id + "', " + LargeObject.getTableShortName() + ".stringField9" + "=" + "'stringField9 " + id + "', " + LargeObject.getTableShortName() + ".stringField10" + "=" + "'stringField10 " + id + "', " + LargeObject.getTableShortName() + ".stringField11" + "=" + "'stringField11 " + id + "', " + LargeObject.getTableShortName() + ".stringField12" + "=" + "'stringField12 " + id + "', " + LargeObject.getTableShortName() + ".stringField13" + "=" + "'stringField13 " + id + "', " + LargeObject.getTableShortName() + ".stringField14" + "=" + "'stringField14 " + id + "', " + LargeObject.getTableShortName() + ".stringField15" + "=" + "'stringField15 " + id + "', " + LargeObject.getTableShortName() + ".stringField16" + "=" + "'stringField16 " + id + "', " + LargeObject.getTableShortName() + ".stringField17" + "=" + "'stringField17 " + id + "', " + LargeObject.getTableShortName() + ".stringField18" + "=" + "'stringField18 " + id + "', " + LargeObject.getTableShortName() + ".stringField19" + "=" + "'stringField19 " + id + "', " + LargeObject.getTableShortName() + ".stringField20" + "=" + "'stringField20 " + id + "', " + LargeObject.getTableShortName() + ".intField1" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField2" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField3" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField4" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField5" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField6" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField7" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField8" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField9" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField10" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField11" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField12" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField13" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField14" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField15" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField16" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField17" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField18" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField19" + "=" + id + ", " + LargeObject.getTableShortName() + ".intField20" + "=" + id + " where " + LargeObject.getTableShortName() + ".id=" + id);
        return sb.toString();
    }

    public String getGetAndPutLargeObjectByLargeObjectIdQuery(int id) {
        int n = rng.nextInt(1, 20);
        StringBuffer sb = new StringBuffer("update " + LargeObject.getTableAndShortName() + " set " + LargeObject.getTableShortName() + ".stringField3" + "=" + "'stringField3 " + n + "', " + LargeObject.getTableShortName() + ".intField12" + "=" + n + ", " + LargeObject.getTableShortName() + ".intField18" + "=" + n + " where " + LargeObject.getTableShortName() + ".id=" + id);
        return sb.toString();
    }

    public String getDeleteLargeObjectByLargeObjectIdQuery(int id) {
        StringBuffer sb = new StringBuffer("delete from " + LargeObject.getTableAndShortName() + " where " + LargeObject.getTableShortName() + ".id=" + id);
        return sb.toString();
    }

    public ResultSet fillAndExecutePreparedQueryStatement(PreparedStatement pstmt, String stmt, int queryType, int i) throws SQLException {
        ResultSet rs = null;
        if (this.logQueries) {
            Log.getLogWriter().info("Executing Prepared Statement: ");
        }
        switch (queryType) {
            case 0: {
                rs = this.fillAndExecutePreparedStatementForRandomEqualityOnLargeObjectIdQuery(pstmt, stmt, i);
                break;
            }
            default: {
                throw new HydraConfigException("Unsupported, should not happen");
            }
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed Prepared Statement: ");
        }
        return rs;
    }

    public String getPreparedStatementForRandomEqualityOnLargeObjectIdQuery() {
        String fields = LargeObjectPrms.getLargeObjectFields();
        this.totalPositions = LargeObjectPrms.getNumLargeObjects();
        return "select " + fields + " from " + LargeObject.getTableAndShortName() + " where " + LargeObject.getTableShortName() + ".id=?";
    }

    public ResultSet fillAndExecutePreparedStatementForRandomEqualityOnLargeObjectIdQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        int id = rng.nextInt(0, this.totalPositions - 1);
        pstmt.setInt(1, id);
        if (this.logQueries) {
            Log.getLogWriter().info("Executing " + stmt + " on " + id);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public int fillAndExecuteUpdatePreparedQueryStatement(PreparedStatement pstmt, String stmt, int queryType, int i) throws SQLException {
        int numUpdated = 0;
        if (this.logQueries) {
            Log.getLogWriter().info("Executing Prepared Statement: and i = " + i);
        }
        switch (queryType) {
            case 1: {
                numUpdated = this.fillAndExecutePreparedStatementForPutNewLargeObjectByLargeObjectIdQuery(pstmt, stmt, i);
                break;
            }
            case 2: {
                numUpdated = this.fillAndExecutePreparedStatementForGetAndPutLargeObjectByLargeObjectIdQuery(pstmt, stmt, i);
                break;
            }
            case 5: {
                numUpdated = this.fillAndExecutePreparedStatementForDeleteLargeObjectByLargeObjectIdQuery(pstmt, stmt, i);
                break;
            }
            default: {
                throw new HydraConfigException("Unsupported query type for updates, should not happen");
            }
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed Prepared Statement: ");
        }
        return numUpdated;
    }

    public String getPreparedStatementForPutNewLargeObjectByLargeObjectIdQuery() {
        StringBuffer sb = new StringBuffer("update " + LargeObject.getTableAndShortName() + " set " + LargeObject.getTableShortName() + ".stringField1=? ," + LargeObject.getTableShortName() + ".stringField2=? ," + LargeObject.getTableShortName() + ".stringField3=? ," + LargeObject.getTableShortName() + ".stringField4=? ," + LargeObject.getTableShortName() + ".stringField5=? ," + LargeObject.getTableShortName() + ".stringField6=? ," + LargeObject.getTableShortName() + ".stringField7=? ," + LargeObject.getTableShortName() + ".stringField8=? ," + LargeObject.getTableShortName() + ".stringField9=? ," + LargeObject.getTableShortName() + ".stringField10=? ," + LargeObject.getTableShortName() + ".stringField11=? ," + LargeObject.getTableShortName() + ".stringField12=? ," + LargeObject.getTableShortName() + ".stringField13=? ," + LargeObject.getTableShortName() + ".stringField14=? ," + LargeObject.getTableShortName() + ".stringField15=? ," + LargeObject.getTableShortName() + ".stringField16=? ," + LargeObject.getTableShortName() + ".stringField17=? ," + LargeObject.getTableShortName() + ".stringField18=? ," + LargeObject.getTableShortName() + ".stringField19=? ," + LargeObject.getTableShortName() + ".stringField20=? ," + LargeObject.getTableShortName() + ".intField1=? ," + LargeObject.getTableShortName() + ".intField2=? ," + LargeObject.getTableShortName() + ".intField3=? ," + LargeObject.getTableShortName() + ".intField4=? ," + LargeObject.getTableShortName() + ".intField5=? ," + LargeObject.getTableShortName() + ".intField6=? ," + LargeObject.getTableShortName() + ".intField7=? ," + LargeObject.getTableShortName() + ".intField8=? ," + LargeObject.getTableShortName() + ".intField9=? ," + LargeObject.getTableShortName() + ".intField10=? ," + LargeObject.getTableShortName() + ".intField11=? ," + LargeObject.getTableShortName() + ".intField12=? ," + LargeObject.getTableShortName() + ".intField13=? ," + LargeObject.getTableShortName() + ".intField14=? ," + LargeObject.getTableShortName() + ".intField15=? ," + LargeObject.getTableShortName() + ".intField16=? ," + LargeObject.getTableShortName() + ".intField17=? ," + LargeObject.getTableShortName() + ".intField18=? ," + LargeObject.getTableShortName() + ".intField19=? ," + LargeObject.getTableShortName() + ".intField20=? " + " where " + LargeObject.getTableShortName() + ".id=?");
        return sb.toString();
    }

    public int fillAndExecutePreparedStatementForPutNewLargeObjectByLargeObjectIdQuery(PreparedStatement pstmt, String stmt, int id) throws SQLException {
        int tmpid = id % 10000;
        pstmt.setString(1, "stringField1 " + tmpid);
        pstmt.setString(2, "stringField2 " + tmpid);
        pstmt.setString(3, "stringField3 " + tmpid);
        pstmt.setString(4, "stringField4 " + tmpid);
        pstmt.setString(5, "stringField5 " + tmpid);
        pstmt.setString(6, "stringField6 " + tmpid);
        pstmt.setString(7, "stringField7 " + tmpid);
        pstmt.setString(8, "stringField8 " + tmpid);
        pstmt.setString(9, "stringField9 " + tmpid);
        pstmt.setString(10, "stringField10 " + tmpid);
        pstmt.setString(11, "stringField11 " + tmpid);
        pstmt.setString(12, "stringField12 " + tmpid);
        pstmt.setString(13, "stringField13 " + tmpid);
        pstmt.setString(14, "stringField14 " + tmpid);
        pstmt.setString(15, "stringField15 " + tmpid);
        pstmt.setString(16, "stringField16 " + tmpid);
        pstmt.setString(17, "stringField17 " + tmpid);
        pstmt.setString(18, "stringField18 " + tmpid);
        pstmt.setString(19, "stringField19 " + tmpid);
        pstmt.setString(20, "stringField20 " + tmpid);
        pstmt.setInt(21, id);
        pstmt.setInt(22, id);
        pstmt.setInt(23, id);
        pstmt.setInt(24, id);
        pstmt.setInt(25, id);
        pstmt.setInt(26, id);
        pstmt.setInt(27, id);
        pstmt.setInt(28, id);
        pstmt.setInt(29, id);
        pstmt.setInt(30, id);
        pstmt.setInt(31, id);
        pstmt.setInt(32, id);
        pstmt.setInt(33, id);
        pstmt.setInt(34, id);
        pstmt.setInt(35, id);
        pstmt.setInt(36, id);
        pstmt.setInt(37, id);
        pstmt.setInt(38, id);
        pstmt.setInt(39, id);
        pstmt.setInt(40, id);
        pstmt.setInt(41, id);
        return this.executeUpdatePreparedStatement(pstmt);
    }

    public String getPreparedStatementForGetAndPutLargeObjectByLargeObjectIdQuery() {
        StringBuffer sb = new StringBuffer("update " + LargeObject.getTableAndShortName() + " set " + LargeObject.getTableShortName() + ".stringField3=? ," + LargeObject.getTableShortName() + ".intField3=? ," + LargeObject.getTableShortName() + ".intField12=? " + " where " + LargeObject.getTableShortName() + ".id=?");
        return sb.toString();
    }

    public int fillAndExecutePreparedStatementForGetAndPutLargeObjectByLargeObjectIdQuery(PreparedStatement pstmt, String stmt, int id) throws SQLException {
        int n = rng.nextInt(1, 20);
        pstmt.setString(1, "stringField3 " + n);
        pstmt.setInt(2, n);
        pstmt.setInt(3, n);
        pstmt.setInt(4, id);
        return this.executeUpdatePreparedStatement(pstmt);
    }

    public String getPreparedStatementForDeleteLargeObjectByLargeObjectIdQuery() {
        StringBuffer sb = new StringBuffer("delete from " + LargeObject.getTableAndShortName() + " where " + LargeObject.getTableShortName() + ".id=?");
        return sb.toString();
    }

    public int fillAndExecutePreparedStatementForDeleteLargeObjectByLargeObjectIdQuery(PreparedStatement pstmt, String stmt, int id) throws SQLException {
        pstmt.setInt(1, id);
        return this.executeUpdatePreparedStatement(pstmt);
    }

    public int readResultSet(int queryType, ResultSet rs) throws SQLException {
        switch (queryType) {
            case 0: {
                return this.readResultSet(queryType, rs, LargeObject.getFields(LargeObjectPrms.getLargeObjectFieldsAsVector()));
            }
        }
        return this.readResultSet(queryType, rs, LargeObject.getFields(LargeObjectPrms.getLargeObjectFieldsAsVector()));
    }

    public int readResultSet(int queryType, ResultSet rs, List fields) throws SQLException {
        int expectedSize;
        int rsSize = 0;
        while (rs.next()) {
            this.readFields(rs, fields);
            ++rsSize;
        }
        if (this.logQueryResultSize) {
            Log.getLogWriter().info("Returned " + rsSize + " rows");
        }
        if (this.validateResults && rsSize != (expectedSize = this.getResultSetSize(queryType))) {
            throw new HydraConfigException("ResultSetSize expected(" + expectedSize + ") did not match actual(" + rsSize + ")");
        }
        return rsSize;
    }

    private void readFields(ResultSet rs, List fields) throws SQLException {
        for (int i = 1; i < 42; ++i) {
            if (i == 1) {
                rs.getInt(i);
                continue;
            }
            if (i > 1 && i < 22) {
                rs.getString(i);
                continue;
            }
            if (i <= 21 || i >= 42) continue;
            rs.getInt(i);
        }
    }

    private int getResultSetSize(int queryType) {
        switch (queryType) {
            case 0: {
                return 1;
            }
        }
        String s = "Query type not supported yet: " + queryType;
        throw new UnsupportedOperationException("");
    }

    private Region getRegion(String regionName) {
        Region region;
        try {
            Class<?> c = Class.forName("com.pivotal.gemfirexd.internal.engine.Misc");
            Method getRegionMethod = c.getMethod("getRegion", String.class);
            Object[] regionNameArray = new Object[]{regionName};
            region = (Region)getRegionMethod.invoke(null, regionNameArray);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Could not access Misc class");
        }
        catch (NoSuchMethodException nsme) {
            throw new TestException("Could not find Misc method");
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw new TestException("Could not invoke Misc method");
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Could not access Misc method");
        }
        return region;
    }

    public Object directGet(Object key, Region region) {
        return this.directGetOnLargeObjectId(key, region);
    }

    public Object directGetOnLargeObjectId(Object key, Region region) {
        Object entry = region.get(key);
        return entry;
    }

    public void directPut(Object key, Region region, Object value) {
        this.directPutOnLargeObjectId(key, region, value);
    }

    public void directPutOnLargeObjectId(Object key, Region region, Object value) {
        Object entry = region.put(key, value);
    }

    public Region getRegionForQuery(int queryType) {
        Region region;
        try {
            Class<?> c = Class.forName("com.pivotal.gemfirexd.internal.engine.Misc");
            Method getRegionMethod = c.getMethod("getRegion", String.class);
            Object[] regionNameArray = new Object[]{"APP." + LargeObject.getTableName().toUpperCase()};
            region = (Region)getRegionMethod.invoke(null, regionNameArray);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Could not access Misc class");
        }
        catch (NoSuchMethodException nsme) {
            throw new TestException("Could not find Misc method");
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw new TestException("Could not invoke Misc method");
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Could not access Misc method");
        }
        return region;
    }
}

