/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.HydraConfigException;
import java.util.ArrayList;
import java.util.List;
import objects.query.sector.GFXDPositionQueryFactory;
import objects.query.sector.Instrument;
import objects.query.sector.SQLInstrumentQueryFactory;
import objects.query.sector.SectorPrms;

public class GFXDInstrumentQueryFactory
extends SQLInstrumentQueryFactory {
    public GFXDInstrumentQueryFactory() {
        this.positionQueryFactory = new GFXDPositionQueryFactory();
    }

    @Override
    public void init() {
        super.init();
        this.positionQueryFactory.init();
    }

    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String error = "";
        int dataPolicy = SectorPrms.getInstrumentDataPolicy();
        if (dataPolicy == 0) {
            stmts.add("create table " + Instrument.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getSectorIdCreateStatement() + ")" + " REPLICATE SERVER GROUPS (sg1)");
        } else if (dataPolicy == 1) {
            boolean offheap;
            int buckets;
            String stmt = "create table " + Instrument.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getSectorIdCreateStatement() + ")";
            int partitionType = SectorPrms.getInstrumentPartitionType();
            switch (partitionType) {
                case 3: {
                    break;
                }
                case 1: {
                    stmt = stmt + " PARTITION BY COLUMN (" + SectorPrms.getInstrumentPartitionColumn() + ")";
                    break;
                }
                case 0: {
                    stmt = stmt + " PARTITION BY PRIMARY KEY";
                    break;
                }
                case 2: {
                    error = "Partition by range is currently unavailable for Instruments table";
                    throw new HydraConfigException(error);
                }
                default: {
                    error = "Invalid partitioning scheme";
                    throw new HydraConfigException(error);
                }
            }
            int redundancy = SectorPrms.getInstrumentPartitionRedundancy();
            if (redundancy != 0) {
                stmt = stmt + " REDUNDANCY " + redundancy;
            }
            if ((buckets = SectorPrms.getInstrumentPartitionTotalNumBuckets()) != 0) {
                stmt = stmt + " BUCKETS " + buckets;
            }
            if (offheap = SectorPrms.getInstrumentOffHeap()) {
                stmt = stmt + " OFFHEAP";
            }
            stmts.add(stmt);
        } else {
            stmts.add("create table " + Instrument.getTableName() + " (id varchar(20) not null, sector_id int)");
        }
        stmts.addAll(this.positionQueryFactory.getTableStatements());
        return stmts;
    }
}

