/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.HydraConfigException;
import java.util.ArrayList;
import java.util.List;
import objects.query.sector.GFXDRiskQueryFactory;
import objects.query.sector.Position;
import objects.query.sector.SQLPositionQueryFactory;
import objects.query.sector.SectorPrms;

public class GFXDPositionQueryFactory
extends SQLPositionQueryFactory {
    public GFXDPositionQueryFactory() {
        this.riskQueryFactory = new GFXDRiskQueryFactory();
    }

    @Override
    public void init() {
        super.init();
        this.riskQueryFactory.init();
    }

    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        int dataPolicy = SectorPrms.getPositionDataPolicy();
        if (dataPolicy == 0) {
            stmts.add("create table " + Position.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getBookIdCreateStatement() + ", " + this.getInstrumentIdCreateStatement() + ", " + this.getAmountCreateStatement() + ", " + this.getSyntheticCreateStatement() + ", " + this.getOwnerCreateStatement() + ", " + this.getSymbolCreateStatement() + " REPLICATE SERVER GROUPS (sg1)");
        } else if (dataPolicy == 1) {
            boolean offheap;
            int buckets;
            String stmt = "create table " + Position.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getBookIdCreateStatement() + ", " + this.getInstrumentIdCreateStatement() + ", " + this.getAmountCreateStatement() + ", " + this.getSyntheticCreateStatement() + ", " + this.getOwnerCreateStatement() + ", " + this.getSymbolCreateStatement() + ")";
            int partitionType = SectorPrms.getPositionPartitionType();
            switch (partitionType) {
                case 3: {
                    break;
                }
                case 1: {
                    stmt = stmt + " PARTITION BY COLUMN (" + SectorPrms.getPositionPartitionColumn() + ")";
                    break;
                }
                case 0: {
                    stmt = stmt + " PARTITION BY PRIMARY KEY";
                    break;
                }
                case 2: {
                    stmt = stmt + " PARTITION BY RANGE (" + SectorPrms.getPositionPartitionColumn() + ") (";
                    stmt = stmt + this.getRangeValuesStmt(SectorPrms.getPositionPartitionColumn());
                    stmt = stmt + ")";
                    break;
                }
                default: {
                    String s = "Invalid partitioning scheme";
                    throw new HydraConfigException(s);
                }
            }
            String colocate = SectorPrms.getPositionColocationStatement();
            stmt = stmt + colocate;
            int redundancy = SectorPrms.getPositionPartitionRedundancy();
            if (redundancy != 0) {
                stmt = stmt + " REDUNDANCY " + redundancy;
            }
            if ((buckets = SectorPrms.getPositionPartitionTotalNumBuckets()) != 0) {
                stmt = stmt + " BUCKETS " + buckets;
            }
            if (offheap = SectorPrms.getPositionOffHeap()) {
                stmt = stmt + " OFFHEAP";
            }
            stmts.add(stmt);
        } else {
            stmts.add("create table " + Position.getTableName() + " (id int not null, book_id int, instrument varchar(20), " + "amount int, synthetic int, owner varchar(20), " + "symbol varchar(5))");
        }
        stmts.addAll(this.riskQueryFactory.getTableStatements());
        return stmts;
    }
}

