/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.HydraConfigException;
import java.util.ArrayList;
import java.util.List;
import objects.query.sector.Risk;
import objects.query.sector.SQLRiskQueryFactory;
import objects.query.sector.SectorPrms;

public class GFXDRiskQueryFactory
extends SQLRiskQueryFactory {
    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        int dataPolicy = SectorPrms.getPositionDataPolicy();
        if (dataPolicy == 0) {
            stmts.add("create table " + Risk.getTableName() + " (" + this.getIdCreateStatement() + " , " + this.getPositionIdCreateStatement() + ", " + this.getRiskValueCreateStatement() + ")" + " REPLICATE SERVER GROUPS (sg1)");
        } else if (dataPolicy == 1) {
            int redundancy;
            boolean offheap;
            String stmt = "create table " + Risk.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getPositionIdCreateStatement() + ", " + this.getRiskValueCreateStatement() + ") ";
            int partitionType = SectorPrms.getRiskPartitionType();
            switch (partitionType) {
                case 3: {
                    break;
                }
                case 1: {
                    stmt = stmt + " PARTITION BY COLUMN (" + SectorPrms.getRiskPartitionColumn() + ")";
                    break;
                }
                case 0: {
                    stmt = stmt + " PARTITION BY PRIMARY KEY";
                    break;
                }
                case 2: {
                    stmt = stmt + " PARTITION BY RANGE (" + SectorPrms.getRiskPartitionColumn() + ") (VALUES BETWEEN 0 AND 9, VALUES BETWEEN 10 AND 19) ";
                    break;
                }
                default: {
                    String s = "Invalid partitioning scheme";
                    throw new HydraConfigException(s);
                }
            }
            int buckets = SectorPrms.getRiskPartitionTotalNumBuckets();
            if (buckets != 0) {
                stmt = stmt + " BUCKETS " + buckets;
            }
            if (offheap = SectorPrms.getRiskOffHeap()) {
                stmt = stmt + " OFFHEAP";
            }
            if ((redundancy = SectorPrms.getRiskPartitionRedundancy()) != 0) {
                stmt = stmt + " REDUNDANCY " + redundancy;
            }
            stmts.add(stmt);
        } else {
            stmts.add("create table " + Risk.getTableName() + " (id int not null, position_id int, risk_value int)");
        }
        return stmts;
    }
}

