/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.HydraConfigException;
import java.util.ArrayList;
import java.util.List;
import objects.query.sector.GFXDInstrumentQueryFactory;
import objects.query.sector.SQLSectorQueryFactory;
import objects.query.sector.Sector;
import objects.query.sector.SectorPrms;

public class GFXDSectorQueryFactory
extends SQLSectorQueryFactory {
    public GFXDSectorQueryFactory() {
        this.instrumentQueryFactory = new GFXDInstrumentQueryFactory();
    }

    @Override
    public void init() {
        super.init();
        this.instrumentQueryFactory.init();
    }

    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        int dataPolicy = SectorPrms.getSectorDataPolicy();
        if (dataPolicy == 0) {
            stmts.add("create table " + Sector.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getNameCreateStatement() + ", " + this.getMarketCapCreateStatement() + ") REPLICATE");
        } else if (dataPolicy == 1) {
            int redundancy;
            boolean offheap;
            int partitionType = SectorPrms.getSectorPartitionType();
            String stmt = "create table " + Sector.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getNameCreateStatement() + ", " + this.getMarketCapCreateStatement() + ")";
            switch (partitionType) {
                case 3: {
                    break;
                }
                case 1: {
                    stmt = stmt + " PARTITION BY COLUMN (" + SectorPrms.getSectorPartitionColumn() + ")";
                    break;
                }
                case 0: {
                    stmt = stmt + " PARTITION BY PRIMARY KEY";
                    break;
                }
                case 2: {
                    throw new UnsupportedOperationException("Partition by range is currently not supported for table Sector");
                }
                default: {
                    String s = "Invalid partitioning scheme";
                    throw new HydraConfigException(s);
                }
            }
            int buckets = SectorPrms.getSectorPartitionTotalNumBuckets();
            if (buckets != 0) {
                stmt = stmt + " BUCKETS " + buckets;
            }
            if (offheap = SectorPrms.getSectorOffHeap()) {
                stmt = stmt + " OFFHEAP";
            }
            if ((redundancy = SectorPrms.getSectorPartitionRedundancy()) != 0) {
                stmt = stmt + " REDUNDANCY " + redundancy;
            }
            stmts.add(stmt);
        } else {
            stmts.add("create table " + Sector.getTableName() + " (id int not null, name varchar(20), market_cap double)");
        }
        stmts.addAll(this.instrumentQueryFactory.getTableStatements());
        return stmts;
    }

    @Override
    public String getCreateSchemaStatement() {
        String stmt = "create schema perfTest ";
        return stmt;
    }

    @Override
    public String getDropSchemaStatement() {
        String stmt = "drop schema perfTest restrict";
        return stmt;
    }
}

