/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.util.Sizeof;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import objects.query.sector.SectorPrms;

public class Instrument
implements DataSerializable {
    private String id;
    private int sectorId;
    private Map positions;
    public static String REGION_TABLE_NAME = "INSTRUMENTS";
    public static String REGION_TABLE_SHORT_NAME = "i";

    public void init(int i) {
        String typeName;
        int numInstrumentsPerSector = SectorPrms.getNumInstrumentsPerSector();
        this.id = typeName = Instrument.getInstrument(i);
        this.sectorId = i / numInstrumentsPerSector;
    }

    public static String getTableName() {
        return REGION_TABLE_NAME;
    }

    public static String getTableAndShortName() {
        return REGION_TABLE_NAME + " " + REGION_TABLE_SHORT_NAME;
    }

    public static String getTableShortName() {
        return REGION_TABLE_SHORT_NAME;
    }

    public static String getInstrument(int id) {
        return "Instrument" + id % SectorPrms.getNumInstruments();
    }

    public static String commaSeparatedStringFor(Vector fields) {
        StringBuffer sb = new StringBuffer();
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            String field = (String)i.next();
            if (field.equals("*")) {
                return field;
            }
            sb.append(REGION_TABLE_SHORT_NAME + "." + field);
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static List getFields(List fieldList) {
        ArrayList<String> fields = new ArrayList<String>();
        if (fieldList.contains("*")) {
            fields.add("id");
            fields.add("sector_id");
        } else if (!fieldList.contains("none")) {
            fields.addAll(fieldList);
        }
        return fields;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getSectorId() {
        return this.sectorId;
    }

    public void setSectorId(int sectorId) {
        this.sectorId = sectorId;
    }

    public Map getPositions() {
        return this.positions;
    }

    public void setPositions(Map positions) {
        this.positions = positions;
    }

    public String toString() {
        return "Instrument #" + this.id;
    }

    public int sizeof(Object o) {
        if (o instanceof Instrument) {
            Instrument obj = (Instrument)o;
            return Sizeof.sizeof((String)obj.id) + Sizeof.sizeof((int)obj.sectorId);
        }
        return Sizeof.sizeof((Object)o);
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.id, (DataOutput)out);
        out.writeInt(this.sectorId);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = DataSerializer.readString((DataInput)in);
        this.sectorId = in.readInt();
    }
}

