/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.HydraConfigException;
import java.util.ArrayList;
import java.util.List;
import objects.query.sector.Instrument;
import objects.query.sector.MySQLCPositionQueryFactory;
import objects.query.sector.MySQLInstrumentQueryFactory;
import objects.query.sector.SectorPrms;

public class MySQLCInstrumentQueryFactory
extends MySQLInstrumentQueryFactory {
    public MySQLCInstrumentQueryFactory() {
        this.positionQueryFactory = new MySQLCPositionQueryFactory();
    }

    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String error = "";
        int dataPolicy = SectorPrms.getInstrumentDataPolicy();
        if (dataPolicy == 0) {
            stmts.add("create table " + Instrument.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getSectorIdCreateStatement() + ")" + " REPLICATE SERVER GROUPS (sg1)");
        } else if (dataPolicy == 1) {
            String stmt = "create table " + Instrument.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getSectorIdCreateStatement() + ")";
            int partitionType = SectorPrms.getInstrumentPartitionType();
            switch (partitionType) {
                case 0: {
                    stmt = stmt + " ENGINE=NDBCLUSTER";
                    break;
                }
                default: {
                    error = "Invalid partitioning scheme";
                    throw new HydraConfigException(error);
                }
            }
            int buckets = SectorPrms.getInstrumentPartitionTotalNumBuckets();
            if (buckets != 0) {
                stmt = stmt + " PARTITIONS " + buckets;
            }
            stmts.add(stmt);
        } else {
            stmts.add("create table " + Instrument.getTableName() + " (id varchar(20) not null, sector_id int)");
        }
        stmts.addAll(this.positionQueryFactory.getTableStatements());
        return stmts;
    }
}

