/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.HydraConfigException;
import java.util.ArrayList;
import java.util.List;
import objects.query.sector.MySQLCRiskQueryFactory;
import objects.query.sector.MySQLPositionQueryFactory;
import objects.query.sector.Position;
import objects.query.sector.SectorPrms;

public class MySQLCPositionQueryFactory
extends MySQLPositionQueryFactory {
    public MySQLCPositionQueryFactory() {
        this.riskQueryFactory = new MySQLCRiskQueryFactory();
    }

    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        int dataPolicy = SectorPrms.getPositionDataPolicy();
        if (dataPolicy == 0) {
            stmts.add("create table " + Position.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getBookIdCreateStatement() + ", " + this.getInstrumentIdCreateStatement() + ", " + this.getAmountCreateStatement() + ", " + this.getSyntheticCreateStatement() + ", " + this.getOwnerCreateStatement() + ", " + this.getSymbolCreateStatement() + " REPLICATE SERVER GROUPS (sg1)");
        } else if (dataPolicy == 1) {
            String stmt = "create table " + Position.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getBookIdCreateStatement() + ", " + this.getInstrumentIdCreateStatement() + ", " + this.getAmountCreateStatement() + ", " + this.getSyntheticCreateStatement() + ", " + this.getOwnerCreateStatement() + ", " + this.getSymbolCreateStatement() + ")";
            int partitionType = SectorPrms.getPositionPartitionType();
            switch (partitionType) {
                case 3: {
                    break;
                }
                case 1: {
                    stmt = stmt + " ENGINE=NDBCLUSTER";
                    break;
                }
                case 0: {
                    stmt = stmt + " ENGINE=NDBCLUSTER";
                    break;
                }
                case 2: {
                    stmt = stmt + " PARTITION BY RANGE (" + SectorPrms.getPositionPartitionColumn() + ") (";
                    stmt = stmt + this.getRangeValuesStmt(SectorPrms.getPositionPartitionColumn());
                    stmt = stmt + ")";
                    break;
                }
                default: {
                    String s = "Invalid partitioning scheme";
                    throw new HydraConfigException(s);
                }
            }
            int buckets = SectorPrms.getPositionPartitionTotalNumBuckets();
            if (buckets != 0) {
                stmt = stmt + " PARTITIONS " + buckets;
            }
            stmts.add(stmt);
        } else {
            stmts.add("create table " + Position.getTableName() + " (id int not null, book_id int, instrument varchar(20), " + "amount int, synthetic int, owner varchar(20), " + "symbol varchar(5))");
        }
        stmts.addAll(this.riskQueryFactory.getTableStatements());
        return stmts;
    }
}

