/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.HydraConfigException;
import java.util.ArrayList;
import java.util.List;
import objects.query.sector.MySQLRiskQueryFactory;
import objects.query.sector.Risk;
import objects.query.sector.SectorPrms;

public class MySQLCRiskQueryFactory
extends MySQLRiskQueryFactory {
    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String error = "";
        int dataPolicy = SectorPrms.getPositionDataPolicy();
        if (dataPolicy == 0) {
            stmts.add("create table " + Risk.getTableName() + " (" + this.getIdCreateStatement() + " , " + this.getPositionIdCreateStatement() + ", " + this.getRiskValueCreateStatement() + ")" + " REPLICATE SERVER GROUPS (sg1)");
        } else if (dataPolicy == 1) {
            String stmt = "create table " + Risk.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getPositionIdCreateStatement() + ", " + this.getRiskValueCreateStatement() + ") ";
            int partitionType = SectorPrms.getRiskPartitionType();
            switch (partitionType) {
                case 0: {
                    stmt = stmt + " ENGINE=NDBCLUSTER";
                    break;
                }
                default: {
                    error = "Invalid partitioning scheme";
                    throw new HydraConfigException(error);
                }
            }
            int buckets = SectorPrms.getRiskPartitionTotalNumBuckets();
            if (buckets != 0) {
                stmt = stmt + " PARTITIONS " + buckets;
            }
            stmts.add(stmt);
        } else {
            stmts.add("create table " + Risk.getTableName() + " (id int not null, position_id int, risk_value int)");
        }
        return stmts;
    }
}

