/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.HydraConfigException;
import java.util.ArrayList;
import java.util.List;
import objects.query.sector.MySQLCInstrumentQueryFactory;
import objects.query.sector.MySQLSectorQueryFactory;
import objects.query.sector.Sector;
import objects.query.sector.SectorPrms;

public class MySQLCSectorQueryFactory
extends MySQLSectorQueryFactory {
    public MySQLCSectorQueryFactory() {
        this.instrumentQueryFactory = new MySQLCInstrumentQueryFactory();
    }

    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String error = "";
        int dataPolicy = SectorPrms.getSectorDataPolicy();
        if (dataPolicy == 0) {
            stmts.add("create table " + Sector.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getNameCreateStatement() + ", " + this.getMarketCapCreateStatement() + ") REPLICATE");
        } else if (dataPolicy == 1) {
            int partitionType = SectorPrms.getSectorPartitionType();
            String stmt = "create table " + Sector.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getNameCreateStatement() + ", " + this.getMarketCapCreateStatement() + ")";
            switch (partitionType) {
                case 0: {
                    stmt = stmt + " ENGINE=NDBCLUSTER";
                    break;
                }
                default: {
                    error = "Invalid partitioning scheme";
                    throw new HydraConfigException(error);
                }
            }
            int buckets = SectorPrms.getSectorPartitionTotalNumBuckets();
            if (buckets != 0) {
                stmt = stmt + " PARTITIONS " + buckets;
            }
            stmts.add(stmt);
        } else {
            stmts.add("create table " + Sector.getTableName() + " (id int not null, name varchar(20), market_cap double)");
        }
        stmts.addAll(this.instrumentQueryFactory.getTableStatements());
        return stmts;
    }

    @Override
    public String getCreateSchemaStatement() {
        String stmt = "create schema perfTest ";
        return stmt;
    }

    @Override
    public String getDropSchemaStatement() {
        String stmt = "drop schema perfTest";
        return stmt;
    }
}

