/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.util.Sizeof;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import objects.query.sector.Instrument;
import objects.query.sector.SectorPrms;

public class Position
implements DataSerializable {
    private int id;
    private int bookId;
    private String instrument;
    private int amount;
    private int synthetic;
    private String owner;
    private String symbol;
    private String str1;
    private Map risks;
    public static String REGION_TABLE_NAME = "POSITIONS";
    public static String REGION_TABLE_SHORT_NAME = "p";

    public void init(int i) {
        int id;
        int numPositionsPerInstrument = SectorPrms.getNumPositionsPerInstrument();
        int numBookValues = SectorPrms.getNumBookValues();
        this.id = id = i;
        this.bookId = id % numBookValues;
        this.instrument = Instrument.getInstrument(id / numPositionsPerInstrument);
        this.amount = id;
        this.synthetic = id % 2;
        this.owner = Position.getOwner(id);
        this.symbol = Position.getSymbol(id);
    }

    public static String getTableName() {
        return REGION_TABLE_NAME;
    }

    public static String getTableAndShortName() {
        return REGION_TABLE_NAME + " " + REGION_TABLE_SHORT_NAME;
    }

    public static String getTableShortName() {
        return REGION_TABLE_SHORT_NAME;
    }

    public static String getOwner(int id) {
        return "Owner" + id % SectorPrms.getNumPositionsPerInstrument();
    }

    public static String getSymbol(int id) {
        return "SYM" + id % SectorPrms.getNumSymbolValues();
    }

    public static String commaSeparatedStringFor(Vector fields) {
        StringBuffer sb = new StringBuffer();
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            String field = (String)i.next();
            if (field.equals("*")) {
                return field;
            }
            sb.append(REGION_TABLE_SHORT_NAME + "." + field);
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static List getFields(List fieldList) {
        ArrayList<String> fields = new ArrayList<String>();
        if (fieldList.contains("*")) {
            fields.add("id");
            fields.add("book_id");
            fields.add("instrument");
            fields.add("amount");
            fields.add("synthetic");
            fields.add("owner");
            fields.add("symbol");
        } else if (!fieldList.contains("none")) {
            fields.addAll(fieldList);
        }
        return fields;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getBookId() {
        return this.bookId;
    }

    public void setBookId(int bookId) {
        this.bookId = bookId;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(int synthetic) {
        this.synthetic = synthetic;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Map getRisks() {
        return this.risks;
    }

    public void setRisks(Map risks) {
        this.risks = risks;
    }

    public String toString() {
        return "Position #" + this.id;
    }

    public int sizeof(Object o) {
        if (o instanceof Position) {
            Position obj = (Position)o;
            return Sizeof.sizeof((int)obj.id) + Sizeof.sizeof((int)obj.bookId) + Sizeof.sizeof((String)obj.instrument) + Sizeof.sizeof((int)obj.amount);
        }
        return Sizeof.sizeof((Object)o);
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(this.bookId);
        DataSerializer.writeString((String)this.instrument, (DataOutput)out);
        out.writeInt(this.amount);
        out.writeInt(this.synthetic);
        DataSerializer.writeString((String)this.owner, (DataOutput)out);
        DataSerializer.writeString((String)this.symbol, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.bookId = in.readInt();
        this.instrument = DataSerializer.readString((DataInput)in);
        this.amount = in.readInt();
        this.synthetic = in.readInt();
        this.owner = DataSerializer.readString((DataInput)in);
        this.symbol = DataSerializer.readString((DataInput)in);
    }
}

