/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import objects.query.BaseQueryFactory;
import objects.query.sector.Instrument;
import objects.query.sector.SQLPositionQueryFactory;
import objects.query.sector.SectorPrms;

public class SQLInstrumentQueryFactory
extends BaseQueryFactory {
    protected SQLPositionQueryFactory positionQueryFactory = new SQLPositionQueryFactory();

    public void init() {
        super.init();
        this.positionQueryFactory.init();
    }

    public List getInsertStatements(int bid) {
        int numInstrumentsPerSector = SectorPrms.getNumInstrumentsPerSector();
        ArrayList<String> stmts = new ArrayList<String>();
        for (int i = 0; i < numInstrumentsPerSector; ++i) {
            int id = bid * numInstrumentsPerSector + i;
            String typeName = Instrument.getInstrument(id);
            String stmt = "insert into " + Instrument.getTableName() + " (id, sector_id)" + " values ('" + typeName + "'," + bid + ")";
            stmts.add(stmt);
            stmts.addAll(this.positionQueryFactory.getInsertStatements(id));
        }
        return stmts;
    }

    public List getPreparedInsertStatements() {
        ArrayList<Object> stmts = new ArrayList<Object>();
        String stmt = "insert into " + Instrument.getTableName() + " values(?,?)";
        stmts.add(stmt);
        stmts.add(this.positionQueryFactory.getPreparedInsertStatements());
        return stmts;
    }

    public int fillAndExecutePreparedInsertStatements(List pstmts, List stmts, int sid) throws SQLException {
        int numInstrumentsPerSector = SectorPrms.getNumInstrumentsPerSector();
        PreparedStatement pstmt = (PreparedStatement)pstmts.get(0);
        String stmt = (String)stmts.get(0);
        int results = 0;
        for (int i = 0; i < numInstrumentsPerSector; ++i) {
            int id = sid * numInstrumentsPerSector + i;
            String typeName = Instrument.getInstrument(id);
            pstmt.setString(1, typeName);
            pstmt.setInt(2, sid);
            if (this.logQueries) {
                Log.getLogWriter().info("EXECUTING: " + stmt + " with id=" + typeName + " sector_id=" + sid);
            }
            results += this.positionQueryFactory.fillAndExecutePreparedInsertStatements((List)pstmts.get(1), (List)stmts.get(1), id);
            pstmt.addBatch();
            ++results;
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
        Connection c = pstmt.getConnection();
        if (c.getTransactionIsolation() != 0 && SectorPrms.commitBatches()) {
            c.commit();
        }
        return results;
    }

    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "create table " + Instrument.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getSectorIdCreateStatement() + ")";
        stmts.add(stmt);
        stmts.addAll(this.positionQueryFactory.getTableStatements());
        return stmts;
    }

    protected String getIdCreateStatement() {
        String stmt = "id varchar(20) not null";
        Vector indexes = SectorPrms.getInstrumentCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 2) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 27) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getSectorIdCreateStatement() {
        String stmt = "sector_id int";
        Vector indexes = SectorPrms.getInstrumentCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 0) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 28) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    public List getDropTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.addAll(this.positionQueryFactory.getDropTableStatements());
        stmts.add("drop table if exists " + Instrument.getTableName());
        return stmts;
    }
}

