/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import objects.query.BaseQueryFactory;
import objects.query.sector.Instrument;
import objects.query.sector.Position;
import objects.query.sector.SQLRiskQueryFactory;
import objects.query.sector.SectorPrms;

public class SQLPositionQueryFactory
extends BaseQueryFactory {
    protected SQLRiskQueryFactory riskQueryFactory = new SQLRiskQueryFactory();

    public void init() {
        super.init();
        this.riskQueryFactory.init();
    }

    public List getInsertStatements(int bid) {
        String instrument = Instrument.getInstrument(bid);
        int numPositionsPerInstrument = SectorPrms.getNumPositionsPerInstrument();
        int numBookValues = SectorPrms.getNumBookValues();
        int synthetic = 0;
        ArrayList<String> stmts = new ArrayList<String>();
        for (int i = 0; i < numPositionsPerInstrument; ++i) {
            int id;
            int amount = id = bid * numPositionsPerInstrument + i;
            int bookId = id % numBookValues;
            String owner = Position.getOwner(id);
            synthetic = id % 2;
            String symbol = Position.getSymbol(id);
            String stmt = "insert into " + Position.getTableName() + " (id, book_id, instrument, amount, " + "synthetic, owner, symbol) values (" + id + "," + bookId + ",'" + instrument + "'," + amount + "," + synthetic + ",'" + owner + "','" + symbol + "')";
            stmts.add(stmt);
            stmts.addAll(this.riskQueryFactory.getInsertStatements(id));
        }
        return stmts;
    }

    public List getPreparedInsertStatements() {
        ArrayList<Object> stmts = new ArrayList<Object>();
        stmts.add(this.getPreparedInsertStatement());
        stmts.add(this.riskQueryFactory.getPreparedInsertStatements());
        return stmts;
    }

    public String getPreparedInsertStatement() {
        String stmt = "insert into " + Position.getTableName() + " values (?,?,?,?,?,?,?)";
        return stmt;
    }

    public int fillAndExecutePreparedInsertStatements(List pstmts, List stmts, int iid) throws SQLException {
        String instrument = Instrument.getInstrument(iid);
        int numPositionsPerInstrument = SectorPrms.getNumPositionsPerInstrument();
        int numBookValues = SectorPrms.getNumBookValues();
        PreparedStatement pstmt = (PreparedStatement)pstmts.get(0);
        String stmt = (String)stmts.get(0);
        int synthetic = 0;
        int results = 0;
        for (int i = 0; i < numPositionsPerInstrument; ++i) {
            int id;
            int amount = id = iid * numPositionsPerInstrument + i;
            int bookId = id % numBookValues;
            String owner = Position.getOwner(id);
            synthetic = 1 - synthetic;
            String symbol = Position.getSymbol(id);
            pstmt.setInt(1, id);
            pstmt.setInt(2, bookId);
            pstmt.setString(3, instrument);
            pstmt.setInt(4, amount);
            pstmt.setInt(5, synthetic);
            pstmt.setString(6, owner);
            pstmt.setString(7, symbol);
            if (this.logQueries) {
                Log.getLogWriter().info("EXECUTING: " + stmt + " with id=" + id + " book_id=" + bookId + " instrument=" + instrument + " amount=" + amount + " synthetic=" + synthetic + " owner=" + owner + " symbol=" + symbol);
            }
            results += this.riskQueryFactory.fillAndExecutePreparedInsertStatements((List)pstmts.get(1), (List)stmts.get(1), id);
            pstmt.addBatch();
            ++results;
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
        List rpstmts = (List)pstmts.get(1);
        PreparedStatement rpstmt = (PreparedStatement)rpstmts.get(rpstmts.size() - 1);
        rpstmt.executeBatch();
        rpstmt.clearBatch();
        Connection c = pstmt.getConnection();
        if (c.getTransactionIsolation() != 0 && SectorPrms.commitBatches()) {
            c.commit();
        }
        return results;
    }

    public void fillPreparedInsertStatement(PreparedStatement pstmt, String stmt, int iid) throws SQLException {
        int id;
        String instrument = Instrument.getInstrument(iid);
        int numPositionsPerInstrument = SectorPrms.getNumPositionsPerInstrument();
        int numBookValues = SectorPrms.getNumBookValues();
        int synthetic = 0;
        int amount = id = iid;
        int bookId = id % numBookValues;
        String owner = Position.getOwner(id);
        synthetic = 1 - synthetic;
        String symbol = Position.getSymbol(id);
        pstmt.setInt(1, id);
        pstmt.setInt(2, bookId);
        pstmt.setString(3, instrument);
        pstmt.setInt(4, amount);
        pstmt.setInt(5, synthetic);
        pstmt.setString(6, owner);
        pstmt.setString(7, symbol);
    }

    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "create table " + Position.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getBookIdCreateStatement() + ", " + this.getInstrumentIdCreateStatement() + ", " + this.getAmountCreateStatement() + ", " + this.getSyntheticCreateStatement() + ", " + this.getOwnerCreateStatement() + ", " + this.getSymbolCreateStatement() + ")";
        stmts.add(stmt);
        stmts.addAll(this.riskQueryFactory.getTableStatements());
        return stmts;
    }

    protected String getRangeValuesStmt(String columnName) {
        String stmt = "";
        if (columnName.equalsIgnoreCase("id")) {
            int numNodes = SectorPrms.getNumServers();
            int numPositions = SectorPrms.getNumPositions();
            int range = numPositions / numNodes;
            int remainder = numPositions - numNodes * range;
            int lower = 0;
            for (int i = 0; i < numNodes; ++i) {
                if (i != 0) {
                    stmt = stmt + ",";
                }
                int upper = lower + range;
                if (i < remainder) {
                    ++upper;
                }
                stmt = stmt + " VALUES BETWEEN " + lower + " AND " + upper;
                lower = upper;
            }
        } else {
            String s = "Partition by range on column " + columnName;
            throw new UnsupportedOperationException(s);
        }
        return stmt;
    }

    protected static int getLowerIdForNode(int node, int range, int remainder) {
        int lower = 0;
        int upper = 0;
        for (int i = 0; i < node; ++i) {
            upper = lower + range;
            if (i < remainder) {
                // empty if block
            }
            lower = ++upper;
        }
        return lower;
    }

    protected String getIdCreateStatement() {
        String stmt = "id int not null";
        Vector indexes = SectorPrms.getPositionCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 3) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 4) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getBookIdCreateStatement() {
        String stmt = "book_id int";
        Vector indexes = SectorPrms.getPositionCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 5) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 6) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getInstrumentIdCreateStatement() {
        String stmt = "instrument varchar(20) not null";
        Vector indexes = SectorPrms.getPositionCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 2) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 27) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getAmountCreateStatement() {
        String stmt = "amount int";
        Vector indexes = SectorPrms.getPositionCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 11) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 12) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getSyntheticCreateStatement() {
        String stmt = "synthetic int";
        Vector indexes = SectorPrms.getPositionCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 7) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 8) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getOwnerCreateStatement() {
        String stmt = "owner varchar(20)";
        Vector indexes = SectorPrms.getPositionCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 13) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 14) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getSymbolCreateStatement() {
        String stmt = " symbol varchar(5)";
        Vector indexes = SectorPrms.getPositionCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 9) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 10) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    public List getDropTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.addAll(this.riskQueryFactory.getDropTableStatements());
        stmts.add("drop table if exists " + Position.getTableName());
        return stmts;
    }
}

