/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.Log;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import objects.query.BaseQueryFactory;
import objects.query.sector.Risk;
import objects.query.sector.SectorPrms;

public class SQLRiskQueryFactory
extends BaseQueryFactory {
    public List getInsertStatements(int bid) {
        int positionId = bid;
        int numRiskValues = SectorPrms.getNumRiskValues();
        int riskValue = bid % numRiskValues;
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "insert into " + Risk.getTableName() + " (id, position_id, risk_value)" + " values (" + positionId + "," + positionId + "," + riskValue + ")";
        stmts.add(stmt);
        return stmts;
    }

    public List getPreparedInsertStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "insert into " + Risk.getTableName() + " values (?,?,?)";
        stmts.add(stmt);
        return stmts;
    }

    public int fillAndExecutePreparedInsertStatements(List pstmts, List stmts, int posId) throws SQLException {
        int positionId = posId;
        int numRiskValues = SectorPrms.getNumRiskValues();
        int riskValue = posId % numRiskValues;
        PreparedStatement pstmt = (PreparedStatement)pstmts.get(pstmts.size() - 1);
        String stmt = (String)stmts.get(stmts.size() - 1);
        pstmt.setInt(1, positionId);
        pstmt.setInt(2, positionId);
        pstmt.setInt(3, riskValue);
        pstmt.addBatch();
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with id=" + positionId + " position_id=" + positionId + " risk_value=" + riskValue);
        }
        return 1;
    }

    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "create table " + Risk.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getPositionIdCreateStatement() + ", " + this.getRiskValueCreateStatement() + ") ";
        stmts.add(stmt);
        return stmts;
    }

    protected String getIdCreateStatement() {
        String stmt = "id int not null";
        Vector indexes = SectorPrms.getRiskCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 15) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 16) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getPositionIdCreateStatement() {
        String stmt = "position_id int not null";
        Vector indexes = SectorPrms.getRiskCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 3) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 4) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getRiskValueCreateStatement() {
        String stmt = "risk_value int";
        Vector indexes = SectorPrms.getRiskCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 3) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 4) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    public List getDropTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add("drop table if exists " + Risk.getTableName());
        return stmts;
    }
}

