/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import com.gemstone.gemfire.cache.Region;
import hydra.BasePrms;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.RemoteTestModule;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import objects.query.BaseSQLQueryFactory;
import objects.query.QueryFactoryException;
import objects.query.QueryObjectException;
import objects.query.SQLQueryFactory;
import objects.query.sector.Instrument;
import objects.query.sector.Position;
import objects.query.sector.SQLInstrumentQueryFactory;
import objects.query.sector.SQLPositionQueryFactory;
import objects.query.sector.Sector;
import objects.query.sector.SectorPrms;
import util.TestException;

public class SQLSectorQueryFactory
extends BaseSQLQueryFactory
implements SQLQueryFactory {
    protected final GsRandom rng = new GsRandom((long)RemoteTestModule.getCurrentThread().getThreadId());
    protected SQLInstrumentQueryFactory instrumentQueryFactory;
    protected static final int numSectors = SectorPrms.getNumSectors();
    protected static final int numInstrumentsPerSector = SectorPrms.getNumInstrumentsPerSector();
    protected static final int numPositionsPerInstrument = SectorPrms.getNumPositionsPerInstrument();
    protected static final int numInstruments = numSectors * numInstrumentsPerSector;
    protected static final int numPositions = numInstruments * numPositionsPerInstrument;
    protected static final int numBookValues = SectorPrms.getNumBookValues();
    protected static final int numSymbolValues = SectorPrms.getNumSymbolValues();
    protected static final int numMarketCapValues = SectorPrms.getNumMarketCapValues();
    protected static final int numAmountsPerRangeClause = SectorPrms.getNumAmountsPerRangeClause();
    protected static final int numInstrumentsPerInClause = SectorPrms.getNumInstrumentsPerInClause();
    protected static final int numMarketCapValuesPerOrClause = SectorPrms.getNumMarketCapValuesPerOrClause();
    protected static final int numOwnersPerOrClause = SectorPrms.getNumOwnersPerOrClause();
    protected static final int numPositionsPerInClause = SectorPrms.getNumPositionsPerInClause();
    protected static final int numSectorsPerInClause = SectorPrms.getNumSectorsPerInClause();
    protected static final int numSymbolsPerInClause = SectorPrms.getNumSymbolsPerInClause();
    protected int[] sectors = new int[numSectors];
    protected int[] instruments = new int[numInstrumentsPerSector];
    protected int[] positions = new int[numPositionsPerInstrument];
    protected int[] symbolValues = new int[numSymbolValues];
    protected int[] ownerValues = new int[numPositionsPerInstrument];
    protected int[] random;
    protected SQLPositionQueryFactory positionQueryFactory;

    public SQLSectorQueryFactory() {
        this.instrumentQueryFactory = new SQLInstrumentQueryFactory();
        this.positionQueryFactory = new SQLPositionQueryFactory();
    }

    public void init() {
        int i;
        super.init();
        this.instrumentQueryFactory.init();
        this.positionQueryFactory.init();
        for (i = 0; i < numSectors; ++i) {
            this.sectors[i] = i;
        }
        for (i = 0; i < numInstrumentsPerSector; ++i) {
            this.instruments[i] = i;
        }
        for (i = 0; i < numPositionsPerInstrument; ++i) {
            this.positions[i] = i;
        }
        for (i = 0; i < numSymbolValues; ++i) {
            this.symbolValues[i] = i;
        }
        for (i = 0; i < numPositionsPerInstrument; ++i) {
            this.ownerValues[i] = i;
        }
        int max = Math.max(0, numAmountsPerRangeClause);
        max = Math.max(max, numInstrumentsPerInClause);
        max = Math.max(max, numMarketCapValuesPerOrClause);
        max = Math.max(max, numOwnersPerOrClause);
        max = Math.max(max, numPositionsPerInClause);
        max = Math.max(max, numSectorsPerInClause);
        max = Math.max(max, numSymbolsPerInClause);
        this.random = new int[max];
    }

    public List getConstraintStatements() {
        return new ArrayList();
    }

    public int getQueryType() {
        return SectorPrms.getQueryType(1);
    }

    public int getUpdateQueryType() {
        return SectorPrms.getUpdateQueryType(1);
    }

    public int getDeleteQueryType() {
        return SectorPrms.getDeleteQueryType(1);
    }

    public String getQuery(int queryType, int i) {
        String query = "";
        int type = queryType;
        switch (type) {
            case 0: {
                query = this.getRandomPositionPKQuery();
                break;
            }
            case 1: {
                query = this.getSectorFilterInQuery(i);
                break;
            }
            case 2: {
                query = this.getSectorFilterInAndMarketCapQuery(i);
                break;
            }
            case 3: {
                query = this.getPositionPruneByInstrumentQuery(i);
                break;
            }
            case 15: {
                query = this.getPositionAmountRangeAndQuery(i);
                break;
            }
            case 16: {
                query = this.getPositionAmountRangeOrQuery(i);
                break;
            }
            case 4: {
                query = this.getPositionPruneByInstrumentAndPositionAmountQuery(i);
                break;
            }
            case 5: {
                query = this.getPositionPruneByInstrumentAndFilterSymbolAndOwnerQuery(i);
                break;
            }
            case 6: {
                query = this.getJoinPruneByPositionAmountAndInstrumentNameQuery(i);
                break;
            }
            case 7: {
                query = this.getJoinPruneByPositionAmountAndInstrumentNameAndSectorNameQuery(i);
                break;
            }
            case 8: {
                query = this.getInstrumentInQuery(i);
                break;
            }
            case 9: {
                query = this.getJoinInstrumentAndPositionInQuery(i);
                break;
            }
            case 10: {
                query = this.getPositionFilterInQuery(i);
                break;
            }
            case 11: {
                query = this.getUpdatePositionByPositionIdQuery(i);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    public String getPreparedQuery(int queryType) {
        String query = "";
        int type = queryType;
        switch (type) {
            case 0: {
                query = this.getPreparedStatementForRandomPositionPKQuery();
                break;
            }
            case 1: {
                query = this.getPreparedStatementForSectorFilterInQuery();
                break;
            }
            case 2: {
                query = this.getPreparedStatementForSectorFilterInAndMarketCapQuery();
                break;
            }
            case 3: {
                query = this.getPreparedStatementForPositionPruneByInstrumentQuery();
                break;
            }
            case 15: {
                query = this.getPreparedStatementForPositionAmountRangeAndQuery();
                break;
            }
            case 16: {
                query = this.getPreparedStatementForPositionAmountRangeOrQuery();
                break;
            }
            case 4: {
                query = this.getPreparedStatementForPositionPruneByInstrumentAndPositionAmountQuery();
                break;
            }
            case 5: {
                query = this.getPreparedStatementForPositionPruneByInstrumentAndFilterSymbolAndOwnerQuery();
                break;
            }
            case 6: {
                query = this.getPreparedStatementForJoinPruneByPositionAmountAndInstrumentNameQuery();
                break;
            }
            case 7: {
                query = this.getPreparedStatementForJoinPruneByPositionAmountAndInstrumentNameAndSectorNameQuery();
                break;
            }
            case 8: {
                query = this.getPreparedStatementForInstrumentInQuery();
                break;
            }
            case 9: {
                query = this.getPreparedStatementForJoinInstrumentAndPositionInQuery();
                break;
            }
            case 14: {
                query = this.getPreparedStatementForJoinInstrumentAndPositionOrQuery();
                break;
            }
            case 10: {
                query = this.getPreparedStatementForPositionFilterInQuery();
                break;
            }
            case 11: {
                query = this.getPreparedStatementForUpdatePositionByPositionIdQuery();
                break;
            }
            case 12: {
                query = this.getPreparedInsertStatementForPosition();
                break;
            }
            case 13: {
                query = this.getPreparedStatementForJoinToSingleNodeQuery();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    public String getPrimaryKeyIndexOnSectorId() {
        return "alter table " + Sector.getTableName() + " add primary key(id)";
    }

    public String getPrimaryKeyIndexOnInstrumentId() {
        return "alter table " + Instrument.getTableName() + " add primary key(id)";
    }

    public String getPrimaryKeyIndexOnPositionId() {
        return "alter table " + Position.getTableName() + " add primary key(id)";
    }

    public List getIndexStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        Vector indexTypes = SectorPrms.getIndexTypes();
        for (String indexTypeString : indexTypes) {
            int indexType = SectorPrms.getIndexType(indexTypeString);
            String stmt = this.getIndexStatement(indexType);
            if (stmt == null) continue;
            stmts.add(stmt);
        }
        return stmts;
    }

    public String getIndexStatement(int type) {
        String query;
        switch (type) {
            case 0: {
                query = this.getPrimaryKeyIndexOnSectorId();
                break;
            }
            case 1: {
                query = this.getUniqueIndexOnSectorName();
                break;
            }
            case 2: {
                query = this.getPrimaryKeyIndexOnInstrumentId();
                break;
            }
            case 3: {
                query = this.getPrimaryKeyIndexOnPositionId();
                break;
            }
            case 17: {
                query = this.getIndexOnSectorId();
                break;
            }
            case 18: {
                query = this.getIndexOnInstrumentId();
                break;
            }
            case 19: {
                query = this.getIndexOnPositionId();
                break;
            }
            case 20: {
                query = this.getIndexOnPositionSynthetic();
                break;
            }
            case 21: {
                query = this.getIndexOnPositionInstrument();
                break;
            }
            case 22: {
                query = this.getIndexOnPositionSymbol();
                break;
            }
            case 23: {
                query = this.getIndexOnPositionOwner();
                break;
            }
            case 24: {
                query = this.getIndexOnPositionAmount();
                break;
            }
            case 25: {
                query = this.getIndexOnSectorName();
                break;
            }
            case 26: {
                query = this.getIndexOnSectorMarketCap();
                break;
            }
            case -1: {
                query = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    public String getUniqueIndexOnSectorName() {
        return "create unique index name_uidx on " + Sector.getTableName() + " (name)";
    }

    public String getIndexOnSectorId() {
        return "create index sector_id_idx on " + Sector.getTableName() + " (id)";
    }

    public String getIndexOnInstrumentId() {
        return "create index instrument_id_idx on " + Instrument.getTableName() + " (id)";
    }

    public String getIndexOnPositionId() {
        return "create index position_id_idx on " + Position.getTableName() + " (id)";
    }

    public String getIndexOnPositionSynthetic() {
        return "create index position_synthetic_idx on " + Position.getTableName() + " (synthetic)";
    }

    public String getIndexOnPositionInstrument() {
        return "create index position_instrument_idx on " + Position.getTableName() + " (instrument)";
    }

    public String getIndexOnPositionSymbol() {
        return "create index position_symbol_idx on " + Position.getTableName() + " (symbol)";
    }

    public String getIndexOnPositionOwner() {
        return "create index position_owner_idx on " + Position.getTableName() + " (owner)";
    }

    public String getIndexOnPositionAmount() {
        return "create index position_amount_idx on " + Position.getTableName() + " (amount)";
    }

    public String getIndexOnSectorName() {
        return "create index sector_name_idx on " + Sector.getTableName() + " (name)";
    }

    public String getIndexOnSectorMarketCap() {
        return "create index sector_market_cap_idx on " + Sector.getTableName() + " (market_cap)";
    }

    public List getInsertStatements(int bid) {
        ArrayList<String> stmts = new ArrayList<String>();
        double marketCap = bid % numMarketCapValues;
        if (bid >= numSectors) {
            String s = "Attempt to get insert statement with sid=" + bid + " when " + BasePrms.nameForKey((Long)SectorPrms.numSectors) + "=" + numSectors;
            throw new QueryObjectException(s);
        }
        String sname = Sector.getSectorName(bid);
        String stmt = "insert into " + Sector.getTableName() + " (id, name, market_cap) values (" + bid + ",'" + sname + "'," + marketCap + ")";
        stmts.add(stmt);
        stmts.addAll(this.instrumentQueryFactory.getInsertStatements(bid));
        return stmts;
    }

    public List getPreparedInsertStatements() {
        ArrayList<Object> stmts = new ArrayList<Object>();
        String stmt = "insert into " + Sector.getTableName() + " values (?,?,?)";
        stmts.add(stmt);
        stmts.add(this.instrumentQueryFactory.getPreparedInsertStatements());
        return stmts;
    }

    public int fillAndExecutePreparedInsertStatements(List pstmts, List stmts, int i) throws SQLException {
        double marketCap = i % numMarketCapValues;
        PreparedStatement pstmt = (PreparedStatement)pstmts.get(0);
        String stmt = (String)stmts.get(0);
        int results = 0;
        if (i >= numSectors) {
            String s = "Attempt to get insert statement with sid=" + i + " when " + BasePrms.nameForKey((Long)SectorPrms.numSectors) + "=" + numSectors;
            throw new QueryObjectException(s);
        }
        String sectorName = Sector.getSectorName(i);
        pstmt.setInt(1, i);
        pstmt.setString(2, sectorName);
        pstmt.setDouble(3, marketCap);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with id=" + i + " name=" + sectorName + " market_cap=" + marketCap);
        }
        results += pstmt.executeUpdate();
        return results += this.instrumentQueryFactory.fillAndExecutePreparedInsertStatements((List)pstmts.get(1), (List)stmts.get(1), i);
    }

    private String getPreparedInsertStatementForPosition() {
        return this.positionQueryFactory.getPreparedInsertStatement();
    }

    private int fillAndExecutePreparedInsertStatementForPosition(PreparedStatement pstmt, String stmt, int i) throws SQLException {
        double marketCap = i % numMarketCapValues;
        this.positionQueryFactory.fillPreparedInsertStatement(pstmt, stmt, i);
        return this.executeUpdatePreparedStatement(pstmt);
    }

    public String getCreateSchemaStatement() {
        String stmt = "create schema perfTest";
        return stmt;
    }

    public String getDropSchemaStatement() {
        String stmt = "drop schema perfTest restrict";
        return stmt;
    }

    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "create table " + Sector.getTableName() + " (" + this.getIdCreateStatement() + ", " + this.getNameCreateStatement() + ", " + this.getMarketCapCreateStatement() + ")";
        stmts.add(stmt);
        stmts.addAll(this.instrumentQueryFactory.getTableStatements());
        return stmts;
    }

    public List getDropTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.addAll(this.instrumentQueryFactory.getDropTableStatements());
        stmts.add("drop table if exists " + Sector.getTableName());
        return stmts;
    }

    protected String getIdCreateStatement() {
        String stmt = "id int not null";
        Vector indexes = SectorPrms.getSectorCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 0) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 28) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getNameCreateStatement() {
        String stmt = "name varchar(20)";
        Vector indexes = SectorPrms.getSectorCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 29) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 1) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    protected String getMarketCapCreateStatement() {
        String stmt = "market_cap double";
        Vector indexes = SectorPrms.getSectorCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = SectorPrms.getIndexType((String)iterator.next());
            if (indexType == 30) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 31) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    public String getRandomPositionPKQuery() {
        String fields = SectorPrms.getPositionFields();
        int id = this.rng.nextInt(0, numPositions - 1);
        return "select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".id=" + id;
    }

    public String getSectorFilterInQuery(int sid) {
        String fields = SectorPrms.getSectorFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Sector.getTableAndShortName() + " where " + Sector.getTableShortName() + ".name in ('");
        this.pickRandomSectors(numSectorsPerInClause);
        for (int i = 0; i < numSectorsPerInClause; ++i) {
            if (i != 0) {
                sb.append("','");
            }
            sb.append(Sector.getSectorName(this.random[i]));
        }
        sb.append("')");
        return sb.toString();
    }

    public String getPositionFilterInQuery(int sid) {
        String fields = SectorPrms.getPositionFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".id in ('");
        if (SectorPrms.getPositionPartitionType() == 2 && SectorPrms.getPositionPartitionColumn().equalsIgnoreCase("id")) {
            int numNodes = SectorPrms.getNumServers();
            int node = this.rng.nextInt(0, numNodes - 1);
            int range = numPositions / numNodes;
            int remainder = numPositions - numNodes * range;
            int lower = SQLPositionQueryFactory.getLowerIdForNode(node, range, remainder);
            for (int i = 1; i <= numPositionsPerInClause; ++i) {
                if (i != 1) {
                    sb.append("','");
                }
                int val = (lower + i - 1) % numPositions;
                sb.append(val);
            }
        } else {
            this.pickRandomPositions(numPositionsPerInClause);
            for (int i = 0; i < numPositionsPerInClause; ++i) {
                if (i != 0) {
                    sb.append("','");
                }
                sb.append(this.random[i]);
            }
        }
        sb.append("')");
        return sb.toString();
    }

    public String getSectorFilterInAndMarketCapQuery(int sid) {
        int i;
        String fields = SectorPrms.getSectorFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Sector.getTableAndShortName() + " where " + Sector.getTableShortName() + ".name in ('");
        int secid = this.rng.nextInt(0, numSectors - numSectorsPerInClause - 1);
        int mcv = secid % numMarketCapValues;
        for (i = 0; i < numSectorsPerInClause; ++i) {
            if (i != 0) {
                sb.append("','");
            }
            sb.append(Sector.getSectorName(secid % numSectors));
            ++secid;
        }
        sb.append("') and (");
        for (i = numSectorsPerInClause; i < numSectorsPerInClause + numMarketCapValuesPerOrClause; ++i) {
            if (i != numSectorsPerInClause) {
                sb.append(" or ");
            }
            int mval = mcv % numMarketCapValues;
            sb.append(Sector.getTableShortName() + ".market_cap=" + mval);
            ++mcv;
        }
        sb.append(")");
        return sb.toString();
    }

    public String getPositionPruneByInstrumentQuery(int sid) {
        String fields = SectorPrms.getPositionFields();
        int iid = this.rng.nextInt(0, numInstruments - 1);
        String s = "select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".synthetic=1" + " and " + Position.getTableShortName() + ".instrument='" + Instrument.getInstrument(iid) + "'";
        return s;
    }

    public String getPositionAmountRangeAndQuery(int sid) {
        String fields = SectorPrms.getPositionFields();
        int iid = this.rng.nextInt(0, numInstruments - 1);
        int min = iid * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max = min + numAmountsPerRangeClause;
        String s = "select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".amount >= " + min + " and " + Position.getTableShortName() + ".amount < " + max;
        return s;
    }

    public String getPositionAmountRangeOrQuery(int sid) {
        String fields = SectorPrms.getPositionFields();
        int iid1 = this.rng.nextInt(0, numInstruments - 1);
        int min1 = iid1 * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max1 = min1 + numAmountsPerRangeClause;
        int iid2 = this.rng.nextInt(0, numInstruments - 1);
        int min2 = iid2 * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max2 = min2 + numAmountsPerRangeClause;
        String s = "select " + fields + " from " + Position.getTableAndShortName() + " where (" + Position.getTableShortName() + ".amount >= " + min1 + " and " + Position.getTableShortName() + ".amount < " + max1 + ") or (" + Position.getTableShortName() + ".amount >= " + min2 + " and " + Position.getTableShortName() + ".amount < " + max2 + ")";
        return s;
    }

    public String getPositionPruneByInstrumentAndPositionAmountQuery(int sid) {
        String fields = SectorPrms.getPositionFields();
        int iid = this.rng.nextInt(0, numInstruments - 1);
        int min = iid * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max = min + numAmountsPerRangeClause;
        String s = "select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".instrument='" + Instrument.getInstrument(iid) + "'" + " and " + Position.getTableShortName() + ".amount >= " + min + " and " + Position.getTableShortName() + ".amount < " + max;
        return s;
    }

    public String getPositionPruneByInstrumentAndFilterSymbolAndOwnerQuery(int sid) {
        String fields = SectorPrms.getPositionFields();
        int instrumentId = this.rng.nextInt(0, numInstruments - 1);
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".instrument='" + Instrument.getInstrument(instrumentId) + "'" + " and " + Position.getTableShortName() + ".symbol in ('");
        int iid = this.rng.nextInt(0, numInstruments - 1);
        String instrument = Instrument.getInstrument(iid);
        String symbols = this.logQueries ? "" : null;
        this.pickRandomSymbolValues(numSymbolsPerInClause);
        for (int i = 2; i < 2 + numSymbolsPerInClause; ++i) {
            if (i != 2) {
                sb.append("','");
            }
            int secid = this.random[i - 2];
            sb.append(Position.getSymbol(secid));
        }
        sb.append("')");
        sb.append(" and (");
        String owners = this.logQueries ? "" : null;
        this.pickRandomOwnerValues(numOwnersPerOrClause);
        for (int i = 2 + numSymbolsPerInClause; i < 2 + numSymbolsPerInClause + numOwnersPerOrClause; ++i) {
            if (i != 2 + numSymbolsPerInClause) {
                sb.append(" or ");
            }
            int oid = this.random[i - (2 + numSymbolsPerInClause)];
            sb.append(Position.getTableShortName() + ".owner='" + Position.getOwner(oid) + "'");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getJoinPruneByPositionAmountAndInstrumentNameQuery(int sid) {
        String fields = this.getPositionAndInstrumentFields();
        int iid = this.rng.nextInt(0, numInstruments - 1);
        int min = iid * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max = min + numAmountsPerRangeClause;
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Position.getTableAndShortName() + "," + Instrument.getTableAndShortName() + " where " + Instrument.getTableShortName() + ".id = " + Position.getTableShortName() + ".instrument" + " and " + Position.getTableShortName() + ".amount >= " + min + " and " + Position.getTableShortName() + ".amount < " + max + " and " + Instrument.getTableShortName() + ".id='" + Instrument.getInstrument(iid) + "'");
        return sb.toString();
    }

    public String getJoinPruneByPositionAmountAndInstrumentNameAndSectorNameQuery(int sid) {
        int iid = sid * numInstrumentsPerSector + this.rng.nextInt(0, numInstrumentsPerSector - 1);
        int min = iid * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max = min + numAmountsPerRangeClause;
        String fields = SectorPrms.getPositionFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Position.getTableAndShortName() + "," + Instrument.getTableAndShortName() + "," + Sector.getTableAndShortName() + " where " + Instrument.getTableShortName() + ".id = " + Position.getTableShortName() + ".instrument" + " and " + Instrument.getTableShortName() + ".sector_id = " + Sector.getTableShortName() + ".id" + " and " + Position.getTableShortName() + ".amount >= " + min + " and " + Position.getTableShortName() + ".amount < " + max + " and " + Instrument.getTableShortName() + ".id='" + Instrument.getInstrument(iid) + "'" + " and " + Sector.getTableShortName() + ".name='" + Sector.getSectorName(sid) + "'");
        return sb.toString();
    }

    public String getInstrumentInQuery(int sid) {
        String fields = SectorPrms.getInstrumentFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Instrument.getTableAndShortName() + " where id in (");
        this.pickRandomInstruments(numInstrumentsPerInClause);
        for (int i = 0; i < numInstrumentsPerInClause; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("'" + Instrument.getInstrument(this.random[i]) + "'");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getJoinInstrumentAndPositionInQuery(int sid) {
        String fields = this.getPositionAndInstrumentFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Instrument.getTableAndShortName() + "," + Position.getTableAndShortName() + " where " + Instrument.getTableShortName() + ".id = " + Position.getTableShortName() + ".instrument" + " and " + Instrument.getTableShortName() + ".id in (");
        this.pickRandomInstruments(numInstrumentsPerInClause);
        for (int i = 0; i < numInstrumentsPerInClause; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("'" + Instrument.getInstrument(this.random[i]) + "'");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getUpdatePositionByPositionIdQuery(int sid) {
        int id = this.rng.nextInt(0, numPositions - 1);
        StringBuffer sb = new StringBuffer("update " + Position.getTableAndShortName() + " set " + Position.getTableShortName() + ".symbol=" + Position.getSymbol(this.rng.nextInt(numSymbolValues)) + ", " + Position.getTableShortName() + ".book_id=" + this.rng.nextInt(numBookValues) + " where " + Position.getTableShortName() + ".id=" + id);
        return sb.toString();
    }

    public int fillAndExecuteUpdatePreparedQueryStatement(PreparedStatement pstmt, String stmt, int queryType, int i) throws SQLException {
        int numUpdated = 0;
        switch (queryType) {
            case 11: {
                numUpdated = this.fillAndExecutePreparedStatementForUpdatePositionByPositionIdQuery(pstmt, stmt, i);
                break;
            }
            case 12: {
                numUpdated = this.fillAndExecutePreparedInsertStatementForPosition(pstmt, stmt, i);
                break;
            }
            default: {
                throw new HydraConfigException("Unsupported query type for updates, should not happen");
            }
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed Prepared Statement: ");
        }
        return numUpdated;
    }

    public ResultSet fillAndExecutePreparedQueryStatement(PreparedStatement pstmt, String stmt, int queryType, int i) throws SQLException {
        ResultSet rs = null;
        switch (queryType) {
            case 0: {
                rs = this.fillAndExecutePreparedStatementForRandomPositionPKQuery(pstmt, stmt, i);
                break;
            }
            case 1: {
                rs = this.fillAndExecutePreparedStatementForSectorFilterInQuery(pstmt, stmt, i);
                break;
            }
            case 2: {
                rs = this.fillAndExecutePreparedStatementForSectorFilterInAndMarketCapQuery(pstmt, stmt, i);
                break;
            }
            case 3: {
                rs = this.fillAndExecutePreparedStatementForPositionPruneByInstrumentQuery(pstmt, stmt, i);
                break;
            }
            case 15: {
                rs = this.fillAndExecutePreparedStatementForPositionAmountRangeAndQuery(pstmt, stmt, i);
                break;
            }
            case 16: {
                rs = this.fillAndExecutePreparedStatementForPositionAmountRangeOrQuery(pstmt, stmt, i);
                break;
            }
            case 4: {
                rs = this.fillAndExecutePreparedStatementForPositionPruneByInstrumentAndPositionAmountQuery(pstmt, stmt, i);
                break;
            }
            case 5: {
                rs = this.fillAndExecutePreparedStatementForPositionPruneByInstrumentAndFilterSymbolAndOwnerQuery(pstmt, stmt, i);
                break;
            }
            case 6: {
                rs = this.fillAndExecutePreparedStatementForJoinPruneByPositionAmountAndInstrumentNameQuery(pstmt, stmt, i);
                break;
            }
            case 7: {
                rs = this.fillAndExecutePreparedStatementForJoinPruneByPositionAmountAndInstrumentNameAndSectorNameQuery(pstmt, stmt, i);
                break;
            }
            case 8: {
                rs = this.fillAndExecutePreparedStatementForInstrumentInQuery(pstmt, stmt, i);
                break;
            }
            case 9: {
                rs = this.fillAndExecutePreparedStatementForJoinInstrumentAndPositionInQuery(pstmt, stmt, i);
                break;
            }
            case 14: {
                rs = this.fillAndExecutePreparedStatementForJoinInstrumentAndPositionOrQuery(pstmt, stmt, i);
                break;
            }
            case 10: {
                rs = this.fillAndExecutePreparedStatementForPositionFilterInQuery(pstmt, stmt, i);
                break;
            }
            case 13: {
                rs = this.fillAndExecutePreparedStatementForJoinToSingleNodeQuery(pstmt, stmt, i);
                break;
            }
            default: {
                throw new HydraConfigException("Unsupported, should not happen");
            }
        }
        return rs;
    }

    public String getPreparedStatementForRandomPositionPKQuery() {
        String fields = SectorPrms.getPositionFields();
        return "select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".id=?";
    }

    public ResultSet fillAndExecutePreparedStatementForRandomPositionPKQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        int id = this.rng.nextInt(0, numPositions - 1);
        pstmt.setInt(1, id);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with p.id=" + id);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForPositionFilterInQuery() {
        String fields = SectorPrms.getPositionFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".id in (");
        for (int i = 0; i < numPositionsPerInClause; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    public ResultSet fillAndExecutePreparedStatementForPositionFilterInQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        String vals;
        String string = vals = this.logQueries ? "" : null;
        if (numPositions < numPositionsPerInClause) {
            String s = "numPositionsPerInClause=" + numPositionsPerInClause + " must be <= numPositions=" + numPositions;
            throw new HydraConfigException(s);
        }
        if (SectorPrms.getPositionPartitionType() == 2 && SectorPrms.getPositionPartitionColumn().equalsIgnoreCase("id")) {
            int numNodes = SectorPrms.getNumServers();
            int node = this.rng.nextInt(0, numNodes - 1);
            int range = numPositions / numNodes;
            int remainder = numPositions - numNodes * range;
            int lower = SQLPositionQueryFactory.getLowerIdForNode(node, range, remainder);
            for (int i = 1; i <= numPositionsPerInClause; ++i) {
                int val = (lower + i - 1) % numPositions;
                pstmt.setInt(i, val);
                if (!this.logQueries) continue;
                vals = vals + " " + val;
            }
        } else {
            this.pickRandomPositions(numPositionsPerInClause);
            for (int i = 1; i <= numPositionsPerInClause; ++i) {
                int val = this.random[i - 1];
                pstmt.setInt(i, val);
                if (!this.logQueries) continue;
                vals = vals + " " + val;
            }
        }
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with p.id in" + vals);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForSectorFilterInQuery() {
        String fields = SectorPrms.getSectorFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Sector.getTableAndShortName() + " where " + Sector.getTableShortName() + ".name in (");
        for (int i = 0; i < numSectorsPerInClause; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    public ResultSet fillAndExecutePreparedStatementForSectorFilterInQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        String vals = this.logQueries ? "" : null;
        String val = null;
        this.pickRandomSectors(numSectorsPerInClause);
        for (int i = 1; i <= numSectorsPerInClause; ++i) {
            val = Sector.getSectorName(this.random[i - 1]);
            pstmt.setString(i, val);
            if (!this.logQueries) continue;
            vals = vals + " " + val;
        }
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with s.id in" + vals);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForSectorFilterInAndMarketCapQuery() {
        int i;
        String fields = SectorPrms.getSectorFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Sector.getTableAndShortName() + " where " + Sector.getTableShortName() + ".name in (");
        for (i = 0; i < numSectorsPerInClause; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(") and (");
        for (i = 0; i < numMarketCapValuesPerOrClause; ++i) {
            if (i != 0) {
                sb.append(" or ");
            }
            sb.append(Sector.getTableShortName() + ".market_cap=?");
        }
        sb.append(")");
        return sb.toString();
    }

    public ResultSet fillAndExecutePreparedStatementForSectorFilterInAndMarketCapQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        int i;
        if (numSectorsPerInClause > numSectors) {
            String s = "numSectorsPerInClause=" + numSectorsPerInClause + " must be <= numSectors=" + numSectors;
            throw new HydraConfigException(s);
        }
        if (numMarketCapValuesPerOrClause > numMarketCapValues) {
            String s = "numMarketCapValuesPerOrClause=" + numMarketCapValuesPerOrClause + " must be <= numMarketCapValues=" + numMarketCapValues;
            throw new HydraConfigException(s);
        }
        String nvals = this.logQueries ? "" : null;
        String mvals = this.logQueries ? "" : null;
        int sid = this.rng.nextInt(0, numSectors - numSectorsPerInClause - 1);
        int mcv = sid % numMarketCapValues;
        for (i = 1; i <= numSectorsPerInClause; ++i) {
            String nval = Sector.getSectorName(sid % numSectors);
            pstmt.setString(i, nval);
            if (this.logQueries) {
                nvals = nvals + nval + " ";
            }
            ++sid;
        }
        for (i = numSectorsPerInClause + 1; i <= numSectorsPerInClause + numMarketCapValuesPerOrClause; ++i) {
            int mval = mcv % numMarketCapValues;
            pstmt.setInt(i, mval);
            if (this.logQueries) {
                mvals = mvals + mval + " or ";
            }
            ++mcv;
        }
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with s.name in " + nvals + " and s.market_cap = one of (or) " + mvals);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForPositionPruneByInstrumentQuery() {
        String fields = SectorPrms.getPositionFields();
        String s = "select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".synthetic=1" + " and " + Position.getTableShortName() + ".instrument=?";
        return s;
    }

    public ResultSet fillAndExecutePreparedStatementForPositionPruneByInstrumentQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        if (this.validateResults && numPositionsPerInstrument % 2 != 0) {
            String s = "numPositionsPerInstrument needs to be an even number to validate results";
            throw new HydraConfigException(s);
        }
        int iid = this.rng.nextInt(0, numInstruments - 1);
        String instrument = Instrument.getInstrument(iid);
        pstmt.setString(1, instrument);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with p.instrument=" + instrument);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForPositionAmountRangeAndQuery() {
        String fields = SectorPrms.getPositionFields();
        String s = "select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".amount >= ?" + " and " + Position.getTableShortName() + ".amount < ?";
        return s;
    }

    public ResultSet fillAndExecutePreparedStatementForPositionAmountRangeAndQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        if (numPositionsPerInstrument < numAmountsPerRangeClause) {
            String s = "numPositionsPerInstrument " + numPositionsPerInstrument + " must be >= numAmountsPerRangeClause=" + numAmountsPerRangeClause;
            throw new HydraConfigException(s);
        }
        int iid = this.rng.nextInt(0, numInstruments - 1);
        int min = iid * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max = min + numAmountsPerRangeClause;
        pstmt.setInt(1, min);
        pstmt.setInt(2, max);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with p.amount >= " + min + " p.amount < " + max);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForPositionAmountRangeOrQuery() {
        String fields = SectorPrms.getPositionFields();
        String s = "select " + fields + " from " + Position.getTableAndShortName() + " where (" + Position.getTableShortName() + ".amount >= ? and " + Position.getTableShortName() + ".amount < ?) or (" + Position.getTableShortName() + ".amount >= ? and " + Position.getTableShortName() + ".amount < ?)";
        return s;
    }

    public ResultSet fillAndExecutePreparedStatementForPositionAmountRangeOrQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        if (numInstruments < 2) {
            String s = "numInstruments " + numInstruments + " must be >= 2";
            throw new HydraConfigException(s);
        }
        if (numPositionsPerInstrument < numAmountsPerRangeClause) {
            String s = "numPositionsPerInstrument " + numPositionsPerInstrument + " must be >= numAmountsPerRangeClause=" + numAmountsPerRangeClause;
            throw new HydraConfigException(s);
        }
        int iid1 = this.rng.nextInt(0, numInstruments / 2 - 1);
        int min1 = iid1 * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max1 = min1 + numAmountsPerRangeClause;
        int iid2 = this.rng.nextInt(numInstruments / 2, numInstruments - 1);
        int min2 = iid2 * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max2 = min2 + numAmountsPerRangeClause;
        pstmt.setInt(1, min1);
        pstmt.setInt(2, max1);
        pstmt.setInt(3, min2);
        pstmt.setInt(4, max2);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with (p.amount >= " + min1 + " p.amount < " + max1 + ") or (p.amount >= " + min2 + " p.amount < " + max2 + ")");
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForPositionPruneByInstrumentAndPositionAmountQuery() {
        String fields = SectorPrms.getPositionFields();
        String s = "select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".instrument=?" + " and " + Position.getTableShortName() + ".amount >= ?" + " and " + Position.getTableShortName() + ".amount < ?";
        return s;
    }

    public ResultSet fillAndExecutePreparedStatementForPositionPruneByInstrumentAndPositionAmountQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        if (numPositionsPerInstrument < numAmountsPerRangeClause) {
            String s = "numPositionsPerInstrument " + numPositionsPerInstrument + " must be >= numAmountsPerRangeClause=" + numAmountsPerRangeClause;
            throw new HydraConfigException(s);
        }
        int iid = this.rng.nextInt(0, numInstruments - 1);
        String instrument = Instrument.getInstrument(iid);
        int min = iid * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max = min + numAmountsPerRangeClause;
        pstmt.setString(1, instrument);
        pstmt.setInt(2, min);
        pstmt.setInt(3, max);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with p.instrument=" + instrument + " p.amount >= " + min + " p.amount < " + max);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForPositionPruneByInstrumentAndFilterSymbolAndOwnerQuery() {
        int i;
        String fields = SectorPrms.getPositionFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Position.getTableAndShortName() + " where " + Position.getTableShortName() + ".instrument=?" + " and " + Position.getTableShortName() + ".symbol in (");
        for (i = 0; i < numSymbolsPerInClause; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(") and (");
        for (i = 0; i < numOwnersPerOrClause; ++i) {
            if (i != 0) {
                sb.append(" or ");
            }
            sb.append(Position.getTableShortName() + ".owner=?");
        }
        sb.append(")");
        return sb.toString();
    }

    public ResultSet fillAndExecutePreparedStatementForPositionPruneByInstrumentAndFilterSymbolAndOwnerQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        int iid = this.rng.nextInt(0, numInstruments - 1);
        String instrument = Instrument.getInstrument(iid);
        pstmt.setString(1, instrument);
        String symbols = this.logQueries ? "" : null;
        this.pickRandomSymbolValues(numSymbolsPerInClause);
        for (int i = 2; i < 2 + numSymbolsPerInClause; ++i) {
            int secid = this.random[i - 2];
            String symbol = Position.getSymbol(secid);
            pstmt.setString(i, symbol);
            if (!this.logQueries) continue;
            symbols = symbols + symbol + " ";
        }
        String owners = this.logQueries ? "" : null;
        this.pickRandomOwnerValues(numOwnersPerOrClause);
        for (int i = 2 + numSymbolsPerInClause; i < 2 + numSymbolsPerInClause + numOwnersPerOrClause; ++i) {
            int oid = this.random[i - (2 + numSymbolsPerInClause)];
            String owner = Position.getOwner(oid);
            pstmt.setString(i, owner);
            if (!this.logQueries) continue;
            owners = owners + owner + " ";
        }
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with p.instrument=" + instrument + " p.symbol in " + symbols + " p.owner = one of (or) " + owners);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForJoinPruneByPositionAmountAndInstrumentNameQuery() {
        String fields = this.getPositionAndInstrumentFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Position.getTableAndShortName() + "," + Instrument.getTableAndShortName() + " where " + Instrument.getTableShortName() + ".id = " + Position.getTableShortName() + ".instrument" + " and " + Position.getTableShortName() + ".amount >= ?" + " and " + Position.getTableShortName() + ".amount < ?" + " and " + Instrument.getTableShortName() + ".id=?");
        return sb.toString();
    }

    public ResultSet fillAndExecutePreparedStatementForJoinPruneByPositionAmountAndInstrumentNameQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        if (numPositionsPerInstrument < numAmountsPerRangeClause) {
            String s = "numPositionsPerInstrument " + numPositionsPerInstrument + " must be >= numAmountsPerRangeClause=" + numAmountsPerRangeClause;
            throw new HydraConfigException(s);
        }
        int iid = this.rng.nextInt(0, numInstruments - 1);
        String instrument = Instrument.getInstrument(iid);
        int min = iid * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max = min + numAmountsPerRangeClause;
        pstmt.setInt(1, min);
        pstmt.setInt(2, max);
        pstmt.setString(3, instrument);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with p.amount >= " + min + " p.amount < " + max + " i.id=" + instrument);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForJoinPruneByPositionAmountAndInstrumentNameAndSectorNameQuery() {
        String fields = this.getPositionAndInstrumentFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Position.getTableAndShortName() + "," + Instrument.getTableAndShortName() + "," + Sector.getTableAndShortName() + " where " + Instrument.getTableShortName() + ".id = " + Position.getTableShortName() + ".instrument" + " and " + Instrument.getTableShortName() + ".sector_id = " + Sector.getTableShortName() + ".id" + " and " + Position.getTableShortName() + ".amount >= ?" + " and " + Position.getTableShortName() + ".amount < ?" + " and " + Instrument.getTableShortName() + ".id=?" + " and " + Sector.getTableShortName() + ".name=?");
        return sb.toString();
    }

    public ResultSet fillAndExecutePreparedStatementForJoinPruneByPositionAmountAndInstrumentNameAndSectorNameQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        if (numPositionsPerInstrument < numAmountsPerRangeClause) {
            String s = "numPositionsPerInstrument " + numPositionsPerInstrument + " must be >= numAmountsPerRangeClause=" + numAmountsPerRangeClause;
            throw new HydraConfigException(s);
        }
        String sector = Sector.getSectorName(sid);
        int iid = sid * numInstrumentsPerSector + this.rng.nextInt(0, numInstrumentsPerSector - 1);
        String instrument = Instrument.getInstrument(iid);
        int min = iid * numPositionsPerInstrument + this.rng.nextInt(0, numPositionsPerInstrument - numAmountsPerRangeClause);
        int max = min + numAmountsPerRangeClause;
        pstmt.setInt(1, min);
        pstmt.setInt(2, max);
        pstmt.setString(3, instrument);
        pstmt.setString(4, sector);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with p.amount >= " + min + " p.amount < " + max + " i.id=" + instrument + " s.name=" + sector);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForInstrumentInQuery() {
        String fields = SectorPrms.getInstrumentFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Instrument.getTableAndShortName() + " where " + Instrument.getTableShortName() + ".id in (");
        for (int i = 0; i < numInstrumentsPerInClause; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    public ResultSet fillAndExecutePreparedStatementForInstrumentInQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        String instruments = this.logQueries ? "" : null;
        this.pickRandomInstruments(numInstrumentsPerInClause);
        for (int i = 1; i <= numInstrumentsPerInClause; ++i) {
            String instrument = Instrument.getInstrument(this.random[i - 1]);
            pstmt.setString(i, instrument);
            if (!this.logQueries) continue;
            instruments = instruments + " " + instrument;
        }
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with i.id in" + instruments);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForJoinInstrumentAndPositionInQuery() {
        String fields = this.getPositionAndInstrumentFields();
        StringBuffer sb = new StringBuffer("select " + fields + " from " + Instrument.getTableAndShortName() + "," + Position.getTableAndShortName() + " where " + Instrument.getTableShortName() + ".id = " + Position.getTableShortName() + ".instrument" + " and " + Instrument.getTableShortName() + ".id in (");
        for (int i = 0; i < numInstrumentsPerInClause; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    public ResultSet fillAndExecutePreparedStatementForJoinInstrumentAndPositionInQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        String instruments = this.logQueries ? "" : null;
        this.pickRandomInstruments(numInstrumentsPerInClause);
        for (int i = 1; i <= numInstrumentsPerInClause; ++i) {
            String instrument = Instrument.getInstrument(this.random[i - 1]);
            pstmt.setString(i, instrument);
            if (!this.logQueries) continue;
            instruments = instruments + " " + instrument;
        }
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with i.id in" + instruments);
        }
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getPreparedStatementForJoinInstrumentAndPositionOrQuery() {
        throw new UnsupportedOperationException("TBD");
    }

    public ResultSet fillAndExecutePreparedStatementForJoinInstrumentAndPositionOrQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        throw new UnsupportedOperationException("TBD");
    }

    public String getPreparedStatementForUpdatePositionByPositionIdQuery() {
        int id = this.rng.nextInt(0, numPositions - 1);
        StringBuffer sb = new StringBuffer("update " + Position.getTableAndShortName() + " set " + Position.getTableShortName() + ".symbol=?" + ", " + Position.getTableShortName() + ".book_id=?" + " where " + Position.getTableShortName() + ".id=?");
        return sb.toString();
    }

    public int fillAndExecutePreparedStatementForUpdatePositionByPositionIdQuery(PreparedStatement pstmt, String stmt, int sid) throws SQLException {
        int id = this.rng.nextInt(0, numPositions - 1);
        String symbol = Position.getSymbol(this.rng.nextInt(numSymbolValues));
        int bookId = this.rng.nextInt(numBookValues);
        pstmt.setString(1, symbol);
        pstmt.setInt(2, bookId);
        pstmt.setInt(3, id);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING: " + stmt + " with p.symbol=" + symbol + " p.book_id=" + bookId + " p.id=" + id);
        }
        return this.executeUpdatePreparedStatement(pstmt);
    }

    public String getPreparedStatementForJoinToSingleNodeQuery() {
        throw new UnsupportedOperationException("TBD");
    }

    public ResultSet fillAndExecutePreparedStatementForJoinToSingleNodeQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        throw new UnsupportedOperationException("TBD");
    }

    private String getPositionAndInstrumentFields() {
        String fields = "";
        if (SectorPrms.getPositionFields().indexOf("NONE") != -1) {
            if (SectorPrms.getInstrumentFields().indexOf("NONE") != -1) {
                String s = BasePrms.nameForKey((Long)SectorPrms.instrumentFields) + " and " + BasePrms.nameForKey((Long)SectorPrms.positionFields) + " cannot both be NONE";
                throw new HydraConfigException(s);
            }
            fields = SectorPrms.getInstrumentFields();
        } else {
            fields = SectorPrms.getInstrumentFields().indexOf("NONE") != -1 ? SectorPrms.getPositionFields() : SectorPrms.getInstrumentFields() + "," + SectorPrms.getPositionFields();
        }
        if (fields.indexOf("*") != -1) {
            fields = "*";
        }
        return fields;
    }

    private String getSectorAndPositionFields() {
        String fields = "";
        if (SectorPrms.getSectorFields().indexOf("NONE") != -1) {
            if (SectorPrms.getPositionFields().indexOf("NONE") != -1) {
                String s = BasePrms.nameForKey((Long)SectorPrms.positionFields) + " and " + BasePrms.nameForKey((Long)SectorPrms.sectorFields) + " cannot both be NONE";
                throw new HydraConfigException(s);
            }
            fields = SectorPrms.getPositionFields();
        } else {
            fields = SectorPrms.getPositionFields().indexOf("NONE") != -1 ? SectorPrms.getSectorFields() : SectorPrms.getPositionFields() + "," + SectorPrms.getSectorFields();
        }
        if (fields.indexOf("*") != -1) {
            fields = "*";
        }
        return fields;
    }

    private String getSectorAndInstrumentFields() {
        String fields = "";
        if (SectorPrms.getSectorFields().indexOf("NONE") != -1) {
            if (SectorPrms.getInstrumentFields().indexOf("NONE") != -1) {
                String s = BasePrms.nameForKey((Long)SectorPrms.instrumentFields) + " and " + BasePrms.nameForKey((Long)SectorPrms.sectorFields) + " cannot both be NONE";
                throw new HydraConfigException(s);
            }
            fields = SectorPrms.getInstrumentFields();
        } else {
            fields = SectorPrms.getInstrumentFields().indexOf("NONE") != -1 ? SectorPrms.getSectorFields() : SectorPrms.getInstrumentFields() + "," + SectorPrms.getSectorFields();
        }
        if (fields.indexOf("*") != -1) {
            fields = "*";
        }
        return fields;
    }

    private String getPositionAndInstrumentAndSectorFields() {
        String fields = "";
        if (SectorPrms.getPositionFields().indexOf("NONE") != -1) {
            if (SectorPrms.getInstrumentFields().indexOf("NONE") != -1) {
                if (SectorPrms.getSectorFields().indexOf("NONE") != -1) {
                    String s = BasePrms.nameForKey((Long)SectorPrms.instrumentFields) + " and " + BasePrms.nameForKey((Long)SectorPrms.positionFields) + " cannot both be NONE";
                    throw new HydraConfigException(s);
                }
                fields = SectorPrms.getSectorFields();
            } else {
                fields = SectorPrms.getSectorFields().indexOf("NONE") != -1 ? SectorPrms.getInstrumentFields() : this.getSectorAndInstrumentFields();
            }
        } else {
            fields = SectorPrms.getInstrumentFields().indexOf("NONE") != -1 ? (SectorPrms.getSectorFields().indexOf("NONE") != -1 ? SectorPrms.getPositionFields() : this.getSectorAndPositionFields()) : (SectorPrms.getSectorFields().indexOf("NONE") != -1 ? this.getPositionAndInstrumentFields() : SectorPrms.getInstrumentFields() + "," + SectorPrms.getPositionFields() + "," + SectorPrms.getSectorFields());
        }
        if (fields.indexOf("*") != -1) {
            fields = "*";
        }
        return fields;
    }

    private List getPositionAndInstrumentFieldsAsList() {
        List fields = null;
        if (SectorPrms.getPositionFields().indexOf("NONE") != -1) {
            if (SectorPrms.getInstrumentFields().indexOf("NONE") != -1) {
                String s = BasePrms.nameForKey((Long)SectorPrms.instrumentFields) + " and " + BasePrms.nameForKey((Long)SectorPrms.positionFields) + " cannot both be NONE";
                throw new HydraConfigException(s);
            }
            fields = Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector());
        } else if (SectorPrms.getInstrumentFields().indexOf("NONE") != -1) {
            fields = Position.getFields(SectorPrms.getPositionFieldsAsVector());
        } else {
            fields = Position.getFields(SectorPrms.getPositionFieldsAsVector());
            fields.addAll(Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector()));
        }
        if (fields.indexOf("*") != -1) {
            fields = Position.getFields(SectorPrms.getPositionFieldsAsVector());
            fields.addAll(Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector()));
        }
        return fields;
    }

    private List getSectorAndPositionFieldsAsList() {
        List fields = null;
        if (SectorPrms.getSectorFields().indexOf("NONE") != -1) {
            if (SectorPrms.getPositionFields().indexOf("NONE") != -1) {
                String s = BasePrms.nameForKey((Long)SectorPrms.positionFields) + " and " + BasePrms.nameForKey((Long)SectorPrms.sectorFields) + " cannot both be NONE";
                throw new HydraConfigException(s);
            }
            fields = Position.getFields(SectorPrms.getPositionFieldsAsVector());
        } else if (SectorPrms.getPositionFields().indexOf("NONE") != -1) {
            fields = Sector.getFields(SectorPrms.getSectorFieldsAsVector());
        } else {
            fields = Position.getFields(SectorPrms.getPositionFieldsAsVector());
            fields.addAll(Sector.getFields(SectorPrms.getSectorFieldsAsVector()));
        }
        if (fields.indexOf("*") != -1) {
            fields = Position.getFields(SectorPrms.getPositionFieldsAsVector());
            fields.addAll(Sector.getFields(SectorPrms.getSectorFieldsAsVector()));
        }
        return fields;
    }

    private List getSectorAndInstrumentFieldsAsList() {
        List fields = null;
        if (SectorPrms.getSectorFields().indexOf("NONE") != -1) {
            if (SectorPrms.getInstrumentFields().indexOf("NONE") != -1) {
                String s = BasePrms.nameForKey((Long)SectorPrms.instrumentFields) + " and " + BasePrms.nameForKey((Long)SectorPrms.sectorFields) + " cannot both be NONE";
                throw new HydraConfigException(s);
            }
            fields = Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector());
        } else if (SectorPrms.getInstrumentFields().indexOf("NONE") != -1) {
            fields = Sector.getFields(SectorPrms.getSectorFieldsAsVector());
        } else {
            fields = Sector.getFields(SectorPrms.getSectorFieldsAsVector());
            fields.addAll(Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector()));
        }
        if (fields.indexOf("*") != -1) {
            fields = Sector.getFields(SectorPrms.getSectorFieldsAsVector());
            fields.addAll(Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector()));
        }
        return fields;
    }

    private List getPositionAndInstrumentAndSectorFieldsAsList() {
        List fields = null;
        if (SectorPrms.getPositionFields().indexOf("NONE") != -1) {
            if (SectorPrms.getInstrumentFields().indexOf("NONE") != -1) {
                if (SectorPrms.getSectorFields().indexOf("NONE") != -1) {
                    String s = BasePrms.nameForKey((Long)SectorPrms.instrumentFields) + " and " + BasePrms.nameForKey((Long)SectorPrms.positionFields) + " cannot both be NONE";
                    throw new HydraConfigException(s);
                }
                fields = Sector.getFields(SectorPrms.getSectorFieldsAsVector());
            } else if (SectorPrms.getSectorFields().indexOf("NONE") != -1) {
                fields = Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector());
            } else {
                fields = Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector());
                fields.addAll(Sector.getFields(SectorPrms.getSectorFieldsAsVector()));
            }
        } else if (SectorPrms.getInstrumentFields().indexOf("NONE") != -1) {
            fields = SectorPrms.getSectorFields().indexOf("NONE") != -1 ? Position.getFields(SectorPrms.getPositionFieldsAsVector()) : this.getSectorAndPositionFieldsAsList();
        } else if (SectorPrms.getSectorFields().indexOf("NONE") != -1) {
            fields = this.getPositionAndInstrumentFieldsAsList();
        } else {
            fields = Position.getFields(SectorPrms.getPositionFieldsAsVector());
            fields.addAll(Sector.getFields(SectorPrms.getSectorFieldsAsVector()));
            fields.addAll(Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector()));
        }
        if (fields.indexOf("*") != -1) {
            fields = Position.getFields(SectorPrms.getPositionFieldsAsVector());
            fields.addAll(Sector.getFields(SectorPrms.getSectorFieldsAsVector()));
            fields.addAll(Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector()));
        }
        return fields;
    }

    protected void pickRandomSectors(int n) {
        if (n > this.sectors.length) {
            String s = "Unable to choose " + n + " unique random sectors from " + this.sectors.length + " total sectors";
            throw new QueryFactoryException(s);
        }
        int last = this.sectors.length;
        for (int i = 0; i < n; ++i) {
            int j = this.rng.nextInt(0, last - 1);
            this.random[i] = this.sectors[j];
            this.sectors[j] = this.sectors[last - 1];
            this.sectors[last - 1] = this.random[i];
            --last;
        }
    }

    protected void pickRandomInstruments(int n) {
        if (n > this.instruments.length) {
            String s = "Unable to choose " + n + " unique random instruments from " + this.instruments.length + " instruments per sector";
            throw new QueryFactoryException(s);
        }
        int last = this.instruments.length;
        for (int i = 0; i < n; ++i) {
            int secid = this.rng.nextInt(0, numSectors - 1);
            int j = this.rng.nextInt(0, last - 1);
            this.random[i] = secid * numInstrumentsPerSector + this.instruments[j];
            this.instruments[j] = this.instruments[last - 1];
            this.instruments[last - 1] = this.random[i];
            --last;
        }
    }

    protected void pickRandomPositions(int n) {
        if (n > this.positions.length) {
            String s = "Unable to choose " + n + " unique random positions from " + this.positions.length + " positions per instrument";
            throw new QueryFactoryException(s);
        }
        int last = this.positions.length;
        for (int i = 0; i < n; ++i) {
            int secid = this.rng.nextInt(0, numSectors - 1);
            int iid = this.rng.nextInt(0, numInstrumentsPerSector - 1);
            int j = this.rng.nextInt(0, last - 1);
            int tmp = this.positions[j];
            this.positions[j] = this.positions[last - 1];
            this.positions[last - 1] = tmp;
            this.random[i] = (secid * numInstrumentsPerSector + iid) * numPositionsPerInstrument + tmp;
            --last;
        }
    }

    protected void pickRandomOwnerValues(int n) {
        if (n > this.ownerValues.length) {
            String s = "Unable to choose " + n + " unique random ownerValues from " + this.ownerValues.length + " total ownerValues";
            throw new QueryFactoryException(s);
        }
        int last = this.ownerValues.length;
        for (int i = 0; i < n; ++i) {
            int j = this.rng.nextInt(0, last - 1);
            this.random[i] = this.ownerValues[j];
            this.ownerValues[j] = this.ownerValues[last - 1];
            this.ownerValues[last - 1] = this.random[i];
            --last;
        }
    }

    protected void pickRandomSymbolValues(int n) {
        if (n > this.symbolValues.length) {
            String s = "Unable to choose " + n + " unique random symbolValues from " + this.symbolValues.length + " total symbolValues";
            throw new QueryFactoryException(s);
        }
        int last = this.symbolValues.length;
        for (int i = 0; i < n; ++i) {
            int j = this.rng.nextInt(0, last - 1);
            this.random[i] = this.symbolValues[j];
            this.symbolValues[j] = this.symbolValues[last - 1];
            this.symbolValues[last - 1] = this.random[i];
            --last;
        }
    }

    public int readResultSet(int queryType, ResultSet rs) throws SQLException {
        switch (queryType) {
            case 0: {
                return this.readResultSet(queryType, rs, Position.getFields(SectorPrms.getPositionFieldsAsVector()));
            }
            case 1: {
                return this.readResultSet(queryType, rs, Sector.getFields(SectorPrms.getSectorFieldsAsVector()));
            }
            case 2: {
                return this.readResultSet(queryType, rs, Sector.getFields(SectorPrms.getSectorFieldsAsVector()));
            }
            case 3: {
                return this.readResultSet(queryType, rs, Position.getFields(SectorPrms.getPositionFieldsAsVector()));
            }
            case 5: {
                return this.readResultSet(queryType, rs, Position.getFields(SectorPrms.getPositionFieldsAsVector()));
            }
            case 15: {
                return this.readResultSet(queryType, rs, Position.getFields(SectorPrms.getPositionFieldsAsVector()));
            }
            case 16: {
                return this.readResultSet(queryType, rs, Position.getFields(SectorPrms.getPositionFieldsAsVector()));
            }
            case 4: {
                return this.readResultSet(queryType, rs, Position.getFields(SectorPrms.getPositionFieldsAsVector()));
            }
            case 8: {
                return this.readResultSet(queryType, rs, Instrument.getFields(SectorPrms.getInstrumentFieldsAsVector()));
            }
            case 9: {
                return this.readResultSet(queryType, rs, this.getPositionAndInstrumentFieldsAsList());
            }
            case 6: {
                return this.readResultSet(queryType, rs, this.getPositionAndInstrumentFieldsAsList());
            }
            case 7: {
                return this.readResultSet(queryType, rs, this.getPositionAndInstrumentAndSectorFieldsAsList());
            }
            case 10: {
                return this.readResultSet(queryType, rs, Position.getFields(SectorPrms.getPositionFieldsAsVector()));
            }
        }
        return this.readResultSet(queryType, rs, Position.getFields(SectorPrms.getPositionFieldsAsVector()));
    }

    private int readResultSet(int queryType, ResultSet rs, List fields) throws SQLException {
        int rss;
        int rows = 0;
        while (rs.next()) {
            this.readFields(rs, fields);
            ++rows;
        }
        if (this.logQueryResultSize) {
            Log.getLogWriter().info("Returned " + rows + " rows");
        }
        if (this.validateResults && (rss = this.getResultSetSize(queryType)) != 0 && rows != rss) {
            throw new HydraConfigException("Result set size expected(" + rss + ") did not match actual(" + rows + ")");
        }
        return rows;
    }

    private int getResultSetSize(int queryType) {
        switch (queryType) {
            case 8: {
                return numInstrumentsPerInClause;
            }
            case 9: {
                return numInstrumentsPerInClause * numPositionsPerInstrument;
            }
            case 6: {
                return numAmountsPerRangeClause;
            }
            case 7: {
                return numAmountsPerRangeClause;
            }
            case 10: {
                return numPositionsPerInClause;
            }
            case 3: {
                return numPositionsPerInstrument / 2;
            }
            case 5: {
                return 0;
            }
            case 15: {
                return numAmountsPerRangeClause;
            }
            case 16: {
                return 2 * numAmountsPerRangeClause;
            }
            case 4: {
                return numAmountsPerRangeClause;
            }
            case 0: {
                return 1;
            }
            case 1: {
                return numSectorsPerInClause;
            }
            case 2: {
                if (numMarketCapValues >= numSectorsPerInClause) {
                    return Math.min(numSectorsPerInClause, numMarketCapValuesPerOrClause);
                }
                int sectorsPerMarketCapValue = numSectors / numMarketCapValues;
                int n = sectorsPerMarketCapValue * numMarketCapValuesPerOrClause;
                int r = numSectorsPerInClause - numMarketCapValues * (numSectorsPerInClause / numMarketCapValues);
                return n + r;
            }
        }
        String s = "Query type not supported yet: " + queryType;
        throw new UnsupportedOperationException("");
    }

    private void readFields(ResultSet rs, List fields) throws SQLException {
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            rs.getObject((String)iterator.next());
        }
    }

    public Object directGet(Object key, Region region) {
        return this.directGetOnPositionId(key, region);
    }

    public Object directGetOnPositionId(Object key, Region region) {
        Object entry = region.get(key);
        return entry;
    }

    public void directPut(Object key, Region region, Object value) {
        this.directPutOnPositionId(key, region, value);
    }

    public void directPutOnPositionId(Object key, Region region, Object value) {
        Object entry = region.put(key, value);
    }

    private Region getRegion(String regionName) {
        Region region;
        try {
            Class<?> c = Class.forName("com.pivotal.gemfirexd.internal.engine.Misc");
            Method getRegionMethod = c.getMethod("getRegion", String.class);
            Object[] regionNameArray = new Object[]{regionName};
            region = (Region)getRegionMethod.invoke(null, regionNameArray);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Could not access Misc class");
        }
        catch (NoSuchMethodException nsme) {
            throw new TestException("Could not find Misc method");
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw new TestException("Could not invoke Misc method");
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Could not access Misc method");
        }
        return region;
    }

    public Region getRegionForQuery(int queryType) {
        Region region;
        try {
            Class<?> c = Class.forName("com.pivotal.gemfirexd.internal.engine.Misc");
            Method getRegionMethod = c.getMethod("getRegion", String.class);
            Object[] regionNameArray = new Object[]{"APP." + Position.getTableName().toUpperCase()};
            region = (Region)getRegionMethod.invoke(null, regionNameArray);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Could not access Misc class");
        }
        catch (NoSuchMethodException nsme) {
            throw new TestException("Could not find Misc method");
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw new TestException("Could not invoke Misc method");
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Could not access Misc method");
        }
        return region;
    }
}

