/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.util.Sizeof;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import objects.query.QueryFactory;
import objects.query.QueryPrms;
import objects.query.sector.GFXDSectorQueryFactory;
import objects.query.sector.MySQLCSectorQueryFactory;
import objects.query.sector.MySQLSectorQueryFactory;
import objects.query.sector.SQLSectorQueryFactory;
import objects.query.sector.SectorPrms;

public class Sector
implements DataSerializable {
    private int id;
    private String name;
    private double marketCap;
    private Map instruments;
    public static String REGION_TABLE_NAME = "SECTORS";
    public static String REGION_TABLE_SHORT_NAME = "s";

    public static String getTableName() {
        return REGION_TABLE_NAME;
    }

    public static String getTableAndShortName() {
        return REGION_TABLE_NAME + " " + REGION_TABLE_SHORT_NAME;
    }

    public static String getTableShortName() {
        return REGION_TABLE_SHORT_NAME;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getMarketCap() {
        return this.marketCap;
    }

    public void setMarketCap(double marketCap) {
        this.marketCap = marketCap;
    }

    public static String getSectorName(int sid) {
        return "IndustrySector" + sid;
    }

    public Map getInstruments() {
        return this.instruments;
    }

    public void setInstruments(Map instruments) {
        this.instruments = instruments;
    }

    public void init(int i) {
        this.id = i;
        this.name = Sector.getSectorName(i);
        this.marketCap = i % SectorPrms.getNumMarketCapValues();
    }

    public static QueryFactory getQueryFactory(int api) {
        switch (api) {
            case 1: {
                return new GFXDSectorQueryFactory();
            }
            case 3: {
                return new MySQLSectorQueryFactory();
            }
            case 4: {
                return new MySQLCSectorQueryFactory();
            }
            case 6: {
                return new SQLSectorQueryFactory();
            }
        }
        String s = "No factory for: " + QueryPrms.getAPIString((int)api);
        throw new UnsupportedOperationException(s);
    }

    public static String commaSeparatedStringFor(Vector fields) {
        StringBuffer sb = new StringBuffer();
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            String field = (String)i.next();
            if (field.equals("*")) {
                return field;
            }
            sb.append(REGION_TABLE_SHORT_NAME + "." + field);
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static List getFields(List fieldList) {
        ArrayList<String> fields = new ArrayList<String>();
        if (fieldList.contains("*")) {
            fields.add("id");
            fields.add("name");
            fields.add("market_cap");
        } else if (!fieldList.contains("none")) {
            fields.addAll(fieldList);
        }
        return fields;
    }

    public String toString() {
        return "Sector #" + this.id + "=" + this.id + ": name=" + this.name + ": marketCap=" + this.marketCap;
    }

    public int sizeof(Object o) {
        if (o instanceof Sector) {
            Sector obj = (Sector)o;
            return Sizeof.sizeof((int)obj.id) + Sizeof.sizeof((String)obj.name) + Sizeof.sizeof((double)obj.marketCap);
        }
        return Sizeof.sizeof((Object)o);
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.id);
        DataSerializer.writeString((String)this.name, (DataOutput)out);
        out.writeDouble(this.marketCap);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.name = DataSerializer.readString((DataInput)in);
        this.marketCap = in.readDouble();
    }
}

