/*
 * Decompiled with CFR 0.152.
 */
package objects.query.sector;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import java.util.Vector;
import objects.query.QueryPrms;
import objects.query.sector.Instrument;
import objects.query.sector.Position;
import objects.query.sector.Sector;

public class SectorPrms
extends BasePrms {
    public static final int POSITION_TYPE = 1;
    public static final int INSTRUMENT_TYPE = 2;
    public static final int SECTOR_TYPE = 3;
    public static final int NO_QUERY = -1;
    public static final String RANDOM_POSITION_PK = "randomPositionPK";
    public static final String SECTOR_FILTER_IN = "sectorFilterIn";
    public static final String SECTOR_FILTER_IN_AND_MARKET_CAP = "sectorFilterInAndMarketCap";
    public static final String POSITION_PRUNE_BY_INSTRUMENT = "positionPruneByInstrument";
    public static final String POSITION_AMOUNT_RANGE_AND = "positionAmountRangeAnd";
    public static final String POSITION_AMOUNT_RANGE_OR = "positionAmountRangeOr";
    public static final String POSITION_PRUNE_BY_INSTRUMENT_AND_POSITION_AMOUNT = "positionPruneByInstrumentAndPositionAmount";
    public static final String POSITION_PRUNE_BY_INSTRUMENT_AND_FILTER_SYMBOL_AND_OWNER = "positionPruneByInstrumentAndFilterSymbolAndOwner";
    public static final String JOIN_PRUNE_BY_POSITION_AMOUNT_AND_INSTRUMENT_NAME = "joinPruneByPositionAmountAndInstrumentName";
    public static final String JOIN_PRUNE_BY_POSITION_AMOUNT_AND_INSTRUMENT_NAME_AND_SECTOR_NAME = "joinPruneByPositionAmountAndInstrumentNameAndSectorName";
    public static final String INSTRUMENT_IN = "instrumentIn";
    public static final String JOIN_INSTRUMENT_AND_POSITION_IN = "joinInstrumentAndPositionIn";
    public static final String POSITION_FILTER_IN = "positionFilterIn";
    public static final String UPDATE_POSITION_BY_POSITION_ID = "updatePositionByPositionId";
    public static final String INSERT_INTO_POSITION = "insertIntoPosition";
    public static final String JOIN_TO_SINGLE_NODE = "joinToSingleNode";
    public static final String JOIN_INSTRUMENT_AND_POSITION_OR = "joinInstrumentAndPositionOr";
    public static final int RANDOM_POSITION_PK_QUERY = 0;
    public static final int SECTOR_FILTER_IN_QUERY = 1;
    public static final int SECTOR_FILTER_IN_AND_MARKET_CAP_QUERY = 2;
    public static final int POSITION_PRUNE_BY_INSTRUMENT_QUERY = 3;
    public static final int POSITION_AMOUNT_RANGE_AND_QUERY = 15;
    public static final int POSITION_AMOUNT_RANGE_OR_QUERY = 16;
    public static final int POSITION_PRUNE_BY_INSTRUMENT_AND_POSITION_AMOUNT_QUERY = 4;
    public static final int POSITION_PRUNE_BY_INSTRUMENT_AND_FILTER_SYMBOL_AND_OWNER_QUERY = 5;
    public static final int JOIN_PRUNE_BY_POSITION_AMOUNT_AND_INSTRUMENT_NAME_QUERY = 6;
    public static final int JOIN_PRUNE_BY_POSITION_AMOUNT_AND_INSTRUMENT_NAME_AND_SECTOR_NAME_QUERY = 7;
    public static final int INSTRUMENT_IN_QUERY = 8;
    public static final int JOIN_INSTRUMENT_AND_POSITION_IN_QUERY = 9;
    public static final int POSITION_FILTER_IN_QUERY = 10;
    public static final int UPDATE_POSITION_BY_POSITION_ID_QUERY = 11;
    public static final int INSERT_INTO_POSITION_QUERY = 12;
    public static final int JOIN_TO_SINGLE_NODE_QUERY = 13;
    public static final int JOIN_INSTRUMENT_AND_POSITION_OR_QUERY = 14;
    protected static final String PRIMARY_KEY_INDEX_ON_SECTOR_ID = "primaryKeyIndexOnSectorId";
    protected static final String UNIQUE_INDEX_ON_SECTOR_ID = "uniqueKeyIndexOnSectorId";
    protected static final String PRIMARY_KEY_INDEX_ON_SECTOR_NAME = "primaryKeyIndexOnSectorName";
    protected static final String UNIQUE_INDEX_ON_SECTOR_NAME = "uniqueKeyIndexOnSectorName";
    protected static final String PRIMARY_KEY_INDEX_ON_MARKET_CAP = "primaryKeyIndexOnMarketCap";
    protected static final String UNIQUE_INDEX_ON_MARKET_CAP = "uniqueKeyIndexOnMarketCap";
    protected static final String PRIMARY_KEY_INDEX_ON_INSTRUMENT_ID = "primaryKeyIndexOnInstrumentId";
    protected static final String UNIQUE_INDEX_ON_INSTRUMENT_ID = "uniqueKeyIndexOnInstrumentId";
    protected static final String PRIMARY_KEY_INDEX_ON_POSITION_ID = "primaryKeyIndexOnPositionId";
    protected static final String UNIQUE_INDEX_ON_POSITION_ID = "uniqueKeyIndexOnPositionId";
    protected static final String PRIMARY_KEY_INDEX_ON_BOOK_ID = "primaryKeyIndexOnBookId";
    protected static final String UNIQUE_INDEX_ON_BOOK_ID = "uniqueKeyIndexOnBookId";
    protected static final String PRIMARY_KEY_INDEX_ON_AMOUNT = "primaryKeyIndexOnAmount";
    protected static final String UNIQUE_INDEX_ON_AMOUNT = "uniqueKeyIndexOnAmount";
    protected static final String PRIMARY_KEY_INDEX_ON_SYNTHETIC = "primaryKeyIndexOnSynthetic";
    protected static final String UNIQUE_INDEX_ON_SYNTHETIC = "uniqueKeyIndexOnSynthetic";
    protected static final String PRIMARY_KEY_INDEX_ON_OWNER = "primaryKeyIndexOnOwner";
    protected static final String UNIQUE_INDEX_ON_OWNER = "uniqueKeyIndexOnOwner";
    protected static final String PRIMARY_KEY_INDEX_ON_SYMBOL = "primaryKeyIndexOnSymbol";
    protected static final String UNIQUE_INDEX_ON_SYMBOL = "uniqueKeyIndexOnSymbol";
    protected static final String PRIMARY_KEY_INDEX_ON_RISK_ID = "primaryKeyIndexOnRiskId";
    protected static final String UNIQUE_INDEX_ON_RISK_ID = "uniqueKeyIndexOnRiskId";
    protected static final String INDEX_ON_SECTOR_ID = "indexOnSectorId";
    protected static final String INDEX_ON_INSTRUMENT_ID = "indexOnInstrumentId";
    protected static final String INDEX_ON_POSITION_ID = "indexOnPositionId";
    protected static final String INDEX_ON_POSITION_SYNTHETIC = "indexOnPositionSynthetic";
    protected static final String INDEX_ON_POSITION_INSTRUMENT = "indexOnPositionInstrument";
    protected static final String INDEX_ON_POSITION_SYMBOL = "indexOnPositionSymbol";
    protected static final String INDEX_ON_POSITION_OWNER = "indexOnPositionOwner";
    protected static final String INDEX_ON_POSITION_AMOUNT = "indexOnPositionAmount";
    protected static final String INDEX_ON_SECTOR_NAME = "indexOnSectorName";
    protected static final String INDEX_ON_SECTOR_MARKET_CAP = "indexOnSectorMarketCap";
    protected static final int PRIMARY_KEY_INDEX_ON_SECTOR_ID_QUERY = 0;
    protected static final int UNIQUE_INDEX_ON_SECTOR_ID_QUERY = 28;
    protected static final int PRIMARY_KEY_INDEX_ON_SECTOR_NAME_QUERY = 29;
    protected static final int UNIQUE_INDEX_ON_SECTOR_NAME_QUERY = 1;
    protected static final int PRIMARY_KEY_INDEX_ON_MARKET_CAP_QUERY = 30;
    protected static final int UNIQUE_INDEX_ON_MARKET_CAP_QUERY = 31;
    protected static final int PRIMARY_KEY_INDEX_ON_INSTRUMENT_ID_QUERY = 2;
    protected static final int UNIQUE_INDEX_ON_INSTRUMENT_ID_QUERY = 27;
    protected static final int PRIMARY_KEY_INDEX_ON_POSITION_ID_QUERY = 3;
    protected static final int UNIQUE_INDEX_ON_POSITION_ID_QUERY = 4;
    protected static final int PRIMARY_KEY_INDEX_ON_BOOK_ID_QUERY = 5;
    protected static final int UNIQUE_INDEX_ON_BOOK_ID_QUERY = 6;
    protected static final int PRIMARY_KEY_INDEX_ON_SYNTHETIC_QUERY = 7;
    protected static final int UNIQUE_INDEX_ON_SYNTHETIC_QUERY = 8;
    protected static final int PRIMARY_KEY_INDEX_ON_SYMBOL_QUERY = 9;
    protected static final int UNIQUE_INDEX_ON_SYMBOL_QUERY = 10;
    protected static final int PRIMARY_KEY_INDEX_ON_AMOUNT_QUERY = 11;
    protected static final int UNIQUE_INDEX_ON_AMOUNT_QUERY = 12;
    protected static final int PRIMARY_KEY_INDEX_ON_OWNER_QUERY = 13;
    protected static final int UNIQUE_INDEX_ON_OWNER_QUERY = 14;
    protected static final int PRIMARY_KEY_INDEX_ON_RISK_ID_QUERY = 15;
    protected static final int UNIQUE_INDEX_ON_RISK_ID_QUERY = 16;
    protected static final int INDEX_ON_SECTOR_ID_QUERY = 17;
    protected static final int INDEX_ON_INSTRUMENT_ID_QUERY = 18;
    protected static final int INDEX_ON_POSITION_ID_QUERY = 19;
    protected static final int INDEX_ON_POSITION_SYNTHETIC_QUERY = 20;
    protected static final int INDEX_ON_POSITION_INSTRUMENT_QUERY = 21;
    protected static final int INDEX_ON_POSITION_SYMBOL_QUERY = 22;
    protected static final int INDEX_ON_POSITION_OWNER_QUERY = 23;
    protected static final int INDEX_ON_POSITION_AMOUNT_QUERY = 24;
    protected static final int INDEX_ON_SECTOR_NAME_QUERY = 25;
    protected static final int INDEX_ON_SECTOR_MARKET_CAP_QUERY = 26;
    public static Long indexTypes;
    public static Long queryType;
    public static Long updateQueryType;
    public static Long deleteQueryType;
    public static Long sectorFields;
    public static Long positionFields;
    public static Long instrumentFields;
    public static Long numSectors;
    public static Long numInstrumentsPerSector;
    public static Long numPositionsPerInstrument;
    public static Long numBookValues;
    public static Long numMarketCapValues;
    public static Long numRiskValues;
    public static Long numSymbolValues;
    public static Long numAmountsPerRangeClause;
    public static Long numInstrumentsPerInClause;
    public static Long numMarketCapValuesPerOrClause;
    public static Long numOwnersPerOrClause;
    public static Long numPositionsPerInClause;
    public static Long numSectorsPerInClause;
    public static Long numSymbolsPerInClause;
    public static Long sectorDataPolicy;
    public static Long instrumentDataPolicy;
    public static Long positionDataPolicy;
    public static Long riskDataPolicy;
    public static Long sectorPartitionRedundancy;
    public static Long instrumentPartitionRedundancy;
    public static Long positionPartitionRedundancy;
    public static Long riskPartitionRedundancy;
    public static Long sectorOffHeap;
    public static Long instrumentOffHeap;
    public static Long positionOffHeap;
    public static Long riskOffHeap;
    public static Long sectorPartitionTotalNumBuckets;
    public static Long instrumentPartitionTotalNumBuckets;
    public static Long positionPartitionTotalNumBuckets;
    public static Long riskPartitionTotalNumBuckets;
    public static Long sectorPartitionType;
    public static Long instrumentPartitionType;
    public static Long positionPartitionType;
    public static Long riskPartitionType;
    public static Long sectorPartitionColumn;
    public static Long instrumentPartitionColumn;
    public static Long positionPartitionColumn;
    public static Long riskPartitionColumn;
    public static Long sectorCreateTableIndexes;
    public static Long instrumentCreateTableIndexes;
    public static Long positionCreateTableIndexes;
    public static Long riskCreateTableIndexes;
    public static Long sectorColocationStatement;
    public static Long instrumentColocationStatement;
    public static Long positionColocationStatement;
    public static Long riskColocationStatement;
    public static Long commitBatches;
    public static Long numClients;
    public static Long numServers;

    public static Vector getIndexTypes() {
        Long key = indexTypes;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector()));
        return val;
    }

    public static int getIndexType(String val) {
        Long key = indexTypes;
        if (val.equals(PRIMARY_KEY_INDEX_ON_SECTOR_ID)) {
            return 0;
        }
        if (val.equals(UNIQUE_INDEX_ON_SECTOR_ID)) {
            return 28;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_SECTOR_NAME)) {
            return 29;
        }
        if (val.equals(UNIQUE_INDEX_ON_SECTOR_NAME)) {
            return 1;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_MARKET_CAP)) {
            return 30;
        }
        if (val.equals(UNIQUE_INDEX_ON_SECTOR_NAME)) {
            return 1;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_INSTRUMENT_ID)) {
            return 2;
        }
        if (val.equals(UNIQUE_INDEX_ON_INSTRUMENT_ID)) {
            return 27;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_POSITION_ID)) {
            return 3;
        }
        if (val.equals(UNIQUE_INDEX_ON_POSITION_ID)) {
            return 4;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_OWNER)) {
            return 13;
        }
        if (val.equals(UNIQUE_INDEX_ON_OWNER)) {
            return 14;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_SYNTHETIC)) {
            return 7;
        }
        if (val.equals(UNIQUE_INDEX_ON_SYNTHETIC)) {
            return 8;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_AMOUNT)) {
            return 11;
        }
        if (val.equals(UNIQUE_INDEX_ON_AMOUNT)) {
            return 12;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_SYMBOL)) {
            return 9;
        }
        if (val.equals(UNIQUE_INDEX_ON_SYMBOL)) {
            return 10;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_BOOK_ID)) {
            return 5;
        }
        if (val.equals(UNIQUE_INDEX_ON_BOOK_ID)) {
            return 6;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_RISK_ID)) {
            return 15;
        }
        if (val.equals(UNIQUE_INDEX_ON_RISK_ID)) {
            return 16;
        }
        if (val.equals(INDEX_ON_SECTOR_ID)) {
            return 17;
        }
        if (val.equals(INDEX_ON_INSTRUMENT_ID)) {
            return 18;
        }
        if (val.equals(INDEX_ON_POSITION_ID)) {
            return 19;
        }
        if (val.equals(INDEX_ON_POSITION_SYNTHETIC)) {
            return 20;
        }
        if (val.equals(INDEX_ON_POSITION_INSTRUMENT)) {
            return 21;
        }
        if (val.equals(INDEX_ON_POSITION_SYMBOL)) {
            return 22;
        }
        if (val.equals(INDEX_ON_POSITION_OWNER)) {
            return 23;
        }
        if (val.equals(INDEX_ON_POSITION_AMOUNT)) {
            return 24;
        }
        if (val.equals(INDEX_ON_SECTOR_NAME)) {
            return 25;
        }
        if (val.equals(INDEX_ON_SECTOR_MARKET_CAP)) {
            return 26;
        }
        if (val.equals("none")) {
            return -1;
        }
        String s = "Unsupported value for " + BasePrms.nameForKey((Long)key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getQueryType(int api) {
        Long key = queryType;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key));
        switch (api) {
            case 1: {
                return SectorPrms.getSQLQueryType(key, val);
            }
        }
        String s = "Unsupported API: " + QueryPrms.getAPIString((int)api);
        throw new HydraConfigException(s);
    }

    private static int getSQLQueryType(Long key, String val) {
        if (val.equalsIgnoreCase(RANDOM_POSITION_PK)) {
            return 0;
        }
        if (val.equalsIgnoreCase(SECTOR_FILTER_IN)) {
            return 1;
        }
        if (val.equalsIgnoreCase(SECTOR_FILTER_IN_AND_MARKET_CAP)) {
            return 2;
        }
        if (val.equalsIgnoreCase(POSITION_PRUNE_BY_INSTRUMENT)) {
            return 3;
        }
        if (val.equalsIgnoreCase(POSITION_AMOUNT_RANGE_AND)) {
            return 15;
        }
        if (val.equalsIgnoreCase(POSITION_AMOUNT_RANGE_OR)) {
            return 16;
        }
        if (val.equalsIgnoreCase(POSITION_PRUNE_BY_INSTRUMENT_AND_POSITION_AMOUNT)) {
            return 4;
        }
        if (val.equalsIgnoreCase(POSITION_PRUNE_BY_INSTRUMENT_AND_FILTER_SYMBOL_AND_OWNER)) {
            return 5;
        }
        if (val.equalsIgnoreCase(JOIN_PRUNE_BY_POSITION_AMOUNT_AND_INSTRUMENT_NAME)) {
            return 6;
        }
        if (val.equalsIgnoreCase(JOIN_PRUNE_BY_POSITION_AMOUNT_AND_INSTRUMENT_NAME_AND_SECTOR_NAME)) {
            return 7;
        }
        if (val.equalsIgnoreCase(INSTRUMENT_IN)) {
            return 8;
        }
        if (val.equalsIgnoreCase(JOIN_INSTRUMENT_AND_POSITION_IN)) {
            return 9;
        }
        if (val.equalsIgnoreCase(POSITION_FILTER_IN)) {
            return 10;
        }
        if (val.equalsIgnoreCase(UPDATE_POSITION_BY_POSITION_ID)) {
            return 11;
        }
        if (val.equalsIgnoreCase(INSERT_INTO_POSITION)) {
            return 12;
        }
        if (val.equalsIgnoreCase(JOIN_TO_SINGLE_NODE)) {
            return 13;
        }
        if (val.equalsIgnoreCase(JOIN_INSTRUMENT_AND_POSITION_OR)) {
            return 14;
        }
        String s = "Unsupported value for " + QueryPrms.getAPIString((int)1) + " query " + BasePrms.nameForKey((Long)key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getUpdateQueryType(int api) {
        Long key = updateQueryType;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key));
        switch (api) {
            case 1: {
                return SectorPrms.getSQLUpdateQueryType(key, val);
            }
        }
        String s = "Unsupported API: " + QueryPrms.getAPIString((int)api);
        throw new HydraConfigException(s);
    }

    private static int getSQLUpdateQueryType(Long key, String val) {
        if (val.equalsIgnoreCase(UPDATE_POSITION_BY_POSITION_ID)) {
            return 11;
        }
        String s = "Unsupported value for " + QueryPrms.getAPIString((int)1) + " query " + BasePrms.nameForKey((Long)key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getDeleteQueryType(int api) {
        Long key = deleteQueryType;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key));
        switch (api) {
            default: 
        }
        String s = "Unsupported API: " + QueryPrms.getAPIString((int)api);
        throw new HydraConfigException(s);
    }

    public static String getSectorFields() {
        Long key = sectorFields;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector((Object)"*")));
        return Sector.commaSeparatedStringFor((Vector)val);
    }

    public static Vector getSectorFieldsAsVector() {
        Long key = sectorFields;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector((Object)"*")));
        return val;
    }

    public static String getPositionFields() {
        Long key = positionFields;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector((Object)"*")));
        return Position.commaSeparatedStringFor((Vector)val);
    }

    public static Vector getPositionFieldsAsVector() {
        Long key = positionFields;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector((Object)"*")));
        return val;
    }

    public static String getInstrumentFields() {
        Long key = instrumentFields;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector((Object)"*")));
        return Instrument.commaSeparatedStringFor((Vector)val);
    }

    public static Vector getInstrumentFieldsAsVector() {
        Long key = instrumentFields;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector((Object)"*")));
        return val;
    }

    public static int getNumSectors() {
        Long key = numSectors;
        int val = SectorPrms.tab().intAt(key);
        if (val <= 0) {
            String s = BasePrms.nameForKey((Long)numSectors) + " must be positive: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getNumInstrumentsPerSector() {
        Long key = numInstrumentsPerSector;
        int val = SectorPrms.tab().intAt(key);
        if (val <= 0) {
            String s = BasePrms.nameForKey((Long)numInstrumentsPerSector) + " must be positive: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getNumPositionsPerInstrument() {
        Long key = numPositionsPerInstrument;
        int val = SectorPrms.tab().intAt(key);
        if (val <= 0) {
            String s = BasePrms.nameForKey((Long)numPositionsPerInstrument) + " must be positive: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getNumInstruments() {
        return SectorPrms.getNumSectors() * SectorPrms.getNumInstrumentsPerSector();
    }

    public static int getNumPositions() {
        return SectorPrms.getNumInstruments() * SectorPrms.getNumPositionsPerInstrument();
    }

    public static int getNumBookValues() {
        Long key = numBookValues;
        int val = SectorPrms.tab().intAt(key);
        if (val <= 0) {
            String s = BasePrms.nameForKey((Long)numBookValues) + " must be positive: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getNumMarketCapValues() {
        Long key = numMarketCapValues;
        int val = SectorPrms.tab().intAt(key);
        if (val <= 0) {
            String s = BasePrms.nameForKey((Long)numMarketCapValues) + " must be positive: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getNumRiskValues() {
        Long key = numRiskValues;
        int val = SectorPrms.tab().intAt(key);
        if (val <= 0) {
            String s = BasePrms.nameForKey((Long)numRiskValues) + " must be positive: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getNumSymbolValues() {
        Long key = numSymbolValues;
        int val = SectorPrms.tab().intAt(key, 1);
        if (val < 0) {
            String s = BasePrms.nameForKey((Long)numSymbolValues) + " cannot be negative.";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getNumAmountsPerRangeClause() {
        Long key = numAmountsPerRangeClause;
        int size = SectorPrms.tab().intAt(key, 1);
        if (size < 0) {
            String s = BasePrms.nameForKey((Long)numAmountsPerRangeClause) + " cannot be negative.";
            throw new HydraConfigException(s);
        }
        return size;
    }

    public static int getNumInstrumentsPerInClause() {
        Long key = numInstrumentsPerInClause;
        int size = SectorPrms.tab().intAt(key, 1);
        if (size < 0) {
            String s = BasePrms.nameForKey((Long)numInstrumentsPerInClause) + " cannot be negative.";
            throw new HydraConfigException(s);
        }
        return size;
    }

    public static int getNumMarketCapValuesPerOrClause() {
        Long key = numMarketCapValuesPerOrClause;
        int size = SectorPrms.tab().intAt(key, 1);
        if (size < 0) {
            String s = BasePrms.nameForKey((Long)numMarketCapValuesPerOrClause) + " cannot be negative.";
            throw new HydraConfigException(s);
        }
        return size;
    }

    public static int getNumOwnersPerOrClause() {
        Long key = numOwnersPerOrClause;
        int size = SectorPrms.tab().intAt(key, 1);
        if (size < 0) {
            String s = BasePrms.nameForKey((Long)numOwnersPerOrClause) + " cannot be negative.";
            throw new HydraConfigException(s);
        }
        return size;
    }

    public static int getNumPositionsPerInClause() {
        Long key = numPositionsPerInClause;
        int size = SectorPrms.tab().intAt(key, 1);
        if (size < 0) {
            String s = BasePrms.nameForKey((Long)numPositionsPerInClause) + " cannot be negative.";
            throw new HydraConfigException(s);
        }
        return size;
    }

    public static int getNumSectorsPerInClause() {
        Long key = numSectorsPerInClause;
        int size = SectorPrms.tab().intAt(key, 1);
        if (size < 0) {
            String s = BasePrms.nameForKey((Long)numSectorsPerInClause) + " cannot be negative.";
            throw new HydraConfigException(s);
        }
        return size;
    }

    public static int getNumSymbolsPerInClause() {
        Long key = numSymbolsPerInClause;
        int size = SectorPrms.tab().intAt(key, 1);
        if (size < 0) {
            String s = BasePrms.nameForKey((Long)numSymbolsPerInClause) + " cannot be negative.";
            throw new HydraConfigException(s);
        }
        return size;
    }

    public static int getSectorDataPolicy() {
        Long key = sectorDataPolicy;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, "NONE"));
        return QueryPrms.getDataPolicy((Long)key, (String)val);
    }

    public static int getInstrumentDataPolicy() {
        Long key = instrumentDataPolicy;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, "NONE"));
        return QueryPrms.getDataPolicy((Long)key, (String)val);
    }

    public static int getPositionDataPolicy() {
        Long key = positionDataPolicy;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, "NONE"));
        return QueryPrms.getDataPolicy((Long)key, (String)val);
    }

    public static int getRiskDataPolicy() {
        Long key = riskDataPolicy;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, "NONE"));
        return QueryPrms.getDataPolicy((Long)key, (String)val);
    }

    public static int getSectorPartitionRedundancy() {
        Long key = sectorPartitionRedundancy;
        return SectorPrms.tasktab().intAt(key, SectorPrms.tab().intAt(key));
    }

    public static int getInstrumentPartitionRedundancy() {
        Long key = instrumentPartitionRedundancy;
        return SectorPrms.tasktab().intAt(key, SectorPrms.tab().intAt(key));
    }

    public static int getPositionPartitionRedundancy() {
        Long key = positionPartitionRedundancy;
        return SectorPrms.tasktab().intAt(key, SectorPrms.tab().intAt(key));
    }

    public static int getRiskPartitionRedundancy() {
        Long key = riskPartitionRedundancy;
        return SectorPrms.tasktab().intAt(key, SectorPrms.tab().intAt(key));
    }

    public static boolean getSectorOffHeap() {
        Long key = sectorOffHeap;
        return SectorPrms.tasktab().booleanAt(key, SectorPrms.tab().booleanAt(key, false));
    }

    public static boolean getInstrumentOffHeap() {
        Long key = instrumentOffHeap;
        return SectorPrms.tasktab().booleanAt(key, SectorPrms.tab().booleanAt(key, false));
    }

    public static boolean getPositionOffHeap() {
        Long key = positionOffHeap;
        return SectorPrms.tasktab().booleanAt(key, SectorPrms.tab().booleanAt(key, false));
    }

    public static boolean getRiskOffHeap() {
        Long key = riskOffHeap;
        return SectorPrms.tasktab().booleanAt(key, SectorPrms.tab().booleanAt(key, false));
    }

    public static int getSectorPartitionTotalNumBuckets() {
        Long key = sectorPartitionTotalNumBuckets;
        return SectorPrms.tasktab().intAt(key, SectorPrms.tab().intAt(key, 0));
    }

    public static int getInstrumentPartitionTotalNumBuckets() {
        Long key = instrumentPartitionTotalNumBuckets;
        return SectorPrms.tasktab().intAt(key, SectorPrms.tab().intAt(key, 0));
    }

    public static int getPositionPartitionTotalNumBuckets() {
        Long key = positionPartitionTotalNumBuckets;
        return SectorPrms.tasktab().intAt(key, SectorPrms.tab().intAt(key, 0));
    }

    public static int getRiskPartitionTotalNumBuckets() {
        Long key = riskPartitionTotalNumBuckets;
        return SectorPrms.tasktab().intAt(key, SectorPrms.tab().intAt(key, 0));
    }

    public static int getSectorPartitionType() {
        Long key = sectorPartitionType;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, "PartitionByPK"));
        return QueryPrms.getPartitionType((Long)key, (String)val);
    }

    public static int getInstrumentPartitionType() {
        Long key = instrumentPartitionType;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, "PartitionByPK"));
        return QueryPrms.getPartitionType((Long)key, (String)val);
    }

    public static int getPositionPartitionType() {
        Long key = positionPartitionType;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, "PartitionByPK"));
        return QueryPrms.getPartitionType((Long)key, (String)val);
    }

    public static int getRiskPartitionType() {
        Long key = riskPartitionType;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, "PartitionByPK"));
        return QueryPrms.getPartitionType((Long)key, (String)val);
    }

    public static String getSectorPartitionColumn() {
        Long key = sectorPartitionColumn;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key));
        return val;
    }

    public static String getInstrumentPartitionColumn() {
        Long key = instrumentPartitionColumn;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key));
        return val;
    }

    public static String getPositionPartitionColumn() {
        Long key = positionPartitionColumn;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key));
        return val;
    }

    public static String getRiskPartitionColumn() {
        Long key = riskPartitionColumn;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key));
        return val;
    }

    public static Vector getSectorCreateTableIndexes() {
        Long key = sectorCreateTableIndexes;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector()));
        return val;
    }

    public static Vector getInstrumentCreateTableIndexes() {
        Long key = instrumentCreateTableIndexes;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector()));
        return val;
    }

    public static Vector getPositionCreateTableIndexes() {
        Long key = positionCreateTableIndexes;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector()));
        return val;
    }

    public static Vector getRiskCreateTableIndexes() {
        Long key = riskCreateTableIndexes;
        HydraVector val = SectorPrms.tasktab().vecAt(key, SectorPrms.tab().vecAt(key, new HydraVector()));
        return val;
    }

    public static String getSectorColocationStatement() {
        Long key = sectorColocationStatement;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, ""));
        if (val == "none") {
            val = "";
        }
        return val;
    }

    public static String getInstrumentColocationStatement() {
        Long key = instrumentColocationStatement;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, ""));
        if (val.equals("none")) {
            val = "";
        }
        return val;
    }

    public static String getPositionColocationStatement() {
        Long key = positionColocationStatement;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, ""));
        if (val.equals("none")) {
            val = "";
        }
        return val;
    }

    public static String getRiskColocationStatement() {
        Long key = riskColocationStatement;
        String val = SectorPrms.tasktab().stringAt(key, SectorPrms.tab().stringAt(key, ""));
        if (val.equals("none")) {
            val = "";
        }
        return val;
    }

    public static boolean commitBatches() {
        Long key = commitBatches;
        return SectorPrms.tasktab().booleanAt(key, SectorPrms.tab().booleanAt(key, true));
    }

    public static int getNumClients() {
        Long key = numClients;
        return SectorPrms.tasktab().intAt(key, SectorPrms.tab().intAt(key));
    }

    public static int getNumServers() {
        Long key = numServers;
        return SectorPrms.tasktab().intAt(key, SectorPrms.tab().intAt(key));
    }

    public static void main(String[] args) {
        SectorPrms.dumpKeys();
    }

    static {
        SectorPrms.setValues(SectorPrms.class);
    }
}

