/*
 * Decompiled with CFR 0.152.
 */
package objects.query.tinyobject;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.gemfirexd.GfxdHelperPrms;
import java.util.ArrayList;
import java.util.List;
import objects.query.tinyobject.SQLTinyObjectQueryFactory;
import objects.query.tinyobject.TinyObject;
import objects.query.tinyobject.TinyObjectPrms;

public class GFXDTinyObjectQueryFactory
extends SQLTinyObjectQueryFactory {
    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "create table " + TinyObject.getTableName() + " (" + this.getIdCreateStatement() + "," + " intField int " + ")";
        int dataPolicy = TinyObjectPrms.getTinyObjectDataPolicy();
        if (dataPolicy == 0) {
            stmt = stmt + " REPLICATE";
        } else if (dataPolicy == 1) {
            int buckets = TinyObjectPrms.getTinyObjectPartitionTotalNumBuckets();
            int partitionType = TinyObjectPrms.getTinyObjectPartitionType();
            switch (partitionType) {
                case 3: {
                    break;
                }
                case 1: {
                    stmt = stmt + " PARTITION BY COLUMN (" + TinyObjectPrms.getTinyObjectPartitionColumn() + ")";
                    break;
                }
                case 0: {
                    stmt = stmt + " PARTITION BY PRIMARY KEY";
                    break;
                }
                case 2: {
                    int numTinyObjects = TinyObjectPrms.getNumTinyObjects();
                    buckets = TinyObjectPrms.getTinyObjectPartitionTotalNumBuckets();
                    if (numTinyObjects % buckets != 0) {
                        String s = BasePrms.nameForKey((Long)TinyObjectPrms.tinyObjectPartitionTotalNumBuckets) + ": " + buckets + " does not evenly divide " + BasePrms.nameForKey((Long)TinyObjectPrms.numTinyObjects) + ": " + numTinyObjects;
                        throw new HydraConfigException(s);
                    }
                    int tinyObjectsPerBucket = numTinyObjects / buckets;
                    Log.getLogWriter().info("Configuring partition by range for " + numTinyObjects + " objects using " + buckets + " ranges and " + tinyObjectsPerBucket + " objects per range");
                    stmt = stmt + " PARTITION BY RANGE (" + TinyObjectPrms.getTinyObjectPartitionColumn() + ")";
                    stmt = stmt + " (";
                    for (int i = 0; i < buckets; ++i) {
                        if (i != 0) {
                            stmt = stmt + ", ";
                        }
                        int x = i * tinyObjectsPerBucket;
                        int y = (i + 1) * tinyObjectsPerBucket;
                        stmt = stmt + "VALUES BETWEEN " + x + " AND " + y;
                    }
                    stmt = stmt + ")";
                    break;
                }
                default: {
                    String s = "Invalid partitioning scheme";
                    throw new HydraConfigException(s);
                }
            }
            int redundancy = TinyObjectPrms.getTinyObjectPartitionRedundancy();
            if (redundancy != 0) {
                stmt = stmt + " REDUNDANCY " + redundancy;
            }
            if (buckets != 0) {
                stmt = stmt + " BUCKETS " + buckets;
            }
        }
        if (GfxdHelperPrms.persistTables()) {
            stmt = stmt + " PERSISTENT SYNCHRONOUS DISKDIR ('tinyobject')";
        }
        stmts.add(stmt);
        return stmts;
    }

    @Override
    public String getCreateSchemaStatement() {
        String stmt = "create schema perfTest";
        return stmt;
    }

    @Override
    public String getDropSchemaStatement() {
        String stmt = "drop schema perfTest restrict";
        return stmt;
    }
}

