/*
 * Decompiled with CFR 0.152.
 */
package objects.query.tinyobject;

import com.gemstone.gemfire.cache.Region;
import hydra.BasePrms;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.TestConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import objects.query.BaseSQLQueryFactory;
import objects.query.QueryObjectException;
import objects.query.SQLQueryFactory;
import objects.query.tinyobject.TinyObject;
import objects.query.tinyobject.TinyObjectPrms;
import util.TestException;

public class SQLTinyObjectQueryFactory
extends BaseSQLQueryFactory
implements SQLQueryFactory {
    protected static final GsRandom rng = TestConfig.tab().getRandGen();
    protected static final String FIELD_SPEC = " intField int ";
    private int totalPositions;

    public List getConstraintStatements() {
        return new ArrayList();
    }

    public int getQueryType() {
        return TinyObjectPrms.getQueryType(1);
    }

    public int getUpdateQueryType() {
        return TinyObjectPrms.getUpdateQueryType(1);
    }

    public int getDeleteQueryType() {
        return TinyObjectPrms.getDeleteQueryType(1);
    }

    public String getQuery(int queryType, int i) {
        String query = "";
        int type = queryType;
        switch (type) {
            case 0: {
                query = this.getRandomEqualityOnTinyObjectIdQuery();
                break;
            }
            case 1: {
                query = this.getPutNewTinyObjectByTinyObjectIdQuery(i);
                break;
            }
            case 2: {
                query = this.getGetAndPutTinyObjectByTinyObjectIdQuery(i);
                break;
            }
            case 5: {
                query = this.getDeleteTinyObjectByTinyObjectIdQuery(i);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    public String getPreparedQuery(int queryType) {
        String query = "";
        int type = queryType;
        switch (type) {
            case 0: {
                query = this.getPreparedStatementForRandomEqualityOnTinyObjectIdQuery();
                break;
            }
            case 1: {
                query = this.getPreparedStatementForPutNewTinyObjectByTinyObjectIdQuery();
                break;
            }
            case 2: {
                query = this.getPreparedStatementForGetAndPutTinyObjectByTinyObjectIdQuery();
                break;
            }
            case 5: {
                query = this.getPreparedStatementForDeleteTinyObjectByTinyObjectIdQuery();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    public String getPrimaryKeyIndexOnTinyObjectId() {
        return "alter table " + TinyObject.getTableName() + " add primary key(id)";
    }

    public List getIndexStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        Vector indexTypes = TinyObjectPrms.getIndexTypes();
        for (String indexTypeString : indexTypes) {
            int indexType = TinyObjectPrms.getIndexType(indexTypeString);
            String stmt = this.getIndexStatement(indexType);
            if (stmt == null) continue;
            stmts.add(stmt);
        }
        return stmts;
    }

    public String getIndexStatement(int type) {
        String query;
        switch (type) {
            case 0: {
                query = this.getPrimaryKeyIndexOnTinyObjectId();
                break;
            }
            case -1: {
                query = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    public List getInsertStatements(int bid) {
        ArrayList<String> stmts = new ArrayList<String>();
        int numTinyObjects = TinyObjectPrms.getNumTinyObjects();
        if (bid >= numTinyObjects) {
            String s = "Attempt to get insert statement with bid=" + bid + " when " + BasePrms.nameForKey((Long)TinyObjectPrms.numTinyObjects) + "=" + numTinyObjects;
            throw new QueryObjectException(s);
        }
        String stmt = "insert into " + TinyObject.getTableName() + " values (" + bid + "," + bid + ")";
        stmts.add(stmt);
        return stmts;
    }

    public List getPreparedInsertStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "insert into " + TinyObject.getTableName() + " values (?, " + "?)";
        stmts.add(stmt);
        return stmts;
    }

    public int fillAndExecutePreparedInsertStatements(List pstmts, List stmts, int i) throws SQLException {
        int numTinyObjects = TinyObjectPrms.getNumTinyObjects();
        PreparedStatement pstmt = (PreparedStatement)pstmts.get(0);
        boolean results = false;
        if (i >= numTinyObjects) {
            String s = "Attempt to get insert statement with bid=" + i + " when " + BasePrms.nameForKey((Long)TinyObjectPrms.numTinyObjects) + "=" + numTinyObjects;
            throw new QueryObjectException(s);
        }
        pstmt.setInt(1, i);
        pstmt.setInt(2, i);
        return this.executeUpdatePreparedStatement(pstmt);
    }

    public String getCreateSchemaStatement() {
        String stmt = "create schema perfTest";
        return stmt;
    }

    public String getDropSchemaStatement() {
        String stmt = "drop schema perfTest restrict";
        return stmt;
    }

    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "create table " + TinyObject.getTableName() + " (" + this.getIdCreateStatement() + "," + FIELD_SPEC + ")";
        stmts.add(stmt);
        return stmts;
    }

    public List getDropTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add("drop table if exists " + TinyObject.getTableName());
        return stmts;
    }

    protected String getIdCreateStatement() {
        String stmt = "id int not null";
        Vector indexes = TinyObjectPrms.getTinyObjectCreateTableIndexes();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int indexType = TinyObjectPrms.getIndexType((String)iterator.next());
            if (indexType == 0) {
                stmt = stmt + " primary key";
                continue;
            }
            if (indexType != 1) continue;
            stmt = stmt + " unique";
        }
        return stmt;
    }

    public String getRandomEqualityOnTinyObjectIdQuery() {
        String fields = TinyObjectPrms.getTinyObjectFields();
        int id = rng.nextInt(0, TinyObjectPrms.getNumTinyObjects() - 1);
        return "select " + fields + " from " + TinyObject.getTableAndShortName() + " where " + TinyObject.getTableShortName() + ".id=" + id;
    }

    public String getPutNewTinyObjectByTinyObjectIdQuery(int id) {
        StringBuffer sb = new StringBuffer("update " + TinyObject.getTableAndShortName() + " set " + TinyObject.getTableShortName() + ".intField" + "=" + id + " where " + TinyObject.getTableShortName() + ".id=" + id);
        return sb.toString();
    }

    public String getGetAndPutTinyObjectByTinyObjectIdQuery(int id) {
        int n = rng.nextInt(1, 20);
        StringBuffer sb = new StringBuffer("update " + TinyObject.getTableAndShortName() + " set " + TinyObject.getTableShortName() + ".intField" + "=" + n + " where " + TinyObject.getTableShortName() + ".id=" + id);
        return sb.toString();
    }

    public String getDeleteTinyObjectByTinyObjectIdQuery(int id) {
        StringBuffer sb = new StringBuffer("delete from " + TinyObject.getTableAndShortName() + " where " + TinyObject.getTableShortName() + ".id=" + id);
        return sb.toString();
    }

    public ResultSet fillAndExecutePreparedQueryStatement(PreparedStatement pstmt, String stmt, int queryType, int i) throws SQLException {
        ResultSet rs = null;
        if (this.logQueries) {
            Log.getLogWriter().info("Executing Prepared Statement: ");
        }
        switch (queryType) {
            case 0: {
                rs = this.fillAndExecutePreparedStatementForRandomEqualityOnTinyObjectIdQuery(pstmt, stmt, i);
                break;
            }
            default: {
                throw new HydraConfigException("Unsupported, should not happen");
            }
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed Prepared Statement: ");
        }
        return rs;
    }

    public String getPreparedStatementForRandomEqualityOnTinyObjectIdQuery() {
        String fields = TinyObjectPrms.getTinyObjectFields();
        this.totalPositions = TinyObjectPrms.getNumTinyObjects();
        return "select " + fields + " from " + TinyObject.getTableAndShortName() + " where " + TinyObject.getTableShortName() + ".id=?";
    }

    public ResultSet fillAndExecutePreparedStatementForRandomEqualityOnTinyObjectIdQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        int id = rng.nextInt(0, this.totalPositions - 1);
        pstmt.setInt(1, id);
        return this.executeQueryPreparedStatement(pstmt);
    }

    public int fillAndExecuteUpdatePreparedQueryStatement(PreparedStatement pstmt, String stmt, int queryType, int i) throws SQLException {
        int numUpdated = 0;
        if (this.logQueries) {
            Log.getLogWriter().info("Executing Prepared Statement: and i = " + i);
        }
        switch (queryType) {
            case 1: {
                numUpdated = this.fillAndExecutePreparedStatementForPutNewTinyObjectByTinyObjectIdQuery(pstmt, stmt, i);
                break;
            }
            case 2: {
                numUpdated = this.fillAndExecutePreparedStatementForGetAndPutTinyObjectByTinyObjectIdQuery(pstmt, stmt, i);
                break;
            }
            case 5: {
                numUpdated = this.fillAndExecutePreparedStatementForDeleteTinyObjectByTinyObjectIdQuery(pstmt, stmt, i);
                break;
            }
            default: {
                throw new HydraConfigException("Unsupported query type for updates, should not happen");
            }
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed Prepared Statement: ");
        }
        return numUpdated;
    }

    public String getPreparedStatementForPutNewTinyObjectByTinyObjectIdQuery() {
        StringBuffer sb = new StringBuffer("update " + TinyObject.getTableAndShortName() + " set " + TinyObject.getTableShortName() + ".intField=? " + " where " + TinyObject.getTableShortName() + ".id=?");
        return sb.toString();
    }

    public int fillAndExecutePreparedStatementForPutNewTinyObjectByTinyObjectIdQuery(PreparedStatement pstmt, String stmt, int id) throws SQLException {
        pstmt.setInt(1, id);
        return this.executeUpdatePreparedStatement(pstmt);
    }

    public String getPreparedStatementForGetAndPutTinyObjectByTinyObjectIdQuery() {
        StringBuffer sb = new StringBuffer("update " + TinyObject.getTableAndShortName() + " set " + TinyObject.getTableShortName() + ".intField=? " + " where " + TinyObject.getTableShortName() + ".id=?");
        return sb.toString();
    }

    public int fillAndExecutePreparedStatementForGetAndPutTinyObjectByTinyObjectIdQuery(PreparedStatement pstmt, String stmt, int id) throws SQLException {
        int n = rng.nextInt(1, 20);
        pstmt.setInt(1, n);
        pstmt.setInt(2, id);
        return this.executeUpdatePreparedStatement(pstmt);
    }

    public String getPreparedStatementForDeleteTinyObjectByTinyObjectIdQuery() {
        StringBuffer sb = new StringBuffer("delete from " + TinyObject.getTableAndShortName() + " where " + TinyObject.getTableShortName() + ".id=?");
        return sb.toString();
    }

    public int fillAndExecutePreparedStatementForDeleteTinyObjectByTinyObjectIdQuery(PreparedStatement pstmt, String stmt, int id) throws SQLException {
        pstmt.setInt(1, id);
        return this.executeUpdatePreparedStatement(pstmt);
    }

    public int readResultSet(int queryType, ResultSet rs) throws SQLException {
        switch (queryType) {
            case 0: {
                return this.readResultSet(rs, TinyObject.getFields(TinyObjectPrms.getTinyObjectFieldsAsVector()));
            }
        }
        return this.readResultSet(rs, TinyObject.getFields(TinyObjectPrms.getTinyObjectFieldsAsVector()));
    }

    public int readResultSet(ResultSet rs, List fields) throws SQLException {
        int rsSize = 0;
        while (rs.next()) {
            this.readFields(rs, fields);
            ++rsSize;
        }
        if (this.logQueryResultSize) {
            Log.getLogWriter().info("Returned " + rsSize + " rows");
        }
        if (this.validateResults && rsSize != TinyObjectPrms.getResultSetSize()) {
            throw new HydraConfigException("ResultSetSize expected(" + TinyObjectPrms.getResultSetSize() + ") did not match actual(" + rsSize + ")");
        }
        return rsSize;
    }

    private void readFields(ResultSet rs, List fields) throws SQLException {
        for (int i = 1; i < 42; ++i) {
            if (i == 1) {
                rs.getInt(i);
                continue;
            }
            if (i > 1 && i < 22) {
                rs.getString(i);
                continue;
            }
            if (i <= 21 || i >= 42) continue;
            rs.getInt(i);
        }
    }

    private Region getRegion(String regionName) {
        Region region;
        try {
            Class<?> c = Class.forName("com.pivotal.gemfirexd.internal.engine.Misc");
            Method getRegionMethod = c.getMethod("getRegion", String.class);
            Object[] regionNameArray = new Object[]{regionName};
            region = (Region)getRegionMethod.invoke(null, regionNameArray);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Could not access Misc class");
        }
        catch (NoSuchMethodException nsme) {
            throw new TestException("Could not find Misc method");
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw new TestException("Could not invoke Misc method");
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Could not access Misc method");
        }
        return region;
    }

    public Object directGet(Object key, Region region) {
        return this.directGetOnTinyObjectId(key, region);
    }

    public Object directGetOnTinyObjectId(Object key, Region region) {
        Object entry = region.get(key);
        return entry;
    }

    public void directPut(Object key, Region region, Object value) {
        this.directPutOnTinyObjectId(key, region, value);
    }

    public void directPutOnTinyObjectId(Object key, Region region, Object value) {
        Object entry = region.put(key, value);
    }

    public Region getRegionForQuery(int queryType) {
        Region region;
        try {
            Class<?> c = Class.forName("com.pivotal.gemfirexd.internal.engine.Misc");
            Method getRegionMethod = c.getMethod("getRegion", String.class);
            Object[] regionNameArray = new Object[]{"APP." + TinyObject.getTableName().toUpperCase()};
            region = (Region)getRegionMethod.invoke(null, regionNameArray);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Could not access Misc class");
        }
        catch (NoSuchMethodException nsme) {
            throw new TestException("Could not find Misc method");
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw new TestException("Could not invoke Misc method");
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Could not access Misc method");
        }
        return region;
    }
}

