/*
 * Decompiled with CFR 0.152.
 */
package objects.query.tinyobject;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.internal.util.Sizeof;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import objects.ConfigurableObject;
import objects.query.QueryFactory;
import objects.query.tinyobject.GFXDTinyObjectQueryFactory;

public class TinyObject
implements DataSerializable,
ConfigurableObject,
Delta {
    private int id;
    private int intField;
    private boolean hasDelta = false;
    public static String REGION_TABLE_NAME = "TINY_OBJECT";
    public static String REGION_TABLE_SHORT_NAME = "lo";

    public static String getTableName() {
        return REGION_TABLE_NAME;
    }

    public static String getTableAndShortName() {
        return REGION_TABLE_NAME + " " + REGION_TABLE_SHORT_NAME;
    }

    public static String getTableShortName() {
        return REGION_TABLE_SHORT_NAME;
    }

    public void init(int i) {
        this.id = i;
        this.intField = i;
    }

    public static QueryFactory getQueryFactory(int api) {
        switch (api) {
            case 1: {
                return new GFXDTinyObjectQueryFactory();
            }
        }
        throw new UnsupportedOperationException("No factory for: " + api);
    }

    public static String commaSeparatedStringFor(Vector fields) {
        StringBuffer sb = new StringBuffer();
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            String field = (String)i.next();
            if (field.equals("*")) {
                return field;
            }
            sb.append(REGION_TABLE_SHORT_NAME + "." + field);
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static List getFields(List fieldList) {
        List<String> fields = new ArrayList<String>();
        if (fieldList.contains("*")) {
            fields.add("id");
            fields.add("intField");
        } else if (!fieldList.contains("none")) {
            fields = fieldList;
        }
        return fields;
    }

    public String toString() {
        return "TinyObject #" + this.id + "=" + this.id + ": intField=" + this.intField;
    }

    public int sizeof(Object o) {
        if (o instanceof TinyObject) {
            TinyObject obj = (TinyObject)o;
            return Sizeof.sizeof((int)obj.id) + Sizeof.sizeof((int)obj.intField);
        }
        return Sizeof.sizeof((Object)o);
    }

    public synchronized void update(int i) {
        this.setIntField(i);
        this.hasDelta = true;
    }

    public boolean hasDelta() {
        return this.hasDelta;
    }

    public void toDelta(DataOutput out) throws IOException {
        out.writeInt(this.intField);
    }

    public void fromDelta(DataInput in) throws IOException {
        this.intField = in.readInt();
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(this.intField);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.intField = in.readInt();
    }

    public Integer getId() {
        return new Integer(this.id);
    }

    public int getIntField() {
        return this.intField;
    }

    public void setIntField(int intField) {
        this.intField = intField;
    }

    public int getIndex() {
        return this.id;
    }

    public void validate(int index) {
    }
}

