/*
 * Decompiled with CFR 0.152.
 */
package sql;

import hydra.DerbyServerHelper;
import hydra.Log;
import hydra.MasterController;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import sql.SQLHelper;
import sql.SQLTest;
import util.TestException;
import util.TestHelper;

public class ClientDiscDBManager {
    private static String driver = "org.apache.derby.jdbc.ClientDriver";
    private static String protocol = "jdbc:derby:";
    private static String dbName = "test";
    private static boolean dbExist = false;
    private static String host;
    private static int port;
    private static String superUser;

    protected static void getHostAndPort() {
        if (DerbyServerHelper.getEndpoint() == null) {
            return;
        }
        port = DerbyServerHelper.getEndpoint().getPort();
        host = DerbyServerHelper.getEndpoint().getHost();
        Log.getLogWriter().info("hostname is " + host);
        Log.getLogWriter().info("port number is " + port);
        protocol = protocol + "//" + host + ":" + port + "/";
    }

    public static String getDriver() {
        return driver;
    }

    public static String getUrl() {
        return protocol + dbName;
    }

    public static String getDBName() {
        return dbName;
    }

    public static synchronized Connection getConnection() throws SQLException {
        boolean success = false;
        Connection conn = null;
        int maxRetries = 3;
        int count = 0;
        while (!success) {
            success = true;
            ++count;
            try {
                DriverManager.setLoginTimeout(150);
                if (!dbExist) {
                    Log.getLogWriter().info("creating disc database");
                    conn = DriverManager.getConnection(protocol + dbName + ";create=true");
                    dbExist = true;
                    continue;
                }
                conn = DriverManager.getConnection(protocol + dbName);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("08003")) {
                    Log.getLogWriter().info("could not get derby connection, may retry again");
                    success = false;
                    MasterController.sleepForMs((int)1000);
                    if (count <= maxRetries) continue;
                    throw se;
                }
                throw se;
            }
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getSuperUserConnection() throws SQLException {
        Connection conn = null;
        if (!dbExist) {
            Log.getLogWriter().info("creating disc database as " + superUser);
            conn = DriverManager.getConnection(protocol + dbName + superUser + ";create=true");
            dbExist = true;
        } else {
            Log.getLogWriter().info("get Connection as :" + superUser);
            conn = DriverManager.getConnection(protocol + dbName + superUser);
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getAuthConnection(int thrId) throws SQLException {
        Connection conn = null;
        String userAuth = ";user=thr_" + thrId + ";password=thr_" + thrId;
        Log.getLogWriter().info("current derby connection use the following credential: " + userAuth);
        conn = DriverManager.getConnection(protocol + dbName + userAuth);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getInvalidAuthConnection(int thrId) throws SQLException {
        Connection conn = null;
        String userAuth = ";user=thr_" + thrId + ";password=thr_" + ++thrId;
        Log.getLogWriter().info("current derby connection use the following credential: " + userAuth);
        conn = DriverManager.getConnection(protocol + dbName + userAuth);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getNoneAuthConnection(int thrId) throws SQLException {
        Log.getLogWriter().info("current derby connection use no credential");
        return ClientDiscDBManager.getConnection();
    }

    public static synchronized Connection getAuthConnection(String user) throws SQLException {
        Connection conn = null;
        String userAuth = ";user=" + user + ";password=" + user;
        Log.getLogWriter().info("current connection use the following credential: " + userAuth);
        conn = DriverManager.getConnection(protocol + dbName + userAuth);
        conn.setAutoCommit(false);
        return conn;
    }

    public static void shutDownDB() {
        try {
            if (SQLTest.testSecurity) {
                DriverManager.getConnection("jdbc:derby:;user=superUser;password=superUser;shutdown=true");
            } else {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) {
                Log.getLogWriter().info("derby db has been shut donw");
                dbExist = false;
            }
            SQLHelper.printSQLException(se);
            throw new TestException("Shutdown failed:" + TestHelper.getStackTrace((Throwable)se));
        }
    }

    static {
        superUser = ";user=superUser;password=superUser";
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Unable to load the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)cnfe));
        }
        catch (InstantiationException ie) {
            throw new TestException("Unable to instantiate the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)ie));
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Not allowed to access the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)iae));
        }
        ClientDiscDBManager.getHostAndPort();
    }
}

